/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.LineRenderer;
import com.jidesoft.chart.render.PointRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ColorFactory;
import com.jidesoft.range.Category;
import com.jidesoft.range.Positionable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Date;
import javax.swing.ListSelectionModel;
import javax.swing.Timer;

public class ModelMorpher {
    public static final String PROPERTY_MORPH_STARTED = "Morph Started";
    public static final String PROPERTY_MORPH_ENDED = "Morph Ended";
    public static final String PROPERTY_MORPH_MODELS = "Morph Models";
    private Chart chart;
    private ChartModel[] transitionModels;
    private double position = 1.0;
    private int numSteps = 10;
    private int delay = 40;
    private int stepsLeft = this.numSteps;
    private Timer timer;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private ChartStyle sourceStyle;
    private ChartStyle targetStyle;
    private boolean autoRepaint = true;

    public ModelMorpher() {
    }

    public ModelMorpher(Chart chart) {
        this.setChart(chart);
    }

    public ModelMorpher(Chart chart, int n, int n2) {
        this.setChart(chart);
        this.numSteps = n < 1 ? 1 : n;
        this.stepsLeft = n;
        this.delay = n2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void morph(ChartModel chartModel, ChartStyle chartStyle, ChartModel chartModel2, ChartStyle chartStyle2) {
        this.morph(chartModel, chartStyle, null, chartModel2, chartStyle2);
    }

    public void morph(ChartModel[] chartModelArray, ChartStyle[] chartStyleArray, ChartModel[] chartModelArray2, ChartStyle[] chartStyleArray2) {
        this.morph(chartModelArray, chartStyleArray, null, chartModelArray2, chartStyleArray2);
    }

    public void morph(ChartModel chartModel, ChartStyle chartStyle, ListSelectionModel listSelectionModel, ChartModel chartModel2, ChartStyle chartStyle2) {
        if (this.chart == null) {
            throw new IllegalStateException("The chart property must be set with a non-null value");
        }
        this.transitionModels = new ChartModel[1];
        this.transitionModels[0] = chartStyle != null && chartStyle.isBarsVisible() ? this.createBarTransitionModel(chartModel, chartModel2) : this.createTransitionModel(chartModel, chartModel2);
        this.animate(new ChartModel[]{chartModel}, new ChartStyle[]{chartStyle}, new ListSelectionModel[]{listSelectionModel}, new ChartModel[]{chartModel2}, new ChartStyle[]{chartStyle2});
    }

    public void morph(ChartModel[] chartModelArray, ChartStyle[] chartStyleArray, ListSelectionModel[] listSelectionModelArray, ChartModel[] chartModelArray2, ChartStyle[] chartStyleArray2) {
        if (this.chart == null) {
            throw new IllegalStateException("The chart property must be set with a non-null value");
        }
        int n = chartModelArray.length;
        this.transitionModels = new ChartModel[n];
        for (int i = 0; i < n; ++i) {
            this.transitionModels[i] = chartStyleArray[i].isBarsVisible() ? this.createBarTransitionModel(chartModelArray[i], chartModelArray2[i]) : this.createTransitionModel(chartModelArray[i], chartModelArray2[i]);
        }
        this.animate(chartModelArray, chartStyleArray, listSelectionModelArray, chartModelArray2, chartStyleArray2);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        this.chart = chart;
    }

    public ChartStyle getSourceStyle() {
        return this.sourceStyle;
    }

    public void setSourceStyle(ChartStyle chartStyle) {
        this.sourceStyle = chartStyle;
    }

    public ChartStyle getTargetStyle() {
        return this.targetStyle;
    }

    public void setTargetStyle(ChartStyle chartStyle) {
        this.targetStyle = chartStyle;
    }

    public boolean isAutoRepaint() {
        return this.autoRepaint;
    }

    public void setAutoRepaint(boolean bl) {
        this.autoRepaint = bl;
    }

    public boolean isMorphing() {
        return this.position < 1.0;
    }

    protected Chartable createIntermediate(Chartable chartable, Chartable chartable2, double d) {
        double d2 = chartable.getX().position();
        double d3 = chartable.getY().position();
        double d4 = chartable2.getX().position();
        double d5 = chartable2.getY().position();
        RealPosition realPosition = new RealPosition(d2 + d * (d4 - d2));
        RealPosition realPosition2 = new RealPosition(d3 + d * (d5 - d3));
        return new ChartPoint((Positionable)realPosition, (Positionable)realPosition2);
    }

    private void animate(final ChartModel[] chartModelArray, final ChartStyle[] chartStyleArray, ListSelectionModel[] listSelectionModelArray, final ChartModel[] chartModelArray2, final ChartStyle[] chartStyleArray2) {
        assert (this.chart != null);
        this.stopAnimation();
        int n = this.transitionModels.length;
        final LineRenderer[] lineRendererArray = new LineRenderer[n];
        final PointRenderer[] pointRendererArray = new PointRenderer[n];
        final BarRenderer[] barRendererArray = new BarRenderer[n];
        final Axis[] axisArray = new Axis[n];
        final boolean[] blArray = new boolean[n];
        for (int i = 0; i < this.transitionModels.length; ++i) {
            ListSelectionModel listSelectionModel;
            Axis axis;
            ChartModel chartModel = this.transitionModels[i];
            if (this.chart.containsModel(chartModel)) {
                this.chart.removeModel(chartModel);
            }
            this.chart.addModel(chartModel, chartStyleArray[i]);
            ChartModel chartModel2 = chartModelArray[i];
            axisArray[i] = axis = this.chart.getAxisForModel(chartModel2);
            if (axis != null) {
                this.chart.setModelAxis(chartModel, axis);
            }
            lineRendererArray[i] = this.chart.getLineRenderer(chartModel2);
            pointRendererArray[i] = this.chart.getPointRenderer(chartModel2);
            barRendererArray[i] = this.chart.getBarRenderer(chartModel2);
            blArray[i] = this.chart.isShadowVisible(chartModel2);
            if (this.chart.containsModel(chartModel2)) {
                this.chart.removeModel(chartModel2);
            }
            if (lineRendererArray[i] != null) {
                this.chart.setLineRenderer(chartModel, lineRendererArray[i]);
            }
            if (pointRendererArray[i] != null) {
                this.chart.setPointRenderer(chartModel, pointRendererArray[i]);
            }
            if (barRendererArray[i] != null) {
                this.chart.setBarRenderer(chartModel, barRendererArray[i]);
            }
            this.chart.setShadowVisible(chartModel, blArray[i]);
            ListSelectionModel listSelectionModel2 = listSelectionModel = listSelectionModelArray == null ? null : listSelectionModelArray[i];
            if (listSelectionModel == null) continue;
            this.chart.setSelectionsForModel(chartModel, listSelectionModel);
        }
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModelMorpher.this.stepsLeft--;
                ModelMorpher.this.position = (double)(ModelMorpher.this.numSteps - ModelMorpher.this.stepsLeft) / (double)ModelMorpher.this.numSteps;
                if (ModelMorpher.this.stepsLeft == 0) {
                    ModelMorpher.this.stopAnimation();
                    for (int i = 0; i < chartModelArray2.length; ++i) {
                        ChartModel chartModel = chartModelArray[i];
                        ChartModel chartModel2 = chartModelArray2[i];
                        ChartStyle chartStyle = chartStyleArray == null ? null : chartStyleArray[i];
                        ChartStyle chartStyle2 = chartStyleArray2 == null ? null : chartStyleArray2[i];
                        ChartStyle chartStyle3 = ModelMorpher.this.createStyle(chartModel, chartStyle, chartModel2, chartStyle2, ModelMorpher.this.position);
                        ModelMorpher.this.chart.addModel(chartModelArray2[i], chartStyle3);
                        if (lineRendererArray[i] != null) {
                            ModelMorpher.this.chart.setLineRenderer(chartModelArray2[i], lineRendererArray[i]);
                        }
                        if (pointRendererArray[i] != null) {
                            ModelMorpher.this.chart.setPointRenderer(chartModelArray2[i], pointRendererArray[i]);
                        }
                        if (barRendererArray[i] != null) {
                            ModelMorpher.this.chart.setBarRenderer(chartModelArray2[i], barRendererArray[i]);
                        }
                        if (blArray[i]) {
                            ModelMorpher.this.chart.setShadowVisible(chartModelArray2[i], blArray[i]);
                        }
                        if (axisArray[i] == null) continue;
                        ModelMorpher.this.chart.setModelAxis(chartModelArray2[i], axisArray[i]);
                    }
                    ModelMorpher.this.support.firePropertyChange(ModelMorpher.PROPERTY_MORPH_ENDED, null, new Date());
                } else {
                    for (int i = 0; i < ModelMorpher.this.transitionModels.length; ++i) {
                        TransitionPoint transitionPoint;
                        Object object2;
                        ChartModel chartModel = ModelMorpher.this.transitionModels[i];
                        for (Object object2 : chartModel) {
                            transitionPoint = (TransitionPoint)object2;
                            transitionPoint.setPosition(ModelMorpher.this.position);
                        }
                        ChartModel chartModel3 = chartModelArray[i];
                        object2 = chartModelArray2[i];
                        transitionPoint = chartStyleArray == null ? null : chartStyleArray[i];
                        ChartStyle chartStyle = chartStyleArray2 == null ? null : chartStyleArray2[i];
                        ChartStyle chartStyle4 = ModelMorpher.this.createStyle(chartModel3, (ChartStyle)((Object)transitionPoint), (ChartModel)object2, chartStyle, ModelMorpher.this.position);
                        ModelMorpher.this.chart.setStyle(chartModel, chartStyle4, false);
                    }
                    ModelMorpher.this.support.firePropertyChange(ModelMorpher.PROPERTY_MORPH_MODELS, chartModelArray, chartModelArray2);
                    if (ModelMorpher.this.isAutoRepaint()) {
                        ModelMorpher.this.chart.repaint();
                    }
                }
            }
        };
        this.stepsLeft = this.numSteps;
        this.timer = new Timer(this.delay, actionListener);
        this.timer.start();
        this.support.firePropertyChange(PROPERTY_MORPH_STARTED, null, new Date());
    }

    private void stopAnimation() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            this.stepsLeft = this.numSteps;
            for (ChartModel chartModel : this.transitionModels) {
                if (!this.chart.containsModel(chartModel)) continue;
                this.chart.removeModel(chartModel);
                this.chart.setZOrder(chartModel, null);
            }
        }
    }

    private ChartStyle createStyle(ChartModel chartModel, ChartStyle chartStyle, ChartModel chartModel2, ChartStyle chartStyle2, double d) {
        if (chartStyle == null) {
            chartStyle = new ChartStyle();
        }
        if (chartStyle2 == null) {
            chartStyle2 = chartStyle;
        }
        ChartStyle chartStyle3 = new ChartStyle(chartStyle2);
        chartStyle3.setBarOrientation(chartStyle.getBarOrientation());
        chartStyle3.setPointColor(ColorFactory.transitionColor(chartStyle.getPointColor(), chartStyle2.getPointColor(), d));
        chartStyle3.setLineColor(ColorFactory.transitionColor(chartStyle.getLineColor(), chartStyle2.getLineColor(), d));
        chartStyle3.setBarColor(ColorFactory.transitionColor(chartStyle.getBarColor(), chartStyle2.getBarColor(), d));
        chartStyle3.setPointSize(chartStyle.getPointSize() + (int)(d * (double)(chartStyle2.getPointSize() - chartStyle.getPointSize())));
        return chartStyle3;
    }

    private ChartModel createBarTransitionModel(ChartModel chartModel, ChartModel chartModel2) {
        int n;
        DefaultChartModel defaultChartModel = new DefaultChartModel("TransitionModel: " + chartModel.getName() + " -> " + chartModel2.getName());
        Integer n2 = this.chart.getZOrder(chartModel);
        if (n2 != null) {
            this.chart.setZOrder(defaultChartModel, n2);
            this.chart.setZOrder(chartModel2, n2);
        }
        if (chartModel.getPointCount() >= chartModel2.getPointCount()) {
            for (n = 0; n < chartModel.getPointCount(); ++n) {
                Chartable chartable = chartModel.getPoint(n);
                Chartable chartable2 = n < chartModel2.getPointCount() ? chartModel2.getPoint(n) : null;
                TransitionPoint transitionPoint = new TransitionPoint(chartable, chartable2);
                defaultChartModel.addPoint(transitionPoint);
            }
        } else {
            for (n = 0; n < chartModel2.getPointCount(); ++n) {
                Chartable chartable = n < chartModel.getPointCount() ? chartModel.getPoint(n) : null;
                Chartable chartable3 = chartModel2.getPoint(n);
                TransitionPoint transitionPoint = new TransitionPoint(chartable, chartable3);
                defaultChartModel.addPoint(transitionPoint);
            }
        }
        if (chartModel2 instanceof DefaultChartModel) {
            DefaultChartModel defaultChartModel2 = (DefaultChartModel)chartModel2;
            defaultChartModel.setCyclical(defaultChartModel2.isCyclical());
        }
        return defaultChartModel;
    }

    private ChartModel createTransitionModel(ChartModel chartModel, ChartModel chartModel2) {
        double d;
        DefaultChartModel defaultChartModel = new DefaultChartModel("TransitionModel: " + chartModel.getName() + " -> " + chartModel2.getName());
        Integer n = this.chart.getZOrder(chartModel);
        if (n != null) {
            this.chart.setZOrder(defaultChartModel, n);
            this.chart.setZOrder(chartModel2, n);
        }
        if (chartModel.getPointCount() >= chartModel2.getPointCount()) {
            d = ((double)chartModel2.getPointCount() - 1.0) / ((double)chartModel.getPointCount() - 1.0);
            int n2 = 0;
            for (int i = 0; i < chartModel.getPointCount(); ++i) {
                Chartable chartable = chartModel.getPoint((i + n2) % chartModel.getPointCount());
                Chartable chartable2 = chartModel2.getPoint((int)Math.rint(d * (double)i));
                TransitionPoint transitionPoint = new TransitionPoint(chartable, chartable2);
                defaultChartModel.addPoint(transitionPoint);
            }
        } else {
            d = ((double)chartModel.getPointCount() - 1.0) / ((double)chartModel2.getPointCount() - 1.0);
            for (int i = 0; i < chartModel2.getPointCount(); ++i) {
                double d2 = (double)i * d;
                int n3 = (int)Math.floor(d2);
                int n4 = (int)Math.ceil(d2);
                Chartable chartable = chartModel.getPoint(n3);
                Chartable chartable3 = chartModel.getPoint(n4);
                Chartable chartable4 = chartModel2.getPoint(i);
                TransitionPoint transitionPoint = new TransitionPoint(this.createIntermediate(chartable, chartable3, d2 - (double)n3), chartable4);
                defaultChartModel.addPoint(transitionPoint);
            }
        }
        if (chartModel2 instanceof DefaultChartModel) {
            DefaultChartModel defaultChartModel2 = (DefaultChartModel)chartModel2;
            defaultChartModel.setCyclical(defaultChartModel2.isCyclical());
        }
        return defaultChartModel;
    }

    public static class TransitionPoint
    extends ChartPoint {
        private Chartable source;
        private Chartable target;
        private double position;

        public TransitionPoint() {
        }

        public TransitionPoint(Chartable chartable, Chartable chartable2) {
            this.setSource(chartable);
            this.setTarget(chartable2);
            this.setX(chartable == null ? null : chartable.getX());
            this.setY(chartable == null ? null : chartable.getY());
            Highlightable highlightable = null;
            if (chartable instanceof Highlightable) {
                highlightable = (Highlightable)((Object)chartable);
            } else if (chartable2 instanceof Highlightable) {
                highlightable = (Highlightable)((Object)chartable2);
            }
            if (highlightable != null) {
                this.setHighlight(highlightable.getHighlight());
            }
        }

        public Chartable getSource() {
            return this.source;
        }

        public void setSource(Chartable chartable) {
            this.source = chartable;
        }

        public Chartable getTarget() {
            return this.target;
        }

        public void setTarget(Chartable chartable) {
            this.target = chartable;
        }

        public double getPosition() {
            return this.position;
        }

        public void setPosition(double d) {
            this.position = d;
            this.update();
        }

        protected void update() {
            double d;
            Double d2 = this.source == null ? null : Double.valueOf(this.source.getX().position());
            Double d3 = this.source == null ? null : Double.valueOf(this.source.getY().position());
            Double d4 = this.target == null ? null : Double.valueOf(this.target.getX().position());
            Double d5 = this.target == null ? null : Double.valueOf(this.target.getY().position());
            double d6 = Math.sin(1.5707963267948966 * this.position);
            double d7 = this.position > 0.5 ? 0.0 : 1.0 - 2.0 * this.position;
            double d8 = d = this.position < 0.5 ? 0.0 : 2.0 * this.position - 1.0;
            Positionable positionable = d4 == null ? (this.source.getX() instanceof Category ? this.source.getX() : new RealPosition(d2 * d7)) : (d2 == null ? (this.target.getX() instanceof Category ? this.target.getX() : new RealPosition(d4 * d)) : new RealPosition(d2 + d6 * (d4 - d2)));
            this.setX(positionable);
            Positionable positionable2 = d5 == null ? (this.source.getY() instanceof Category ? this.source.getY() : new RealPosition(d3 * d7)) : (d3 == null ? (this.target.getY() instanceof Category ? this.target.getY() : new RealPosition(d5 * d)) : new RealPosition(d3 + d6 * (d5 - d3)));
            this.setY(positionable2);
        }
    }
}

