/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.range.Positionable;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class LineSmoother {
    private LineSmoother() {
    }

    public static GeneralPath preparePath(Chart chart, ChartModel chartModel, double d) {
        return LineSmoother.preparePath(chart, chartModel, d, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeneralPath preparePath(Chart chart, ChartModel chartModel, double d, boolean bl) {
        double[] dArray;
        double[] dArray2;
        Axis axis = chart.getAxisForModel(chartModel);
        ChartModel chartModel2 = chartModel;
        synchronized (chartModel2) {
            int n = chartModel.getPointCount();
            dArray2 = new double[n];
            dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                Chartable chartable = chartModel.getPoint(bl ? n - i - 1 : i);
                Positionable positionable = chartable.getX();
                Positionable positionable2 = chartable.getY();
                Point2D.Double double_ = new Point2D.Double(positionable.position(), positionable2.position());
                Point2D point2D = axis != null ? chart.calculatePixelPoint2D((Point2D)double_, axis) : chart.calculatePixelPoint2D(double_);
                double d2 = chart.getAnimationPosition();
                if (d2 == 1.0) {
                    dArray2[i] = point2D.getX();
                    dArray[i] = point2D.getY();
                    continue;
                }
                int n2 = chart.interpolateXForAnimation((int)point2D.getX(), chartModel);
                int n3 = chart.interpolateYForAnimation((int)point2D.getY(), chartModel);
                dArray2[i] = n2;
                dArray[i] = n3;
            }
        }
        return LineSmoother.preparePath(chart, dArray2, dArray, d);
    }

    public static GeneralPath prepareCyclicPath(Chart chart, double[] dArray, double[] dArray2, double d) {
        int n;
        assert (dArray.length == dArray2.length);
        double[] dArray3 = new double[dArray.length + 3];
        double[] dArray4 = new double[dArray2.length + 3];
        int n2 = dArray.length;
        for (int i = 0; i < dArray3.length; ++i) {
            int n3 = i - 2;
            if (n3 < 0) {
                n3 += n2;
            } else if (n3 >= n2) {
                n3 -= n2;
            }
            dArray3[i] = dArray[n3];
            dArray4[i] = dArray2[n3];
        }
        GeneralPath generalPath = new GeneralPath();
        if (n2 <= 2) {
            return generalPath;
        }
        Pair[] pairArray = new Pair[dArray3.length - 2];
        generalPath.moveTo((float)dArray3[1], (float)dArray4[1]);
        for (n = 0; n < dArray3.length - 2; ++n) {
            pairArray[n] = LineSmoother.controlPoints(dArray3[n], dArray4[n], dArray3[n + 1], dArray4[n + 1], dArray3[n + 2], dArray4[n + 2], d);
        }
        for (n = 1; n <= n2; ++n) {
            LineSmoother.curveTo(generalPath, (Point2D)pairArray[n - 1].getSecond(), (Point2D)pairArray[n].getFirst(), dArray3[n + 1], dArray4[n + 1]);
        }
        return generalPath;
    }

    public static GeneralPath preparePath(Chart chart, double[] dArray, double[] dArray2, double d) {
        int n;
        assert (dArray.length == dArray2.length);
        GeneralPath generalPath = new GeneralPath();
        int n2 = dArray.length;
        if (n2 < 3) {
            if (n2 == 2) {
                generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
                generalPath.lineTo((float)dArray[1], (float)dArray2[1]);
            }
            return generalPath;
        }
        Pair[] pairArray = new Pair[n2 - 2];
        generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
        for (n = 0; n < n2 - 2; ++n) {
            pairArray[n] = LineSmoother.controlPoints(dArray[n], dArray2[n], dArray[n + 1], dArray2[n + 1], dArray[n + 2], dArray2[n + 2], d);
        }
        LineSmoother.quadTo(generalPath, (Point2D)pairArray[0].getFirst(), dArray[1], dArray2[1]);
        for (n = 1; n < pairArray.length; ++n) {
            LineSmoother.curveTo(generalPath, (Point2D)pairArray[n - 1].getSecond(), (Point2D)pairArray[n].getFirst(), dArray[n + 1], dArray2[n + 1]);
        }
        LineSmoother.quadTo(generalPath, (Point2D)pairArray[pairArray.length - 1].getSecond(), dArray[n2 - 1], dArray2[n2 - 1]);
        return generalPath;
    }

    private static Pair<Point2D, Point2D> controlPoints(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        Point2D point2D = LineSmoother.midPoint(d, d2, d3, d4);
        Point2D point2D2 = LineSmoother.midPoint(d3, d4, d5, d6);
        Point2D point2D3 = LineSmoother.midPoint(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        Point2D point2D4 = LineSmoother.genPoint(point2D3.getX(), point2D3.getY(), point2D.getX(), point2D.getY(), d7);
        Point2D point2D5 = LineSmoother.genPoint(point2D3.getX(), point2D3.getY(), point2D2.getX(), point2D2.getY(), d7);
        double d8 = d3 - point2D3.getX();
        double d9 = d4 - point2D3.getY();
        Point2D point2D6 = LineSmoother.translate(point2D4, d8, d9);
        Point2D point2D7 = LineSmoother.translate(point2D5, d8, d9);
        return new Pair<Point2D, Point2D>(point2D6, point2D7);
    }

    private static Point2D midPoint(double d, double d2, double d3, double d4) {
        return LineSmoother.genPoint(d, d2, d3, d4, 0.5);
    }

    private static Point2D translate(Point2D point2D, double d, double d2) {
        return new Point2D.Double(point2D.getX() + d, point2D.getY() + d2);
    }

    private static Point2D genPoint(double d, double d2, double d3, double d4, double d5) {
        double d6 = (1.0 - d5) * d + d5 * d3;
        double d7 = (1.0 - d5) * d2 + d5 * d4;
        return new Point2D.Double(d6, d7);
    }

    private static void curveTo(GeneralPath generalPath, Point2D point2D, Point2D point2D2, double d, double d2) {
        generalPath.curveTo((float)point2D.getX(), (float)point2D.getY(), (float)point2D2.getX(), (float)point2D2.getY(), (float)d, (float)d2);
    }

    private static void quadTo(GeneralPath generalPath, Point2D point2D, double d, double d2) {
        generalPath.quadTo((float)point2D.getX(), (float)point2D.getY(), (float)d, (float)d2);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Chart.class.getName(), 4096);
        }
    }
}

