/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.chart.util.Filter;
import com.jidesoft.chart.util.IdentityFilter;

public class FilterableChartModel
extends AbstractDelegatingChartModel {
    private Filter<Chartable> filter = new IdentityFilter<Chartable>();
    private DefaultChartModel model = new DefaultChartModel();

    public FilterableChartModel() {
    }

    public FilterableChartModel(AnnotatedChartModel annotatedChartModel) {
        this.setDelegates(annotatedChartModel);
    }

    @Override
    public int getAnnotationCount() {
        return this.getDelegate().getAnnotationCount();
    }

    @Override
    public Annotation getAnnotation(int n) {
        return this.getDelegate().getAnnotation(n);
    }

    @Override
    public boolean isAnnotationsVisible() {
        return false;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Chartable getPoint(int n) {
        return this.model.getPoint(n);
    }

    @Override
    public int getPointCount() {
        return this.model.getPointCount();
    }

    public Filter<Chartable> getFilter() {
        return this.filter;
    }

    public void setFilter(Filter<Chartable> filter) {
        this.filter = filter;
        this.update();
        this.fireModelChanged();
    }

    protected synchronized void applyFilter() {
        AnnotatedChartModel annotatedChartModel = this.getDelegate();
        if (annotatedChartModel == null) {
            return;
        }
        this.model.clearPoints();
        for (int i = 0; i < annotatedChartModel.getPointCount(); ++i) {
            Chartable chartable = annotatedChartModel.getPoint(i);
            if (this.filter.isValueFiltered(chartable)) continue;
            this.model.addPoint(chartable);
        }
    }

    @Override
    protected void update() {
        if (this.filter != null) {
            this.applyFilter();
        }
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.filter == null ? 0 : this.filter.hashCode());
        n = 31 * n + (this.model == null ? 0 : this.model.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FilterableChartModel filterableChartModel = (FilterableChartModel)object;
        if (this.filter == null ? filterableChartModel.filter != null : !this.filter.equals(filterableChartModel.filter)) {
            return false;
        }
        return !(this.model == null ? filterableChartModel.model != null : !this.model.equals(filterableChartModel.model));
    }
}

