/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelChangeEvent;
import com.jidesoft.chart.model.ChartModelChangeListener;
import com.jidesoft.chart.model.ChartModelChangeType;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.RangeProvider;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.range.Category;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DefaultChartModel
implements AnnotatedChartModel,
RangeProvider,
Comparable<ChartModel> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private static volatile int modelCounter;
    private Object key;
    private List<Chartable> points = new ArrayList<Chartable>();
    private Range<Double> xRange = null;
    private Range<Double> yRange = null;
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private CopyOnWriteArrayList<ChartModelListener> listeners = new CopyOnWriteArrayList();
    private double xLeadingMarginProportion = 0.0;
    private double yLeadingMarginProportion = 0.0;
    private double xTrailingMarginProportion = 0.0;
    private double yTrailingMarginProportion = 0.0;
    private boolean annotationsVisible = true;
    private boolean cyclical;
    private boolean firingEventsOnEDT = false;

    public DefaultChartModel() {
        this(String.format("%d", ++modelCounter));
    }

    public DefaultChartModel(DefaultChartModel defaultChartModel) {
        this.key = defaultChartModel.key;
        this.points = new ArrayList<Chartable>(defaultChartModel.points);
        this.annotations = new ArrayList<Annotation>(defaultChartModel.annotations);
        this.xLeadingMarginProportion = defaultChartModel.xLeadingMarginProportion;
        this.yLeadingMarginProportion = defaultChartModel.yLeadingMarginProportion;
        this.xTrailingMarginProportion = defaultChartModel.xTrailingMarginProportion;
        this.yTrailingMarginProportion = defaultChartModel.yTrailingMarginProportion;
        this.cyclical = defaultChartModel.cyclical;
    }

    public DefaultChartModel(Object object) {
        this.key = object;
    }

    @Override
    public String getName() {
        return this.key == null ? String.format("<DefaultChartModel @%X>", System.identityHashCode(this)) : this.key.toString();
    }

    public Object getKey() {
        return this.key;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot set the name of a ChartModel to null");
        }
        this.key = string;
    }

    public boolean isFiringEventsOnEDT() {
        return this.firingEventsOnEDT;
    }

    public void setFiringEventsOnEDT(boolean bl) {
        this.firingEventsOnEDT = bl;
    }

    @Override
    public Chartable getPoint(int n) {
        this.readLock.lock();
        try {
            Chartable chartable = this.points.get(n);
            return chartable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clearPoints() {
        this.writeLock.lock();
        try {
            this.points.clear();
            this.xRange = null;
            this.yRange = null;
        }
        finally {
            this.writeLock.unlock();
        }
        this.fireModelChanged();
    }

    public void clearAnnotations() {
        this.writeLock.lock();
        try {
            this.annotations.clear();
        }
        finally {
            this.writeLock.unlock();
        }
        this.fireModelChanged();
    }

    @Override
    public int getPointCount() {
        this.readLock.lock();
        try {
            int n = this.points.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public DefaultChartModel addPoint(Chartable chartable) {
        return this.addPoint(chartable, true);
    }

    public DefaultChartModel addPoint(int n, int n2) {
        return this.addPoint(new ChartPoint((double)n, (double)n2), true);
    }

    public DefaultChartModel addPoint(int n, double d) {
        return this.addPoint(new ChartPoint((double)n, d), true);
    }

    public DefaultChartModel addPoint(double d, int n) {
        return this.addPoint(new ChartPoint(d, (double)n), true);
    }

    public DefaultChartModel addPoint(double d, double d2) {
        return this.addPoint(new ChartPoint(d, d2), true);
    }

    public DefaultChartModel addPoint(Positionable positionable, Positionable positionable2) {
        return this.addPoint(new ChartPoint(positionable, positionable2), true);
    }

    public DefaultChartModel addPoint(double d, Positionable positionable) {
        return this.addPoint(new ChartPoint(d, positionable), true);
    }

    public DefaultChartModel addPoint(Positionable positionable, double d) {
        return this.addPoint(new ChartPoint(positionable, d), true);
    }

    public DefaultChartModel addPoint(double d, double d2, boolean bl) {
        this.addPoint(new ChartPoint(d, d2), bl);
        return this;
    }

    public DefaultChartModel addPoint(Positionable positionable, Positionable positionable2, boolean bl) {
        this.addPoint(new ChartPoint(positionable, positionable2), bl);
        return this;
    }

    public DefaultChartModel addPoint(double d, Positionable positionable, boolean bl) {
        this.addPoint(new ChartPoint(d, positionable), bl);
        return this;
    }

    public DefaultChartModel addPoint(Positionable positionable, double d, boolean bl) {
        this.addPoint(new ChartPoint(positionable, d), bl);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel addPoint(Chartable chartable, boolean bl) {
        this.writeLock.lock();
        try {
            int n = this.points.size();
            DefaultChartModel defaultChartModel = this.addPoint(n, chartable, bl);
            return defaultChartModel;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public DefaultChartModel addPoint(int n, Chartable chartable) {
        return this.addPoint(n, chartable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel addPoint(int n, Chartable chartable, boolean bl) {
        ChartUtils.assertEDT();
        if (chartable == null) {
            throw new IllegalArgumentException("Cannot add a null point to the model");
        }
        Positionable positionable = chartable.getX();
        Positionable positionable2 = chartable.getY();
        this.writeLock.lock();
        try {
            this.points.add(n, chartable);
            if (positionable != null) {
                if (this.xRange == null) {
                    if (positionable instanceof Category && ((Category)positionable).getRange() == null) {
                        this.xRange = null;
                    } else if (!Double.isNaN(positionable.position())) {
                        this.xRange = new NumericRange(positionable.position(), positionable.position());
                    }
                } else if (positionable.position() > this.xRange.maximum()) {
                    if (!Double.isNaN(positionable.position())) {
                        this.xRange = new NumericRange(this.xRange.minimum(), positionable.position());
                    }
                } else if (positionable.position() < this.xRange.minimum() && !Double.isNaN(positionable.position())) {
                    this.xRange = new NumericRange(positionable.position(), this.xRange.maximum());
                }
            }
            if (positionable2 != null) {
                if (this.yRange == null) {
                    if (positionable2 instanceof Category && ((Category)positionable2).getRange() == null) {
                        this.yRange = null;
                    } else if (!Double.isNaN(positionable2.position())) {
                        this.yRange = new NumericRange(positionable2.position(), positionable2.position());
                    }
                } else if (positionable2.position() > this.yRange.maximum()) {
                    if (!Double.isNaN(positionable2.position())) {
                        this.yRange = new NumericRange(this.yRange.minimum(), positionable2.position());
                    }
                } else if (positionable2.position() < this.yRange.minimum() && !Double.isNaN(positionable2.position())) {
                    this.yRange = new NumericRange(positionable2.position(), this.yRange.maximum());
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (bl) {
            ChartModelChangeEvent chartModelChangeEvent = new ChartModelChangeEvent(this, ChartModelChangeType.INSERT, n, 1);
            this.fireModelChanged(chartModelChangeEvent);
        }
        return this;
    }

    public DefaultChartModel replacePoint(int n, Chartable chartable) {
        return this.replacePoint(n, chartable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel replacePoint(int n, Chartable chartable, boolean bl) {
        this.writeLock.lock();
        try {
            this.points.set(n, chartable);
            this.xRange = null;
            this.yRange = null;
        }
        finally {
            this.writeLock.unlock();
        }
        if (bl) {
            ChartModelChangeEvent chartModelChangeEvent = new ChartModelChangeEvent(this, ChartModelChangeType.MODIFY, n, 1);
            this.fireModelChanged(chartModelChangeEvent);
        }
        return this;
    }

    public DefaultChartModel removePoint(int n) {
        return this.removePoint(n, true);
    }

    public DefaultChartModel removePoint(int n, boolean bl) {
        this.writeLock.lock();
        try {
            this.points.remove(n);
            this.xRange = null;
            this.yRange = null;
        }
        finally {
            this.writeLock.unlock();
        }
        if (bl) {
            ChartModelChangeEvent chartModelChangeEvent = new ChartModelChangeEvent(this, ChartModelChangeType.REMOVE, n, 1);
            this.fireModelChanged(chartModelChangeEvent);
        }
        return this;
    }

    public DefaultChartModel removePoint(Chartable chartable) {
        return this.removePoint(chartable, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultChartModel removePoint(Chartable chartable, boolean bl) {
        this.writeLock.lock();
        try {
            int n = this.points.indexOf(chartable);
            DefaultChartModel defaultChartModel = this.removePoint(n, bl);
            return defaultChartModel;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getAnnotationCount() {
        this.readLock.lock();
        try {
            int n = this.annotations.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Annotation getAnnotation(int n) {
        this.readLock.lock();
        try {
            Annotation annotation = this.annotations.get(n);
            return annotation;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addAnnotation(Annotation annotation) {
        this.writeLock.lock();
        try {
            this.annotations.add(annotation);
        }
        finally {
            this.writeLock.unlock();
        }
        this.fireModelChanged();
    }

    public void removeAnnotation(Annotation annotation) {
        this.writeLock.lock();
        try {
            this.annotations.remove(annotation);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public double getXLeadingMarginProportion() {
        return this.xLeadingMarginProportion;
    }

    public void setXLeadingMarginProportion(double d) {
        assert (0.0 <= d);
        assert (1.0 >= d);
        this.xLeadingMarginProportion = d;
    }

    public double getYLeadingMarginProportion() {
        return this.yLeadingMarginProportion;
    }

    public void setYLeadingMarginProportion(double d) {
        assert (0.0 <= d);
        assert (1.0 >= d);
        this.yLeadingMarginProportion = d;
    }

    public double getXTrailingMarginProportion() {
        return this.xTrailingMarginProportion;
    }

    public void setXTrailingMarginProportion(double d) {
        assert (0.0 <= d);
        assert (1.0 >= d);
        this.xTrailingMarginProportion = d;
    }

    public double getYTrailingMarginProportion() {
        return this.yTrailingMarginProportion;
    }

    public void setYTrailingMarginProportion(double d) {
        assert (0.0 <= d);
        assert (1.0 >= d);
        this.yTrailingMarginProportion = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range<Double> getXRange() {
        if (this.xRange != null) {
            return this.xRange;
        }
        this.readLock.lock();
        try {
            if (this.getPointCount() > 0) {
                Double d = Double.POSITIVE_INFINITY;
                Double d2 = Double.NEGATIVE_INFINITY;
                for (Chartable chartable : this.points) {
                    Positionable positionable = chartable.getX();
                    if (positionable == null) continue;
                    double d3 = positionable.position();
                    if (d == null || d3 < d) {
                        d = d3;
                    }
                    if (d2 != null && !(d3 > d2)) continue;
                    d2 = d3;
                }
                this.xRange = new NumericRange(d, d2);
                Range<Double> range = this.xRange;
                return range;
            }
            Range<Double> range = null;
            return range;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Range<Double> getXRange(double d, double d2) {
        Range<Double> range = this.getXRange();
        double d3 = range == null ? Double.POSITIVE_INFINITY : range.maximum();
        double d4 = range == null ? Double.NEGATIVE_INFINITY : range.minimum();
        double d5 = Math.abs(d3 - d4);
        double d6 = d * d5;
        double d7 = d2 * d5;
        return new NumericRange(d4 - d6, d3 + d7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Range<Double> getYRange() {
        if (this.yRange != null) {
            return this.yRange;
        }
        this.readLock.lock();
        try {
            if (this.getPointCount() > 0) {
                Double d = Double.POSITIVE_INFINITY;
                Double d2 = Double.NEGATIVE_INFINITY;
                for (Chartable chartable : this.points) {
                    Positionable positionable = chartable.getY();
                    if (positionable == null) continue;
                    double d3 = positionable.position();
                    if (d == null || d3 < d) {
                        d = d3;
                    }
                    if (d2 != null && !(d3 > d2)) continue;
                    d2 = d3;
                }
                this.yRange = new NumericRange(d, d2);
                Range<Double> range = this.yRange;
                return range;
            }
            Range<Double> range = null;
            return range;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Range<Double> getYRange(double d, double d2) {
        Range<Double> range = this.getYRange();
        double d3 = range == null ? Double.POSITIVE_INFINITY : range.maximum();
        double d4 = range == null ? Double.NEGATIVE_INFINITY : range.minimum();
        double d5 = Math.abs(d3 - d4);
        double d6 = d * d5;
        double d7 = d2 * d5;
        return new NumericRange(d4 - d6, d3 + d7);
    }

    @Override
    public boolean isAnnotationsVisible() {
        this.readLock.lock();
        try {
            boolean bl = this.annotationsVisible;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        this.writeLock.lock();
        try {
            this.annotationsVisible = bl;
        }
        finally {
            this.writeLock.unlock();
        }
        this.fireModelChanged();
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.add(chartModelListener);
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.remove(chartModelListener);
    }

    @Override
    public Iterator<Chartable> iterator() {
        return this.points.iterator();
    }

    @Override
    public boolean isCyclical() {
        this.readLock.lock();
        try {
            boolean bl = this.cyclical;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setCyclical(boolean bl) {
        this.writeLock.lock();
        try {
            this.cyclical = bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void update() {
        this.fireModelChanged();
    }

    protected void fireModelChanged(final ChartModelChangeEvent chartModelChangeEvent) {
        if (this.firingEventsOnEDT) {
            ChartUtils.runOnEdt(new Runnable(){

                @Override
                public void run() {
                    for (ChartModelListener chartModelListener : DefaultChartModel.this.listeners) {
                        if (chartModelListener instanceof ChartModelChangeListener) {
                            ((ChartModelChangeListener)chartModelListener).chartModelChanged(chartModelChangeEvent);
                            continue;
                        }
                        if (chartModelListener == null) continue;
                        chartModelListener.chartModelChanged();
                    }
                }
            });
        } else {
            for (ChartModelListener chartModelListener : this.listeners) {
                if (chartModelListener instanceof ChartModelChangeListener) {
                    ((ChartModelChangeListener)chartModelListener).chartModelChanged(chartModelChangeEvent);
                    continue;
                }
                if (chartModelListener == null) continue;
                chartModelListener.chartModelChanged();
            }
        }
    }

    protected void fireModelChanged() {
        if (this.firingEventsOnEDT) {
            ChartUtils.runOnEdt(new Runnable(){

                @Override
                public void run() {
                    for (ChartModelListener chartModelListener : DefaultChartModel.this.listeners) {
                        chartModelListener.chartModelChanged();
                    }
                }
            });
        } else {
            for (ChartModelListener chartModelListener : this.listeners) {
                chartModelListener.chartModelChanged();
            }
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultChartModel) {
            DefaultChartModel defaultChartModel = (DefaultChartModel)object;
            String string = this.getName();
            return string.equals(defaultChartModel.getName());
        }
        return false;
    }

    @Override
    public int compareTo(ChartModel chartModel) {
        String string = chartModel.getName();
        String string2 = this.getName();
        return string2.compareTo(string);
    }

    public String toString() {
        return String.format("#<DefaultChartModel name='%s'>", this.getName());
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(DefaultChartModel.class.getName(), 4096);
        }
        modelCounter = 0;
    }
}

