/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelChangeEvent;
import com.jidesoft.chart.model.ChartModelChangeListener;
import com.jidesoft.chart.model.ChartModelIterator;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import java.util.Iterator;

public final class CopiedChartModel
implements ChartModel {
    private String name;
    private Chartable[] points;
    private boolean cyclical;
    private boolean changedDuringInitialisation = false;

    public CopiedChartModel(ChartModel chartModel) {
        InitialisationListener initialisationListener = new InitialisationListener();
        chartModel.addChartModelListener(initialisationListener);
        int n = 0;
        int n2 = 3;
        do {
            this.name = chartModel.getName();
            this.cyclical = chartModel.isCyclical();
            int n3 = chartModel.getPointCount();
            this.points = new Chartable[n3];
            try {
                for (int i = 0; i < n3; ++i) {
                    this.points[i] = chartModel.getPoint(i);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.changedDuringInitialisation = true;
            }
        } while (!this.changedDuringInitialisation && ++n < n2);
        chartModel.removeChartModelListener(initialisationListener);
    }

    public boolean isErrorFree() {
        return !this.changedDuringInitialisation;
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Chartable getPoint(int n) {
        return this.points[n];
    }

    @Override
    public int getPointCount() {
        return this.points.length;
    }

    @Override
    public boolean isCyclical() {
        return this.cyclical;
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new ChartModelIterator(this);
    }

    public boolean equals(Object object) {
        return object instanceof ChartModel && this.name.equals(((ChartModel)object).getName());
    }

    private class InitialisationListener
    implements ChartModelChangeListener {
        private InitialisationListener() {
        }

        @Override
        public void chartModelChanged() {
            CopiedChartModel.this.changedDuringInitialisation = true;
        }

        @Override
        public void chartModelChanged(ChartModelChangeEvent chartModelChangeEvent) {
            CopiedChartModel.this.changedDuringInitialisation = true;
        }
    }
}

