/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.ChartableND;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChartPointND
implements ChartableND,
Highlightable {
    private List<Positionable> values = new ArrayList<Positionable>();
    private Highlight highlight;

    public ChartPointND() {
    }

    public ChartPointND(double ... dArray) {
        for (double d : dArray) {
            this.values.add(new RealPosition(d));
        }
    }

    public ChartPointND(Positionable ... positionableArray) {
        Collections.addAll(this.values, positionableArray);
    }

    @Override
    public Positionable getX() {
        if (this.values.size() < 1) {
            return null;
        }
        return this.values.get(0);
    }

    @Override
    public Positionable getY() {
        if (this.values.size() < 2) {
            return null;
        }
        return this.values.get(1);
    }

    @Override
    public Positionable getZ() {
        if (this.values.size() < 3) {
            return null;
        }
        return this.values.get(2);
    }

    @Override
    public int compareTo(Chartable chartable) {
        Positionable positionable = this.getX();
        if (positionable == null) {
            return 0;
        }
        return positionable.compareTo(chartable.getX());
    }

    @Override
    public int getDimensionCount() {
        return this.values.size();
    }

    @Override
    public Positionable get(int n) {
        if (this.values.size() < n + 1) {
            return null;
        }
        return this.values.get(n);
    }

    public void set(int n, Positionable positionable) {
        while (this.values.size() < n + 1) {
            this.values.add(new RealPosition(0.0));
        }
        this.values.set(n, positionable);
    }

    @Override
    public Highlight getHighlight() {
        return this.highlight;
    }

    public boolean isHighlight(Highlight highlight) {
        return highlight != null && highlight.equals(this.highlight);
    }

    @Override
    public void setHighlight(Highlight highlight) {
        assert (highlight != null);
        this.highlight = highlight;
    }
}

