/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

public class AxisExtent
implements Comparable<AxisExtent> {
    private final double min;
    private final double max;

    public AxisExtent(int n, int n2) {
        assert (n <= n2) : "Minimum " + n + " is not less than or equal to " + n2;
        this.min = n;
        this.max = n2;
    }

    public AxisExtent(double d, double d2) {
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (Double.isInfinite(d) && Double.isInfinite(d2)) {
                if (d == Double.POSITIVE_INFINITY && d2 == Double.NEGATIVE_INFINITY) {
                    throw new IllegalArgumentException("Minimum must be less than or equal to maximum");
                }
            } else assert (d <= d2) : "Minimum " + d + " is not less than or equal to " + d2;
        }
        this.min = d;
        this.max = d2;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double size() {
        double d = this.max - this.min;
        return d >= 0.0 ? d : 0.0;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.max);
        n = 31 * n + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.min);
        n = 31 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AxisExtent axisExtent = (AxisExtent)object;
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(axisExtent.max)) {
            return false;
        }
        return Double.doubleToLongBits(this.min) == Double.doubleToLongBits(axisExtent.min);
    }

    public String toString() {
        return String.format("#<AxisExtent min=%f max=%f>", this.min, this.max);
    }

    @Override
    public int compareTo(AxisExtent axisExtent) {
        int n = Double.compare(this.min, axisExtent.min);
        if (n == 0) {
            return Double.compare(this.max, axisExtent.max);
        }
        return n;
    }
}

