/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AbstractDelegatingChartModel;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AverageChartModel
extends AbstractDelegatingChartModel {
    private List<Chartable> averages = new ArrayList<Chartable>();

    public AverageChartModel(AnnotatedChartModel[] annotatedChartModelArray) {
        super(annotatedChartModelArray);
        assert (annotatedChartModelArray.length > 0);
        this.update();
    }

    public AverageChartModel(String string, AnnotatedChartModel[] annotatedChartModelArray) {
        super(annotatedChartModelArray);
        this.setName(string);
        assert (annotatedChartModelArray.length > 0);
        this.update();
    }

    @Override
    public int getAnnotationCount() {
        return 0;
    }

    @Override
    public Annotation getAnnotation(int n) {
        return null;
    }

    @Override
    protected void update() {
        HashMap<Positionable, ArrayList<Double>> hashMap = new HashMap<Positionable, ArrayList<Double>>();
        HashMap<Positionable, ArrayList<Highlight>> hashMap2 = new HashMap<Positionable, ArrayList<Highlight>>();
        for (Iterable<Chartable> iterable : this.getDelegates()) {
            for (Chartable chartable : iterable) {
                ArrayList<Double> arrayList;
                Positionable positionable = chartable.getX();
                Positionable positionable2 = chartable.getY();
                Double d = positionable2 == null ? Double.NaN : positionable2.position();
                Highlight highlight = null;
                if (chartable instanceof Highlightable) {
                    highlight = ((Highlightable)((Object)chartable)).getHighlight();
                }
                if ((arrayList = (ArrayList<Double>)hashMap.get(positionable)) == null) {
                    arrayList = new ArrayList<Double>();
                }
                arrayList.add(d);
                hashMap.put(positionable, arrayList);
                ArrayList<Highlight> arrayList2 = (ArrayList<Highlight>)hashMap2.get(positionable);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Highlight>();
                }
                arrayList2.add(highlight);
                hashMap2.put(positionable, arrayList2);
            }
        }
        if (this.averages == null) {
            this.averages = new ArrayList<Chartable>();
        } else {
            this.averages.clear();
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Chartable chartable;
            Iterable<Chartable> iterable;
            Positionable positionable = (Positionable)entry.getKey();
            iterable = (List)hashMap2.get(positionable);
            Highlight highlight = AverageChartModel.combineHighlights((List<Highlight>)iterable);
            chartable = new ChartPoint(positionable, (double)AverageChartModel.average((List)entry.getValue()), highlight);
            this.averages.add(chartable);
        }
        Collections.sort(this.averages);
    }

    public static Double average(List<Double> list) {
        if (list == null) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = 0;
        for (Double d2 : list) {
            if (d2 == null || Double.isNaN(d2)) continue;
            d += d2.doubleValue();
            ++n;
        }
        return d / (double)n;
    }

    @Override
    public Chartable getPoint(int n) {
        return this.averages.get(n);
    }

    @Override
    public int getPointCount() {
        return this.averages.size();
    }

    @Override
    public boolean isAnnotationsVisible() {
        return false;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }
}

