/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class AnnotatedChartModelAdapter
implements AnnotatedChartModel,
ChartModelListener {
    private ChartModel delegate;
    private List<ChartModelListener> listeners = Collections.synchronizedList(new ArrayList());

    public AnnotatedChartModelAdapter(ChartModel chartModel) {
        this.setDelegate(chartModel);
    }

    public ChartModel getDelegate() {
        return this.delegate;
    }

    public void setDelegate(ChartModel chartModel) {
        if (this.delegate != null) {
            this.delegate.removeChartModelListener(this);
        }
        this.delegate = chartModel;
        if (this.delegate != null) {
            this.delegate.addChartModelListener(this);
        }
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        if (!this.listeners.contains(chartModelListener)) {
            this.listeners.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.remove(chartModelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChanged() {
        List<ChartModelListener> list = this.listeners;
        synchronized (list) {
            for (ChartModelListener chartModelListener : this.listeners) {
                chartModelListener.chartModelChanged();
            }
        }
    }

    @Override
    public void chartModelChanged() {
        this.update();
        this.fireModelChanged();
    }

    public void update() {
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public Chartable getPoint(int n) {
        return this.delegate.getPoint(n);
    }

    @Override
    public int getPointCount() {
        return this.delegate == null ? 0 : this.delegate.getPointCount();
    }

    @Override
    public boolean isCyclical() {
        return this.delegate.isCyclical();
    }

    @Override
    public Iterator<Chartable> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Annotation getAnnotation(int n) {
        return null;
    }

    @Override
    public int getAnnotationCount() {
        return 0;
    }

    @Override
    public boolean isAnnotationsVisible() {
        return false;
    }

    @Override
    public void setAnnotationsVisible(boolean bl) {
    }
}

