/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.model;

import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.AnnotatedChartModelAdapter;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelIterator;
import com.jidesoft.chart.model.ChartModelListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractDelegatingChartModel
implements AnnotatedChartModel,
ChartModelListener {
    private static AtomicInteger instanceCount;
    private String name;
    private List<AnnotatedChartModel> delegates = new ArrayList<AnnotatedChartModel>();
    private final CopyOnWriteArrayList<ChartModelListener> listeners = new CopyOnWriteArrayList();

    public AbstractDelegatingChartModel() {
        this.delegates = new ArrayList<AnnotatedChartModel>();
        this.init();
    }

    public AbstractDelegatingChartModel(ChartModel ... chartModelArray) {
        this.setDelegates(chartModelArray);
        this.init();
    }

    public AbstractDelegatingChartModel(Collection<ChartModel> collection) {
        this.setDelegates(collection, true);
        this.init();
    }

    static Highlight combineHighlights(List<Highlight> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Highlight highlight = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            if (!(highlight == null ? list.get(i) != null : !highlight.equals(list.get(i)))) continue;
            return null;
        }
        return highlight;
    }

    protected void init() {
        int n = instanceCount.incrementAndGet();
        this.name = this.getClass().getName() + "@" + Integer.toHexString(n);
    }

    @Override
    public abstract int getAnnotationCount();

    @Override
    public abstract Annotation getAnnotation(int var1);

    @Override
    public abstract Chartable getPoint(int var1);

    @Override
    public abstract int getPointCount();

    protected abstract void update();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("Cannot set the name of a ChartModel to null");
        }
        this.name = string;
    }

    public AnnotatedChartModel getDelegate() {
        AnnotatedChartModel[] annotatedChartModelArray = this.getDelegates();
        if (annotatedChartModelArray.length > 0) {
            return annotatedChartModelArray[0];
        }
        return null;
    }

    public AnnotatedChartModel getDelegate(int n) {
        return this.delegates.get(n);
    }

    public AnnotatedChartModel[] getDelegates() {
        return this.delegates.toArray(new AnnotatedChartModel[this.delegates.size()]);
    }

    public void setDelegate(ChartModel chartModel) {
        this.setDelegates(chartModel);
    }

    public void setDelegates(Collection<ChartModel> collection, boolean bl) {
        if (this.delegates == null) {
            this.delegates = new ArrayList<AnnotatedChartModel>();
        } else {
            for (ChartModel chartModel : this.delegates) {
                if (chartModel == null) continue;
                chartModel.removeChartModelListener(this);
            }
            this.delegates.clear();
        }
        if (collection != null) {
            for (ChartModel chartModel : collection) {
                if (chartModel instanceof AnnotatedChartModel) {
                    this.delegates.add((AnnotatedChartModel)chartModel);
                    continue;
                }
                AnnotatedChartModelAdapter annotatedChartModelAdapter = new AnnotatedChartModelAdapter(chartModel);
                this.delegates.add(annotatedChartModelAdapter);
            }
        }
        if (this.delegates != null && bl) {
            for (ChartModel chartModel : this.delegates) {
                if (chartModel == null) continue;
                chartModel.addChartModelListener(this);
            }
        }
        this.update();
    }

    public void setDelegates(ChartModel ... chartModelArray) {
        if (this.delegates == null) {
            this.delegates = new ArrayList<AnnotatedChartModel>();
        } else {
            for (ChartModel chartModel : this.delegates) {
                if (chartModel == null) continue;
                chartModel.removeChartModelListener(this);
            }
            this.delegates.clear();
        }
        if (chartModelArray != null) {
            for (ChartModel chartModel : chartModelArray) {
                if (chartModel instanceof AnnotatedChartModel) {
                    this.delegates.add((AnnotatedChartModel)chartModel);
                    continue;
                }
                AnnotatedChartModelAdapter annotatedChartModelAdapter = new AnnotatedChartModelAdapter(chartModel);
                this.delegates.add(annotatedChartModelAdapter);
            }
        }
        if (this.delegates != null) {
            for (ChartModel chartModel : this.delegates) {
                if (chartModel == null) continue;
                chartModel.addChartModelListener(this);
            }
        }
        this.update();
    }

    @Override
    public boolean isCyclical() {
        return false;
    }

    @Override
    public void addChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.addIfAbsent(chartModelListener);
        if (!this.listeners.contains(chartModelListener)) {
            this.listeners.add(chartModelListener);
        }
    }

    @Override
    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.remove(chartModelListener);
    }

    protected void fireModelChanged() {
        for (ChartModelListener chartModelListener : this.listeners) {
            chartModelListener.chartModelChanged();
        }
    }

    @Override
    public void chartModelChanged() {
        this.update();
        this.fireModelChanged();
    }

    @Override
    public Iterator<Chartable> iterator() {
        return new ChartModelIterator(this);
    }

    public int hashCode() {
        int n = this.getDelegate() == null ? 1 : this.getDelegate().hashCode();
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractDelegatingChartModel abstractDelegatingChartModel = (AbstractDelegatingChartModel)object;
        return !(this.name == null ? abstractDelegatingChartModel.name != null : !this.name.equals(abstractDelegatingChartModel.name));
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(AbstractDelegatingChartModel.class.getName(), 4096);
        }
        instanceCount = new AtomicInteger(0);
    }
}

