/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import org.apache.commons.math.linear.RealMatrixImpl;

public class QuadraticFitter
implements CurveFitter {
    private static QuadraticFitter instance;

    private QuadraticFitter() {
    }

    public static QuadraticFitter getInstance() {
        if (instance == null) {
            instance = new QuadraticFitter();
        }
        return instance;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        int n = chartModel.getPointCount();
        assert (n > 0) : "Can't perform a regression on a model containing no points!";
        double d = this.sumOfXToPowerMYToPowerN(chartModel, 1, 0);
        double d2 = this.sumOfXToPowerMYToPowerN(chartModel, 2, 0);
        double d3 = this.sumOfXToPowerMYToPowerN(chartModel, 3, 0);
        double d4 = this.sumOfXToPowerMYToPowerN(chartModel, 4, 0);
        double d5 = this.sumOfXToPowerMYToPowerN(chartModel, 0, 1);
        double d6 = this.sumOfXToPowerMYToPowerN(chartModel, 1, 1);
        double d7 = this.sumOfXToPowerMYToPowerN(chartModel, 2, 1);
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl((double[][])new double[][]{{n, d, d2}, {d, d2, d3}, {d2, d3, d4}});
        double[] dArray = new double[]{d5, d6, d7};
        double[] dArray2 = realMatrixImpl.solve(dArray);
        return new Polynomial(dArray2);
    }

    @Override
    public DefaultChartModel createModel(Polynomial polynomial, Range<?> range, int n) {
        return this.createModel((String)null, polynomial, (Range)range, n);
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        for (Double d : doubleArray) {
            double d2 = polynomial.eval(d);
            defaultChartModel.addPoint((double)d, d2);
        }
        return defaultChartModel;
    }

    @Override
    public DefaultChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n) {
        double d = range.minimum();
        double d2 = range.maximum();
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        double d3 = (d2 - d) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double d4 = d + (double)i * d3;
            double d5 = polynomial.eval(d4);
            defaultChartModel.addPoint(d4, d5);
        }
        return defaultChartModel;
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, (Range)range, n);
    }

    private double sumOfXToPowerMYToPowerN(ChartModel chartModel, int n, int n2) {
        double d = 0.0;
        for (Chartable chartable : chartModel) {
            d += Math.pow(chartable.getX().position(), n) * Math.pow(chartable.getY().position(), n2);
        }
        return d;
    }
}

