/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.List;
import org.apache.commons.math.linear.RealMatrixImpl;

public class PolynomialFitter
implements CurveFitter {
    private int order;

    public PolynomialFitter(int n) {
        this.setOrder(n);
    }

    public void setOrder(int n) {
        assert (n >= 0);
        this.order = n;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d;
        int n;
        double[][] dArray = new double[this.order + 1][this.order + 1];
        for (int i = 0; i <= this.order; ++i) {
            for (n = 0; n <= this.order; ++n) {
                dArray[i][n] = d = this.sumOfXToPowerMYToPowerN(chartModel, i + n, 0);
            }
        }
        double[] dArray2 = new double[this.order + 1];
        for (n = 0; n <= this.order; ++n) {
            dArray2[n] = d = this.sumOfXToPowerMYToPowerN(chartModel, n, 1);
        }
        RealMatrixImpl realMatrixImpl = new RealMatrixImpl(dArray);
        double[] dArray3 = realMatrixImpl.solve(dArray2);
        return new Polynomial(dArray3);
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n) {
        return this.createModel(null, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n) {
        double d = range.minimum();
        double d2 = range.maximum();
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        double d3 = (d2 - d) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double d4 = d + (double)i * d3;
            double d5 = polynomial.eval(d4);
            defaultChartModel.addPoint(d4, d5);
        }
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        for (Double d : doubleArray) {
            double d2 = polynomial.eval(d);
            defaultChartModel.addPoint((double)d, d2);
        }
        return defaultChartModel;
    }

    public Polynomial performRegression(List<? extends Point2D> list) {
        throw new UnsupportedOperationException();
    }

    private double sumOfXToPowerMYToPowerN(ChartModel chartModel, int n, int n2) {
        double d = 0.0;
        for (Chartable chartable : chartModel) {
            d += Math.pow(chartable.getX().position(), n) * Math.pow(chartable.getY().position(), n2);
        }
        return d;
    }
}

