/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.axis.AxisType;
import com.jidesoft.chart.fit.CurveFitter;
import com.jidesoft.chart.fit.Polynomial;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.range.Range;
import java.awt.geom.Point2D;
import java.util.Collection;

public class LineFitter
implements CurveFitter {
    private static LineFitter lineFitter;

    private LineFitter() {
    }

    public static LineFitter getInstance() {
        if (lineFitter == null) {
            lineFitter = new LineFitter();
        }
        return lineFitter;
    }

    @Override
    public AnnotatedChartModel performRegression(String string, ChartModel chartModel, Range<?> range, int n) {
        Polynomial polynomial = this.performRegression(chartModel);
        return this.createModel(string, polynomial, range, 2);
    }

    @Override
    public AnnotatedChartModel createModel(Polynomial polynomial, Range<?> range, int n) {
        return this.createModel(null, polynomial, range, n);
    }

    @Override
    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Range<?> range, int n) {
        double d = range.minimum();
        double d2 = range.maximum();
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        defaultChartModel.addPoint(d, polynomial.eval(d));
        defaultChartModel.addPoint(d2, polynomial.eval(d2));
        return defaultChartModel;
    }

    public AnnotatedChartModel createModel(String string, Polynomial polynomial, Double[] doubleArray) {
        DefaultChartModel defaultChartModel = string == null ? new DefaultChartModel() : new DefaultChartModel(string);
        for (Double d : doubleArray) {
            double d2 = polynomial.eval(d);
            defaultChartModel.addPoint((double)d, d2);
        }
        return defaultChartModel;
    }

    @Override
    public Polynomial performRegression(ChartModel chartModel) {
        double d = this.mean(AxisType.x, chartModel);
        double d2 = this.mean(AxisType.y, chartModel);
        double d3 = this.calculateGradient(chartModel, d, d2);
        double d4 = this.calculateIntercept(d, d2, d3);
        return new Polynomial(d4, d3);
    }

    public Polynomial performRegression(Collection<? extends Point2D> collection) {
        double d = this.mean(AxisType.x, collection);
        double d2 = this.mean(AxisType.y, collection);
        double d3 = this.calculateGradient(collection, d, d2);
        double d4 = this.calculateIntercept(d, d2, d3);
        return new Polynomial(d4, d3);
    }

    private double calculateGradient(ChartModel chartModel, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Chartable chartable : chartModel) {
            double d5 = chartable.getX().position() - d;
            double d6 = chartable.getY().position() - d2;
            d3 += d5 * d6;
            d4 += d5 * d5;
        }
        return d3 / d4;
    }

    private double calculateGradient(Collection<? extends Point2D> collection, double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        for (Point2D point2D : collection) {
            double d5 = point2D.getX() - d;
            double d6 = point2D.getY() - d2;
            d3 += d5 * d6;
            d4 += d5 * d5;
        }
        return d3 / d4;
    }

    private double calculateIntercept(double d, double d2, double d3) {
        return d2 - d3 * d;
    }

    private double mean(AxisType axisType, ChartModel chartModel) {
        double d = 0.0;
        if (axisType == AxisType.x) {
            for (Chartable chartable : chartModel) {
                d += chartable.getX().position();
            }
        } else {
            for (Chartable chartable : chartModel) {
                d += chartable.getY().position();
            }
        }
        return d / (double)chartModel.getPointCount();
    }

    private double mean(AxisType axisType, Collection<? extends Point2D> collection) {
        double d = 0.0;
        if (axisType == AxisType.x) {
            for (Point2D point2D : collection) {
                d += point2D.getX();
            }
        } else {
            for (Point2D point2D : collection) {
                d += point2D.getY();
            }
        }
        return d / (double)collection.size();
    }
}

