/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.event.ChartSelectionEvent;
import com.jidesoft.chart.event.MouseHandler;
import com.jidesoft.chart.event.PointSelectionEvent;
import com.jidesoft.chart.event.ZoomDirection;
import com.jidesoft.chart.event.ZoomListener;
import com.jidesoft.chart.event.ZoomLocation;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MouseWheelZoomer
implements MouseHandler,
MouseWheelListener {
    public static final String PROPERTY_HORIZONTAL_ZOOM = "Horizontal Zoom";
    public static final String PROPERTY_VERTICAL_ZOOM = "Vertical Zoom";
    public static final String PROPERTY_ZOOM_LOCATION = "Zoom Location";
    public static final String PROPERTY_X_LIMITS = "X Limits";
    public static final String PROPERTY_MIN_X_RANGE_SIZE = "Min X Range Size";
    public static final String PROPERTY_MAX_X_RANGE_SIZE = "Max X Range Size";
    public static final String PROPERTY_Y_LIMITS = "Y Limits";
    public static final String PROPERTY_MIN_Y_RANGE_SIZE = "Min Y Range Size";
    public static final String PROPERTY_MAX_Y_RANGE_SIZE = "Max y Range Size";
    private List<ZoomListener> listeners = Collections.synchronizedList(new ArrayList());
    private Chart chart;
    private boolean horizontalZoom = true;
    private boolean verticalZoom = true;
    private boolean handled = false;
    private ZoomLocation zoomLocation = ZoomLocation.CHART_CENTER;
    private Point2D zoomFrom = null;
    private Range<?> xLimits;
    private Double minXRangeSize;
    private Double minYRangeSize;
    private Double maxXRangeSize;
    private Double maxYRangeSize;
    private Range<?> yLimits;
    private int horizontalOnlyZoomKeyMask = -1;
    private int verticalOnlyZoomKeyMask = -1;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public MouseWheelZoomer(Chart chart) {
        this.chart = chart;
    }

    public MouseWheelZoomer(Chart chart, boolean bl, boolean bl2) {
        this.chart = chart;
        this.horizontalZoom = bl;
        this.verticalZoom = bl2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean isHorizontalZoom() {
        return this.horizontalZoom;
    }

    public void setHorizontalZoom(boolean bl) {
        boolean bl2 = this.horizontalZoom;
        this.horizontalZoom = bl;
        this.support.firePropertyChange(PROPERTY_HORIZONTAL_ZOOM, bl2, bl);
    }

    public boolean isVerticalZoom() {
        return this.verticalZoom;
    }

    public void setVerticalZoom(boolean bl) {
        boolean bl2 = this.verticalZoom;
        this.verticalZoom = bl;
        this.support.firePropertyChange(PROPERTY_VERTICAL_ZOOM, bl2, bl);
    }

    public ZoomLocation getZoomLocation() {
        return this.zoomLocation;
    }

    public void setZoomLocation(ZoomLocation zoomLocation) {
        ZoomLocation zoomLocation2 = this.zoomLocation;
        this.zoomLocation = zoomLocation;
        this.support.firePropertyChange(PROPERTY_ZOOM_LOCATION, (Object)zoomLocation2, (Object)zoomLocation);
    }

    public Point2D getZoomFrom() {
        return this.zoomFrom;
    }

    public void setZoomFrom(Point2D point2D) {
        this.zoomFrom = point2D;
    }

    public Range<?> getXLimits() {
        return this.xLimits;
    }

    public void setXLimits(Range<?> range) {
        Range<?> range2 = this.xLimits;
        this.xLimits = range;
        this.support.firePropertyChange(PROPERTY_X_LIMITS, range2, range);
    }

    public Double getMinXRangeSize() {
        return this.minXRangeSize;
    }

    public void setMinXRangeSize(Double d) {
        Double d2 = this.minXRangeSize;
        this.minXRangeSize = d;
        this.support.firePropertyChange(PROPERTY_MIN_X_RANGE_SIZE, d2, d);
    }

    public Range<?> getYLimits() {
        return this.yLimits;
    }

    public void setYLimits(Range<?> range) {
        Range<?> range2 = this.yLimits;
        this.yLimits = range;
        this.support.firePropertyChange(PROPERTY_Y_LIMITS, range2, range);
    }

    public Double getMinYRangeSize() {
        return this.minYRangeSize;
    }

    public void setMinYRangeSize(Double d) {
        Double d2 = this.minYRangeSize;
        this.minYRangeSize = d;
        this.support.firePropertyChange(PROPERTY_MIN_Y_RANGE_SIZE, d2, d);
    }

    public Double getMaxXRangeSize() {
        return this.maxXRangeSize;
    }

    public void setMaxXRangeSize(Double d) {
        Double d2 = this.maxXRangeSize;
        this.maxXRangeSize = d;
        this.support.firePropertyChange(PROPERTY_MAX_X_RANGE_SIZE, d2, d);
    }

    public Double getMaxYRangeSize() {
        return this.maxYRangeSize;
    }

    public void setMaxYRangeSize(Double d) {
        Double d2 = this.maxYRangeSize;
        this.maxYRangeSize = d;
        this.support.firePropertyChange(PROPERTY_MAX_Y_RANGE_SIZE, d2, d);
    }

    public int getHorizontalOnlyZoomKeyMask() {
        return this.horizontalOnlyZoomKeyMask;
    }

    public void setHorizontalOnlyZoomKeyMask(int n) {
        this.horizontalOnlyZoomKeyMask = n;
    }

    public int getVerticalOnlyZoomKeyMask() {
        return this.verticalOnlyZoomKeyMask;
    }

    public void setVerticalOnlyZoomKeyMask(int n) {
        this.verticalOnlyZoomKeyMask = n;
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.listeners.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.listeners.remove(zoomListener);
    }

    protected void fireZoom(Point point, ZoomDirection zoomDirection) {
        this.fireZoom(new PointSelectionEvent(this, point, zoomDirection));
    }

    protected void fireZoom(Point point, ZoomDirection zoomDirection, double d) {
        this.fireZoom(new PointSelectionEvent(this, point, zoomDirection, d));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireZoom(ChartSelectionEvent chartSelectionEvent) {
        List<ZoomListener> list = this.listeners;
        synchronized (list) {
            for (ZoomListener zoomListener : this.listeners) {
                zoomListener.zoomChanged(chartSelectionEvent);
            }
        }
        this.chart.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.setHandled(!this.chart.isEnabled());
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.setHandled(!this.chart.isEnabled());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        NumericRange numericRange;
        NumericRange numericRange2;
        Point point;
        if (mouseWheelEvent.getWheelRotation() == 0 || !this.chart.isEnabled()) {
            return;
        }
        ZoomDirection zoomDirection = mouseWheelEvent.getWheelRotation() < 0 ? ZoomDirection.IN : ZoomDirection.OUT;
        boolean bl = this.horizontalOnlyZoomKeyMask > 0 && (mouseWheelEvent.getModifiersEx() & this.horizontalOnlyZoomKeyMask) == this.horizontalOnlyZoomKeyMask;
        boolean bl2 = this.verticalOnlyZoomKeyMask > 0 && (mouseWheelEvent.getModifiersEx() & this.verticalOnlyZoomKeyMask) == this.verticalOnlyZoomKeyMask;
        boolean bl3 = !bl && !bl2;
        boolean bl4 = this.horizontalZoom && (bl3 || bl);
        boolean bl5 = this.verticalZoom && (bl3 || bl2);
        Axis axis = this.chart.getXAxis();
        Axis axis2 = this.chart.getYAxis();
        if (this.zoomLocation == ZoomLocation.CHART_CENTER) {
            Point2D.Double double_ = new Point2D.Double(axis.midPoint(), axis2.midPoint());
            point = this.chart.calculatePixelPoint(double_);
            if (zoomDirection == ZoomDirection.IN) {
                double d = 0.9;
                numericRange2 = bl4 ? Axis.zoom(axis, d) : axis.getRange();
                numericRange = bl5 ? Axis.zoom(axis2, d) : axis2.getRange();
            } else {
                double d = 1.1;
                numericRange2 = bl4 ? Axis.zoom(axis, d) : axis.getRange();
                numericRange = bl5 ? Axis.zoom(axis2, d) : axis2.getRange();
            }
        } else if (this.zoomLocation == ZoomLocation.SPECIFIED_POINT) {
            point = this.chart.calculatePixelPoint(this.zoomFrom);
            if (this.zoomFrom != null) {
                if (zoomDirection == ZoomDirection.IN) {
                    double d = 0.9;
                    numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d, this.zoomFrom.getX()) : axis.getRange();
                    numericRange = bl5 ? Axis.zoomFromPosition(axis2, d, this.zoomFrom.getY()) : axis2.getRange();
                } else {
                    double d = 1.1;
                    numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d, this.zoomFrom.getX()) : axis.getRange();
                    numericRange = bl5 ? Axis.zoomFromPosition(axis2, d, this.zoomFrom.getY()) : axis2.getRange();
                }
            } else {
                numericRange2 = axis.getRange();
                numericRange = axis2.getRange();
            }
        } else {
            point = mouseWheelEvent.getPoint();
            Point2D point2D = this.chart.calculateUserPoint(point);
            if (zoomDirection == ZoomDirection.IN) {
                double d = 0.9;
                numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d, point2D.getX()) : axis.getRange();
                numericRange = bl5 ? Axis.zoomFromPosition(axis2, d, point2D.getY()) : axis2.getRange();
            } else {
                double d = 1.1;
                numericRange2 = bl4 ? Axis.zoomFromPosition(axis, d, point2D.getX()) : axis.getRange();
                NumericRange numericRange3 = numericRange = bl5 ? Axis.zoomFromPosition(axis2, d, point2D.getY()) : axis2.getRange();
            }
        }
        if (this.xLimits != null && numericRange2 instanceof NumericRange) {
            if (numericRange2.minimum() < this.xLimits.minimum()) {
                numericRange2 = new NumericRange(this.xLimits.minimum(), numericRange2.maximum());
            }
            if (numericRange2.maximum() > this.xLimits.maximum()) {
                numericRange2 = new NumericRange(numericRange2.minimum(), this.xLimits.maximum());
            }
        }
        if ((this.minXRangeSize == null || numericRange2.size() >= this.minXRangeSize) && (this.maxXRangeSize == null || numericRange2.size() <= this.maxXRangeSize) && (this.xLimits == null || numericRange2.minimum() >= this.xLimits.minimum() && numericRange2.maximum() <= this.xLimits.maximum())) {
            axis.setRange(numericRange2, true, false);
        }
        if (this.yLimits != null && numericRange instanceof NumericRange) {
            if (numericRange.minimum() <= this.yLimits.minimum()) {
                numericRange = new NumericRange(this.yLimits.minimum(), numericRange.maximum());
            }
            if (numericRange.maximum() >= this.yLimits.maximum()) {
                numericRange = new NumericRange(numericRange.minimum(), this.yLimits.maximum());
            }
        }
        if ((this.minYRangeSize == null || numericRange.size() >= this.minYRangeSize) && (this.maxYRangeSize == null || numericRange.size() <= this.maxYRangeSize) && (this.yLimits == null || numericRange.minimum() >= this.yLimits.minimum() && numericRange.maximum() <= this.yLimits.maximum())) {
            axis2.setRange(numericRange, true, false);
        }
        this.fireZoom(point, zoomDirection, 0.1);
        this.setHandled(true);
    }

    @Override
    public boolean isHandled() {
        return this.handled;
    }

    @Override
    public void setHandled(boolean bl) {
        this.handled = bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setHandled(false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.setHandled(false);
    }
}

