/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartException;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.event.PointSelection;
import com.jidesoft.chart.fit.FunctionMap;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ChartCrossHair
implements MouseListener,
MouseMotionListener,
ComponentListener,
Drawable {
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_CIRCLE_DIAMETER = "Circle Diameter";
    public static final String PROPERTY_MODEL = "Model";
    public static final String PROPERTY_OBSERVED_MODEL = "Model Observed";
    public static final String PROPERTY_POSITION = "Position";
    public static final String PROPERTY_SNAP_TO_POINTS = "Snap to Points";
    public static final String PROPERTY_STROKE = "Stroke";
    public static final String PROPERTY_UPDATE_FROM_MODEL = "Update From Model";
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_HORIZONTAL_LINE_VISIBLE = "Horizontal Line Visible";
    public static final String PROPERTY_VERTICAL_LINE_VISIBLE = "Vertical Line Visible";
    private int circleDiameter = 10;
    private Chart chart;
    private Point latestCursorPosition = null;
    private ChartModel model = null;
    private boolean updateFromModel = true;
    private ChartModel observedModel = null;
    private Color color = Color.orange.darker();
    private Stroke stroke = new BasicStroke(1.0f, 0, 0, 5.0f, new float[]{5.0f}, 0.0f);
    private boolean visible = false;
    private boolean verticalLineVisible = true;
    private boolean horizontalLineVisible = true;
    private Point xAxisPoint = null;
    private Point yAxisPoint = null;
    private boolean snapToPoints = false;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Chartable position;

    public ChartCrossHair() {
    }

    public ChartCrossHair(Chart chart) {
        this(chart, false);
    }

    public ChartCrossHair(Chart chart, boolean bl) {
        if (bl) {
            chart.addMouseListener(this);
            chart.addMouseMotionListener(this);
            chart.addDrawable(this);
        }
        this.setChart(chart);
    }

    public void detach() {
        if (this.chart != null) {
            this.chart.removeMouseListener(this);
            this.chart.removeMouseMotionListener(this);
            this.chart.removeComponentListener(this);
            this.chart.removeDrawable(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.chart;
        if (chart2 != null) {
            chart2.removeComponentListener(this);
        }
        this.chart = chart;
        if (chart != null) {
            chart.addComponentListener(this);
        }
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public boolean isVerticalLineVisible() {
        return this.verticalLineVisible;
    }

    public void setVerticalLineVisible(boolean bl) {
        boolean bl2 = this.verticalLineVisible;
        this.verticalLineVisible = bl;
        this.support.firePropertyChange(PROPERTY_VERTICAL_LINE_VISIBLE, bl2, bl);
    }

    public boolean isHorizontalLineVisible() {
        return this.horizontalLineVisible;
    }

    public void setHorizontalLineVisible(boolean bl) {
        boolean bl2 = this.horizontalLineVisible;
        this.horizontalLineVisible = bl;
        this.support.firePropertyChange(PROPERTY_HORIZONTAL_LINE_VISIBLE, bl2, bl);
    }

    public boolean isSnapToPoints() {
        return this.snapToPoints;
    }

    public void setSnapToPoints(boolean bl) {
        boolean bl2 = this.snapToPoints;
        this.snapToPoints = bl;
        this.support.firePropertyChange(PROPERTY_SNAP_TO_POINTS, bl2, bl);
    }

    public boolean isUpdateFromModel() {
        return this.updateFromModel;
    }

    public void setUpdateFromModel(boolean bl) {
        boolean bl2 = this.updateFromModel;
        this.updateFromModel = bl;
        this.support.firePropertyChange(PROPERTY_UPDATE_FROM_MODEL, bl2, bl);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        this.support.firePropertyChange(PROPERTY_STROKE, stroke2, stroke);
    }

    public Point getXAxisPoint() {
        return this.xAxisPoint;
    }

    public Point getYAxisPoint() {
        return this.yAxisPoint;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.latestCursorPosition = mouseEvent.getPoint();
        this.update();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setVisible(true);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.latestCursorPosition = null;
        this.setVisible(false);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.latestCursorPosition = mouseEvent.getPoint();
        this.update();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.update();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    public ChartModel getModel() {
        return this.model;
    }

    public void setModel(ChartModel chartModel) {
        ChartModel chartModel2 = this.model;
        this.model = chartModel;
        this.support.firePropertyChange(PROPERTY_MODEL, chartModel2, chartModel);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        Color color2 = this.color;
        this.color = color;
        this.support.firePropertyChange(PROPERTY_COLOR, color2, color);
    }

    private void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        this.support.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public ChartModel getObservedModel() {
        return this.observedModel;
    }

    private void setObservedModel(ChartModel chartModel) {
        ChartModel chartModel2 = this.observedModel;
        this.observedModel = chartModel;
        this.support.firePropertyChange(PROPERTY_OBSERVED_MODEL, chartModel2, chartModel);
    }

    public void update() {
        if (this.chart == null) {
            throw new NullPointerException("Chart property is null");
        }
        if (!this.updateFromModel) {
            if (this.position != null) {
                this.xAxisPoint = this.chart.calculatePixelPoint((Point2D)new Point2D.Double(this.position.getX().position(), 0.0), this.chart.getXAxis());
                this.yAxisPoint = this.chart.calculatePixelPoint((Point2D)new Point2D.Double(0.0, this.position.getY().position()), this.chart.getYAxis());
                this.setVisible(true);
            } else {
                this.setVisible(false);
            }
            return;
        }
        ChartModel chartModel = this.model == null ? this.chart.nearestModel(this.latestCursorPosition) : this.model;
        this.setObservedModel(chartModel);
        Axis axis = this.chart.getAxisForModel(chartModel);
        if (this.latestCursorPosition != null && chartModel != null && chartModel.getPointCount() >= 1) {
            if (this.snapToPoints) {
                PointSelection pointSelection = this.chart.nearestPoint(this.latestCursorPosition, chartModel);
                if (pointSelection == null) {
                    this.setPosition(null);
                    this.setVisible(false);
                } else {
                    Chartable chartable = pointSelection.getSelected();
                    this.xAxisPoint = this.chart.calculatePixelPoint((Point2D)new Point2D.Double(chartable.getX().position(), 0.0), axis);
                    this.yAxisPoint = this.chart.calculatePixelPoint((Point2D)new Point2D.Double(0.0, chartable.getY().position()), axis);
                    this.setPosition(chartable);
                    this.setVisible(true);
                }
            } else {
                try {
                    Point2D point2D = this.chart.calculateUserPoint(this.latestCursorPosition);
                    if (point2D != null) {
                        double d = FunctionMap.getYApproximately(chartModel, point2D.getX());
                        double d2 = point2D.getX();
                        this.xAxisPoint = this.chart.calculatePixelPoint((Point2D)new Point2D.Double(d2, 0.0), axis);
                        this.yAxisPoint = this.chart.calculatePixelPoint((Point2D)new Point2D.Double(0.0, d), axis);
                        this.setPosition(new ChartPoint(d2, d));
                        this.setVisible(true);
                    }
                }
                catch (ChartException chartException) {
                    this.setPosition(null);
                    this.setVisible(false);
                }
            }
        }
        this.chart.repaint();
    }

    public void setPosition(Chartable chartable) {
        Chartable chartable2 = this.position;
        this.position = chartable;
        if (!this.updateFromModel) {
            this.update();
        }
        this.support.firePropertyChange(PROPERTY_POSITION, chartable2, chartable);
    }

    public Chartable getPosition() {
        return this.position;
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.visible && this.xAxisPoint != null && this.yAxisPoint != null) {
            int n;
            int n2;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setColor(this.color);
            Dimension dimension = this.chart.getSize();
            graphics2D.setClip(0, 0, dimension.width, dimension.height);
            graphics2D.setStroke(this.stroke);
            int n3 = this.xAxisPoint.x;
            int n4 = this.yAxisPoint.y;
            if (this.isVerticalLineVisible() && this.xAxisPoint.x >= this.chart.getXStart() && this.xAxisPoint.x <= this.chart.getXEnd()) {
                n2 = n4 + this.circleDiameter / 2;
                if (n2 > this.chart.getYStart()) {
                    n2 = this.chart.getYStart();
                }
                if ((n = n4 - this.circleDiameter / 2) < this.chart.getYEnd()) {
                    n = this.chart.getYEnd();
                }
                graphics2D.drawLine(this.xAxisPoint.x, this.chart.getYStart(), this.xAxisPoint.x, n2);
                graphics2D.drawLine(this.xAxisPoint.x, n, this.xAxisPoint.x, this.chart.getYEnd());
            }
            if (this.isHorizontalLineVisible() && this.yAxisPoint.y <= this.chart.getYStart() && this.yAxisPoint.y >= this.chart.getYEnd()) {
                n2 = n3 - this.circleDiameter / 2;
                if (n2 > this.chart.getXEnd()) {
                    n2 = this.chart.getXEnd();
                }
                if ((n = n3 + this.circleDiameter / 2) < this.chart.getXStart()) {
                    n = this.chart.getXStart();
                }
                graphics2D.drawLine(this.chart.getXStart(), this.yAxisPoint.y, n2, this.yAxisPoint.y);
                graphics2D.drawLine(n, this.yAxisPoint.y, this.chart.getXEnd(), this.yAxisPoint.y);
            }
            graphics2D.drawOval(n3 - this.circleDiameter / 2, n4 - this.circleDiameter / 2, this.circleDiameter, this.circleDiameter);
            graphics2D.dispose();
        }
    }

    public int getCircleDiameter() {
        return this.circleDiameter;
    }

    public void setCircleDiameter(int n) {
        int n2 = this.circleDiameter;
        this.circleDiameter = n;
        this.support.firePropertyChange(PROPERTY_CIRCLE_DIAMETER, n2, n);
    }
}

