/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.event;

import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.event.DirectionZoomEvent;
import com.jidesoft.chart.event.ZoomDirection;
import com.jidesoft.chart.event.ZoomListener;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class AxisZoomController
extends JPanel {
    private static final long serialVersionUID = 3563894591444838109L;
    private JButton zoomOutButton = new JButton("Zoom Out");
    private JButton zoomInButton = new JButton("Zoom In");
    private JLabel label = new JLabel("Axis");
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private JComboBox comboBox = new JComboBox(this.model);
    private List<ZoomListener> listeners = Collections.synchronizedList(new ArrayList());
    private Axis[] axes = new Axis[0];

    public AxisZoomController() {
    }

    public AxisZoomController(Axis ... axisArray) {
        this.setAxes(axisArray);
    }

    public void setAxes(Axis[] axisArray) {
        this.axes = axisArray;
        this.init();
    }

    public Axis[] getAxes() {
        return this.axes;
    }

    protected void init() {
        JComponent jComponent;
        if (this.axes.length == 1) {
            this.label.setText(this.axes[0].getLabel().getLabel());
            jComponent = this.label;
        } else {
            for (Axis axis : this.axes) {
                this.model.addElement(axis);
            }
            jComponent = this.comboBox;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)jComponent, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.zoomOutButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.zoomInButton, gridBagConstraints);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                ZoomDirection zoomDirection = object == AxisZoomController.this.zoomInButton ? ZoomDirection.IN : ZoomDirection.OUT;
                AxisZoomController.this.fireZoomAction(zoomDirection);
            }
        };
        this.zoomInButton.addActionListener(actionListener);
        this.zoomOutButton.addActionListener(actionListener);
        this.comboBox.setRenderer(new AxisComboBoxRenderer());
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.listeners.add(zoomListener);
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.listeners.remove(zoomListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireZoomAction(ZoomDirection zoomDirection) {
        List<ZoomListener> list = this.listeners;
        synchronized (list) {
            Object object = this.axes.length == 1 ? this.axes[0] : this.comboBox.getSelectedItem();
            DirectionZoomEvent directionZoomEvent = new DirectionZoomEvent(object, zoomDirection);
            for (ZoomListener zoomListener : this.listeners) {
                zoomListener.zoomChanged(directionZoomEvent);
            }
        }
    }

    public void setZoomOutText(String string) {
        this.zoomOutButton.setText(string);
    }

    public void setZoomInText(String string) {
        this.zoomInButton.setText(string);
    }

    public void setZoomOutIcon(Icon icon) {
        this.zoomOutButton.setIcon(icon);
    }

    public void setZoomInIcon(Icon icon) {
        this.zoomInButton.setIcon(icon);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(AxisZoomController.class.getName(), 4096);
        }
    }

    static class AxisComboBoxRenderer
    extends DefaultListCellRenderer {
        AxisComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Axis axis = (Axis)object;
            String string = axis.getLabel().getLabel();
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }
}

