/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.axis.NumericTickCalculator;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.range.Range;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;

public class DefaultNumericTickCalculator
implements NumericTickCalculator {
    public static final String PROPERTY_NUMBER_FORMAT = "numberFormat";
    public static final String PROPERTY_TICK_INTERVALS_BETWEEN_MAJORS = "tickIntervalsBetweenMajors";
    private static final Tick[] noTicks = new Tick[0];
    private static double minIntervals = 4.0;
    private static double maxIntervals = 10.0;
    private int minorTickIntervalBetweenMajors = 5;
    private static final int MAX_TICKS = 500;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private int scale = 0;

    public DefaultNumericTickCalculator() {
        this.numberFormat.setMinimumFractionDigits(0);
        this.numberFormat.setMaximumFractionDigits(2);
        this.numberFormat.setGroupingUsed(false);
    }

    public int getMinorTickIntervalBetweenMajors() {
        return this.minorTickIntervalBetweenMajors;
    }

    public void setMinorTickIntervalBetweenMajors(int n) {
        int n2 = this.minorTickIntervalBetweenMajors;
        this.minorTickIntervalBetweenMajors = n;
        this.support.firePropertyChange(PROPERTY_TICK_INTERVALS_BETWEEN_MAJORS, n2, n);
    }

    @Override
    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.support.firePropertyChange(PROPERTY_NUMBER_FORMAT, null, numberFormat);
    }

    @Override
    public void setNumberFormat(String string) {
        DecimalFormat decimalFormat = this.createDecimalFormat(string);
        this.setNumberFormat(decimalFormat);
    }

    private DecimalFormat createDecimalFormat(String string) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        decimalFormat.applyPattern(string);
        return decimalFormat;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    @Override
    public Tick[] calculateTicks(Range<Double> range) {
        double d;
        double d2;
        if (range == null) {
            return new Tick[0];
        }
        double d3 = range.minimum();
        double d4 = range.maximum();
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            return noTicks;
        }
        assert (d4 >= d3) : "Max >= Min; max is " + d4 + ", min is " + d3;
        double d5 = d4 - d3;
        if (d5 < 1.0E-8) {
            d5 = 1.0E-8;
        }
        double d6 = Math.log10(d5);
        double d7 = Math.ceil(d6 - 1.0);
        double d8 = Math.pow(10.0, d7);
        assert (maxIntervals / minIntervals >= 2.0);
        do {
            if ((d2 = d5 / d8) > maxIntervals) {
                d8 *= 2.0;
                continue;
            }
            if (!(d2 < minIntervals)) continue;
            d8 /= 2.0;
        } while (d2 < minIntervals || d2 > maxIntervals);
        double d9 = d8 / (double)this.minorTickIntervalBetweenMajors;
        double d10 = Math.ceil(d3 / d8) * d8;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        for (d = d10 - d9; d > d3 && arrayList.size() < this.minorTickIntervalBetweenMajors; d -= d9) {
            arrayList.add(new Tick(d));
        }
        d = d4 + d9 / 1000.0;
        for (double d11 = d10; d11 < d && arrayList.size() < 500; d11 += d8) {
            double d12;
            double d13;
            String string;
            if (d11 == 0.0) {
                d11 = 0.0;
            }
            if ((string = this.numberFormat.format(d13 = this.scale == 0 ? d11 : d11 * Math.pow(10.0, this.scale))).startsWith("-0")) {
                try {
                    Number number = this.numberFormat.parse(string);
                    if (number != null && (double)number.floatValue() == -0.0) {
                        string = string.substring(1);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            arrayList.add(new Tick(d11, string));
            if (!(d11 <= d4)) continue;
            for (int i = 1; i < this.minorTickIntervalBetweenMajors && !((d12 = d11 + (double)i * d9) > d4); ++i) {
                arrayList.add(new Tick(d12));
            }
        }
        return arrayList.toArray(new Tick[arrayList.size()]);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }
}

