/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.annotation;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.annotation.AbstractAnnotation;
import com.jidesoft.chart.annotation.ChartAnnotation;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.RealPosition;
import com.jidesoft.range.Positionable;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;

public class ChartImage
extends AbstractAnnotation
implements Chartable,
ChartAnnotation {
    private static final int defaultZOrder = 100;
    private Image image;
    private Positionable xMin;
    private Positionable yMin;
    private Positionable xMax;
    private Positionable yMax;
    private Point pixelOffset;

    public ChartImage(Positionable positionable, Positionable positionable2, Positionable positionable3, Positionable positionable4, Image image) {
        this.setImage(image);
        this.xMin = positionable;
        this.yMin = positionable2;
        this.xMax = positionable3;
        this.yMax = positionable4;
        this.setZOrder(100);
    }

    public ChartImage(double d, double d2, double d3, double d4, Image image) {
        this(new RealPosition(d), new RealPosition(d2), new RealPosition(d3), new RealPosition(d4), image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Positionable getXMax() {
        return this.xMax;
    }

    public void setXMax(Positionable positionable) {
        this.xMax = positionable;
    }

    public Positionable getXMin() {
        return this.xMin;
    }

    public void setXMin(Positionable positionable) {
        this.xMin = positionable;
    }

    public Positionable getYMax() {
        return this.yMax;
    }

    public void setYMax(Positionable positionable) {
        this.yMax = positionable;
    }

    public Positionable getYMin() {
        return this.yMin;
    }

    public void setYMin(Positionable positionable) {
        this.yMin = positionable;
    }

    @Override
    public Positionable getX() {
        return this.getXMin();
    }

    @Override
    public Positionable getY() {
        return this.getYMin();
    }

    public Point getPixelOffset() {
        return this.pixelOffset;
    }

    public void setPixelOffset(Point point) {
        this.pixelOffset = point;
    }

    @Override
    public int compareTo(Chartable chartable) {
        double d;
        double d2 = this.xMin.position();
        if (d2 == (d = chartable.getX().position())) {
            return 0;
        }
        if (d2 < d) {
            return -1;
        }
        return 1;
    }

    @Override
    public void draw(Graphics2D graphics2D, Chart chart) {
        if (graphics2D != null) {
            double d;
            Point point = chart.calculatePixelPoint(new Point2D.Double(this.getXMin().position(), this.getYMax().position()));
            Point point2 = chart.calculatePixelPoint(new Point2D.Double(this.getXMax().position(), this.getYMin().position()));
            Point point3 = this.getPixelOffset();
            if (point3 != null) {
                point = new Point(point.x + point3.x, point.y + point3.y);
                point2 = new Point(point2.x + point3.x, point2.y + point3.y);
            }
            int n = (d = chart.getAnimationPosition()) == 1.0 ? point.x : chart.interpolateXForAnimation(point.x, null);
            int n2 = d == 1.0 ? point.y : chart.interpolateYForAnimation(point.y, null);
            int n3 = chart.interpolateXForAnimation(point2.x, null);
            int n4 = chart.interpolateYForAnimation(point2.y, null);
            graphics2D.drawImage(this.image, n, n2, n3 - n, n4 - n2, chart);
        }
    }
}

