/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.annotation;

import com.jidesoft.chart.annotation.AbstractAnnotation;
import com.jidesoft.chart.style.LabelStyle;
import com.jidesoft.chart.util.Rotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.UIManager;

public abstract class AbstractLabel
extends AbstractAnnotation {
    private static final Logger logger = Logger.getLogger(AbstractLabel.class.getName());
    private Color defaultColor;
    private Font defaultFont;
    private Color backgroundColor = null;
    private String label;
    private LabelStyle labelStyle = new LabelStyle();
    private Dimension size = null;
    private final JLabel labelComponent = new JLabel("");

    public AbstractLabel() {
        this("");
    }

    public AbstractLabel(String string) {
        this(string, UIManager.getColor("Chart.foreground") == null ? UIManager.getColor("Panel.foreground") : UIManager.getColor("Chart.foreground"));
    }

    public AbstractLabel(String string, Color color) {
        this(string, color, UIManager.getFont("Chart.font") == null ? UIManager.getFont("Label.font") : UIManager.getFont("Chart.font"));
    }

    public AbstractLabel(String string, Color color, Font font) {
        this.setLabel(string);
        this.setColor(color);
        this.setFont(font);
    }

    public AbstractLabel(String string, LabelStyle labelStyle) {
        this.setLabel(string);
        this.setLabelStyle(labelStyle);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    protected JLabel getLabelComponent() {
        return this.labelComponent;
    }

    public Color getColor() {
        return this.labelStyle == null ? this.defaultColor : this.labelStyle.getColor();
    }

    public void setColor(Color color) {
        if (this.defaultColor == null) {
            this.defaultColor = color;
        }
        if (this.labelStyle != null) {
            this.labelStyle.setColor(color);
        }
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public Font getFont() {
        return this.labelStyle == null ? this.defaultFont : this.labelStyle.getFont();
    }

    public void setFont(Font font) {
        if (this.defaultFont == null) {
            this.defaultFont = font;
        }
        if (this.labelStyle != null) {
            this.labelStyle.setFont(font);
        }
        this.size = null;
    }

    public Double getRotation() {
        logger.finest("LabelStyle = " + this.labelStyle);
        if (this.labelStyle == null) {
            return 0.0;
        }
        return this.labelStyle.getRotation();
    }

    public void setRotation(Double d) {
        this.labelStyle.setRotation(d);
    }

    public LabelStyle getLabelStyle() {
        return this.labelStyle;
    }

    public void setLabelStyle(LabelStyle labelStyle) {
        this.labelStyle = labelStyle;
        this.size = null;
    }

    public Dimension size(Graphics graphics, Font font) {
        if (this.size == null) {
            String string = this.getLabel();
            if (string != null && string.trim().toLowerCase().startsWith("<html")) {
                Font font2 = font == null ? this.findFont() : font;
                this.labelComponent.setFont(font2);
                this.labelComponent.setText(string);
                this.size = this.labelComponent.getPreferredSize();
            } else {
                Font font3 = font == null ? graphics.getFont() : font;
                FontMetrics fontMetrics = graphics.getFontMetrics(font3);
                int n = fontMetrics.getHeight();
                String string2 = this.getLabel();
                int n2 = string2 == null ? 0 : fontMetrics.stringWidth(string2);
                this.size = new Dimension(n2, n);
            }
        }
        return this.size;
    }

    private Font findFont() {
        Font font;
        LabelStyle labelStyle = this.getLabelStyle();
        if (labelStyle == null) {
            font = UIManager.getFont("Label.font");
        } else {
            font = labelStyle.getFont();
            if (font == null) {
                font = UIManager.getFont("Label.font");
            }
        }
        return font;
    }

    private Color findTextColor() {
        Color color;
        LabelStyle labelStyle = this.getLabelStyle();
        if (labelStyle == null) {
            color = UIManager.getColor("Label.foreground");
        } else {
            color = labelStyle.getColor();
            if (color == null) {
                color = UIManager.getColor("Label.foreground");
            }
        }
        return color;
    }

    public void paint(Graphics graphics, int n, int n2, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            this.paint(graphics, n, n2, 0.0);
        } else if (rotation == Rotation.QUARTER_CLOCKWISE) {
            this.paint(graphics, n, n2, 1.5707963267948966);
        } else if (rotation == Rotation.QUARTER_ANTICLOCKWISE) {
            this.paint(graphics, n, n2, -1.5707963267948966);
        } else if (rotation == Rotation.HALF) {
            this.paint(graphics, n, n2, -Math.PI);
        } else {
            throw new RuntimeException("Unexpected value : " + (Object)((Object)rotation));
        }
    }

    public void paint(Graphics graphics, int n, int n2, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setColor(this.getColor());
        if (d == 0.0) {
            this.drawLabel(graphics2D, n, n2);
        } else {
            graphics2D.translate(n, n2);
            graphics2D.rotate(d);
            this.drawLabel(graphics2D, 0, 0);
        }
        graphics2D.dispose();
    }

    private void drawLabel(Graphics2D graphics2D, int n, int n2) {
        String string = this.getLabel();
        if (string != null && string.trim().toLowerCase().startsWith("<html")) {
            Font font = this.findFont();
            Color color = this.findTextColor();
            this.labelComponent.setForeground(color);
            this.labelComponent.setFont(font);
            this.labelComponent.setText(string);
            Dimension dimension = this.labelComponent.getPreferredSize();
            this.labelComponent.setSize(dimension);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            graphics2D.translate(n - dimension.width / 2, n2 - fontMetrics.getAscent());
            this.labelComponent.paint(graphics2D);
            graphics2D.translate(-n + dimension.width / 2, -n2 + fontMetrics.getAscent());
        } else if (string != null) {
            Font font = this.getFont();
            if (font == null) {
                font = graphics2D.getFont();
            } else {
                graphics2D.setFont(font);
            }
            assert (font != null) : "Font cannot be null";
            Dimension dimension = this.size(graphics2D, font);
            graphics2D.drawString(string, n - dimension.width / 2, n2);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.label == null ? 0 : this.label.hashCode());
        n = 31 * n + (this.labelStyle == null ? 0 : this.labelStyle.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractLabel abstractLabel = (AbstractLabel)object;
        if (this.label == null ? abstractLabel.label != null : !this.label.equals(abstractLabel.label)) {
            return false;
        }
        return !(this.labelStyle == null ? abstractLabel.labelStyle != null : !this.labelStyle.equals(abstractLabel.labelStyle));
    }

    public String toString() {
        return String.format("#<Label label=%s>", this.label);
    }
}

