/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.style.ChartStyle;
import java.lang.ref.WeakReference;
import java.util.Comparator;

public class ZOrderModelComparator
implements Comparator<ChartModel> {
    private WeakReference<Chart> chartRef;

    public ZOrderModelComparator(Chart chart) {
        this.chartRef = new WeakReference<Chart>(chart);
    }

    private boolean isLineChart(ChartModel chartModel) {
        Chart chart = (Chart)this.chartRef.get();
        if (chart == null) {
            return false;
        }
        ChartStyle chartStyle = chart.getStyle(chartModel);
        return chartStyle == null || chartStyle.isLinesVisible() && chartStyle.getLineFill() == null;
    }

    private boolean isAreaChart(ChartModel chartModel) {
        Chart chart = (Chart)this.chartRef.get();
        if (chart == null) {
            return false;
        }
        ChartStyle chartStyle = chart.getStyle(chartModel);
        return chartStyle != null && chartStyle.getLineFill() != null;
    }

    private boolean isBarChart(ChartModel chartModel) {
        Chart chart = (Chart)this.chartRef.get();
        if (chart == null) {
            return false;
        }
        ChartStyle chartStyle = chart.getStyle(chartModel);
        return chartStyle != null && chartStyle.isBarsVisible();
    }

    @Override
    public int compare(ChartModel chartModel, ChartModel chartModel2) {
        Chart chart = (Chart)this.chartRef.get();
        if (chart == null) {
            return 0;
        }
        Integer n = chart.getZOrder(chartModel);
        Integer n2 = chart.getZOrder(chartModel2);
        if (n == null) {
            n = 100;
        }
        if (n2 == null) {
            n2 = 100;
        }
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        boolean bl = this.isAreaChart(chartModel);
        boolean bl2 = this.isAreaChart(chartModel2);
        if (!bl || !bl2) {
            if (bl) {
                return -1;
            }
            if (bl2) {
                return 1;
            }
        }
        boolean bl3 = this.isBarChart(chartModel);
        boolean bl4 = this.isBarChart(chartModel2);
        if (!bl3 || !bl4) {
            if (bl3) {
                return -1;
            }
            if (bl4) {
                return 1;
            }
        }
        boolean bl5 = this.isLineChart(chartModel);
        boolean bl6 = this.isLineChart(chartModel2);
        if (!bl5 || !bl6) {
            if (bl5) {
                return -1;
            }
            if (bl6) {
                return 1;
            }
        }
        return 0;
    }
}

