/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartException;
import com.jidesoft.chart.ChartPainter;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.fit.FunctionMap;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.Highlightable;
import com.jidesoft.chart.model.LeanChartModel;
import com.jidesoft.chart.render.LineRenderer;
import com.jidesoft.chart.render.LineRenderer2D;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.style.LineStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class LinePainter
implements ChartPainter {
    private final Map<ChartModel, List<Shape>> shapeMap = Collections.synchronizedMap(new HashMap());

    LinePainter() {
    }

    public void clearShapes() {
        this.shapeMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ChartModel> nearLine(Point point, float f) {
        HashSet<ChartModel> hashSet = new HashSet<ChartModel>();
        if (point == null) {
            return hashSet;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)point.x - (1.0f + f) / 2.0f, (float)point.y - (1.0f + f) / 2.0f, 1.0f + f * 2.0f, 1.0f + f * 2.0f);
        Map<ChartModel, List<Shape>> map = this.shapeMap;
        synchronized (map) {
            for (Map.Entry<ChartModel, List<Shape>> entry : this.shapeMap.entrySet()) {
                List<Shape> list = entry.getValue();
                for (Shape shape : list) {
                    if (!shape.intersects(float_)) continue;
                    hashSet.add(entry.getKey());
                }
            }
        }
        return hashSet;
    }

    @Override
    public void drawChart(Graphics graphics, Chart chart, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        ChartStyle chartStyle = chart.getStyle(chartModel);
        LineStyle lineStyle = chartStyle == null ? null : chartStyle.getLineStyle();
        double d = chart.getAnimationPosition();
        if (chartStyle == null || chartStyle.isLinesVisible()) {
            Object object;
            Object object2;
            LineRenderer lineRenderer = chart.getLineRenderer(chartModel);
            if (lineRenderer instanceof LineRenderer2D) {
                this.drawChart2D(graphics2D, chart, chartModel, n, userToPixelTransform, bl, (LineRenderer2D)lineRenderer);
                return;
            }
            int n2 = chartModel.getPointCount();
            boolean bl2 = chartModel.isCyclical();
            int[] nArray = new int[n2 + (bl2 ? 1 : 0)];
            int[] nArray2 = new int[n2 + (bl2 ? 1 : 0)];
            boolean bl3 = false;
            Integer n3 = null;
            Integer n4 = null;
            int n5 = 0;
            LineStyle lineStyle2 = null;
            for (int i = 0; i < n2; ++i) {
                Object object3;
                Highlightable highlightable;
                Highlight highlight;
                Object object4;
                Object object5;
                LineStyle lineStyle3 = lineStyle;
                if (bl && i % 100 == 0 && Thread.interrupted()) {
                    return;
                }
                object2 = null;
                if (chartModel instanceof LeanChartModel) {
                    object5 = (LeanChartModel)chartModel;
                    object4 = object5.getPointPositions(i);
                    double d2 = object4[0];
                    double d3 = object4[1];
                    object = chart.calculatePixelPoint((Point2D)new Point2D.Double(d2, d3), userToPixelTransform);
                } else {
                    object2 = chartModel.getPoint(i);
                    object5 = object2 == null ? null : object2.getX();
                    object4 = object2 == null ? null : object2.getY();
                    object = object5 == null || object4 == null ? null : chart.calculatePixelPoint((Point2D)new Point2D.Double(object5.position(), object4.position()), userToPixelTransform);
                    Object object6 = object;
                }
                if (object != null) {
                    nArray[n5] = d == 1.0 ? object.x : chart.interpolateXForAnimation(object.x, chartModel);
                    int n6 = nArray2[n5] = d == 1.0 ? object.y : chart.interpolateYForAnimation(object.y, chartModel);
                    if (!bl3) {
                        n3 = nArray[0];
                        n4 = nArray2[0];
                        bl3 = true;
                    }
                    if (chart.isHighQuality() && chartModel.getPointCount() > 1) {
                        try {
                            object5 = (Point2D.Double)chart.calculateUserPoint((Point)object);
                            if (object5 != null) {
                                double d4 = FunctionMap.getYApproximately(chartModel, ((Point2D.Double)object5).getX());
                                ((Point2D.Double)object5).setLocation(((Point2D.Double)object5).x, d4);
                                object = chart.calculatePixelPoint((Point2D)object5, userToPixelTransform);
                            }
                        }
                        catch (ChartException chartException) {
                            // empty catch block
                        }
                    }
                    if (chart.isLabellingTraces() && i == chartModel.getPointCount() - 1) {
                        this.paintTraceLabel(graphics2D, chart, chartModel, (Point2D)object);
                    }
                    ++n5;
                }
                object5 = null;
                if (object2 instanceof Highlightable && (highlight = (highlightable = (Highlightable)object2).getHighlight()) != null && (object5 = chart.getHighlightStyle(highlight)) != null) {
                    lineStyle3 = ((ChartStyle)object5).getLineStyle();
                }
                if (object5 != null && !((ChartStyle)object5).isLinesVisible()) {
                    int[] nArray3 = LinePainter.copyOf(nArray, n5);
                    int[] nArray4 = LinePainter.copyOf(nArray2, n5);
                    if (nArray3.length > 1 && nArray4.length > 1) {
                        object3 = lineRenderer.renderLine(graphics2D, chartModel, nArray3, nArray4, chartStyle);
                        this.recordShape(chart, chartModel, (Shape)object3);
                    }
                    nArray = new int[n2 + (bl2 ? 1 : 0)];
                    nArray2 = new int[n2 + (bl2 ? 1 : 0)];
                    n5 = 0;
                } else if (lineStyle3 != null && !lineStyle3.equals(lineStyle2)) {
                    int[] nArray5 = LinePainter.copyOf(nArray, n5);
                    int[] nArray6 = LinePainter.copyOf(nArray2, n5);
                    if (nArray5.length > 1 && nArray6.length > 1) {
                        object3 = new ChartStyle(chartStyle);
                        ((ChartStyle)object3).setLineStyle(lineStyle2);
                        Shape shape = lineRenderer.renderLine(graphics2D, chartModel, nArray5, nArray6, (ChartStyle)object3);
                        this.recordShape(chart, chartModel, shape);
                    }
                    object3 = nArray.length == 0 || nArray5.length == 0 ? null : Integer.valueOf(nArray5[nArray5.length - 1]);
                    Integer n7 = nArray2.length == 0 || nArray6.length == 0 ? null : Integer.valueOf(nArray6[nArray6.length - 1]);
                    nArray = new int[n2 + (bl2 ? 1 : 0)];
                    nArray2 = new int[n2 + (bl2 ? 1 : 0)];
                    n5 = 0;
                    if (object3 != null && n7 != null) {
                        nArray[0] = (Integer)object3;
                        nArray2[0] = n7;
                        ++n5;
                    }
                }
                lineStyle2 = lineStyle3;
            }
            if (bl2 && n2 > 0 && n3 != null && n4 != null) {
                nArray[n5] = n3;
                nArray2[n5] = n4;
                ++n5;
            }
            int[] nArray7 = LinePainter.copyOf(nArray, n5);
            object = LinePainter.copyOf(nArray2, n5);
            object2 = lineRenderer.renderLine(graphics2D, chartModel, nArray7, (int[])object, chartStyle);
            this.recordShape(chart, chartModel, (Shape)object2);
        }
    }

    private void recordShape(Chart chart, ChartModel chartModel, Shape shape) {
        if (shape != null && chart.isRecordingShapes()) {
            List<Shape> list = this.shapeMap.get(chartModel);
            if (list == null) {
                list = new ArrayList<Shape>();
                this.shapeMap.put(chartModel, list);
            }
            list.add(shape);
        }
    }

    private static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = i < nArray.length ? nArray[i] : 0;
        }
        return nArray2;
    }

    private static double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = i < dArray.length ? dArray[i] : 0.0;
        }
        return dArray2;
    }

    public void drawChart2D(Graphics2D graphics2D, Chart chart, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform, boolean bl, LineRenderer2D lineRenderer2D) {
        Object object;
        int n2 = chartModel.getPointCount();
        ChartStyle chartStyle = chart.getStyle(chartModel);
        LineStyle lineStyle = chartStyle == null ? null : chartStyle.getLineStyle();
        boolean bl2 = chartModel.isCyclical();
        double[] dArray = new double[n2 + (bl2 ? 1 : 0)];
        double[] dArray2 = new double[n2 + (bl2 ? 1 : 0)];
        boolean bl3 = false;
        Double d = null;
        Double d2 = null;
        int n3 = 0;
        LineStyle lineStyle2 = null;
        double d3 = chart.getAnimationPosition();
        for (int i = 0; i < n2; ++i) {
            Highlight highlight;
            Object object2;
            Object object3;
            LineStyle lineStyle3 = lineStyle;
            Chartable chartable = null;
            if (bl && i % 100 == 0 && Thread.interrupted()) {
                return;
            }
            if (chartModel instanceof LeanChartModel) {
                object3 = (LeanChartModel)chartModel;
                object2 = object3.getPointPositions(i);
                double d4 = object2[0];
                double d5 = object2[1];
                object = chart.calculatePixelPoint2D((Point2D)new Point2D.Double(d4, d5), userToPixelTransform);
            } else {
                chartable = chartModel.getPoint(i);
                object3 = chartable.getX();
                object2 = chartable.getY();
                Object object4 = object = object3 == null || object2 == null ? null : chart.calculatePixelPoint2D((Point2D)new Point2D.Double(object3.position(), object2.position()), userToPixelTransform);
            }
            if (object != null) {
                dArray[n3] = d3 == 1.0 ? ((Point2D)object).getX() : (double)chart.interpolateXForAnimation((int)((Point2D)object).getX(), chartModel);
                double d6 = dArray2[n3] = d3 == 1.0 ? ((Point2D)object).getY() : (double)chart.interpolateYForAnimation((int)((Point2D)object).getY(), chartModel);
                if (!bl3) {
                    d = dArray[0];
                    d2 = dArray2[0];
                    bl3 = true;
                }
                if (chart.isLabellingTraces() && i == chartModel.getPointCount() - 1) {
                    this.paintTraceLabel(graphics2D, chart, chartModel, (Point2D)object);
                }
                ++n3;
            }
            object3 = null;
            if (chartable instanceof Highlightable && (highlight = (object2 = (Highlightable)((Object)chartable)).getHighlight()) != null) {
                object3 = chart.getHighlightStyle(highlight);
                lineStyle3 = ((ChartStyle)object3).getLineStyle();
            }
            if (object3 != null && !((ChartStyle)object3).isLinesVisible()) {
                object2 = LinePainter.copyOf(dArray, n3);
                double[] dArray3 = LinePainter.copyOf(dArray2, n3);
                if (((double[])object2).length > 1 && dArray3.length > 1) {
                    lineRenderer2D.renderLine(graphics2D, chartModel, (double[])object2, dArray3, chartStyle);
                }
                dArray = new double[n2 + (bl2 ? 1 : 0)];
                dArray2 = new double[n2 + (bl2 ? 1 : 0)];
                n3 = 0;
            } else if (lineStyle3 != null && !lineStyle3.equals(lineStyle2)) {
                ChartStyle chartStyle2;
                object2 = LinePainter.copyOf(dArray, n3);
                double[] dArray4 = LinePainter.copyOf(dArray2, n3);
                if (((double[])object2).length > 1 && dArray4.length > 1) {
                    chartStyle2 = new ChartStyle(chartStyle);
                    chartStyle2.setLineStyle(lineStyle2);
                    lineRenderer2D.renderLine(graphics2D, chartModel, (double[])object2, dArray4, chartStyle2);
                }
                chartStyle2 = dArray.length == 0 ? null : Double.valueOf(object2[((double[])object2).length - 1]);
                Double d7 = dArray2.length == 0 ? null : Double.valueOf(dArray4[dArray4.length - 1]);
                dArray = new double[n2 + (bl2 ? 1 : 0)];
                dArray2 = new double[n2 + (bl2 ? 1 : 0)];
                n3 = 0;
                if (chartStyle2 != null && d7 != null) {
                    dArray[0] = (Double)((Object)chartStyle2);
                    dArray2[0] = d7;
                    ++n3;
                }
            }
            lineStyle2 = lineStyle3;
        }
        if (bl2 && n2 > 0) {
            dArray[n2] = d;
            dArray2[n2] = d2;
        }
        double[] dArray5 = LinePainter.copyOf(dArray, n3);
        object = LinePainter.copyOf(dArray2, n3);
        if (dArray5.length > 1 && ((double[])object).length > 1) {
            lineRenderer2D.renderLine(graphics2D, chartModel, dArray5, (double[])object, chartStyle);
        }
    }

    private void paintTraceLabel(Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D) {
        String string = chartModel.getName();
        if (string != null) {
            int n = graphics2D.getFontMetrics().getDescent();
            Color color = graphics2D.getColor();
            Color color2 = chart.getLabelColor();
            graphics2D.setColor(color2);
            graphics2D.drawString(chartModel.getName(), (int)point2D.getX() + 5, (int)point2D.getY() + n);
            graphics2D.setColor(color);
        }
    }
}

