/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LabelPlacement;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.Shadowable;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.axis.Axis;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JViewport;

public class IntervalMarker
implements Drawable,
Frontable,
Shadowable,
ZOrder {
    public static final String PROPERTY_VISIBLE = "Visible";
    public static final String PROPERTY_ORIENTATION = "Orientation";
    public static final String PROPERTY_CHART = "Chart";
    public static final String PROPERTY_COLOR = "Color";
    public static final String PROPERTY_PAINT = "Paint";
    public static final String PROPERTY_MAX = "Maximum";
    public static final String PROPERTY_MIN = "Minimum";
    public static final String PROPERTY_LABEL = "Label";
    public static final String PROPERTY_LABEL_PLACEMENT = "Label Placement";
    public static final String PROPERTY_LABEL_COLOR = "Label Color";
    public static final String PROPERTY_LABEL_FONT = "Label Font";
    public static final String PROPERTY_AT_FRONT = "At Front";
    public static final String PROPERTY_OUTLINE_COLOR = "Outline Color";
    public static final String PROPERTY_OUTLINE_STROKE = "Outline Stroke";
    public static final String PROPERTY_SHADOW_VISIBLE = "Shadow Visible";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private Chart chart;
    private Paint paint = new Color(255, 0, 0, 128);
    private Orientation orientation = Orientation.vertical;
    private double min;
    private double max;
    private boolean visible = true;
    private boolean atFront = false;
    private boolean shadowVisible = false;
    private String label;
    private LabelPlacement labelPlacement;
    private Color labelColor;
    private Color outlineColor;
    private Stroke outlineStroke = new BasicStroke(1.0f);
    private Font labelFont;
    private static final int distanceFromEdge = 4;
    private int zOrder = 100;

    public IntervalMarker() {
    }

    public IntervalMarker(Chart chart) {
        this.chart = chart;
    }

    public IntervalMarker(Chart chart, double d, double d2, Paint paint) {
        this.chart = chart;
        this.paint = paint;
        this.setInterval(d, d2);
    }

    public IntervalMarker(Chart chart, Orientation orientation, double d, double d2, Paint paint) {
        this.chart = chart;
        this.paint = paint;
        this.orientation = orientation;
        this.setInterval(d, d2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Chart getChart() {
        return this.chart;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.chart;
        this.chart = chart;
        this.support.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.visible;
        this.visible = bl;
        this.support.firePropertyChange(PROPERTY_VISIBLE, bl2, bl);
    }

    public Color getColor() {
        if (this.paint instanceof Color) {
            return (Color)this.paint;
        }
        return null;
    }

    public void setColor(Color color) {
        Paint paint = this.paint;
        this.paint = color;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_COLOR, paint, color);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.paint;
        this.paint = paint;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_PAINT, paint2, paint);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        Orientation orientation2 = this.orientation;
        this.orientation = orientation;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_ORIENTATION, (Object)orientation2, (Object)orientation);
    }

    @Override
    public int getZOrder() {
        return this.zOrder;
    }

    @Override
    public void setZOrder(int n) {
        this.zOrder = n;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double d) {
        double d2 = this.min;
        this.min = d;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_MIN, d2, d);
    }

    public void setMax(double d) {
        double d2 = this.max;
        this.max = d;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_MAX, d2, d);
    }

    public void setInterval(double d, double d2) {
        double d3 = this.min;
        double d4 = this.max;
        this.min = d;
        this.max = d2;
        if (this.chart != null) {
            this.chart.repaint();
        }
        this.support.firePropertyChange(PROPERTY_MIN, d3, d);
        this.support.firePropertyChange(PROPERTY_MAX, d4, d2);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.support.firePropertyChange(PROPERTY_LABEL, string2, string);
    }

    public LabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    public void setLabelPlacement(LabelPlacement labelPlacement) {
        LabelPlacement labelPlacement2 = this.labelPlacement;
        this.labelPlacement = labelPlacement;
        this.support.firePropertyChange(PROPERTY_LABEL_PLACEMENT, (Object)labelPlacement2, (Object)labelPlacement);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.labelColor;
        this.labelColor = color;
        this.support.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        Font font2 = this.labelFont;
        this.labelFont = font;
        this.support.firePropertyChange(PROPERTY_LABEL_FONT, font2, font);
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public void setOutlineColor(Color color) {
        Color color2 = this.outlineColor;
        this.outlineColor = color;
        this.support.firePropertyChange(PROPERTY_OUTLINE_COLOR, color2, color);
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        Stroke stroke2 = this.outlineStroke;
        this.outlineStroke = stroke;
        this.support.firePropertyChange(PROPERTY_OUTLINE_STROKE, stroke2, stroke);
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (this.chart == null) {
            return;
        }
        if (this.visible) {
            Axis axis = this.chart.getXAxis();
            Axis axis2 = this.chart.getYAxis();
            if (this.orientation == Orientation.horizontal) {
                double d = axis == null ? 0.0 : axis.minimum();
                double d2 = axis2.isFlipped() ? this.max : this.min;
                double d3 = axis2.isFlipped() ? this.min : this.max;
                Point point = this.chart.calculatePixelPoint(new Point2D.Double(d, d2));
                Point point2 = this.chart.calculatePixelPoint(new Point2D.Double(d, d3));
                if (point != null && point2 != null) {
                    Paint paint = this.createHorizontalPaint(this.chart, point.y, point2.y);
                    point2.x = this.chart.getXStart();
                    graphics2D.setPaint(paint);
                    graphics2D.fillRect(point2.x, point2.y, this.chart.getChartWidth(), point.y - point2.y);
                    if (this.outlineColor != null && this.outlineStroke != null) {
                        graphics2D.setColor(this.outlineColor);
                        graphics2D.setStroke(this.outlineStroke);
                        graphics2D.drawLine(this.chart.getXStart(), point2.y, this.chart.getXEnd(), point2.y);
                        graphics2D.drawLine(this.chart.getXStart(), point.y, this.chart.getXEnd(), point.y);
                    }
                    if (this.label != null) {
                        this.paintLabel(graphics2D, this.label, point.x, point2.y, this.chart.getChartWidth(), point.y - point2.y);
                    }
                }
            } else if (this.orientation == Orientation.vertical) {
                double d = axis2 == null ? 0.0 : axis2.minimum();
                double d4 = axis.isFlipped() ? this.max : this.min;
                double d5 = axis.isFlipped() ? this.min : this.max;
                Point point = this.chart.calculatePixelPoint(new Point2D.Double(d4, d));
                Point point3 = this.chart.calculatePixelPoint(new Point2D.Double(d5, d));
                if (point != null && point3 != null) {
                    Paint paint = this.createVerticalPaint(this.chart, point.x, point3.x);
                    graphics2D.setPaint(paint);
                    graphics2D.fillRect(point.x, this.chart.getYEnd(), point3.x - point.x, this.chart.getChartHeight());
                    if (this.outlineColor != null && this.outlineStroke != null) {
                        graphics2D.setColor(this.outlineColor);
                        graphics2D.setStroke(this.outlineStroke);
                        graphics2D.drawLine(point3.x, this.chart.getYStart(), point3.x, this.chart.getYEnd());
                        graphics2D.drawLine(point.x, this.chart.getYStart(), point.x, this.chart.getYEnd());
                    }
                    if (this.label != null) {
                        this.paintLabel(graphics2D, this.label, point.x, this.chart.getYEnd(), point3.x - point.x, this.chart.getChartHeight());
                    }
                }
            }
        }
        graphics2D.dispose();
    }

    protected Paint createHorizontalPaint(Chart chart, int n, int n2) {
        return this.paint;
    }

    protected Paint createVerticalPaint(Chart chart, int n, int n2) {
        return this.paint;
    }

    private void paintLabel(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.labelFont != null) {
            graphics2D.setFont(this.labelFont);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n7 = fontMetrics.stringWidth(string);
        int n8 = fontMetrics.getHeight();
        int n9 = fontMetrics.getAscent();
        int n10 = n + n3;
        int n11 = n2 + n4;
        Rectangle rectangle = null;
        Container container = this.chart.getParent();
        if (container != null && container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            rectangle = jViewport.getViewRect();
        }
        if (this.labelPlacement == LabelPlacement.WEST || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.SOUTH_WEST) {
            n6 = n + 4;
            if (rectangle != null) {
                n6 += rectangle.x;
            }
        } else if (this.labelPlacement == LabelPlacement.EAST || this.labelPlacement == LabelPlacement.NORTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_EAST) {
            n6 = n10 - n7 - 4;
            if (rectangle != null) {
                n6 = n6 - this.chart.getChartWidth() + rectangle.x + rectangle.width;
            }
        } else {
            n6 = n + n3 / 2 - n7 / 2;
            if (rectangle != null) {
                n6 += rectangle.x;
            }
        }
        if (this.labelPlacement == LabelPlacement.NORTH || this.labelPlacement == LabelPlacement.NORTH_WEST || this.labelPlacement == LabelPlacement.NORTH_EAST) {
            n5 = n2 + n8;
            if (rectangle != null) {
                n5 += rectangle.y;
            }
        } else if (this.labelPlacement == LabelPlacement.SOUTH || this.labelPlacement == LabelPlacement.SOUTH_EAST || this.labelPlacement == LabelPlacement.SOUTH_WEST) {
            n5 = n11 - 4;
            if (rectangle != null) {
                n5 = n5 + this.chart.getChartHeight() + rectangle.y + rectangle.height;
            }
        } else {
            n5 = (n2 + n11) / 2 + n9 / 2;
            if (rectangle != null) {
                n5 += rectangle.y;
            }
        }
        if (rectangle != null) {
            n5 += rectangle.y;
        }
        if (this.labelColor == null) {
            graphics2D.setColor(Color.black);
        } else {
            graphics2D.setColor(this.labelColor);
        }
        graphics2D.drawString(string, n6, n5);
    }

    @Override
    public boolean isAtFront() {
        return this.atFront;
    }

    @Override
    public void setAtFront(boolean bl) {
        boolean bl2 = this.atFront;
        this.atFront = bl;
        this.support.firePropertyChange(PROPERTY_AT_FRONT, bl2, bl);
    }

    @Override
    public boolean isShadowVisible() {
        return this.shadowVisible;
    }

    @Override
    public void setShadowVisible(boolean bl) {
        boolean bl2 = this.shadowVisible;
        this.shadowVisible = bl;
        this.support.firePropertyChange(PROPERTY_SHADOW_VISIBLE, bl2, bl);
    }
}

