/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;

class ChartRolloverListener
implements MouseListener,
MouseMotionListener {
    public static final int DOUBLE_CLICK = 2;
    private Chart chart;
    private Chartable rolloverPoint;
    private PointDescriptor focusPoint;
    private boolean rollover = false;
    private boolean selectionEnabled = false;
    private int anchor = -1;
    private final List<ActionListener> doubleClickListeners = Collections.synchronizedList(new ArrayList());
    private boolean selectWhileDragging;
    private int selectionButton = 0;

    public ChartRolloverListener(Chart chart) {
        this.chart = chart;
    }

    public void addDoubleClickListener(ActionListener actionListener) {
        if (actionListener != null && !this.doubleClickListeners.contains(actionListener)) {
            this.doubleClickListeners.add(actionListener);
        }
    }

    public void removeDoubleClickListener(ActionListener actionListener) {
        this.doubleClickListeners.remove(actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireActionPerformed(ActionEvent actionEvent) {
        List<ActionListener> list = this.doubleClickListeners;
        synchronized (list) {
            ActionListener[] actionListenerArray;
            for (ActionListener actionListener : actionListenerArray = this.doubleClickListeners.toArray(new ActionListener[this.doubleClickListeners.size()])) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public boolean isRolloverVisible() {
        return this.rollover;
    }

    public void setRolloverVisible(boolean bl) {
        this.rollover = bl;
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean bl) {
        this.selectionEnabled = bl;
    }

    public int getSelectionButton() {
        return this.selectionButton;
    }

    public void setSelectionButton(int n) {
        this.selectionButton = n;
    }

    protected void fireDoubleClick(MouseEvent mouseEvent) {
        ActionEvent actionEvent = new ActionEvent(this.chart, 2, "doubleClick", System.currentTimeMillis(), mouseEvent.getModifiers());
        this.fireActionPerformed(actionEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.fireDoubleClick(mouseEvent);
        } else {
            this.checkRollover(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.chart.setCurrentChartPoint(null);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Chartable chartable = this.checkRollover(mouseEvent);
        boolean bl = this.selectionButton == 0 || mouseEvent.getButton() == this.selectionButton;
        this.chart.setCurrentChartPoint(chartable);
        if (bl && this.selectionEnabled && this.focusPoint != null) {
            int n = this.focusPoint.getIndex();
            ChartModel chartModel = this.focusPoint.getModel();
            ListSelectionModel listSelectionModel = this.chart.getSelectionsForModel(chartModel);
            if (listSelectionModel != null) {
                int n2 = listSelectionModel.getSelectionMode();
                switch (n2) {
                    case 0: {
                        if (listSelectionModel.isSelectedIndex(n)) {
                            listSelectionModel.removeSelectionInterval(n, n);
                            break;
                        }
                        listSelectionModel.addSelectionInterval(n, n);
                        break;
                    }
                    case 1: {
                        if (this.isIntervalSelect(mouseEvent) && this.anchor >= 0) {
                            listSelectionModel.setSelectionInterval(this.anchor, n);
                            break;
                        }
                        listSelectionModel.setSelectionInterval(n, n);
                        this.anchor = n;
                        break;
                    }
                    case 2: {
                        if (this.isIntervalSelect(mouseEvent)) {
                            if (this.anchor >= 0) {
                                listSelectionModel.setSelectionInterval(this.anchor, n);
                                break;
                            }
                            listSelectionModel.setSelectionInterval(n, n);
                            this.anchor = n;
                            break;
                        }
                        if (this.isIntervalAdd(mouseEvent)) {
                            if (listSelectionModel.isSelectedIndex(n)) {
                                listSelectionModel.removeSelectionInterval(n, n);
                            } else {
                                listSelectionModel.addSelectionInterval(n, n);
                            }
                            this.anchor = n;
                            break;
                        }
                        listSelectionModel.setSelectionInterval(n, n);
                        this.anchor = n;
                    }
                }
            }
            this.chart.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Chartable chartable = this.checkRollover(mouseEvent);
        this.chart.setCurrentChartPoint(chartable);
        this.selectWhileDragging = UIManager.getBoolean("ChartRolloverListener.selectWhileDragging");
        if (this.selectWhileDragging && this.selectionEnabled && this.focusPoint != null) {
            int n = this.focusPoint.getIndex();
            ChartModel chartModel = this.focusPoint.getModel();
            ListSelectionModel listSelectionModel = this.chart.getSelectionsForModel(chartModel);
            if (listSelectionModel != null) {
                int n2 = listSelectionModel.getSelectionMode();
                switch (n2) {
                    case 0: {
                        listSelectionModel.setSelectionInterval(n, n);
                        break;
                    }
                    case 1: {
                        listSelectionModel.addSelectionInterval(n, n);
                        break;
                    }
                    case 2: {
                        listSelectionModel.addSelectionInterval(n, n);
                    }
                }
            }
        }
        if (this.rollover) {
            this.chart.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Chartable chartable = this.rolloverPoint;
        Chartable chartable2 = this.checkRollover(mouseEvent);
        this.chart.setCurrentChartPoint(chartable2);
        if (this.rollover && chartable2 != null && !chartable2.equals(chartable)) {
            this.chart.repaint();
        }
    }

    private Chartable checkRollover(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        PointDescriptor pointDescriptor = this.chart.containingShape(point);
        if (pointDescriptor == null) {
            this.focusPoint = null;
            return null;
        }
        this.rolloverPoint = pointDescriptor.getChartable();
        if (this.focusPoint != null && !this.focusPoint.equals(pointDescriptor)) {
            this.focusPoint = null;
            return null;
        }
        if (this.rolloverPoint != null) {
            this.focusPoint = pointDescriptor;
            return this.rolloverPoint;
        }
        ChartModel chartModel = pointDescriptor.getModel();
        this.rolloverPoint = chartModel.getPoint(pointDescriptor.getIndex());
        if (this.rolloverPoint != null) {
            this.focusPoint = pointDescriptor;
            return this.rolloverPoint;
        }
        this.focusPoint = null;
        return null;
    }

    private boolean isIntervalSelect(MouseEvent mouseEvent) {
        return mouseEvent.isShiftDown();
    }

    private boolean isIntervalAdd(MouseEvent mouseEvent) {
        if (ChartRolloverListener.isMac()) {
            return mouseEvent.isMetaDown();
        }
        return mouseEvent.isControlDown();
    }

    private static boolean isMac() {
        String string = System.getProperty("os.name").toLowerCase();
        return string != null && string.startsWith("mac");
    }
}

