/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.LeanChartModel;
import com.jidesoft.swing.AnimatorListener;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

class ChartAnimator
implements AnimatorListener {
    private Chart chart;
    private Map<String, Integer> modelMeans = new HashMap<String, Integer>();

    public ChartAnimator(Chart chart) {
        assert (chart != null);
        this.chart = chart;
    }

    @Override
    public void animationEnds(Component component) {
    }

    @Override
    public void animationFrame(Component component, int n, int n2) {
        double d = (double)n2 / (double)n;
        this.chart.setAnimationPosition(d);
        if (n2 == n) {
            this.chart.update();
        }
    }

    @Override
    public void animationStarts(Component component) {
        this.chart.setAnimationPosition(0.0);
        this.modelMeans.clear();
    }

    int interpolateXForAnimation(int n, ChartModel chartModel) {
        if (this.chart.isAnimateOnShow()) {
            int n2 = (this.chart.getXStart() + this.chart.getXEnd()) / 2;
            double d = this.chart.getAnimationPosition() * 2.0;
            if (d > 1.0) {
                d = 1.0;
            }
            int n3 = n2 - n;
            int n4 = n2 - (int)(d * (double)n3);
            return n4;
        }
        return n;
    }

    int interpolateYForAnimation(int n, ChartModel chartModel) {
        if (this.chart.isAnimateOnShow() && this.chart.getAnimationPosition() < 1.0) {
            double d;
            double d2;
            Integer n2;
            if (chartModel == null) {
                return n;
            }
            String string = chartModel.getName();
            Integer n3 = n2 = string == null ? null : this.modelMeans.get(string);
            if (n2 == null) {
                n2 = chartModel.getPointCount() == 0 ? Integer.valueOf((this.chart.getYStart() + this.chart.getYEnd()) / 2) : Integer.valueOf(this.meanY(chartModel));
                this.modelMeans.put(string, n2);
            }
            if ((d2 = Math.sin(1.5707963267948966 * (d = this.chart.getAnimationPosition() < 0.5 ? 0.0 : (this.chart.getAnimationPosition() - 0.5) * 2.0))) < 0.0) {
                d2 = 0.0;
            }
            int n4 = n2 - n;
            return n2 - (int)(d2 * (double)n4);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int meanY(ChartModel chartModel) {
        double d = 0.0;
        int n = 0;
        ChartModel chartModel2 = chartModel;
        synchronized (chartModel2) {
            UserToPixelTransform userToPixelTransform = this.chart.getTransformForModel(chartModel);
            for (int i = 0; i < chartModel.getPointCount(); ++i) {
                int n2;
                Point point;
                Object object;
                Object object2;
                if (chartModel instanceof LeanChartModel) {
                    object2 = (LeanChartModel)chartModel;
                    object = object2.getPointPositions(i);
                    double d2 = object[0];
                    double d3 = object[1];
                    point = this.chart.calculatePixelPoint((Point2D)new Point2D.Double(d2, d3), userToPixelTransform);
                } else {
                    object2 = chartModel.getPoint(i);
                    object = object2 == null ? null : object2.getY();
                    Point point2 = point = object == null ? null : this.chart.calculatePixelPoint((Point2D)new Point2D.Double(0.0, object.position()), userToPixelTransform);
                }
                if (point == null || (n2 = point.y) < this.chart.getYEnd() || n2 > this.chart.getYStart()) continue;
                d += (double)n2;
                ++n;
            }
        }
        int n3 = n == 0 ? 0 : (int)(d / (double)n);
        return n3;
    }
}

