/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.Animatable;
import com.jidesoft.chart.AnimatedChart;
import com.jidesoft.chart.AutoRanger;
import com.jidesoft.chart.BarPainter;
import com.jidesoft.chart.BarResizePolicy;
import com.jidesoft.chart.ChartAnimator;
import com.jidesoft.chart.ChartRolloverListener;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.ChartUIDefaultsCustomizer;
import com.jidesoft.chart.DefaultAutoRanger;
import com.jidesoft.chart.Drawable;
import com.jidesoft.chart.Frontable;
import com.jidesoft.chart.LazyRenderer;
import com.jidesoft.chart.LinePainter;
import com.jidesoft.chart.MultiAutoRanger;
import com.jidesoft.chart.MultiImageLazyChartRenderer;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.PieChartPainter;
import com.jidesoft.chart.PointPainter;
import com.jidesoft.chart.ShadowVisibility;
import com.jidesoft.chart.Shadowable;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.ZOrder;
import com.jidesoft.chart.ZOrderModelComparator;
import com.jidesoft.chart.annotation.AbstractAnnotation;
import com.jidesoft.chart.annotation.AbstractLabel;
import com.jidesoft.chart.annotation.Annotation;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.annotation.ChartAnnotation;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.event.ImageChangeEvent;
import com.jidesoft.chart.event.ImageChangeListener;
import com.jidesoft.chart.event.MouseDragPanner;
import com.jidesoft.chart.event.MouseWheelZoomer;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.event.PointSelection;
import com.jidesoft.chart.model.AnnotatedChartModel;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartModelChangeEvent;
import com.jidesoft.chart.model.ChartModelChangeListener;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.Highlight;
import com.jidesoft.chart.model.IdentityTransform;
import com.jidesoft.chart.model.LeanChartModel;
import com.jidesoft.chart.model.SummingChartModel;
import com.jidesoft.chart.render.AbstractPieSegmentRenderer;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.render.BarRenderer;
import com.jidesoft.chart.render.DefaultBarRenderer;
import com.jidesoft.chart.render.DefaultLineRenderer;
import com.jidesoft.chart.render.DefaultPieSegmentRenderer;
import com.jidesoft.chart.render.DefaultPointRenderer;
import com.jidesoft.chart.render.LineRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.render.PointRenderer;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ChartUtils;
import com.jidesoft.chart.util.Filter;
import com.jidesoft.chart.util.GraphicsUtilities;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.chart.util.Point2DPool;
import com.jidesoft.chart.util.Rotation;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.ShadowRenderer;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.DefaultListSelectionModel;
import javax.swing.GrayFilter;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class Chart
extends JComponent
implements ChartModelChangeListener,
PropertyChangeListener,
Animatable,
AnimatedChart {
    private static final long serialVersionUID = 1843397021865383301L;
    public static final String PROPERTY_ANIMATE_ON_SHOW = "Animate on Show";
    public static final String PROPERTY_ANIMATION_POSITION = "Animation Position";
    public static final String PROPERTY_ANTI_ALIASING = "AntiAliasing";
    public static final String PROPERTY_AUTO_RANGING = "AutoRanging";
    public static final String PROPERTY_AXIS_COLOR = "AxisColor";
    public static final String PROPERTY_BAR_RENDERER = "BarRenderer";
    public static final String PROPERTY_BAR_GAP = "BarGap";
    public static final String PROPERTY_BAR_GROUP_GAP = "BarGroupGap";
    public static final String PROPERTY_BARS_GROUPED = "BarsGrouped";
    public static final String PROPERTY_CHART_BACKGROUND = "ChartBackground";
    public static final String PROPERTY_CHART_BORDER = "ChartBorder";
    public static final String PROPERTY_CURRENT_CHART_POINT = "ChartFocusPoint";
    public static final String PROPERTY_CHART_TYPE = "ChartType";
    public static final String PROPERTY_GRID_COLOR = "GridColor";
    public static final String PROPERTY_HIGHLIGHT_STYLE = "HighlightStyle";
    public static final String PROPERTY_HIGH_QUALITY = "HighQuality";
    public static final String PROPERTY_HORIZONTAL_GRID_LINES_VISIBLE = "HorizontalGridLinesVisible";
    public static final String PROPERTY_HORIZONTAL_MINOR_GRID_LINES_VISIBLE = "HorizontalMinorGridLinesVisible";
    public static final String PROPERTY_HORIZONTAL_MINOR_GRID_STROKE = "HorizontalMinorGridStroke";
    public static final String PROPERTY_HORIZONTAL_GRID_STROKE = "HorizontalGridStroke";
    public static final String PROPERTY_LABEL_COLOR = "LabelColor";
    public static final String PROPERTY_LABELLING_TRACES = "LabellingTraces";
    public static final String PROPERTY_LAZY_RENDERING_THRESHOLD = "LazyRenderingThreshold";
    public static final String PROPERTY_LINE_RENDERER = "LineRenderer";
    public static final String PROPERTY_MAX_BAR_WIDTH = "MaxBarWidth";
    public static final String PROPERTY_MINOR_GRID_COLOR = "MinorGridColor";
    public static final String PROPERTY_MODEL = "Model";
    public static final String PROPERTY_PANEL_BACKGROUND = "PanelBackground";
    public static final String PROPERTY_PIE_DIAMETER = "PieDiameter";
    public static final String PROPERTY_PIE_SEGMENT_RENDERER = "PieSegmentRenderer";
    public static final String PROPERTY_POINT_RENDERER = "PointRenderer";
    public static final String PROPERTY_ROLLOVER_VISIBLE = "Rollover Visible";
    public static final String PROPERTY_SELECTABLE = "Selectable";
    public static final String PROPERTY_SELECTION_SHOWS_EXPLODED_SEGMENTS = "SelectionShowsExplodedSegments";
    public static final String PROPERTY_SELECTION_SHOWS_OUTLINE = "SelectionShowsOutlines";
    public static final String PROPERTY_SHADOW_RENDERER = "Shadow Renderer";
    public static final String PROPERTY_SHADOW_VISIBLE = "ShadowVisible";
    public static final String PROPERTY_SHADOW_VISIBILITY = "ShadowVisibility";
    public static final String PROPERTY_CHART_STYLE = "ChartStyle";
    public static final String PROPERTY_TICK_COLOR = "TickColor";
    public static final String PROPERTY_TICK_STROKE = "TickStroke";
    public static final String PROPERTY_TICK_FONT = "TickFont";
    public static final String PROPERTY_TICK_LENGTH = "TickLength";
    public static final String PROPERTY_MINOR_TICK_LENGTH = "Minor TickLength";
    public static final String PROPERTY_ALLOW_TICK_LABEL_OVERLAP = "Allow Tick Label Overlap";
    public static final String PROPERTY_TITLE = "Title";
    public static final String PROPERTY_TITLE_VISIBLE = "TitleVisible";
    public static final String PROPERTY_VERTICAL_GRID_LINES_VISIBLE = "VerticalGridLinesVisible";
    public static final String PROPERTY_VERTICAL_MINOR_GRID_LINES_VISIBLE = "VerticalMinorGridLinesVisible";
    public static final String PROPERTY_VERTICAL_MINOR_GRID_STROKE = "VerticalMinorGridStroke";
    public static final String PROPERTY_VERTICAL_GRID_STROKE = "VerticalGridStroke";
    public static final String PROPERTY_X_AXIS = "XAxis";
    public static final String PROPERTY_Y_AXIS = "YAxis";
    private static final boolean DEBUG = false;
    private static int instance;
    private static double axisBreadthRatio;
    private int lazyRenderingThreshold = Integer.MAX_VALUE;
    private ShadowRenderer shadowRenderer;
    private Axis xAxis;
    private List<Axis> yAxes = new CopyOnWriteArrayList<Axis>();
    private Map<ChartModel, Axis> axisChoices = new HashMap<ChartModel, Axis>();
    private Map<ChartModel, ListSelectionModel> selectionModels = new HashMap<ChartModel, ListSelectionModel>();
    private AbstractLabel title = null;
    private List<Drawable> drawables = new ArrayList<Drawable>();
    private transient LazyRenderer<ChartModel> lazyChartRenderer;
    private ImageChangeListener imageChangeListener;
    private Filter<ChartModel> areaChartFilter = new AreaChartFilter();
    private Filter<ChartModel> barChartFilter = new BarChartFilter();
    private Filter<ChartModel> lineChartFilter = new LineChartFilter();
    private Filter<ChartModel> pointChartFilter = new PointChartFilter();
    private Map<ChartModel, Integer> zOrders = new HashMap<ChartModel, Integer>();
    private boolean animateOnShow = true;
    private boolean animationShown = false;
    private Animator animator = new Animator(this, 50, 40, 10);
    private boolean antiAliasing = true;
    private boolean autoRanging = false;
    private AutoRanger autoRanger = new DefaultAutoRanger();
    private boolean labellingTraces = false;
    private boolean titleVisible = true;
    private boolean verticalGridLinesVisible = true;
    private boolean verticalMinorGridLinesVisible = false;
    private boolean horizontalGridLinesVisible = true;
    private boolean horizontalMinorGridLinesVisible = false;
    private boolean highQuality = false;
    private boolean recordingShapes = true;
    private boolean allowTickLabelOverlap = false;
    private List<UserToPixelTransform> userToPixelTransforms = new CopyOnWriteArrayList<UserToPixelTransform>();
    private int xStart;
    private int xEnd;
    private int yStart;
    private int yEnd;
    private Paint panelBackground;
    private Paint chartBackground = null;
    private Border chartBorder;
    private Color axisColor = Color.DARK_GRAY;
    private Color tickColor = Color.DARK_GRAY;
    private Color gridColor = Color.LIGHT_GRAY;
    private Color minorGridColor = new Color(192, 192, 192, 100);
    private Color labelColor = Color.black;
    private Stroke tickStroke = new BasicStroke(1.0f);
    private Font tickFont;
    private ShadowVisibility shadowVisibility = ShadowVisibility.NONE;
    private final Map<String, ChartModel> shadowedModels = Collections.synchronizedMap(new HashMap());
    private BufferedImage shadowImage = null;
    private BufferedImage labelImage = null;
    private BufferedImage disabledImage = null;
    private boolean dirty;
    private Map<String, ChartStyle> chartStyles = new HashMap<String, ChartStyle>();
    private Map<String, PointRenderer> pointRenderers = new HashMap<String, PointRenderer>();
    private Map<String, LineRenderer> lineRenderers = new HashMap<String, LineRenderer>();
    private Map<String, BarRenderer> barRenderers = new HashMap<String, BarRenderer>();
    private Map<Highlight, ChartStyle> highlightStyles = new HashMap<Highlight, ChartStyle>();
    private MouseWheelZoomer zoomer;
    private MouseDragPanner panner;
    private ChartRolloverListener chartRolloverListener;
    private Chartable chartRolloverPoint;
    private List<ChartModel> models = new CopyOnWriteArrayList<ChartModel>();
    private final PieChartPainter piePainter = new PieChartPainter();
    private final BarPainter barPainter = new BarPainter();
    private final LinePainter linePainter = new LinePainter();
    private final PointPainter pointPainter = new PointPainter();
    private final ChartAnimator chartAnimator = new ChartAnimator(this);
    private Stroke horizontalGridStroke = new BasicStroke(1.0f);
    private Stroke horizontalMinorGridStroke = new BasicStroke(1.0f);
    private Stroke verticalGridStroke = new BasicStroke(1.0f);
    private Stroke verticalMinorGridStroke = new BasicStroke(1.0f);
    private ChartType chartType = ChartType.XY;
    private PointRenderer pointRenderer = new DefaultPointRenderer();
    private BarRenderer barRenderer = new DefaultBarRenderer();
    private LineRenderer lineRenderer = new DefaultLineRenderer(this);
    private PieSegmentRenderer pieSegmentRenderer = new DefaultPieSegmentRenderer();
    private double animationPosition = 0.0;
    private boolean selectionShowsExplodedSegments = false;
    private boolean selectionShowsOutline = true;
    private int axisLabelPadding = 4;
    private final ReadWriteLock coordinateSpaceLock = new ReentrantReadWriteLock();
    private final Lock coordinateSpaceReadLock = this.coordinateSpaceLock.readLock();
    private final Lock coordinateSpaceWriteLock = this.coordinateSpaceLock.writeLock();
    private Point2DPool point2DPool = Point2DPool.instance();

    public Chart() {
        this.init();
    }

    public Chart(ChartModel chartModel) {
        this();
        this.setModel(chartModel);
    }

    public Chart(String string) {
        this();
        this.setName(string);
    }

    public Chart(Dimension dimension) {
        this();
        this.setSize(dimension);
        this.setPreferredSize(dimension);
        this.update();
    }

    protected void init() {
        this.setName("Chart-" + instance);
        ++instance;
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        if (UIDefaultsLookup.get("Chart.font") == null) {
            new ChartUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
        ShadowFactory shadowFactory = new ShadowFactory();
        shadowFactory.setRenderingHint("blur_quality", "high");
        this.setShadowRenderer(shadowFactory);
        this.setPanelBackground(UIManager.getColor("Chart.background"));
        this.setXAxis(new Axis("x"), false);
        this.setYAxis(new Axis("y"), false);
        this.setMinimumSize(new Dimension(100, 100));
        this.setFont(UIManager.getFont("Chart.font"));
        this.setTickFont(UIManager.getFont("Chart.tickFont"));
        this.imageChangeListener = new ImageChangeListener(){

            @Override
            public void imageChanged(ImageChangeEvent imageChangeEvent) {
                Chart.this.update(false);
                Chart.this.firePropertyChange("dirty", false, true);
            }
        };
        this.setLazyChartRenderer(new MultiImageLazyChartRenderer(this));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Chart.this.update();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                Chart.this.repaint(500L);
            }
        });
        this.chartRolloverListener = new ChartRolloverListener(this);
        this.addMouseListener(this.chartRolloverListener);
        this.addMouseMotionListener(this.chartRolloverListener);
        this.animator.addAnimatorListener(this.chartAnimator);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (UIDefaultsLookup.get("Chart.font") == null) {
            new ChartUIDefaultsCustomizer().customize(UIManager.getLookAndFeelDefaults());
        }
    }

    public void setZOrder(ChartModel chartModel, Integer n) {
        this.zOrders.put(chartModel, n);
    }

    public Integer getZOrder(ChartModel chartModel) {
        return this.zOrders.get(chartModel);
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public void setChartType(ChartType chartType) {
        ChartType chartType2 = this.chartType;
        this.chartType = chartType;
        ChartUtils.clearBufferedImage(this.labelImage, this.getBackground());
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_TYPE, (Object)chartType2, (Object)chartType);
    }

    public ShadowRenderer getShadowRenderer() {
        return this.shadowRenderer;
    }

    public void setShadowRenderer(ShadowRenderer shadowRenderer) {
        if (shadowRenderer == null) {
            throw new IllegalArgumentException("Shadow Renderer cannot be null");
        }
        ShadowRenderer shadowRenderer2 = this.shadowRenderer;
        this.shadowRenderer = shadowRenderer;
        this.firePropertyChange(PROPERTY_SHADOW_RENDERER, shadowRenderer2, shadowRenderer);
    }

    public PointRenderer getPointRenderer() {
        return this.pointRenderer;
    }

    public void setPointRenderer(PointRenderer pointRenderer) {
        PointRenderer pointRenderer2 = this.pointRenderer;
        if (pointRenderer == null) {
            throw new IllegalArgumentException("PointRenderer cannot be null");
        }
        this.pointRenderer = pointRenderer;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_POINT_RENDERER, pointRenderer2, pointRenderer);
    }

    public PointRenderer getPointRenderer(ChartModel chartModel) {
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("The name of the supplied ChartModel cannot be null");
        }
        PointRenderer pointRenderer = this.pointRenderers.get(string);
        if (pointRenderer == null) {
            return this.getPointRenderer();
        }
        return pointRenderer;
    }

    public void setPointRenderer(ChartModel chartModel, PointRenderer pointRenderer) {
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("ChartModel name cannot be null");
        }
        PointRenderer pointRenderer2 = this.pointRenderers.get(string);
        if (pointRenderer == null) {
            throw new IllegalArgumentException("PointRenderer cannot be null");
        }
        this.pointRenderers.put(string, pointRenderer);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_POINT_RENDERER, pointRenderer2, pointRenderer);
    }

    public LineRenderer getLineRenderer(ChartModel chartModel) {
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("ChartModel name cannot be null");
        }
        LineRenderer lineRenderer = this.lineRenderers.get(string);
        if (lineRenderer == null) {
            return this.getLineRenderer();
        }
        return lineRenderer;
    }

    public void setLineRenderer(ChartModel chartModel, LineRenderer lineRenderer) {
        if (chartModel == null) {
            throw new IllegalArgumentException("Cannot set LineRenderer for a null model");
        }
        String string = chartModel.getName();
        if (string == null) {
            throw new IllegalArgumentException("Cannot set LineRenderer for a ChartModel with null name");
        }
        LineRenderer lineRenderer2 = this.lineRenderers.get(string);
        if (lineRenderer == null) {
            throw new IllegalArgumentException("LineRenderer cannot be null");
        }
        this.lineRenderers.put(string, lineRenderer);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LINE_RENDERER, lineRenderer2, lineRenderer);
    }

    public BarRenderer getBarRenderer() {
        return this.barRenderer;
    }

    public void setBarRenderer(BarRenderer barRenderer) {
        BarRenderer barRenderer2 = this.barRenderer;
        this.barRenderer = barRenderer;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_RENDERER, barRenderer2, barRenderer);
    }

    public BarRenderer getBarRenderer(ChartModel chartModel) {
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("ChartModel name cannot be null");
        }
        BarRenderer barRenderer = this.barRenderers.get(string);
        if (barRenderer == null) {
            return this.getBarRenderer();
        }
        return barRenderer;
    }

    public void setBarRenderer(ChartModel chartModel, BarRenderer barRenderer) {
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("ChartModel name cannot be null");
        }
        BarRenderer barRenderer2 = this.barRenderers.get(string);
        if (barRenderer == null) {
            throw new IllegalArgumentException("BarRenderer cannot be null");
        }
        this.barRenderers.put(string, barRenderer);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_RENDERER, barRenderer2, barRenderer);
    }

    public boolean isRecordingShapes() {
        return this.recordingShapes;
    }

    public void setRecordingShapes(boolean bl) {
        this.recordingShapes = bl;
    }

    public void setPieDiameter(Integer n) {
        Integer n2 = this.piePainter.getDiameter();
        this.piePainter.setDiameter(n);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_PIE_DIAMETER, n2, n);
    }

    public Integer getPieDiameter() {
        return this.piePainter.getDiameter();
    }

    public Stroke getHorizontalGridStroke() {
        return this.horizontalGridStroke;
    }

    public Stroke getHorizontalMinorGridStroke() {
        return this.horizontalMinorGridStroke;
    }

    public void setHorizontalMinorGridStroke(Stroke stroke) {
        Stroke stroke2 = this.horizontalMinorGridStroke;
        this.horizontalMinorGridStroke = stroke;
        this.firePropertyChange(PROPERTY_HORIZONTAL_MINOR_GRID_STROKE, stroke2, stroke);
    }

    public void setHorizontalGridStroke(Stroke stroke) {
        Stroke stroke2 = this.horizontalGridStroke;
        this.horizontalGridStroke = stroke;
        this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_STROKE, stroke2, stroke);
    }

    public Stroke getVerticalGridStroke() {
        return this.verticalGridStroke;
    }

    public void setVerticalGridStroke(Stroke stroke) {
        Stroke stroke2 = this.verticalGridStroke;
        this.verticalGridStroke = stroke;
        this.firePropertyChange(PROPERTY_VERTICAL_GRID_STROKE, stroke2, stroke);
    }

    public Stroke getVerticalMinorGridStroke() {
        return this.verticalMinorGridStroke;
    }

    public void setVerticalMinorGridStroke(Stroke stroke) {
        Stroke stroke2 = this.verticalMinorGridStroke;
        this.verticalMinorGridStroke = stroke;
        this.firePropertyChange(PROPERTY_VERTICAL_MINOR_GRID_STROKE, stroke2, stroke);
    }

    public Chartable getCurrentChartPoint() {
        return this.chartRolloverPoint;
    }

    void setCurrentChartPoint(Chartable chartable) {
        Chartable chartable2 = this.chartRolloverPoint;
        if (this.chartRolloverPoint != null && this.chartRolloverPoint.equals(chartable) || this.chartRolloverPoint == null && chartable == null) {
            return;
        }
        this.chartRolloverPoint = chartable;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CURRENT_CHART_POINT, chartable2, this.chartRolloverPoint);
    }

    public Shape renderedAs(Chartable chartable) {
        PointDescriptor pointDescriptor = this.barPainter.rendered(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor.getShape();
        }
        pointDescriptor = this.pointPainter.rendered(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor.getShape();
        }
        if (this.pieSegmentRenderer instanceof AbstractPieSegmentRenderer) {
            AbstractPieSegmentRenderer abstractPieSegmentRenderer = (AbstractPieSegmentRenderer)this.pieSegmentRenderer;
            pointDescriptor = abstractPieSegmentRenderer.rendered(chartable);
            return pointDescriptor == null ? null : pointDescriptor.getShape();
        }
        return null;
    }

    public PointDescriptor rendered(Chartable chartable) {
        PointDescriptor pointDescriptor = this.barPainter.rendered(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor;
        }
        pointDescriptor = this.pointPainter.rendered(chartable);
        if (pointDescriptor != null) {
            return pointDescriptor;
        }
        if (this.pieSegmentRenderer instanceof AbstractPieSegmentRenderer) {
            AbstractPieSegmentRenderer abstractPieSegmentRenderer = (AbstractPieSegmentRenderer)this.pieSegmentRenderer;
            pointDescriptor = abstractPieSegmentRenderer.rendered(chartable);
            return pointDescriptor;
        }
        return null;
    }

    public PointDescriptor containingShape(Point point) {
        PointDescriptor pointDescriptor = this.pieSegmentRenderer.containingSegment(point);
        if (pointDescriptor != null) {
            return pointDescriptor;
        }
        PointDescriptor pointDescriptor2 = this.barPainter.containingBar(point);
        if (pointDescriptor2 != null) {
            return pointDescriptor2;
        }
        PointDescriptor pointDescriptor3 = this.pointPainter.containingPoint(point);
        if (pointDescriptor3 != null) {
            return pointDescriptor3;
        }
        return null;
    }

    public Collection<PointDescriptor> containingShapes(Point point) {
        List<PointDescriptor> list;
        List<PointDescriptor> list2;
        ArrayList<PointDescriptor> arrayList = new ArrayList<PointDescriptor>();
        PointDescriptor pointDescriptor = this.pieSegmentRenderer.containingSegment(point);
        if (pointDescriptor != null) {
            arrayList.add(pointDescriptor);
        }
        if ((list2 = this.barPainter.containingBars(point)) != null) {
            arrayList.addAll(list2);
        }
        if ((list = this.pointPainter.containingPoints(point)) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public PointDescriptor containingBar(Point point) {
        return this.barPainter.containingBar(point);
    }

    public PointDescriptor containingSegment(Point point) {
        return this.pieSegmentRenderer.containingSegment(point);
    }

    public Collection<ChartModel> nearLine(Point point, float f) {
        return this.linePainter.nearLine(point, f);
    }

    public PointDescriptor containingPoint(Point point) {
        return this.pointPainter.containingPoint(point);
    }

    public Collection<PointDescriptor> containingPoints(Point point) {
        return this.pointPainter.containingPoints(point);
    }

    public PieSegmentRenderer getPieSegmentRenderer() {
        return this.pieSegmentRenderer;
    }

    public void setPieSegmentRenderer(PieSegmentRenderer pieSegmentRenderer) {
        PieSegmentRenderer pieSegmentRenderer2 = this.pieSegmentRenderer;
        this.pieSegmentRenderer = pieSegmentRenderer;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_PIE_SEGMENT_RENDERER, pieSegmentRenderer2, pieSegmentRenderer);
    }

    public LineRenderer getLineRenderer() {
        return this.lineRenderer;
    }

    public void setLineRenderer(LineRenderer lineRenderer) {
        LineRenderer lineRenderer2 = this.lineRenderer;
        this.lineRenderer = lineRenderer;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LINE_RENDERER, lineRenderer2, lineRenderer);
    }

    public void setBarGap(int n) {
        int n2 = this.barPainter.getBarGap();
        this.barPainter.setBarGap(n);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GAP, n2, n);
    }

    public int getBarGap() {
        return this.barPainter.getBarGap();
    }

    public void setMaxBarWidth(int n) {
        int n2 = this.barPainter.getMaxBarWidth();
        this.barPainter.setMaxBarWidth(n);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_MAX_BAR_WIDTH, n2, n);
    }

    public int getMaxBarWidth() {
        return this.barPainter.getMaxBarWidth();
    }

    public int getBarGroupGap() {
        return this.barPainter.getGroupGap();
    }

    public void setBarGroupGap(int n) {
        int n2 = this.barPainter.getGroupGap();
        this.barPainter.setGroupGap(n);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GROUP_GAP, n2, n);
    }

    public void setBarGroupGapProportion(Double d) {
        Double d2 = this.barPainter.getGroupGapProportion();
        this.barPainter.setGroupGapProportion(d);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BAR_GROUP_GAP, d2, d);
    }

    public void setBarsGrouped(boolean bl) {
        boolean bl2 = this.barPainter.isGrouped();
        this.barPainter.setGrouped(bl);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_BARS_GROUPED, bl2, bl);
    }

    public boolean isBarsGrouped() {
        return this.barPainter.isGrouped();
    }

    public void setBarResizePolicy(BarResizePolicy barResizePolicy) {
        this.barPainter.setBarResizePolicy(barResizePolicy);
    }

    public BarResizePolicy getBarResizePolicy() {
        return this.barPainter.getResizePolicy();
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private void setDirty(boolean bl) {
        boolean bl2 = this.dirty;
        this.dirty = bl;
        if (!bl2 && bl && this.isLazyRendering()) {
            this.lazyChartRenderer.updateCharts(false);
        }
    }

    public boolean isHighQuality() {
        return this.highQuality;
    }

    public void setHighQuality(boolean bl) {
        boolean bl2 = this.highQuality;
        this.highQuality = bl;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_HIGH_QUALITY, bl2, bl);
    }

    public boolean isVerticalGridLinesVisible() {
        return this.verticalGridLinesVisible;
    }

    public boolean isVerticalMinorGridLinesVisible() {
        return this.verticalMinorGridLinesVisible;
    }

    public void setVerticalMinorGridLinesVisible(boolean bl) {
        boolean bl2 = this.verticalMinorGridLinesVisible;
        this.verticalMinorGridLinesVisible = bl;
        this.firePropertyChange(PROPERTY_VERTICAL_MINOR_GRID_LINES_VISIBLE, bl2, bl);
    }

    public void setVerticalGridLinesVisible(boolean bl) {
        boolean bl2 = this.verticalGridLinesVisible;
        this.verticalGridLinesVisible = bl;
        this.firePropertyChange(PROPERTY_VERTICAL_GRID_LINES_VISIBLE, bl2, bl);
    }

    public boolean isHorizontalGridLinesVisible() {
        return this.horizontalGridLinesVisible;
    }

    public boolean isHorizontalMinorGridLinesVisible() {
        return this.horizontalMinorGridLinesVisible;
    }

    public void setHorizontalGridLinesVisible(boolean bl) {
        boolean bl2 = this.horizontalGridLinesVisible;
        this.horizontalGridLinesVisible = bl;
        this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_LINES_VISIBLE, bl2, bl);
    }

    public void setHorizontalMinorGridLinesVisible(boolean bl) {
        boolean bl2 = this.horizontalMinorGridLinesVisible;
        this.horizontalMinorGridLinesVisible = bl;
        this.firePropertyChange(PROPERTY_HORIZONTAL_MINOR_GRID_LINES_VISIBLE, bl2, bl);
    }

    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    public void setTitleVisible(boolean bl) {
        if (bl == this.titleVisible) {
            return;
        }
        boolean bl2 = this.titleVisible;
        this.titleVisible = bl;
        this.setDirty(true);
        this.update();
        this.firePropertyChange(PROPERTY_TITLE_VISIBLE, bl2, bl);
    }

    public Font getTickFont() {
        return this.tickFont;
    }

    protected Font getTickFont(Axis axis) {
        Font font = axis.getTickFont();
        return font == null ? this.tickFont : font;
    }

    public void setTickFont(Font font) {
        Font font2 = this.tickFont;
        this.tickFont = font;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_FONT, font2, font);
    }

    public Stroke getTickStroke() {
        return this.tickStroke;
    }

    public void setTickStroke(Stroke stroke) {
        Stroke stroke2 = this.tickStroke;
        this.tickStroke = stroke;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_STROKE, stroke2, stroke);
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        Color color2 = this.axisColor;
        this.axisColor = color;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_AXIS_COLOR, color2, color);
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color color) {
        Color color2 = this.gridColor;
        this.gridColor = color;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_GRID_COLOR, color2, color);
    }

    public Color getMinorGridColor() {
        return this.minorGridColor;
    }

    public void setMinorGridColor(Color color) {
        Color color2 = this.minorGridColor;
        this.minorGridColor = color;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_MINOR_GRID_COLOR, color2, color);
    }

    public Paint getPanelBackground() {
        return this.panelBackground;
    }

    public void setPanelBackground(Paint paint) {
        Paint paint2 = this.panelBackground;
        if (paint instanceof Color) {
            Color color = (Color)paint;
            super.setBackground(color);
        }
        this.panelBackground = paint;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_PANEL_BACKGROUND, paint2, paint);
    }

    @Override
    public void setBackground(Color color) {
        this.setPanelBackground(color);
    }

    public Paint getChartBackground() {
        return this.chartBackground;
    }

    public void setChartBackground(Paint paint) {
        Paint paint2 = this.chartBackground;
        this.chartBackground = paint;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_BACKGROUND, paint2, paint);
    }

    public Border getChartBorder() {
        return this.chartBorder;
    }

    public void setChartBorder(Border border) {
        Border border2 = this.chartBorder;
        this.chartBorder = border;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_CHART_BORDER, border2, border);
    }

    public UserToPixelTransform getUserToPixelTransform() {
        this.coordinateSpaceReadLock.lock();
        try {
            assert (this.userToPixelTransforms != null);
            UserToPixelTransform userToPixelTransform = this.userToPixelTransforms.size() > 0 ? this.userToPixelTransforms.get(0) : null;
            return userToPixelTransform;
        }
        finally {
            this.coordinateSpaceReadLock.unlock();
        }
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(boolean bl) {
        boolean bl2 = this.antiAliasing;
        this.antiAliasing = bl;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_ANTI_ALIASING, bl2, bl);
    }

    public boolean isAllowTickLabelOverlap() {
        return this.allowTickLabelOverlap;
    }

    public void setAllowTickLabelOverlap(boolean bl) {
        boolean bl2 = this.allowTickLabelOverlap;
        this.allowTickLabelOverlap = bl;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_ALLOW_TICK_LABEL_OVERLAP, bl2, bl);
    }

    public boolean isAutoRanging() {
        return this.autoRanging;
    }

    public void setAutoRanging(boolean bl) {
        boolean bl2 = this.autoRanging;
        this.autoRanging = bl;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_AUTO_RANGING, bl2, bl);
    }

    public void setAutoRanger(AutoRanger autoRanger) {
        this.autoRanger = autoRanger;
    }

    public AutoRanger getAutoRanger() {
        return this.autoRanger;
    }

    public boolean isLabellingTraces() {
        return this.labellingTraces;
    }

    public void setLabellingTraces(boolean bl) {
        boolean bl2 = this.labellingTraces;
        this.labellingTraces = bl;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LABELLING_TRACES, bl2, bl);
    }

    public Chart addMouseZoomer() {
        return this.addMouseZoomer(true, true);
    }

    public Chart addMouseZoomer(boolean bl, boolean bl2) {
        if (this.zoomer != null) {
            this.removeMouseZoomer();
        }
        this.zoomer = new MouseWheelZoomer(this, bl, bl2);
        this.addMouseWheelListener(this.zoomer);
        this.addMouseMotionListener(this.zoomer);
        return this;
    }

    public Chart removeMouseZoomer() {
        if (this.zoomer != null) {
            this.removeMouseWheelListener(this.zoomer);
            this.removeMouseMotionListener(this.zoomer);
        }
        return this;
    }

    public Chart addMousePanner() {
        return this.addMousePanner(true, true);
    }

    public Chart addMousePanner(boolean bl, boolean bl2) {
        if (this.panner != null) {
            this.removeMousePanner();
        }
        this.panner = new MouseDragPanner(this, bl, bl2);
        this.addMouseListener(this.panner);
        this.addMouseMotionListener(this.panner);
        return this;
    }

    public Chart removeMousePanner() {
        if (this.panner != null) {
            this.removeMouseListener(this.panner);
            this.removeMouseMotionListener(this.panner);
        }
        return this;
    }

    public void setRolloverEnabled(boolean bl) {
        boolean bl2 = this.chartRolloverListener.isRolloverVisible();
        this.chartRolloverListener.setRolloverVisible(bl);
        this.firePropertyChange(PROPERTY_ROLLOVER_VISIBLE, bl2, bl);
    }

    public boolean isRolloverEnabled() {
        return this.chartRolloverListener.isRolloverVisible();
    }

    public void setSelectionEnabled(boolean bl) {
        boolean bl2 = this.chartRolloverListener.isSelectionEnabled();
        this.chartRolloverListener.setSelectionEnabled(bl);
        this.firePropertyChange(PROPERTY_SELECTABLE, bl2, bl);
    }

    public boolean isSelectionEnabled() {
        return this.chartRolloverListener.isSelectionEnabled();
    }

    public boolean isSelectionShowsExplodedSegments() {
        return this.selectionShowsExplodedSegments;
    }

    public void setSelectionShowsExplodedSegments(boolean bl) {
        boolean bl2 = this.selectionShowsExplodedSegments;
        this.selectionShowsExplodedSegments = bl;
        this.firePropertyChange(PROPERTY_SELECTION_SHOWS_EXPLODED_SEGMENTS, bl2, bl);
    }

    public boolean isSelectionShowsOutline() {
        return this.selectionShowsOutline;
    }

    public void setSelectionShowsOutline(boolean bl) {
        boolean bl2 = this.selectionShowsOutline;
        this.selectionShowsOutline = bl;
        this.firePropertyChange(PROPERTY_SELECTION_SHOWS_OUTLINE, bl2, bl);
    }

    public void addDoubleClickListener(ActionListener actionListener) {
        this.chartRolloverListener.addDoubleClickListener(actionListener);
    }

    public void removeDoubleClickListener(ActionListener actionListener) {
        this.chartRolloverListener.removeDoubleClickListener(actionListener);
    }

    public void setSelectionButton(int n) {
        this.chartRolloverListener.setSelectionButton(n);
    }

    @Override
    public void chartModelChanged() {
        this.autoRange();
        this.update();
    }

    @Override
    public void chartModelChanged(ChartModelChangeEvent chartModelChangeEvent) {
        this.autoRange();
        this.update();
    }

    public boolean isShadowVisible() {
        return this.shadowVisibility == ShadowVisibility.ALL || this.shadowVisibility == ShadowVisibility.SOME;
    }

    public void setShadowVisible(boolean bl) {
        boolean bl2 = this.isShadowVisible();
        this.shadowVisibility = bl ? ShadowVisibility.ALL : ShadowVisibility.NONE;
        this.setDirty(true);
        this.update();
        this.firePropertyChange(PROPERTY_SHADOW_VISIBLE, bl2, bl);
    }

    public ShadowVisibility getShadowVisibility() {
        return this.shadowVisibility;
    }

    public void setShadowVisibility(ShadowVisibility shadowVisibility) {
        ShadowVisibility shadowVisibility2 = this.shadowVisibility;
        this.shadowVisibility = shadowVisibility;
        this.setDirty(true);
        this.update();
        this.firePropertyChange(PROPERTY_SHADOW_VISIBILITY, (Object)shadowVisibility2, (Object)shadowVisibility);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShadowVisible(ChartModel chartModel, boolean bl) {
        Map<String, ChartModel> map = this.shadowedModels;
        synchronized (map) {
            String string = chartModel.getName();
            ChartModel chartModel2 = this.shadowedModels.get(string);
            if (bl) {
                if (chartModel2 == null) {
                    this.shadowedModels.put(string, chartModel);
                }
            } else {
                this.shadowedModels.remove(string);
            }
        }
        this.setDirty(true);
        this.update();
    }

    public boolean isShadowVisible(ChartModel chartModel) {
        String string = chartModel.getName();
        ChartModel chartModel2 = this.shadowedModels.get(string);
        return chartModel2 != null;
    }

    public void autoRange() {
        if (this.isAutoRanging() && this.autoRanger != null) {
            if (this.autoRanger instanceof MultiAutoRanger) {
                MultiAutoRanger multiAutoRanger = (MultiAutoRanger)this.autoRanger;
                Map<Axis, Range<?>> map = multiAutoRanger.getAxisRanges(this);
                if (map != null) {
                    for (Map.Entry<Axis, Range<?>> entry : map.entrySet()) {
                        Axis axis = entry.getKey();
                        Range<?> range = entry.getValue();
                        if (range == null) continue;
                        axis.setRange(range, false);
                    }
                }
            } else {
                Axis axis;
                Pair<Range<?>, Range<?>> pair = this.autoRanger.getRanges(this);
                Range<?> range = pair.getFirst();
                Range<?> range2 = pair.getSecond();
                if (range != null && this.xAxis != null) {
                    this.xAxis.setRange(range);
                }
                if (range2 != null && (axis = this.getYAxis()) != null) {
                    axis.setRange(range2);
                }
            }
            this.update();
        }
    }

    public void update() {
        this.update(true);
    }

    protected void update(boolean bl) {
        Container container;
        Axis axis;
        AxisRenderer axisRenderer;
        this.updateMargins();
        this.updateCoordinateSystems();
        AxisRenderer axisRenderer2 = this.xAxis == null ? null : this.xAxis.getAxisRenderer();
        int n = this.barPainter.computeAxisBreadth(this);
        if (axisRenderer2 != null) {
            axisRenderer2.setBreadth(n);
        }
        AxisRenderer axisRenderer3 = axisRenderer = (axis = this.getYAxis()) == null ? null : axis.getAxisRenderer();
        if (axisRenderer != null) {
            axisRenderer.setBreadth(n);
        }
        this.updateMargins();
        this.updateCoordinateSystems();
        Dimension dimension = this.getSize();
        if (this.isShadowVisible() && dimension.width > 0 && dimension.height > 0) {
            int n2;
            int n3 = this.shadowImage == null ? 0 : this.shadowImage.getWidth();
            int n4 = n2 = this.shadowImage == null ? 0 : this.shadowImage.getHeight();
            if (n3 != dimension.width || n2 != dimension.height) {
                this.shadowImage = new BufferedImage(dimension.width, dimension.height, 2);
                if (this.chartType == ChartType.PIE) {
                    this.labelImage = new BufferedImage(dimension.width, dimension.height, 2);
                }
            }
        }
        if (bl) {
            this.setDirty(true);
        }
        if ((container = this.getParent()) != null) {
            container.repaint();
        }
        this.revalidate();
        this.repaint();
    }

    public void drawInBackground() {
        if (this.isLazyRendering() && this.isDirty()) {
            this.lazyChartRenderer.updateCharts(false);
        }
        this.setDirty(false);
        super.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("range".equals(string) || "max".equals(string) || "min".equals(string)) {
            this.update();
        } else if ("updateOtherAxes".equals(string)) {
            Object object = propertyChangeEvent.getSource();
            Object object2 = propertyChangeEvent.getOldValue();
            Object object3 = propertyChangeEvent.getNewValue();
            Axis axis = this.getYAxis();
            Axis axis2 = (Axis)object;
            if (axis != null && axis.equals(object)) {
                Range range = (Range)object2;
                Range range2 = (Range)object3;
                double d = (range2.minimum() - range.minimum()) / range.size();
                double d2 = (range2.maximum() - range.minimum()) / range.size();
                for (Axis axis3 : this.yAxes) {
                    if (axis3.equals(axis2)) continue;
                    Range<?> range3 = axis3.getRange();
                    NumericRange numericRange = new NumericRange(d * range3.size() + range3.minimum(), d2 * range3.size() + range3.minimum());
                    axis3.setRange(numericRange, false);
                }
            }
            this.update();
        } else if ("label".equals(string)) {
            this.repaint();
        }
    }

    public Chart addDrawable(Drawable drawable) {
        if (drawable == null) {
            return this;
        }
        this.drawables.add(drawable);
        if (!drawable.equals(this.lazyChartRenderer)) {
            this.invalidate();
            this.repaint();
        }
        return this;
    }

    public Chart removeDrawable(Drawable drawable) {
        if (drawable != null && !drawable.equals(this.lazyChartRenderer)) {
            this.drawables.remove(drawable);
            this.repaint();
        }
        return this;
    }

    public Chart removeDrawables() {
        this.drawables.clear();
        this.drawables.add(this.lazyChartRenderer);
        this.repaint();
        return this;
    }

    public boolean containsDrawable(Drawable drawable) {
        return this.drawables.contains(drawable);
    }

    public Collection<Drawable> getDrawables() {
        return this.drawables;
    }

    void clearShapes() {
        this.pointPainter.clearShapes();
        this.barPainter.clearShapes();
        this.linePainter.clearShapes();
    }

    int axisWidth(Axis axis) {
        return this.axisWidth(this.getGraphics(), axis);
    }

    public int getAxisLabelPadding() {
        return this.axisLabelPadding;
    }

    public void setAxisLabelPadding(int n) {
        this.axisLabelPadding = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int axisWidth(Graphics graphics, Axis axis) {
        int n;
        if (!axis.isVisible()) {
            return 0;
        }
        int n2 = axis.isVisible() && axis.isTicksVisible() ? this.getTickLength() : 0;
        Font font = this.getTickFont(axis);
        int n3 = n = axis.getLabel() == null ? 0 : this.axisLabelPadding;
        if (graphics == null) {
            Graphics graphics2 = null;
            try {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
                graphics2 = bufferedImage.getGraphics();
                if (axis == this.xAxis) {
                    int n4 = axis.labelWidth(graphics2, font, Orientation.horizontal);
                    int n5 = n2 + 2 * n + n4;
                    return n5;
                }
                int n6 = axis.labelWidth(graphics2, font, Orientation.vertical);
                int n7 = n2 + 2 * n + n6;
                return n7;
            }
            finally {
                if (graphics2 != null) {
                    graphics2.dispose();
                }
            }
        }
        if (axis == this.xAxis) {
            int n8 = axis.labelWidth(graphics, font, Orientation.horizontal);
            return n2 + 2 * n + n8;
        }
        int n9 = axis.labelWidth(graphics, font, Orientation.vertical);
        return n2 + 2 * n + n9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int titleHeight() {
        Object object;
        if (this.title == null || "".equals(this.title.getLabel()) || !this.titleVisible) {
            return 0;
        }
        Graphics graphics = this.getGraphics();
        Graphics graphics2 = null;
        if (graphics == null) {
            object = new BufferedImage(1, 1, 2);
            graphics = graphics2 = ((BufferedImage)object).getGraphics();
        }
        try {
            object = this.title;
            FontMetrics fontMetrics = graphics.getFontMetrics(((AbstractLabel)object).getFont());
            int n = 2 * fontMetrics.getHeight();
            return n;
        }
        finally {
            if (graphics2 != null) {
                graphics2.dispose();
            }
        }
    }

    int getMarginLeft() {
        Insets insets = this.getInsets();
        int n = insets == null ? 0 : insets.left;
        for (Axis axis : this.yAxes) {
            if (axis.getPlacement() != AxisPlacement.LEADING) continue;
            int n2 = this.axisWidth(axis);
            n += n2;
        }
        return n;
    }

    int getMarginRight() {
        Insets insets = this.getInsets();
        int n = insets == null ? 0 : insets.right;
        for (Axis axis : this.yAxes) {
            if (axis.getPlacement() != AxisPlacement.TRAILING) continue;
            n += this.axisWidth(axis);
        }
        return n;
    }

    int getMarginTop() {
        int n;
        Insets insets = this.getInsets();
        int n2 = n = insets == null ? 0 : insets.top;
        if (this.xAxis.getPlacement() == AxisPlacement.TRAILING) {
            return n + this.axisWidth(this.getXAxis());
        }
        return n;
    }

    int getMarginBottom() {
        int n;
        Insets insets = this.getInsets();
        int n2 = n = insets == null ? 0 : insets.bottom;
        int n3 = this.xAxis.getPlacement() == AxisPlacement.FLOATING ? n : (this.xAxis.getPlacement() == AxisPlacement.TRAILING ? n : (this.xAxis.getPlacement() == AxisPlacement.CENTER ? n : n + this.axisWidth(this.xAxis)));
        return n3;
    }

    public int getXStart() {
        return this.xStart;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getChartWidth() {
        int n = this.xEnd - this.xStart;
        return n < 0 ? 0 : n;
    }

    public int getYStart() {
        return this.yStart;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public int getChartHeight() {
        int n = this.yStart - this.yEnd;
        return n < 0 ? 0 : n;
    }

    public double getYSum(ChartModel chartModel) {
        double d = 0.0;
        if (chartModel != null) {
            for (int i = 0; i < chartModel.getPointCount(); ++i) {
                Chartable chartable = chartModel.getPoint(i);
                d += chartable.getY().position();
            }
        }
        return d;
    }

    private void updateMargins() {
        Axis axis;
        int n;
        int n2;
        Dimension dimension = this.getSize();
        int n3 = this.getMarginLeft();
        Axis axis2 = this.getYAxis();
        int n4 = n2 = axis2 == null || axis2.getAxisRenderer() == null ? 0 : axis2.getAxisRenderer().getBreadth();
        if (axis2 != null) {
            int n5 = axis2.getPlacement() == AxisPlacement.LEADING ? n2 / 2 : 1;
            n = axis2.getPlacement() == AxisPlacement.TRAILING ? n2 / 2 : 1;
            this.xStart = dimension.width == 0 ? 0 : n3 + n5;
            this.xEnd = dimension.width == 0 ? 0 : dimension.width - this.getMarginRight() - n;
        }
        int n6 = n = (axis = this.getXAxis()) == null || axis.getAxisRenderer() == null ? 0 : axis.getAxisRenderer().getBreadth();
        if (axis != null) {
            int n7 = axis.getPlacement() == AxisPlacement.LEADING ? n / 2 : 1;
            int n8 = axis.getPlacement() == AxisPlacement.TRAILING ? n / 2 : 1;
            this.yStart = dimension.height == 0 ? 0 : dimension.height - this.getMarginBottom() - n7;
            this.yEnd = dimension.height == 0 ? 0 : this.getMarginTop() + this.titleHeight() + n8;
        }
    }

    public int getTickLength() {
        return this.xAxis == null ? 0 : this.xAxis.getTickLength();
    }

    public void setTickLength(int n) {
        int n2 = this.getTickLength();
        if (this.xAxis != null) {
            this.xAxis.setTickLength(n);
        }
        for (Axis axis : this.yAxes) {
            if (axis == null) continue;
            axis.setTickLength(n);
        }
        this.update();
        this.firePropertyChange(PROPERTY_TICK_LENGTH, n2, n);
    }

    public int getMinorTickLength() {
        return this.xAxis == null ? 0 : this.xAxis.getMinorTickLength();
    }

    public void setMinorTickLength(int n) {
        int n2 = this.getMinorTickLength();
        if (this.xAxis != null) {
            this.xAxis.setMinorTickLength(n);
        }
        for (Axis axis : this.yAxes) {
            if (axis == null) continue;
            axis.setMinorTickLength(n);
        }
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_MINOR_TICK_LENGTH, n2, n);
    }

    public Color getTickColor() {
        return this.tickColor;
    }

    public void setTickColor(Color color) {
        Color color2 = this.tickColor;
        this.tickColor = color;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_TICK_COLOR, color2, color);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelColor(Color color) {
        Color color2 = this.labelColor;
        this.labelColor = color;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LABEL_COLOR, color2, color);
    }

    private void setXAxis(Axis axis, boolean bl) {
        Axis axis2 = this.xAxis;
        if (this.xAxis != null) {
            this.xAxis.removePropertyChangeListener(this);
        }
        this.xAxis = axis;
        if (bl) {
            this.update();
        }
        if (this.xAxis != null) {
            this.xAxis.addPropertyChangeListener(this);
        }
        this.firePropertyChange(PROPERTY_X_AXIS, axis2, axis);
    }

    public void setXAxis(Axis axis) {
        this.setXAxis(axis, true);
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    private void setYAxis(Axis axis, boolean bl) {
        assert (this.yAxes != null);
        for (Axis axis2 : this.yAxes) {
            axis2.removePropertyChangeListener(this);
        }
        this.yAxes.clear();
        if (axis != null) {
            if (axis.getPlacement() == null) {
                axis.setPlacement(AxisPlacement.LEADING);
            }
            this.yAxes.add(axis);
        }
        if (bl) {
            this.update();
        }
        if (axis != null) {
            axis.addPropertyChangeListener(this);
        }
        this.firePropertyChange(PROPERTY_Y_AXIS, null, axis);
    }

    public void setYAxis(Axis axis) {
        this.setYAxis(axis, true);
    }

    public Chart addYAxis(Axis axis) {
        assert (this.yAxes != null);
        assert (axis != null);
        this.yAxes.add(axis);
        this.update();
        axis.addPropertyChangeListener(this);
        return this;
    }

    public Axis getYAxis() {
        assert (this.yAxes != null);
        if (this.yAxes.size() == 0) {
            return null;
        }
        return this.yAxes.get(0);
    }

    public Axis getYAxis(int n) {
        return this.yAxes.get(n);
    }

    public int getYAxisCount() {
        if (this.yAxes == null) {
            return 0;
        }
        return this.yAxes.size();
    }

    public void setTitle(String string) {
        AutoPositionedLabel autoPositionedLabel = new AutoPositionedLabel(string);
        this.setTitle(autoPositionedLabel);
    }

    public AbstractAnnotation getTitle() {
        return this.title;
    }

    public void setTitle(AbstractLabel abstractLabel) {
        AbstractLabel abstractLabel2 = this.title;
        this.title = abstractLabel;
        this.repaint();
        this.firePropertyChange(PROPERTY_TITLE, abstractLabel2, abstractLabel);
    }

    public int getLazyRenderingThreshold() {
        return this.lazyRenderingThreshold;
    }

    public void setLazyRenderingThreshold(int n) {
        int n2 = this.lazyRenderingThreshold;
        if (n < 0) {
            throw new IllegalArgumentException("Threshold must be >= 0");
        }
        this.lazyRenderingThreshold = n;
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_LAZY_RENDERING_THRESHOLD, n2, n);
    }

    public LazyRenderer<ChartModel> getLazyChartRenderer() {
        return this.lazyChartRenderer;
    }

    public void setLazyChartRenderer(LazyRenderer<ChartModel> lazyRenderer) {
        this.setLazyChartRenderer(lazyRenderer, true);
    }

    public void setLazyChartRenderer(LazyRenderer<ChartModel> lazyRenderer, boolean bl) {
        if (this.lazyChartRenderer != null) {
            this.removeDrawable(this.lazyChartRenderer);
            this.lazyChartRenderer.removeImageChangeListener(this.imageChangeListener);
        }
        this.lazyChartRenderer = lazyRenderer;
        this.addDrawable(lazyRenderer);
        lazyRenderer.addImageChangeListener(this.imageChangeListener);
        lazyRenderer.updateCharts(true);
    }

    public boolean isLazyRendering() {
        return this.getLazyRenderingThreshold() <= 0 || this.pointCount() >= this.getLazyRenderingThreshold();
    }

    private void addModelSafely(ChartModel chartModel) {
        if (chartModel == null) {
            throw new NullPointerException("You cannot add a NULL ChartModel to a chart");
        }
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("You cannot add a chart model without a name to a chart");
        }
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.models);
        assert (!this.models.contains(chartModel)) : String.format("Chart '%s' already contains a model with name '%s'", this.getName(), chartModel.getName());
        for (ChartModel chartModel2 : this.models) {
            if (!chartModel2.getName().equals(chartModel.getName())) continue;
            throw new IllegalArgumentException("ChartModel " + chartModel2.getName() + " already exists!");
        }
        this.models.add(chartModel);
        if (this.isLazyRendering()) {
            this.setDirty(true);
        }
        this.autoRange();
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.selectionModels.put(chartModel, defaultListSelectionModel);
        chartModel.addChartModelListener(this);
        this.firePropertyChange(PROPERTY_MODEL, arrayList, this.models);
    }

    public void setModel(ChartModel chartModel) {
        ChartModel chartModel2 = this.models.size() > 0 ? this.models.get(0) : null;
        this.removeModels();
        this.addModel(chartModel);
        this.firePropertyChange(PROPERTY_MODEL, chartModel2, chartModel);
    }

    public void setModel(ChartModel chartModel, ChartStyle chartStyle) {
        ChartModel chartModel2 = this.models.size() > 0 ? this.models.get(0) : null;
        this.removeModels();
        this.addModel(chartModel, chartStyle);
        this.firePropertyChange(PROPERTY_MODEL, chartModel2, chartModel);
    }

    public Chart addModel(ChartModel chartModel) {
        this.addModel(chartModel, true);
        return this;
    }

    public Chart addModel(ChartModel chartModel, boolean bl) {
        this.addModelSafely(chartModel);
        if (!this.isLazyRendering() && bl) {
            this.setDirty(true);
            this.repaint();
        }
        return this;
    }

    public Chart addModel(ChartModel chartModel, ChartStyle chartStyle) {
        return this.addModel(chartModel, null, chartStyle);
    }

    public Chart addModel(ChartModel chartModel, Axis axis) {
        return this.addModel(chartModel, axis, null);
    }

    public Chart addModel(ChartModel chartModel, Axis axis, ChartStyle chartStyle) {
        if (chartModel == null) {
            throw new NullPointerException("You cannot add a NULL ChartModel to a chart");
        }
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("You cannot add an unnamed ChartModel to a chart");
        }
        if (chartStyle != null) {
            this.chartStyles.put(chartModel.getName(), chartStyle);
        }
        this.addModelSafely(chartModel);
        if (axis != null) {
            this.setModelAxis(chartModel, axis);
        }
        if (!this.isLazyRendering()) {
            this.setDirty(true);
            this.repaint();
        }
        return this;
    }

    public ChartModel getModel() {
        if (this.models == null || this.models.size() == 0) {
            return null;
        }
        return this.models.get(0);
    }

    public ChartModel getModel(int n) {
        if (this.models == null || this.models.size() == 0) {
            return null;
        }
        return this.models.get(n);
    }

    public ChartModel getModel(String string) {
        for (ChartModel chartModel : this.models) {
            if (!string.equals(chartModel.getName())) continue;
            return chartModel;
        }
        return null;
    }

    public List<ChartModel> getModels() {
        return this.models;
    }

    public int modelCount() {
        return this.models == null ? 0 : this.models.size();
    }

    public int pointCount() {
        int n = 0;
        for (ChartModel chartModel : this.models) {
            n += chartModel.getPointCount();
        }
        return n;
    }

    public void setModelAxis(ChartModel chartModel, Axis axis) {
        this.axisChoices.put(chartModel, axis);
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_Y_AXIS, null, axis);
    }

    public Axis getAxisForModel(ChartModel chartModel) {
        Axis axis = this.axisChoices.get(chartModel);
        return axis == null ? this.getYAxis() : axis;
    }

    public ListSelectionModel getSelectionsForModel(ChartModel chartModel) {
        return this.selectionModels.get(chartModel);
    }

    public void setSelectionsForModel(ChartModel chartModel, ListSelectionModel listSelectionModel) {
        this.selectionModels.put(chartModel, listSelectionModel);
    }

    public UserToPixelTransform getTransformForModel(ChartModel chartModel) {
        Axis axis = this.getAxisForModel(chartModel);
        assert (axis != null);
        return this.getTransformForAxis(axis);
    }

    public void setStyle(ChartModel chartModel, ChartStyle chartStyle) {
        this.setStyle(chartModel, chartStyle, true);
    }

    public void setStyle(ChartModel chartModel, ChartStyle chartStyle, boolean bl) {
        ChartStyle chartStyle2 = this.chartStyles.get(chartModel.getName());
        this.chartStyles.put(chartModel.getName(), chartStyle);
        if (bl) {
            if (this.isLazyRendering()) {
                this.lazyChartRenderer.updateImage(chartModel, true);
            } else {
                this.setDirty(true);
                this.repaint();
            }
            this.firePropertyChange(PROPERTY_CHART_STYLE, chartStyle2, chartStyle);
        }
    }

    public ChartStyle getStyle(ChartModel chartModel) {
        assert (chartModel != null);
        String string = chartModel.getName();
        if (string == null) {
            throw new NullPointerException("Unnamed Model " + chartModel);
        }
        return this.chartStyles.get(string);
    }

    public void setHighlightStyle(Highlight highlight, ChartStyle chartStyle) {
        if (chartStyle == null) {
            this.highlightStyles.remove(highlight);
        } else {
            this.highlightStyles.put(highlight, chartStyle);
        }
        this.setDirty(true);
        this.repaint();
        this.firePropertyChange(PROPERTY_HIGHLIGHT_STYLE, null, chartStyle);
    }

    public ChartStyle getHighlightStyle(Highlight highlight) {
        return this.highlightStyles.get(highlight);
    }

    public Chart clearHighlights() {
        this.highlightStyles.clear();
        this.repaint();
        return this;
    }

    public boolean containsModel(ChartModel chartModel) {
        return this.models.contains(chartModel);
    }

    public Chart removeModel(ChartModel chartModel) {
        assert (chartModel != null) : "Supplied ChartModel cannot be null";
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.models);
        chartModel.removeChartModelListener(this);
        int n = this.models.size();
        this.models.remove(chartModel);
        this.zOrders.remove(chartModel);
        assert (this.models.size() == n - 1) : "Unable to remove model. Was it named?";
        this.axisChoices.remove(chartModel);
        String string = chartModel.getName();
        this.lineRenderers.remove(string);
        this.barRenderers.remove(string);
        this.pointRenderers.remove(string);
        this.chartStyles.remove(string);
        this.selectionModels.remove(chartModel);
        this.shadowedModels.remove(string);
        if (!this.isLazyRendering()) {
            this.setDirty(true);
            this.repaint();
        } else {
            this.lazyChartRenderer.removeImage(chartModel);
            this.lazyChartRenderer.updateCharts(false);
        }
        this.firePropertyChange(PROPERTY_MODEL, arrayList, this.models);
        return this;
    }

    public Chart replaceModel(ChartModel chartModel, ChartModel chartModel2) {
        String string = chartModel.getName();
        if (!string.equals(chartModel2.getName())) {
            throw new IllegalArgumentException("The names of the old and new chart models must be the same");
        }
        chartModel.removeChartModelListener(this);
        int n = this.models.indexOf(chartModel);
        if (n < 0) {
            throw new IllegalArgumentException("Cannot find model " + string + " in chart");
        }
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.models);
        this.models.set(n, chartModel2);
        Axis axis = this.axisChoices.get(chartModel);
        this.axisChoices.remove(chartModel);
        this.axisChoices.put(chartModel2, axis);
        this.selectionModels.remove(chartModel);
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.selectionModels.put(chartModel2, defaultListSelectionModel);
        chartModel2.addChartModelListener(this);
        this.setDirty(true);
        if (!this.isLazyRendering()) {
            this.repaint();
        }
        this.firePropertyChange(PROPERTY_MODEL, arrayList, this.models);
        return this;
    }

    public Chart removeModels() {
        this.lazyChartRenderer.cancelDrawing();
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>(this.getModels());
        for (ChartModel chartModel : arrayList) {
            this.removeModel(chartModel);
        }
        this.zOrders.clear();
        assert (this.models.size() == 0) : String.format("Chart " + this.getName() + " still has %d models", this.models.size());
        return this;
    }

    private Color getAncestorBackground(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        Color color = container.getBackground();
        if (color == null) {
            return this.getAncestorBackground(container);
        }
        return color;
    }

    private boolean isPaintedBeforeAxes(Drawable drawable) {
        if (drawable instanceof ZOrder) {
            ZOrder zOrder = (ZOrder)((Object)drawable);
            return zOrder.getZOrder() < 0;
        }
        return false;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        Object object3;
        Rectangle rectangle;
        this.updateMargins();
        if (!this.animationShown) {
            this.autoRange();
            this.update();
            if (this.isAnimateOnShow()) {
                this.setAnimationPosition(0.0);
                this.startAnimation();
            } else {
                this.setAnimationPosition(1.0);
            }
            this.animationShown = true;
        }
        Rectangle rectangle2 = this.getVisibleRect();
        int n = rectangle2.width;
        int n2 = rectangle2.height;
        if (this.isLazyRendering() && this.isDirty() && n > 0 && n2 > 0) {
            this.setDirty(false);
            this.lazyChartRenderer.updateCharts(false);
        }
        this.dirty = false;
        if (this.xStart == this.xEnd) {
            return;
        }
        ChartUtils.clearBufferedImage(this.shadowImage, this.getBackground());
        if (this.chartType == ChartType.PIE) {
            ChartUtils.clearBufferedImage(this.labelImage, this.getBackground());
        }
        Graphics2D graphics2D = this.shadowImage == null ? null : this.shadowImage.createGraphics();
        Graphics2D graphics2D2 = this.labelImage == null ? null : this.labelImage.createGraphics();
        Graphics2D graphics2D3 = (Graphics2D)graphics;
        Shape shape = graphics2D3.getClip();
        Rectangle rectangle3 = rectangle = shape == null ? new Rectangle(0, 0, 0, 0) : shape.getBounds();
        if (!this.isEnabled()) {
            if (this.disabledImage == null || this.disabledImage.getWidth() != this.getWidth() || this.disabledImage.getHeight() != this.getHeight()) {
                this.disabledImage = new BufferedImage(this.getWidth(), this.getHeight(), 2);
                graphics2D3 = this.disabledImage.createGraphics();
            } else {
                graphics2D3 = this.disabledImage.createGraphics();
                graphics2D3.setColor(new Color(0, 0, 0, 0));
                graphics2D3.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }
        if (graphics2D != null) {
            graphics2D.setFont(this.getFont());
        }
        graphics2D3.setFont(this.getFont());
        if (this.antiAliasing) {
            graphics2D3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (graphics2D2 != null) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
        } else {
            graphics2D3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D3.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            if (graphics2D2 != null) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        Paint paint = graphics2D3.getPaint();
        Color color = UIManager.getColor("Chart.disabledBackground");
        Paint paint2 = this.isEnabled() || color == null ? this.panelBackground : color;
        graphics2D3.setPaint(paint2);
        if (this.isOpaque()) {
            graphics2D3.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        Rectangle2D rectangle2D = graphics2D3.getClipBounds();
        int n3 = 0;
        int n4 = 0;
        if (this.chartType == ChartType.PIE) {
            if (this.chartBackground != null) {
                object3 = this.getInsets();
                graphics2D3.setPaint(this.chartBackground);
                graphics2D3.fillRect(((Insets)object3).left, ((Insets)object3).top, this.getWidth() - ((Insets)object3).left - ((Insets)object3).right, this.getHeight() - ((Insets)object3).top - ((Insets)object3).bottom);
            }
        } else {
            object3 = this.chartBackground == null ? Color.white : this.chartBackground;
            graphics2D3.setPaint((Paint)object3);
            graphics2D3.fillRect(this.xStart, this.yEnd, this.getXEnd() - this.xStart, this.yStart - this.yEnd);
            AxisRenderer object22 = this.xAxis == null ? null : this.xAxis.getAxisRenderer();
            n3 = object22 == null ? 0 : object22.getBreadth();
            object = this.getYAxis();
            AxisRenderer axisRenderer = object == null ? null : ((Axis)object).getAxisRenderer();
            n4 = axisRenderer == null ? 0 : axisRenderer.getBreadth();
            int n5 = this.xStart - n4 / 2 + 1;
            Rectangle rectangle4 = new Rectangle(n5, this.yEnd, this.getXEnd() - n5, this.yStart - this.yEnd + n3 / 2);
            rectangle2D = rectangle.createIntersection(rectangle4);
            graphics2D3.setClip(rectangle2D);
        }
        if (this.chartType == ChartType.PIE) {
            graphics2D3.setClip(shape);
            this.piePainter.setLabelGraphics(graphics2D2);
            object3 = this.getModel();
            Graphics2D graphics2D4 = this.getGraphicsTarget(graphics2D3, graphics2D);
            if (graphics2D4 != null && object3 != null) {
                this.piePainter.drawChart(graphics2D4, this, (ChartModel)object3, 0, null, false);
            }
        } else {
            graphics2D3.setClip(rectangle2D);
            for (Drawable drawable : this.drawables) {
                if (!this.isPaintedBeforeAxes(drawable) || (object = (Frontable)((Object)drawable)).isAtFront()) continue;
                drawable.draw(graphics2D3);
                this.drawDrawableForShadow(graphics2D, drawable);
            }
            graphics2D3.setClip(shape);
            this.paintAxes(graphics2D3);
        }
        this.paintTitle(graphics2D3);
        graphics2D3.setClip(rectangle2D);
        for (Drawable drawable : this.drawables) {
            if (drawable == this.lazyChartRenderer || !(drawable instanceof Frontable) || this.isPaintedBeforeAxes(drawable) || (object = (Frontable)((Object)drawable)).isAtFront()) continue;
            drawable.draw(graphics2D3);
            this.drawDrawableForShadow(graphics2D, drawable);
        }
        this.lazyChartRenderer.draw(this.getGraphicsTarget(graphics2D3, graphics2D));
        if (!this.isLazyRendering() && this.chartType == ChartType.XY) {
            this.paintModels(graphics2D3, graphics2D, rectangle, rectangle2D);
        }
        if (this.chartType != ChartType.PIE) {
            graphics2D3.setClip(rectangle);
            this.paintYAxisLabels(graphics2D3);
            graphics2D3.setClip(rectangle2D);
        }
        if (this.shadowImage != null) {
            object3 = new Rectangle(this.xStart + n4 / 2, this.yEnd, (int)((double)(this.getXEnd() - this.xStart) - (double)n4 / 2.0), (int)((double)(this.yStart - this.yEnd) - (double)n3 / 2.0));
            graphics2D3.setClip((Shape)object3);
            if (this.isShadowVisible() && this.animationPosition >= 1.0) {
                BufferedImage bufferedImage = this.shadowRenderer.createShadow(this.shadowImage);
                if (this.chartType == ChartType.PIE) {
                    graphics.setClip(rectangle);
                }
                graphics2D3.drawImage((Image)bufferedImage, 0, 0, null);
            }
            graphics2D3.setClip(rectangle2D);
            graphics2D3.drawImage((Image)this.shadowImage, 0, 0, null);
            if (this.labelImage != null) {
                graphics2D3.drawImage((Image)this.labelImage, 0, 0, null);
            }
        }
        this.paintAnnotations(graphics2D3);
        graphics2D3.setPaint(paint);
        if (this.shadowImage != null && graphics2D != null) {
            graphics2D.dispose();
        }
        for (Drawable drawable : this.drawables) {
            if (drawable instanceof Frontable) {
                object = (Frontable)((Object)drawable);
                if (!object.isAtFront()) continue;
                drawable.draw(graphics2D3);
                continue;
            }
            drawable.draw(graphics2D3);
        }
        object3 = this.getBounds();
        graphics2D3.setClip(new Rectangle(0, 0, ((Rectangle)object3).width, ((Rectangle)object3).height));
        if (this.chartType == ChartType.XY && this.chartBorder != null) {
            this.chartBorder.paintBorder(this, graphics2D3, this.xStart, this.yEnd, this.getChartWidth() + 1, this.getChartHeight() + 1);
        }
        if (!this.isEnabled()) {
            if (this.chartType == ChartType.PIE) {
                graphics.drawImage(this.disabledImage, 0, 0, null);
                Image image = GrayFilter.createDisabledImage(this.disabledImage);
                graphics.drawImage(image, 0, 0, null);
            } else {
                graphics.drawImage(this.disabledImage, 0, 0, null);
                graphics.setClip(rectangle2D);
                Image image = GrayFilter.createDisabledImage(this.disabledImage);
                graphics.drawImage(image, 0, 0, null);
            }
            graphics2D3.dispose();
        }
    }

    private void drawDrawableForShadow(Graphics2D graphics2D, Drawable drawable) {
        if (this.isShadowVisible() && this.animationPosition == 1.0) {
            Shadowable shadowable;
            if (this.shadowVisibility == ShadowVisibility.ALL) {
                drawable.draw(graphics2D);
            } else if (drawable instanceof Shadowable && graphics2D != null && (shadowable = (Shadowable)((Object)drawable)).isShadowVisible()) {
                drawable.draw(graphics2D);
            }
        }
    }

    private Graphics2D getGraphicsTarget(Graphics2D graphics2D, Graphics2D graphics2D2) {
        return this.shadowVisibility == ShadowVisibility.ALL ? graphics2D2 : graphics2D;
    }

    @Override
    public JToolTip createToolTip() {
        final JToolTip jToolTip = super.createToolTip();
        jToolTip.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                Chart.this.repaint(jToolTip.getBounds());
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
        return jToolTip;
    }

    public void paintYAxisTicks(Graphics graphics, Axis axis, Point point, int n) {
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        this.paintYAxisTicks(graphics, axis, userToPixelTransform, point, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintHorizontalGrid(Graphics graphics, Axis axis, UserToPixelTransform userToPixelTransform) {
        Tick[] tickArray;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font2 = this.getTickFont(axis);
        graphics2D.setFont(font2);
        for (Tick tick : tickArray = axis.getTicks()) {
            Point2D point2D;
            block4: {
                double d;
                block5: {
                    point2D = null;
                    try {
                        point2D = this.point2DPool.borrow(0.0, tick.getPosition());
                        Point2D point2D2 = this.calculatePixelPoint2D(point2D, userToPixelTransform);
                        if (point2D2 == null) break block4;
                        d = point2D2.getY();
                        if (!Double.isInfinite(d) && !Double.isNaN(d)) break block5;
                        this.point2DPool.replace(point2D);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.point2DPool.replace(point2D);
                        throw throwable;
                    }
                }
                int n = (int)d;
                if (n + 1 < this.yEnd || n > this.yStart || axis != this.getYAxis() || !tick.isMajor() && !this.isHorizontalMinorGridLinesVisible()) break block4;
                Stroke stroke2 = tick.isMajor() ? this.horizontalGridStroke : this.horizontalMinorGridStroke;
                Color color2 = tick.isMajor() ? this.gridColor : this.minorGridColor;
                graphics2D.setStroke(stroke2);
                graphics2D.setColor(color2);
                graphics2D.drawLine(this.xStart, n, this.xEnd, n);
            }
            this.point2DPool.replace(point2D);
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintYAxisTicks(Graphics graphics, Axis axis, UserToPixelTransform userToPixelTransform, Point point, int n) {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AxisPlacement axisPlacement = axis.getPlacement();
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font2 = this.getTickFont(axis);
        graphics2D.setFont(font2);
        Tick[] tickArray = axis.getTicks();
        Color color2 = this.getTickColor(axis);
        Color color3 = this.getMinorTickColor(axis);
        for (Tick object : tickArray) {
            Point2D n6;
            block11: {
                double d;
                block12: {
                    int n3 = n2 = object.isMajor() ? axis.getTickLength() : axis.getMinorTickLength();
                    if (n2 <= 0) continue;
                    n6 = null;
                    try {
                        n6 = this.point2DPool.borrow(0.0, object.getPosition());
                        Point2D n7 = this.calculatePixelPoint2D(n6, userToPixelTransform);
                        if (n7 == null) break block11;
                        d = n7.getY();
                        if (!Double.isInfinite(d) && !Double.isNaN(d)) break block12;
                        this.point2DPool.replace(n6);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.point2DPool.replace(n6);
                        throw throwable;
                    }
                }
                int n4 = (int)d;
                if (n4 + 1 < this.yEnd || n4 > this.yStart || !axis.isVisible() || !axis.isTicksVisible()) break block11;
                graphics2D.setColor(object.isMajor() ? color2 : color3);
                if (this.tickStroke != null) {
                    graphics2D.setStroke(this.tickStroke);
                }
                int n5 = axisPlacement == AxisPlacement.LEADING ? -1 : 1;
                graphics2D.drawLine(n, n4, n + n2 * n5, n4);
            }
            this.point2DPool.replace(n6);
        }
        if (axis.isVisible() && axis.isLabelVisible()) {
            FontMetrics fontMetrics;
            AutoPositionedLabel autoPositionedLabel = axis.getLabel();
            Font font3 = autoPositionedLabel == null ? null : autoPositionedLabel.getFont();
            FontMetrics fontMetrics2 = fontMetrics = font3 == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics(font3);
            if (autoPositionedLabel != null) {
                Double d = autoPositionedLabel.getRotation();
                n2 = this.axisWidth(axis);
                if (axisPlacement == AxisPlacement.TRAILING) {
                    autoPositionedLabel.paint((Graphics)graphics2D, n + n2 - fontMetrics.getAscent() - this.axisLabelPadding, point.y, d == null ? Rotation.QUARTER_CLOCKWISE.doubleValue() : d.doubleValue());
                } else if (axisPlacement == AxisPlacement.LEADING) {
                    autoPositionedLabel.paint((Graphics)graphics2D, n - n2 + fontMetrics.getAscent() + this.axisLabelPadding, point.y, d == null ? Rotation.QUARTER_ANTICLOCKWISE.doubleValue() : d.doubleValue());
                } else {
                    int n6 = fontMetrics.stringWidth(autoPositionedLabel.getLabel());
                    int n7 = 10;
                    autoPositionedLabel.paint((Graphics)graphics2D, n - fontMetrics.getAscent() + this.axisLabelPadding, this.yEnd + n7 + n6 / 2, d == null ? Rotation.QUARTER_ANTICLOCKWISE.doubleValue() : d.doubleValue());
                }
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    protected boolean drawStringIfWithinBounds(Graphics graphics, String string, int n, int n2) {
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
        Rectangle2D rectangle2D = GraphicsUtilities.calculateStringBounds(graphics, string, n, n2);
        if (GraphicsUtilities.rectangleWithinBounds(rectangle2D, rectangle2)) {
            this.paintLabel((Graphics2D)graphics, string, n, n2, rectangle2D);
            return true;
        }
        return false;
    }

    protected boolean drawRotatedStringIfWithinBounds(Graphics graphics, String string, int n, int n2, double d) {
        Rectangle rectangle = this.getBounds();
        Container container = this.getParent();
        Rectangle rectangle2 = container == null ? null : SwingUtilities.convertRectangle(this.getParent(), rectangle, this);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (string == null || "".equals(string)) {
            return false;
        }
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getDescent();
        float f = (float)n + (float)n3 / 2.0f;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = GraphicsUtilities.calculateRotatedStringBounds(graphics2D, string, n, n2, d);
        Rectangle rectangle3 = shape.getBounds();
        if (GraphicsUtilities.rectangleWithinBounds(rectangle3, rectangle2)) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int n5 = n2;
            graphics2D.translate(f, (double)n5);
            graphics2D.rotate(-d);
            graphics2D.drawString(string, (float)(-n3) / 2.0f, (float)n4);
            graphics2D.rotate(d);
            graphics2D.translate(-f, (double)(-n5));
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            return true;
        }
        return false;
    }

    public void drawXAxisTickLabel(Graphics graphics, Axis axis, String string, int n, int n2) {
        if (string == null) {
            return;
        }
        double d = axis.getTickLabelRotation();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getDescent();
        int n4 = fontMetrics.getAscent();
        AxisPlacement axisPlacement = axis.getPlacement();
        if (d == 0.0) {
            int n5 = fontMetrics.stringWidth(string);
            int n6 = n - n5 / 2;
            int n7 = axisPlacement == AxisPlacement.TRAILING ? n2 - n3 : n2 + n4;
            this.drawStringIfWithinBounds(graphics, string, n6, n7);
        } else {
            boolean bl;
            String string2 = string;
            boolean bl2 = false;
            do {
                String string3 = bl2 ? string2 + "\u2026" : string2;
                int n8 = string2.length() <= 1 ? 0 : fontMetrics.stringWidth(string3.substring(0, string3.length() - 1));
                int n9 = n8 / 2;
                int n10 = d < 1.5707963267948966 && d > 0.0 ? -((int)((double)n9 * Math.cos(d))) : (int)((double)n9 * Math.cos(d));
                int n11 = axisPlacement == AxisPlacement.TRAILING ? n - n8 / 2 - n10 : n - n8 / 2 + n10;
                int n12 = axisPlacement == AxisPlacement.TRAILING ? n2 - n4 - (int)Math.abs((double)n9 * Math.sin(d)) : n2 + n3 + (int)Math.abs((double)n9 * Math.sin(d));
                bl = this.drawRotatedStringIfWithinBounds(graphics, string3, n11, n12 + this.xAxis.getTickLength() + 1, d);
                string2 = string2.substring(0, string2.length() - 1);
                bl2 = true;
            } while (!bl && string2.length() > 0);
        }
    }

    protected void paintYAxis(Graphics2D graphics2D, Axis axis, int n) {
        if (!axis.isVisible()) {
            return;
        }
        axis.render(graphics2D, n, this.yEnd, this.yStart - this.yEnd, Orientation.vertical);
    }

    protected void paintXAxis(Graphics2D graphics2D) {
        AxisRenderer axisRenderer = this.xAxis.getAxisRenderer();
        if (!this.xAxis.isVisible() || axisRenderer == null) {
            return;
        }
        int n = this.getXAxisYCoord();
        AutoPositionedLabel autoPositionedLabel = this.xAxis.getLabel();
        if (autoPositionedLabel != null && this.xAxis.isLabelVisible()) {
            graphics2D.setColor(this.getLabelColor());
            Point point = this.getXAxisLabelPosition(graphics2D);
            autoPositionedLabel.paint((Graphics)graphics2D, point.x, point.y, Rotation.NONE.doubleValue());
        }
        int n2 = this.xEnd - this.xStart;
        this.xAxis.render(graphics2D, this.xStart, n, n2, Orientation.horizontal);
    }

    int getXAxisYCoord() {
        int n;
        AxisPlacement axisPlacement = this.xAxis.getPlacement();
        if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
            n = this.yStart;
        } else if (axisPlacement == AxisPlacement.CENTER) {
            n = (this.yStart + this.yEnd) / 2;
        } else if (axisPlacement == AxisPlacement.FLOATING) {
            double d = this.xAxis.getFloatingPosition();
            Point2D.Double double_ = new Point2D.Double(this.xAxis.minimum(), d);
            Point point = this.calculatePixelPoint(double_);
            n = point.y;
        } else {
            n = this.yEnd;
        }
        return n;
    }

    Point getXAxisLabelPosition(Graphics graphics) {
        AutoPositionedLabel autoPositionedLabel = this.xAxis.getLabel();
        assert (autoPositionedLabel != null);
        Font font = autoPositionedLabel.getFont();
        FontMetrics fontMetrics = font == null ? graphics.getFontMetrics() : graphics.getFontMetrics(font);
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        int n = this.getXAxisYCoord();
        AxisPlacement axisPlacement = this.xAxis.getPlacement();
        Point point = this.calculatePixelPoint(new Point2D.Double(this.xAxis.minimum(), this.getYAxis().midPoint()));
        Point point2 = this.calculatePixelPoint(new Point2D.Double(this.xAxis.maximum(), this.getYAxis().midPoint()));
        int n2 = point == null ? 0 : point.x;
        int n3 = point2 == null ? this.xEnd : point2.x;
        int n4 = point2 == null ? 0 : point2.y;
        Point point3 = new Point((n2 + n3) / 2, n4);
        Dimension dimension2 = autoPositionedLabel.size(graphics, font);
        Point point4 = axisPlacement == AxisPlacement.LEADING ? new Point(point3.x, dimension.height - dimension2.height + fontMetrics.getAscent() - this.axisLabelPadding - insets.bottom) : (axisPlacement == AxisPlacement.CENTER ? new Point(n3 - dimension2.width / 2 - this.axisLabelPadding, n - dimension2.height + fontMetrics.getAscent() - this.axisLabelPadding) : (axisPlacement == AxisPlacement.FLOATING ? new Point(n3 - dimension2.width / 2 - this.axisLabelPadding, n - dimension2.height + fontMetrics.getAscent() - this.axisLabelPadding) : new Point(point3.x, insets.top + this.titleHeight() + this.axisLabelPadding + fontMetrics.getHeight() / 2)));
        return point4;
    }

    protected Color getTickColor(Axis axis) {
        Color color;
        Color color2 = color = axis == null ? this.tickColor : axis.getTickColor();
        if (color == null) {
            color = this.tickColor;
        }
        return color;
    }

    protected Color getMinorTickColor(Axis axis) {
        Color color;
        Color color2 = color = axis == null ? this.tickColor : axis.getMinorTickColor();
        if (color == null) {
            color = this.getTickColor(axis);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintXAxisTicks(Graphics2D graphics2D, Tick[] tickArray) {
        Font font;
        if (tickArray == null) {
            return;
        }
        Font font2 = graphics2D.getFont();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Font font3 = font = this.xAxis == null ? UIManager.getFont("Label.font") : this.getTickFont(this.xAxis);
        if (font != null) {
            graphics2D.setFont(font);
        }
        Tick[] tickArray2 = this.allowTickLabelOverlap ? tickArray : this.filterXTicksToRemoveOverlap(graphics2D, tickArray, font);
        FontMetrics fontMetrics = font == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics(font);
        AxisPlacement axisPlacement = this.xAxis == null ? AxisPlacement.LEADING : this.xAxis.getPlacement();
        Color color2 = this.getTickColor(this.xAxis);
        Color color3 = this.getMinorTickColor(this.xAxis);
        for (Tick tick : tickArray2) {
            int n;
            if (tick == null) continue;
            int n2 = n = tick.isMajor() ? this.xAxis.getTickLength() : this.xAxis.getMinorTickLength();
            if (this.tickStroke != null) {
                graphics2D.setStroke(this.tickStroke);
            }
            Point2D point2D = null;
            try {
                point2D = this.point2DPool.borrow(tick.getPosition(), this.getYAxis().minimum());
                Point point = this.calculatePixelPoint(point2D);
                if (point != null) {
                    int n3 = point.x;
                    String string = tick.getLabel();
                    graphics2D.setColor(tick.isMajor() ? color2 : color3);
                    Color color4 = this.xAxis.getTickLabelColor();
                    if (color4 == null) {
                        color4 = this.labelColor;
                    }
                    if (this.xAxis.isVisible() && n3 + 1 >= this.xStart && n3 <= this.xEnd) {
                        AxisRenderer axisRenderer = this.xAxis.getAxisRenderer();
                        int n4 = axisRenderer == null ? 0 : axisRenderer.getBreadth() / 2;
                        int n5 = this.xAxis.getTickLabelOffset();
                        if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                            if (n > 0) {
                                graphics2D.drawLine(n3, this.yStart + n4, n3, this.yStart + n + n4);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.xAxis, string, n3, this.yStart + fontMetrics.getDescent() + n5 + n4);
                        } else if (axisPlacement == AxisPlacement.CENTER) {
                            int n6 = (this.yStart + this.yEnd) / 2;
                            if (n > 0) {
                                graphics2D.drawLine(n3, n6 + n4, n3, n6 + n + n4);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.xAxis, string, n3, n6 + fontMetrics.getDescent() + n5 + n4);
                        } else if (axisPlacement == AxisPlacement.FLOATING) {
                            double d = this.xAxis.getFloatingPosition();
                            point2D.setLocation(this.xAxis.minimum(), d);
                            Point point2 = this.calculatePixelPoint(point2D);
                            int n7 = point2.y;
                            if (n > 0) {
                                graphics2D.drawLine(n3, n7 + n4, n3, n7 + n + n4);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.xAxis, string, n3, n7 + fontMetrics.getDescent() + n5 + n4);
                        } else {
                            if (n > 0) {
                                graphics2D.drawLine(n3, this.yEnd - n4, n3, this.yEnd - n - n4);
                            }
                            graphics2D.setColor(color4);
                            this.drawXAxisTickLabel(graphics2D, this.xAxis, string, n3, this.yEnd - fontMetrics.getDescent() - n5 - n4);
                        }
                    }
                }
                this.point2DPool.replace(point2D);
            }
            catch (Throwable throwable) {
                this.point2DPool.replace(point2D);
                throw throwable;
            }
        }
        graphics2D.setFont(font2);
        graphics2D.setColor(color);
        graphics2D.setStroke(stroke);
    }

    protected void paintXAxisGridLines(Graphics2D graphics2D, Tick[] tickArray) {
        assert (tickArray != null);
        Stroke stroke = graphics2D.getStroke();
        for (Tick tick : tickArray) {
            Point2D.Double double_;
            Point point;
            if (tick == null || (point = this.calculatePixelPoint(double_ = new Point2D.Double(tick.getPosition(), 0.0))) == null) continue;
            int n = point.x;
            if (!this.verticalGridLinesVisible || n < this.xStart || n > this.xEnd || !tick.isMajor() && !this.verticalMinorGridLinesVisible) continue;
            Stroke stroke2 = tick.isMajor() ? this.verticalGridStroke : this.verticalMinorGridStroke;
            Color color = tick.isMajor() ? this.gridColor : this.minorGridColor;
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(color);
            graphics2D.drawLine(n, this.yStart, n, this.yEnd);
        }
        graphics2D.setStroke(stroke);
    }

    protected void paintAxes(Graphics2D graphics2D) {
        Tick[] tickArray = this.xAxis.getTicks();
        if (this.isVerticalGridLinesVisible()) {
            this.paintXAxisGridLines(graphics2D, tickArray);
        }
        if (this.horizontalGridLinesVisible) {
            this.paintHorizontalGrid(graphics2D, this.getYAxis(), this.getUserToPixelTransform());
        }
        this.paintXAxis(graphics2D);
        AxisRenderer axisRenderer = this.getYAxis().getAxisRenderer();
        int n = 0;
        graphics2D.setColor(this.axisColor);
        int n2 = (this.xStart + this.xEnd) / 2;
        int n3 = this.xStart;
        int n4 = this.xEnd;
        Axis axis = this.getYAxis();
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        Range<?> range = axis.getRange();
        double d = range.minimum();
        double d2 = range.maximum();
        Point point = this.calculatePixelPoint((Point2D)new Point2D.Double(this.xAxis.midPoint(), d), userToPixelTransform);
        Point point2 = this.calculatePixelPoint((Point2D)new Point2D.Double(this.xAxis.midPoint(), d2), userToPixelTransform);
        for (Axis axis2 : this.yAxes) {
            int n5;
            int n6;
            int n7 = this.axisWidth(axis2);
            AxisRenderer axisRenderer2 = axis2.getAxisRenderer();
            int n8 = axisRenderer2 == null ? 0 : axisRenderer2.getBreadth() / 2;
            AxisPlacement axisPlacement = axis2.getPlacement();
            if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                n6 = n3;
                n5 = n6 - n8;
                n3 -= n7;
            } else if (axisPlacement == AxisPlacement.TRAILING) {
                n6 = n4;
                n5 = n6 + n8;
                n4 += n7;
            } else if (axisPlacement == AxisPlacement.FLOATING) {
                double d3 = axis2.getFloatingPosition();
                Point2D.Double double_ = new Point2D.Double(d3, axis2.midPoint());
                Point point3 = this.calculatePixelPoint(double_);
                n6 = point3.x;
                n5 = n6 - n8;
            } else {
                n6 = n2;
                n5 = n6 - n8;
            }
            this.paintYAxis(graphics2D, axis2, n6);
            if (n < this.userToPixelTransforms.size()) {
                UserToPixelTransform userToPixelTransform2 = this.userToPixelTransforms.get(n);
                assert (userToPixelTransform2 != null);
                if (point != null && point2 != null) {
                    Point point4 = new Point(point.x, (point.y + point2.y) / 2);
                    this.paintYAxisTicks(graphics2D, axis2, userToPixelTransform2, point4, n5);
                }
            }
            ++n;
        }
        if (this.xAxis.isTicksVisible()) {
            this.paintXAxisTicks(graphics2D, tickArray);
        }
    }

    private void paintTitle(Graphics graphics) {
        if (this.title != null && this.titleVisible) {
            Insets insets = this.getInsets();
            int n = this.getChartType() == ChartType.PIE ? this.getWidth() / 2 : this.getXStart() + this.getChartWidth() / 2;
            Font font = this.title.getFont();
            if (font == null) {
                font = graphics.getFont();
            }
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            int n2 = fontMetrics.getHeight() + fontMetrics.getDescent();
            this.title.paint(graphics, n, insets.top + n2, Rotation.NONE.doubleValue());
        }
    }

    protected void paintYAxisLabels(Graphics2D graphics2D) {
        int n = 0;
        graphics2D.setColor(this.axisColor);
        int n2 = (this.xStart + this.xEnd) / 2;
        int n3 = this.xStart;
        int n4 = this.xEnd;
        for (Axis axis : this.yAxes) {
            Serializable serializable;
            Serializable serializable2;
            int n5;
            int n6 = this.axisWidth(axis);
            AxisRenderer axisRenderer = axis.getAxisRenderer();
            int n7 = axisRenderer == null ? 0 : axisRenderer.getBreadth() / 2;
            int n8 = axis.getTickLabelOffset();
            AxisPlacement axisPlacement = axis.getPlacement();
            if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                n5 = n3 - n8 - n7;
                n3 -= n6 + n7;
            } else if (axisPlacement == AxisPlacement.TRAILING) {
                n5 = n4 + n8 + n7;
                n4 += n6 + n7;
            } else if (axisPlacement == AxisPlacement.FLOATING) {
                double d = axis.getFloatingPosition();
                serializable2 = new Point2D.Double(d, axis.midPoint());
                serializable = this.calculatePixelPoint((Point2D)((Object)serializable2));
                n5 = ((Point)serializable).x - n8 - n7;
            } else {
                n5 = n2 - n8 - n7;
            }
            if (n < this.userToPixelTransforms.size()) {
                UserToPixelTransform userToPixelTransform = this.userToPixelTransforms.get(n);
                assert (userToPixelTransform != null);
                serializable2 = this.getTickFont(axis);
                Serializable serializable3 = serializable = serializable2 == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics((Font)serializable2);
                if (axis.isVisible() && axis.isTicksVisible()) {
                    Tick[] tickArray;
                    Tick[] tickArray2 = axis.getTicks();
                    for (Tick tick : tickArray = this.allowTickLabelOverlap ? tickArray2 : this.filterYTicksToRemoveOverlap(graphics2D, axis, tickArray2, (Font)serializable2)) {
                        double d;
                        Point2D.Double double_ = new Point2D.Double(0.0, tick.getPosition());
                        Point2D point2D = this.calculatePixelPoint2D((Point2D)double_, userToPixelTransform);
                        if (point2D == null || Double.isInfinite(d = point2D.getY()) || Double.isNaN(d)) continue;
                        int n9 = (int)d;
                        String string = tick.getLabel();
                        graphics2D.setFont((Font)serializable2);
                        Color color = axis.getTickLabelColor();
                        if (color == null) {
                            color = this.labelColor;
                        }
                        graphics2D.setColor(color);
                        if (axisPlacement == AxisPlacement.TRAILING) {
                            this.drawYAxisTickLabel(graphics2D, axis, string, n5 + axis.getTickLength() + 1, n9 + ((FontMetrics)serializable).getDescent());
                            continue;
                        }
                        if (axisPlacement == AxisPlacement.LEADING) {
                            this.drawYAxisTickLabel(graphics2D, axis, string, n5 - axis.getTickLength() - 1, n9 + ((FontMetrics)serializable).getDescent());
                            continue;
                        }
                        this.drawYAxisTickLabel(graphics2D, axis, string, n5 + axis.getTickLength() + 1, n9 + ((FontMetrics)serializable).getDescent());
                    }
                }
            }
            ++n;
        }
    }

    private Tick[] filterYTicksToRemoveOverlap(Graphics graphics, Axis axis, Tick[] tickArray, Font font) {
        boolean bl;
        int n = 1;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setFont(font);
        do {
            int n2 = 0;
            bl = false;
            Rectangle2D rectangle2D = null;
            arrayList.clear();
            for (Tick tick : tickArray) {
                if (tick.isMajor()) {
                    if (n2 == 0) {
                        Point2D.Double double_ = new Point2D.Double(0.0, tick.getPosition());
                        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
                        Point2D point2D = this.calculatePixelPoint2D((Point2D)double_, userToPixelTransform);
                        double d = axis.getTickLabelRotation();
                        Shape shape = null;
                        if (point2D != null) {
                            shape = this.isApproximatelyInDegrees(d, 0.0, 1.0) ? GraphicsUtilities.calculateStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY()) : GraphicsUtilities.calculateRotatedStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY(), d);
                        }
                        if (rectangle2D != null && shape != null) {
                            Area area = new Area(shape);
                            Area area2 = new Area(rectangle2D);
                            area.intersect(area2);
                            if (!area.isEmpty()) {
                                bl = true;
                                break;
                            }
                        }
                        arrayList.add(tick);
                        rectangle2D = shape;
                    }
                    if (++n2 != n) continue;
                    n2 = 0;
                    continue;
                }
                arrayList.add(tick);
            }
            ++n;
        } while (bl);
        graphics2D.dispose();
        Tick[] tickArray2 = new Tick[arrayList.size()];
        return arrayList.toArray(tickArray2);
    }

    private Tick[] filterXTicksToRemoveOverlap(Graphics graphics, Tick[] tickArray, Font font) {
        boolean bl;
        int n = 1;
        ArrayList<Tick> arrayList = new ArrayList<Tick>();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setFont(font);
        do {
            int n2 = 0;
            bl = false;
            Rectangle2D rectangle2D = null;
            arrayList.clear();
            for (Tick tick : tickArray) {
                if (tick == null) continue;
                if (tick.isMajor()) {
                    if (n2 == 0) {
                        Point2D.Double double_ = new Point2D.Double(tick.getPosition(), 0.0);
                        Point2D point2D = this.calculatePixelPoint2D(double_);
                        double d = this.xAxis.getTickLabelRotation();
                        Shape shape = null;
                        if (point2D != null) {
                            shape = this.isApproximatelyInDegrees(d, 0.0, 1.0) ? GraphicsUtilities.calculateStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY()) : GraphicsUtilities.calculateRotatedStringBounds(graphics2D, tick.getLabel(), point2D.getX(), point2D.getY(), d);
                        }
                        if (rectangle2D != null && shape != null) {
                            Area area = new Area(shape);
                            Area area2 = new Area(rectangle2D);
                            area.intersect(area2);
                            if (!area.isEmpty()) {
                                bl = true;
                                break;
                            }
                        }
                        arrayList.add(tick);
                        rectangle2D = shape;
                    }
                    if (++n2 != n) continue;
                    n2 = 0;
                    continue;
                }
                arrayList.add(tick);
            }
            ++n;
        } while (bl);
        graphics2D.dispose();
        Tick[] tickArray2 = new Tick[arrayList.size()];
        return arrayList.toArray(tickArray2);
    }

    protected void drawYAxisTickLabel(Graphics graphics, Axis axis, String string, int n, int n2) {
        if (string == null) {
            return;
        }
        AxisPlacement axisPlacement = axis.getPlacement();
        double d = axis.getTickLabelRotation();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = fontMetrics.getAscent();
        int n5 = fontMetrics.getDescent();
        if (d == 0.0) {
            int n6 = axisPlacement == AxisPlacement.LEADING ? n - n3 : n + n5;
            Rectangle rectangle = this.getBounds();
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height);
            Rectangle2D rectangle2D = GraphicsUtilities.calculateStringBounds(graphics, string, n, n2);
            if (GraphicsUtilities.rectangleWithinBounds(rectangle2D, rectangle2)) {
                this.paintLabel((Graphics2D)graphics, string, n6, n2 + n5, rectangle2D);
            }
        } else if (this.isApproximatelyInDegrees(d, 90.0, 1.0) || this.isApproximatelyInDegrees(d, -90.0, 1.0) || this.isApproximatelyInDegrees(d, 270.0, 1.0)) {
            int n7 = axisPlacement == AxisPlacement.LEADING ? n - n3 / 2 - n4 / 2 : n + n4 / 2 - n3 / 2;
            int n8 = n2 - fontMetrics.stringWidth("0") / 2;
            this.drawRotatedStringIfWithinBounds(graphics, string, n7, n8, d);
        } else {
            boolean bl;
            boolean bl2 = false;
            String string2 = string;
            do {
                String string3 = bl2 ? string2 + "\u2026" : string2;
                int n9 = string2.length() <= 1 ? 0 : fontMetrics.stringWidth(string3.substring(0, string3.length() - 1));
                double d2 = (double)n9 / 2.0;
                int n10 = axisPlacement == AxisPlacement.LEADING ? n - n3 + (int)(d2 - d2 * Math.cos(d)) : n + n5 - (int)(d2 - d2 * Math.cos(d));
                int n11 = axisPlacement == AxisPlacement.LEADING ? n2 + (int)(d2 * Math.sin(d)) : n2 - (int)(d2 * Math.sin(d));
                bl = this.drawRotatedStringIfWithinBounds(graphics, string3, n10, n11, d);
                string2 = string2.substring(0, string2.length() - 1);
                bl2 = true;
            } while (!bl && string2.length() > 0);
        }
    }

    private void paintLabel(Graphics2D graphics2D, String string, float f, float f2, Rectangle2D rectangle2D) {
        graphics2D.drawString(string, f, f2);
    }

    private boolean isApproximatelyInDegrees(double d, double d2, double d3) {
        double d4 = Math.toDegrees(d);
        return Math.abs(d4 - d2) < d3;
    }

    public PointSelection nearestPoint(Point point, ChartModel chartModel) {
        if (point == null) {
            return null;
        }
        UserToPixelTransform userToPixelTransform = this.getTransformForModel(chartModel);
        double d = Double.MAX_VALUE;
        Chartable chartable = null;
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < chartModel.getPointCount(); ++i) {
            double d2;
            Object object;
            Object object2;
            Point2D.Double double_ = null;
            if (chartModel instanceof LeanChartModel) {
                object2 = (LeanChartModel)chartModel;
                object = object2.getPointPositions(i);
                double_ = new Point2D.Double(object[0], object[1]);
            } else {
                Positionable positionable;
                object2 = chartModel.getPoint(i);
                object = object2 == null ? null : object2.getX();
                Positionable positionable2 = positionable = object2 == null ? null : object2.getY();
                if (object != null && positionable != null) {
                    double_ = new Point2D.Double(object.position(), positionable.position());
                }
            }
            Object object3 = object2 = double_ == null ? null : this.calculatePixelPoint((Point2D)double_, userToPixelTransform);
            if (object2 != null && (d2 = ((Point2D)object2).distanceSq(point.x, point.y)) < d) {
                d = d2;
                chartable = chartModel.getPoint(i);
                n = n2;
            }
            ++n2;
        }
        if (chartable == null) {
            return null;
        }
        return new PointSelection(chartable, Math.sqrt(d), n);
    }

    public ChartModel nearestModel(Point point) {
        Double d = Double.MAX_VALUE;
        ChartModel chartModel = null;
        for (ChartModel chartModel2 : this.getModels()) {
            Double d2;
            PointSelection pointSelection = this.nearestPoint(point, chartModel2);
            if (pointSelection == null || (d2 = pointSelection.getDistance()) == null || !(d2 < d)) continue;
            d = d2;
            chartModel = chartModel2;
        }
        return chartModel;
    }

    public boolean isUserPointViewable(Point2D point2D, ChartModel chartModel) {
        UserToPixelTransform userToPixelTransform = this.getTransformForModel(chartModel);
        Point2D point2D2 = userToPixelTransform.transform(point2D);
        return this.isPixelPointViewable((int)point2D2.getX(), (int)point2D2.getY());
    }

    public boolean isPixelPointViewable(int n, int n2) {
        boolean bl = n <= this.getXEnd() && n >= this.getXStart();
        boolean bl2 = n2 <= this.getYStart() && n2 >= this.getYEnd();
        return bl && bl2;
    }

    public Pair<Chartable, Double> nearestPoint(Point2D point2D, ChartModel chartModel) {
        Chartable chartable = null;
        Double d = null;
        for (Chartable chartable2 : chartModel) {
            double d2 = Chart.distanceSq(point2D, chartable2);
            if (d != null && !(d2 < d)) continue;
            d = d2;
            chartable = chartable2;
        }
        return new Pair<Object, Object>(chartable, d);
    }

    public static double distanceSq(Point2D point2D, Chartable chartable) {
        double d = chartable.getX().position();
        double d2 = chartable.getY().position();
        return point2D.distanceSq(d, d2);
    }

    public static double distance(Point2D point2D, Chartable chartable) {
        double d = chartable.getX().position();
        double d2 = chartable.getY().position();
        return point2D.distance(d, d2);
    }

    void addCoordinateSystem(Rectangle2D rectangle2D, Rectangle rectangle, Axis axis) {
        UserToPixelTransform userToPixelTransform = this.computeCoordinateConversion(rectangle2D, rectangle, axis);
        this.userToPixelTransforms.add(userToPixelTransform);
    }

    void setCoordinateSystem(Rectangle2D rectangle2D, Rectangle rectangle) {
        this.setCoordinateSystem(rectangle2D, rectangle, this.getYAxis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCoordinateSystem(Rectangle2D rectangle2D, Rectangle rectangle, Axis axis) {
        this.coordinateSpaceWriteLock.lock();
        try {
            UserToPixelTransform userToPixelTransform = this.computeCoordinateConversion(rectangle2D, rectangle, axis);
            this.userToPixelTransforms.clear();
            this.userToPixelTransforms.add(userToPixelTransform);
        }
        finally {
            this.coordinateSpaceWriteLock.unlock();
        }
    }

    private UserToPixelTransform computeCoordinateConversion(Rectangle2D rectangle2D, Rectangle rectangle, Axis axis) {
        if (rectangle.width == 0 || rectangle.height == 0) {
            rectangle = new Rectangle(100, 100);
        }
        boolean bl = this.xAxis != null && this.xAxis.isFlipped();
        int n = bl ? -1 : 1;
        boolean bl2 = axis != null && axis.isFlipped();
        int n2 = bl2 ? -1 : 1;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(bl ? (double)(rectangle.x + rectangle.width) : (double)rectangle.x, rectangle.y + (bl2 ? 0 : rectangle.height));
        double d = (double)n * (double)rectangle.width / rectangle2D.getWidth();
        double d2 = -1.0 * (double)n2 * (double)rectangle.height / rectangle2D.getHeight();
        affineTransform.scale(d, d2);
        UserToPixelTransform userToPixelTransform = new UserToPixelTransform(affineTransform);
        userToPixelTransform.setTranslation(-rectangle2D.getX(), -rectangle2D.getY());
        userToPixelTransform.setXTransform(this.xAxis == null ? new IdentityTransform() : this.xAxis.getAxisTransform());
        userToPixelTransform.setYTransform(axis == null ? new IdentityTransform() : axis.getAxisTransform());
        return userToPixelTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point calculatePixelPoint(Point2D point2D) {
        this.coordinateSpaceReadLock.lock();
        try {
            UserToPixelTransform userToPixelTransform = this.getUserToPixelTransform();
            if (userToPixelTransform != null) {
                Point2D point2D2 = userToPixelTransform.transform(point2D);
                if (point2D2 == null) {
                    Point point = null;
                    return point;
                }
                Point point = new Point((int)point2D2.getX(), (int)point2D2.getY());
                return point;
            }
            Point point = null;
            return point;
        }
        finally {
            this.coordinateSpaceReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D calculatePixelPoint2D(Point2D point2D) {
        this.coordinateSpaceReadLock.lock();
        try {
            UserToPixelTransform userToPixelTransform = this.getUserToPixelTransform();
            Point2D point2D2 = userToPixelTransform == null ? null : userToPixelTransform.transform(point2D);
            return point2D2;
        }
        finally {
            this.coordinateSpaceReadLock.unlock();
        }
    }

    public Point calculatePixelPoint(Point2D point2D, Axis axis) {
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        return this.calculatePixelPoint(point2D, userToPixelTransform);
    }

    public Point2D calculatePixelPoint2D(Point2D point2D, Axis axis) {
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        return this.calculatePixelPoint2D(point2D, userToPixelTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point calculatePixelPoint(Point2D point2D, UserToPixelTransform userToPixelTransform) {
        Point point;
        if (userToPixelTransform == null) {
            return null;
        }
        Point2D point2D2 = null;
        try {
            point2D2 = this.point2DPool.borrow(0.0, 0.0);
            point2D2 = userToPixelTransform.transform(point2D, point2D2);
            point = point2D2 == null || Double.isNaN(point2D2.getX()) || Double.isNaN(point2D2.getY()) ? null : new Point((int)point2D2.getX(), (int)point2D2.getY());
        }
        finally {
            this.point2DPool.replace(point2D2);
        }
        return point;
    }

    public Point2D calculatePixelPoint2D(Point2D point2D, UserToPixelTransform userToPixelTransform) {
        if (userToPixelTransform == null) {
            return null;
        }
        return userToPixelTransform.transform(point2D);
    }

    public Point2D calculateUserPoint(Point point) {
        Point2D point2D;
        assert (point != null);
        try {
            UserToPixelTransform userToPixelTransform = this.getUserToPixelTransform();
            point2D = userToPixelTransform == null ? null : userToPixelTransform.inverseTransform(point);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return point2D;
    }

    public Point2D calculateUserPoint(Point point, Axis axis) {
        Point2D point2D;
        assert (point != null);
        try {
            UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
            point2D = userToPixelTransform == null ? null : userToPixelTransform.inverseTransform(point);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return point2D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double convertYToPrimary(double d, Axis axis) {
        Point2D point2D = null;
        try {
            point2D = this.point2DPool.borrow(this.getXAxis().midPoint(), d);
            Point2D point2D2 = this.calculatePixelPoint2D(point2D, axis);
            Axis axis2 = this.getYAxis();
            Point point = new Point((int)point2D2.getX(), (int)point2D2.getY());
            Point2D point2D3 = this.calculateUserPoint(point, axis2);
            double d2 = point2D3.getY();
            this.point2DPool.replace(point2D);
            return d2;
        }
        catch (Throwable throwable) {
            this.point2DPool.replace(point2D);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double convertPrimaryToY(double d, Axis axis) {
        Point2D point2D = null;
        try {
            point2D = this.point2DPool.borrow(this.getXAxis().midPoint(), d);
            Axis axis2 = this.getYAxis();
            Point2D point2D2 = this.calculatePixelPoint2D(point2D, axis2);
            Point point = new Point((int)point2D2.getX(), (int)point2D2.getY());
            Point2D point2D3 = this.calculateUserPoint(point, axis);
            double d2 = point2D3.getY();
            this.point2DPool.replace(point2D);
            return d2;
        }
        catch (Throwable throwable) {
            this.point2DPool.replace(point2D);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateCoordinateSystems() {
        Rectangle rectangle = new Rectangle(this.getXStart(), this.getYEnd(), Math.abs(this.getXEnd() - this.getXStart()), Math.abs(this.getYStart() - this.getYEnd()));
        if (this.getBarResizePolicy() == BarResizePolicy.RESIZE_OFF) {
            Object object;
            ChartStyle chartStyle;
            int n = 0;
            Object object2 = null;
            Iterator<ChartModel> object3 = this.getModels().iterator();
            while (object3.hasNext() && ((chartStyle = this.getStyle((ChartModel)(object = object3.next()))) == null || chartStyle.isBarsVisible() && chartStyle.getBarWidth() != null)) {
                int n2 = object.getPointCount();
                if (n2 < n) continue;
                n = n2;
                object2 = object;
            }
            if (object2 != null) {
                void var4_8;
                ChartStyle chartStyle2 = this.getStyle((ChartModel)object2);
                if (chartStyle2 == null) {
                    ChartStyle chartStyle3 = new ChartStyle();
                }
                object = var4_8.getBarWidth();
                int n3 = this.getBarGap();
                if (object == null) {
                    this.updateMargins();
                    rectangle = new Rectangle(this.xStart, this.yEnd, this.xEnd - this.xStart, Math.abs(this.yStart - this.yEnd));
                } else {
                    int n4;
                    int n5;
                    Dimension dimension = this.barPainter.calculatePreferredChartAreaSize(this, var4_8.getBarOrientation(), ((Integer)object).doubleValue());
                    if (dimension == null) {
                        this.updateMargins();
                        rectangle = new Rectangle(this.xStart, this.yEnd, this.xEnd - this.xStart, Math.abs(this.yStart - this.yEnd));
                    } else if (var4_8.getBarOrientation() == Orientation.vertical) {
                        n5 = this.getXStart();
                        n4 = n5 + dimension.width;
                        rectangle = new Rectangle(n5, this.getYEnd(), n4 - n5, Math.abs(this.getYStart() - this.getYEnd()));
                    } else {
                        n5 = this.getYStart();
                        n4 = n5 - ((Integer)object + n3) * (n + 1);
                        rectangle = new Rectangle(this.xStart, n4, this.xEnd - this.xStart, Math.abs(n5 - n4));
                    }
                }
            }
        }
        this.userToPixelTransforms.clear();
        if (this.xAxis != null) {
            Range<?> range = this.xAxis.getOutputRange();
            for (Axis axis : this.yAxes) {
                double d = range.minimum();
                double d2 = range.size();
                Range<?> range2 = axis.getOutputRange();
                double d3 = range2.minimum();
                double d4 = range2.size();
                Rectangle2D.Double double_ = new Rectangle2D.Double(d, d3, d2, d4);
                this.addCoordinateSystem(double_, rectangle, axis);
            }
        }
    }

    Map<String, UserToPixelTransform> getCoordinateSystems() {
        HashMap<String, UserToPixelTransform> hashMap = new HashMap<String, UserToPixelTransform>();
        for (ChartModel chartModel : this.models) {
            UserToPixelTransform userToPixelTransform;
            Axis axis = this.getAxisForModel(chartModel);
            if (axis == null || (userToPixelTransform = this.getTransformForAxis(axis)) == null) continue;
            hashMap.put(chartModel.getName(), userToPixelTransform);
        }
        return hashMap;
    }

    void paintBars(Graphics2D graphics2D, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform) {
        int n2 = this.getXStart();
        int n3 = this.getYEnd();
        graphics2D.translate(-n2, -n3);
        this.barPainter.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, true);
        graphics2D.translate(n2, n3);
    }

    protected void paintModels(Graphics2D graphics2D, Graphics2D graphics2D2, Shape shape, Shape shape2) {
        ArrayList<Object> arrayList;
        this.pointPainter.clearShapes();
        this.barPainter.clearShapes();
        this.linePainter.clearShapes();
        ChartModel chartModel = this.createStackedBarModel(this.models);
        if (chartModel == null) {
            arrayList = new ArrayList<ChartModel>(this.models);
        } else {
            arrayList = new ArrayList();
            for (ChartModel chartModel2 : this.models) {
                if (!this.barChartFilter.isValueFiltered(chartModel2)) continue;
                arrayList.add(chartModel2);
            }
            arrayList.add(chartModel);
        }
        Collections.sort(arrayList, new ZOrderModelComparator(this));
        for (int i = 0; i < arrayList.size(); ++i) {
            ChartModel chartModel2;
            chartModel2 = (ChartModel)arrayList.get(i);
            if (this.shadowVisibility == ShadowVisibility.ALL) {
                this.paintModel(graphics2D2, chartModel2, i, shape, shape2);
                continue;
            }
            if (this.shadowVisibility == ShadowVisibility.NONE) {
                this.paintModel(graphics2D, chartModel2, i, shape, shape2);
                continue;
            }
            if (this.shadowVisibility != ShadowVisibility.SOME) continue;
            if (this.isShadowVisible(chartModel2) && this.animationPosition == 1.0) {
                this.paintModel(graphics2D2, chartModel2, i, shape, shape2);
                continue;
            }
            this.paintModel(graphics2D, chartModel2, i, shape, shape2);
        }
        if (!this.isBarsGrouped() && chartModel instanceof SummingChartModel) {
            this.setStyle(chartModel, null, false);
        }
        if (chartModel instanceof SummingChartModel) {
            ((SummingChartModel)chartModel).clear();
        }
        chartModel = null;
        arrayList.clear();
        arrayList = null;
    }

    private ChartModel createStackedBarModel(List<ChartModel> list) {
        ChartModel chartModel;
        if (this.isBarsGrouped() || list == null || list.size() == 0) {
            return null;
        }
        ArrayList<ChartModel> arrayList = new ArrayList<ChartModel>();
        for (Object object : list) {
            if (this.barChartFilter.isValueFiltered((ChartModel)object)) continue;
            arrayList.add((ChartModel)object);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1 && !(arrayList.get(0) instanceof SummingChartModel)) {
            chartModel = (ChartModel)arrayList.get(0);
        } else {
            Object object;
            chartModel = new SummingChartModel();
            ChartStyle chartStyle = this.getStyle((ChartModel)arrayList.get(0));
            object = chartStyle.getBarOrientation();
            ((SummingChartModel)chartModel).setOrientation((Orientation)((Object)object));
            ((SummingChartModel)chartModel).setDelegates(arrayList, false);
            ChartStyle chartStyle2 = new ChartStyle(chartStyle);
            chartStyle2.setBarOrientation((Orientation)((Object)object));
            this.setStyle(chartModel, chartStyle2, false);
        }
        arrayList.clear();
        return chartModel;
    }

    private void paintModel(Graphics2D graphics2D, ChartModel chartModel, int n, Shape shape, Shape shape2) {
        Axis axis = this.getAxisForModel(chartModel);
        UserToPixelTransform userToPixelTransform = this.getTransformForAxis(axis);
        graphics2D.setClip(shape2);
        this.barPainter.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, false);
        Stroke stroke = graphics2D.getStroke();
        this.linePainter.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, false);
        graphics2D.setStroke(stroke);
        this.pointPainter.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, false);
        graphics2D.setClip(shape2);
    }

    void paintPoints(Graphics2D graphics2D, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform) {
        int n2 = this.getXStart();
        int n3 = this.getYEnd();
        graphics2D.translate(-n2, -n3);
        this.pointPainter.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, true);
        graphics2D.translate(n2, n3);
    }

    public UserToPixelTransform getTransformForAxis(Axis axis) {
        int n;
        if (axis == null) {
            axis = this.getYAxis();
        }
        if ((n = this.yAxes.indexOf(axis)) < 0) {
            n = 0;
        }
        try {
            return this.userToPixelTransforms.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    protected void paintAnnotations(Graphics2D graphics2D) {
        Comparator<ChartAnnotation> comparator = new Comparator<ChartAnnotation>(){

            @Override
            public int compare(ChartAnnotation chartAnnotation, ChartAnnotation chartAnnotation2) {
                int n;
                int n2 = chartAnnotation.getZOrder();
                if (n2 == (n = chartAnnotation2.getZOrder())) {
                    return 0;
                }
                if (n2 < n) {
                    return -1;
                }
                return 1;
            }
        };
        ArrayList<ChartAnnotation> arrayList = new ArrayList<ChartAnnotation>();
        for (ChartModel object : this.models) {
            AnnotatedChartModel annotatedChartModel;
            if (!(object instanceof AnnotatedChartModel) || !(annotatedChartModel = (AnnotatedChartModel)object).isAnnotationsVisible()) continue;
            for (int i = 0; i < annotatedChartModel.getAnnotationCount(); ++i) {
                Annotation annotation = annotatedChartModel.getAnnotation(i);
                if (!(annotation instanceof ChartAnnotation)) continue;
                arrayList.add((ChartAnnotation)annotation);
            }
        }
        Collections.sort(arrayList, comparator);
        for (ChartAnnotation chartAnnotation : arrayList) {
            chartAnnotation.draw(graphics2D, this);
        }
    }

    void paintLines(Graphics2D graphics2D, ChartModel chartModel, int n, UserToPixelTransform userToPixelTransform) {
        int n2 = this.getXStart();
        int n3 = this.getYEnd();
        graphics2D.translate(-n2, -n3);
        this.linePainter.drawChart(graphics2D, this, chartModel, n, userToPixelTransform, true);
        graphics2D.translate(n2, n3);
    }

    @Override
    public double getAnimationPosition() {
        return this.animationPosition;
    }

    @Override
    public void setAnimationPosition(double d) {
        double d2 = this.animationPosition;
        this.animationPosition = d;
        this.firePropertyChange(PROPERTY_ANIMATION_POSITION, d2, d);
        this.repaint(this.getXStart(), this.getYEnd(), this.getChartWidth(), this.getChartHeight());
    }

    @Override
    public boolean isAnimateOnShow() {
        return this.animateOnShow;
    }

    @Override
    public void setAnimateOnShow(boolean bl) {
        boolean bl2 = this.animateOnShow;
        this.animateOnShow = bl;
        this.firePropertyChange(PROPERTY_ANIMATE_ON_SHOW, bl2, bl);
    }

    @Override
    public void startAnimation() {
        this.animator.start();
    }

    @Override
    public void stopAnimation() {
        this.animator.stop();
    }

    public int interpolateXForAnimation(int n, ChartModel chartModel) {
        return this.chartAnimator.interpolateXForAnimation(n, chartModel);
    }

    public int interpolateYForAnimation(int n, ChartModel chartModel) {
        return this.chartAnimator.interpolateYForAnimation(n, chartModel);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(4096)) {
            Lm.showInvalidProductMessage(Chart.class.getName(), 4096);
        }
        instance = 1;
        axisBreadthRatio = 0.05;
    }

    class PointChartFilter
    implements Filter<ChartModel> {
        PointChartFilter() {
        }

        @Override
        public boolean isValueFiltered(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle != null && !chartStyle.isPointsVisible();
        }
    }

    class AreaChartFilter
    implements Filter<ChartModel> {
        AreaChartFilter() {
        }

        @Override
        public boolean isValueFiltered(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle == null || chartStyle.getLineFill() == null;
        }
    }

    class LineChartFilter
    implements Filter<ChartModel> {
        LineChartFilter() {
        }

        @Override
        public boolean isValueFiltered(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle != null && (!chartStyle.isLinesVisible() || chartStyle.getLineFill() != null);
        }
    }

    class BarChartFilter
    implements Filter<ChartModel> {
        BarChartFilter() {
        }

        @Override
        public boolean isValueFiltered(ChartModel chartModel) {
            ChartStyle chartStyle = Chart.this.getStyle(chartModel);
            return chartStyle == null || !chartStyle.isBarsVisible();
        }
    }
}

