/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.AbstractBackgroundTask;
import com.jidesoft.chart.Chart;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.CopiedChartModel;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Immutable;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class BackgroundPlotterTask
extends AbstractBackgroundTask<Image> {
    private static final Logger logger = Logger.getLogger(BackgroundPlotterTask.class.getName());
    private ChartModel m;
    private String modelName;
    private int modelIndex;
    private Map<String, UserToPixelTransform> coordinates;
    private Chart chart;
    private int width;
    private int height;

    BackgroundPlotterTask(Chart chart, ChartModel chartModel, int n, int n2, int n3) {
        this.chart = chart;
        this.m = chartModel;
        this.modelName = chartModel.getName();
        this.modelIndex = n;
        this.width = n2;
        this.height = n3;
        this.coordinates = chart.getCoordinateSystems();
    }

    public String getModelName() {
        return this.modelName;
    }

    private static GraphicsConfiguration getConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image compute() {
        if (this.width <= 0 || this.height <= 0) {
            return null;
        }
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (this.chart.isAntiAliasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        this.chart.clearShapes();
        try {
            ChartModel chartModel = this.isModelImmutable(this.m) ? this.m : new CopiedChartModel(this.m);
            ChartStyle chartStyle = this.chart.getStyle(chartModel);
            if (chartStyle == null) {
                chartStyle = new ChartStyle();
            }
            UserToPixelTransform userToPixelTransform = this.coordinates.get(chartModel.getName());
            if (chartStyle.isBarsVisible()) {
                this.chart.paintBars(graphics2D, chartModel, this.modelIndex, userToPixelTransform);
            }
            if (this.isCancelled()) {
                BufferedImage bufferedImage2 = bufferedImage;
                return bufferedImage2;
            }
            if (chartStyle.isLinesVisible()) {
                this.chart.paintLines(graphics2D, chartModel, this.modelIndex, userToPixelTransform);
            }
            if (this.isCancelled()) {
                BufferedImage bufferedImage3 = bufferedImage;
                return bufferedImage3;
            }
            if (chartStyle.isPointsVisible()) {
                this.chart.paintPoints(graphics2D, chartModel, this.modelIndex, userToPixelTransform);
            }
            if (this.isCancelled()) {
                BufferedImage bufferedImage4 = bufferedImage;
                return bufferedImage4;
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage;
    }

    @Override
    protected void onCompletion(Image image, Throwable throwable, boolean bl) {
    }

    private boolean isModelImmutable(ChartModel chartModel) {
        Class<?> clazz = chartModel.getClass();
        Annotation[] annotationArray = clazz.getAnnotations();
        boolean bl = false;
        for (Annotation annotation : annotationArray) {
            if (!(annotation instanceof Immutable)) continue;
            bl = true;
        }
        return bl;
    }
}

