/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart;

import com.jidesoft.chart.AutoRanger;
import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisQuantity;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.RangeProvider;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.Pair;
import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Positionable;
import com.jidesoft.range.Range;
import com.jidesoft.range.TimeRange;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractAutoRanger
implements AutoRanger {
    private static final Logger logger = Logger.getLogger(AbstractAutoRanger.class.getName());
    private double leadingXMarginProportion = 0.1;
    private double trailingXMarginProportion = 0.1;
    private double leadingYMarginProportion = 0.1;
    private double trailingYMarginProportion = 0.1;
    private boolean allowYMarginToCrossZero = true;
    private boolean allowXMarginToCrossZero = true;
    private Double absoluteMinX;
    private Double absoluteMinY;
    private Double absoluteMaxX;
    private Double absoluteMaxY;
    private Double fixMinX;
    private Double fixMinY;
    private Double fixMaxX;
    private Double fixMaxY;

    protected AbstractAutoRanger() {
    }

    protected AbstractAutoRanger(Double d, Double d2, Double d3, Double d4) {
        this.fixMinX = d;
        this.fixMinY = d2;
        this.fixMaxX = d3;
        this.fixMaxY = d4;
    }

    public void setMarginProportions(double d, double d2, double d3, double d4) {
        this.setTrailingYMarginProportion(d);
        this.setLeadingXMarginProportion(d2);
        this.setLeadingYMarginProportion(d3);
        this.setTrailingXMarginProportion(d4);
    }

    public double getLeadingXMarginProportion() {
        return this.leadingXMarginProportion;
    }

    public void setLeadingXMarginProportion(double d) {
        this.leadingXMarginProportion = d;
    }

    public double getLeadingYMarginProportion() {
        return this.leadingYMarginProportion;
    }

    public void setLeadingYMarginProportion(double d) {
        this.leadingYMarginProportion = d;
    }

    public double getTrailingXMarginProportion() {
        return this.trailingXMarginProportion;
    }

    public void setTrailingXMarginProportion(double d) {
        this.trailingXMarginProportion = d;
    }

    public double getTrailingYMarginProportion() {
        return this.trailingYMarginProportion;
    }

    public boolean isAllowXMarginToCrossZero() {
        return this.allowXMarginToCrossZero;
    }

    public void setAllowXMarginToCrossZero(boolean bl) {
        this.allowXMarginToCrossZero = bl;
    }

    public void setTrailingYMarginProportion(double d) {
        this.trailingYMarginProportion = d;
    }

    public boolean isAllowYMarginToCrossZero() {
        return this.allowYMarginToCrossZero;
    }

    public Double getFixMinY() {
        return this.fixMinY;
    }

    public Double getFixMaxY() {
        return this.fixMaxY;
    }

    public Double getFixMinX() {
        return this.fixMinX;
    }

    public Double getFixMaxX() {
        return this.fixMaxX;
    }

    public Double getAbsoluteMaxX() {
        return this.absoluteMaxX;
    }

    public void setAbsoluteMaxX(Double d) {
        this.absoluteMaxX = d;
    }

    public Double getAbsoluteMaxY() {
        return this.absoluteMaxY;
    }

    public void setAbsoluteMaxY(Double d) {
        this.absoluteMaxY = d;
    }

    public Double getAbsoluteMinX() {
        return this.absoluteMinX;
    }

    public void setAbsoluteMinX(Double d) {
        this.absoluteMinX = d;
    }

    public Double getAbsoluteMinY() {
        return this.absoluteMinY;
    }

    public void setAbsoluteMinY(Double d) {
        this.absoluteMinY = d;
    }

    public void setAllowYMarginToCrossZero(boolean bl) {
        this.allowYMarginToCrossZero = bl;
    }

    public Pair<Range<?>, Range<?>> getRanges(ChartModel chartModel) {
        return this.getRanges(chartModel, false);
    }

    public Pair<Range<?>, Range<?>> getRanges(ChartModel chartModel, boolean bl) {
        NumericRange numericRange;
        NumericRange numericRange2;
        if (chartModel instanceof RangeProvider) {
            RangeProvider rangeProvider = (RangeProvider)((Object)chartModel);
            numericRange2 = rangeProvider.getXRange();
            numericRange = rangeProvider.getYRange();
        } else {
            Comparable<Positionable> comparable;
            Comparable<Positionable> comparable2;
            Comparable<Chartable> comparable3;
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            double d3 = Double.NEGATIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            int n = chartModel.getPointCount();
            for (int i = 0; i < n; ++i) {
                try {
                    double d5;
                    comparable3 = chartModel.getPoint(i);
                    if (comparable3 == null) continue;
                    comparable2 = comparable3.getX();
                    comparable = comparable3.getY();
                    if (comparable2 != null) {
                        d5 = comparable2.position();
                        if (d5 < d2) {
                            d2 = d5;
                        }
                        if (d5 > d) {
                            d = d5;
                        }
                    }
                    if (comparable == null) continue;
                    d5 = comparable.position();
                    if (d5 < d4) {
                        d4 = d5;
                    }
                    if (!(d5 > d3)) continue;
                    d3 = d5;
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    logger.fine(indexOutOfBoundsException.getMessage());
                }
            }
            if (bl) {
                Double d6 = this.getFixMinY();
                if (d6 != null) {
                    d4 = d6;
                }
                if ((comparable3 = this.getFixMaxY()) != null) {
                    d3 = (Double)comparable3;
                }
                if ((comparable2 = this.getFixMinX()) != null) {
                    d2 = (Double)comparable2;
                }
                if ((comparable = this.getFixMaxX()) != null) {
                    d = (Double)comparable;
                }
            }
            numericRange2 = n == 0 ? null : new NumericRange(d2, d);
            numericRange = n == 0 ? null : new NumericRange(d4, d3);
        }
        return new Pair(numericRange2, numericRange);
    }

    protected Pair<Range<?>, Range<?>> applyRangeConstraints(Axis axis, Axis axis2, double d, double d2, double d3, double d4) {
        Range<?> range = this.applyXRangeConstraints(axis, d, d3);
        Range<?> range2 = this.applyYRangeConstraints(axis2, d2, d4);
        return new Pair(range, range2);
    }

    protected Range<?> applyXRangeConstraints(Axis axis, double d, double d2) {
        boolean bl;
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.fixMinX != null && this.fixMinX < d) {
            d = this.fixMinX;
        }
        if (this.fixMaxX != null && this.fixMaxX > d2) {
            d2 = this.fixMaxX;
        }
        double d7 = Math.abs(d2 - d);
        if (d2 == d) {
            d6 = this.leadingXMarginProportion == 0.0 ? 0.1 : this.leadingXMarginProportion;
            double d8 = d5 = this.trailingXMarginProportion == 0.0 ? 0.1 : this.trailingXMarginProportion;
            if (Math.abs(d2) < 1.0) {
                d4 = 1.0;
                d3 = 1.0;
            } else {
                d4 = d6 * d2;
                d3 = d5 * d2;
            }
        } else {
            d4 = this.leadingXMarginProportion * d7;
            d3 = this.trailingXMarginProportion * d7;
        }
        d6 = this.fixMinX == null ? d - d4 : this.fixMinX;
        double d9 = d5 = this.fixMaxX == null ? d2 + d3 : this.fixMaxX;
        if (this.absoluteMinX != null && d6 < this.absoluteMinX) {
            d6 = this.absoluteMinX;
        }
        if (this.absoluteMaxX != null && d5 > this.absoluteMaxX) {
            d5 = this.absoluteMaxX;
        }
        if (!Double.isInfinite(d) && !Double.isInfinite(d2)) assert (d <= d2);
        boolean bl2 = d < 0.0;
        boolean bl3 = bl = d2 > 0.0;
        if (!this.allowXMarginToCrossZero && !this.isAllowXMarginToCrossZero()) {
            if (bl2 && !bl) {
                if (d5 > 0.0) {
                    d5 = 0.0;
                }
            } else if (bl && !bl2 && d6 < 0.0) {
                d6 = 0.0;
            }
        }
        AbstractRange abstractRange = axis.getQuantity() == AxisQuantity.CATEGORY ? axis.getRange() : (axis.getQuantity() == AxisQuantity.TIME ? new TimeRange((long)d6, (long)d5) : new NumericRange(d6, d5));
        return abstractRange;
    }

    protected Range<?> applyYRangeConstraints(Axis axis, double d, double d2) {
        boolean bl;
        double d3;
        double d4;
        double d5;
        double d6;
        if (this.fixMinY != null && this.fixMinY < d) {
            d = this.fixMinY;
        }
        if (this.fixMaxY != null && this.fixMaxY > d2) {
            d2 = this.fixMaxY;
        }
        double d7 = Math.abs(d2 - d);
        if (d2 == d) {
            d6 = this.leadingYMarginProportion == 0.0 ? 0.1 : this.leadingYMarginProportion;
            double d8 = d5 = this.trailingYMarginProportion == 0.0 ? 0.1 : this.trailingYMarginProportion;
            if (Math.abs(d2) < 1.0) {
                d4 = 1.0;
                d3 = 1.0;
            } else {
                d4 = d6 * d2;
                d3 = d5 * d2;
            }
        } else {
            d4 = this.leadingYMarginProportion * d7;
            d3 = this.trailingYMarginProportion * d7;
        }
        d6 = this.fixMinY == null ? d - d4 : this.fixMinY;
        double d9 = d5 = this.fixMaxY == null ? d2 + d3 : this.fixMaxY;
        if (this.absoluteMinY != null && d6 < this.absoluteMinY) {
            d6 = this.absoluteMinY;
        }
        if (this.absoluteMaxY != null && d5 > this.absoluteMaxY) {
            d5 = this.absoluteMaxY;
        }
        if (!Double.isInfinite(d) && !Double.isInfinite(d2)) assert (d <= d2);
        boolean bl2 = d < 0.0;
        boolean bl3 = bl = d2 >= 0.0;
        if (!this.isAllowYMarginToCrossZero()) {
            if (bl2 && !bl) {
                if (d5 > 0.0) {
                    d5 = 0.0;
                }
            } else if (bl && !bl2 && d6 < 0.0) {
                d6 = 0.0;
            }
        }
        AbstractRange abstractRange = axis.getQuantity() == AxisQuantity.CATEGORY ? axis.getRange() : (axis.getQuantity() == AxisQuantity.TIME ? new TimeRange((long)d6, (long)d5) : new NumericRange(d6, d5));
        return abstractRange;
    }

    protected boolean isNullOrInfinite(Range<?> range) {
        return range == null || Double.NEGATIVE_INFINITY == range.minimum() && Double.POSITIVE_INFINITY == range.maximum();
    }

    protected boolean containsZero(Range<?> range) {
        return 0.0 >= range.minimum() && 0.0 <= range.maximum();
    }

    public Pair<Range<?>, Range<?>> getStackedRanges(Chart chart) {
        if (!chart.isBarsGrouped()) {
            HashMap<Positionable, Double> hashMap = new HashMap<Positionable, Double>();
            HashMap hashMap2 = new HashMap();
            List<ChartModel> list = chart.getModels();
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = Double.NEGATIVE_INFINITY;
            for (ChartModel chartModel : list) {
                double d5;
                Positionable positionable;
                double d6;
                HashMap<Positionable, Double> hashMap3;
                Double d7;
                Positionable positionable2;
                Chartable chartable;
                int n;
                ChartStyle chartStyle = chart.getStyle(chartModel);
                if (chartStyle == null || !chartStyle.isBarsVisible()) continue;
                if (chartStyle.getBarOrientation() == Orientation.vertical) {
                    for (n = 0; n < chartModel.getPointCount(); ++n) {
                        chartable = chartModel.getPoint(n);
                        positionable2 = chartable.getX();
                        if (positionable2 != null) {
                            double d8 = positionable2.position();
                            if (d8 < d) {
                                d = d8;
                            }
                            if (d8 > d2) {
                                d2 = d8;
                            }
                        }
                        if ((d7 = (Double)(hashMap3 = (d6 = (positionable = chartable.getY()) == null ? 0.0 : positionable.position()) >= 0.0 ? hashMap : hashMap2).get(positionable2)) == null) {
                            d7 = 0.0;
                        }
                        d5 = d7 + d6;
                        hashMap3.put(positionable2, d5);
                        if (d5 < d3) {
                            d3 = d5;
                        }
                        if (!(d5 > d4)) continue;
                        d4 = d5;
                    }
                    continue;
                }
                for (n = 0; n < chartModel.getPointCount(); ++n) {
                    chartable = chartModel.getPoint(n);
                    positionable2 = chartable.getY();
                    if (positionable2 != null) {
                        double d9 = positionable2.position();
                        if (d9 < d3) {
                            d3 = d9;
                        }
                        if (d9 > d4) {
                            d4 = d9;
                        }
                    }
                    if ((d7 = (Double)(hashMap3 = (d6 = (positionable = chartable.getX()) == null ? 0.0 : positionable.position()) >= 0.0 ? hashMap : hashMap2).get(positionable2)) == null) {
                        d7 = 0.0;
                    }
                    d5 = d7 + d6;
                    hashMap3.put(positionable2, d5);
                    if (d5 < d) {
                        d = d5;
                    }
                    if (!(d5 > d2)) continue;
                    d2 = d5;
                }
            }
            boolean bl = d != Double.POSITIVE_INFINITY || d2 != Double.NEGATIVE_INFINITY;
            boolean bl2 = d3 != Double.POSITIVE_INFINITY || d4 != Double.NEGATIVE_INFINITY;
            return new Pair(bl ? new NumericRange(d, d2) : null, bl2 ? new NumericRange(d3, d4) : null);
        }
        return null;
    }
}

