/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarContext;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import com.jidesoft.action.DockableBarListList;
import com.jidesoft.action.DockableBarManager;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.FloatingDockableBars;
import com.jidesoft.action.HiddenDockableBars;
import com.jidesoft.action.PreviousState;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingConstants;

class SaveUtils
implements SwingConstants {
    private static final int DBC = 1130;
    private static final int DB = 1131;
    private static final int FLC = 1132;
    private static final int HIDE_OFFSCREEN_OFFSET = 10000;

    SaveUtils() {
    }

    static short readShort(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readShort();
    }

    static void writeShort(DataOutputStream dataOutputStream, short s) throws IOException {
        dataOutputStream.writeShort(s);
    }

    static int readInt(DataInputStream dataInputStream) throws IOException {
        return dataInputStream.readInt();
    }

    static void writeInt(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeInt(n);
    }

    static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n > 0x100000) {
            throw new IOException("The layout is corrupted. Please remove it and try again.");
        }
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        return new String(cArray);
    }

    static void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        dataOutputStream.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            dataOutputStream.writeChar(string.charAt(i));
        }
    }

    static Dimension readSize(DataInputStream dataInputStream) throws IOException {
        Dimension dimension = new Dimension(dataInputStream.readInt(), dataInputStream.readInt());
        return dimension;
    }

    static void writeSize(DataOutputStream dataOutputStream, Dimension dimension) throws IOException {
        if (dimension == null) {
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(dimension.width);
            dataOutputStream.writeInt(dimension.height);
        }
    }

    static Rectangle readRectangle(DataInputStream dataInputStream) throws IOException {
        Rectangle rectangle = new Rectangle(dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
        return rectangle;
    }

    static void writeRectangle(DataOutputStream dataOutputStream, Rectangle rectangle) throws IOException {
        if (rectangle == null) {
            dataOutputStream.writeInt(60);
            dataOutputStream.writeInt(60);
            dataOutputStream.writeInt(200);
            dataOutputStream.writeInt(200);
        } else {
            dataOutputStream.writeInt(rectangle.x);
            dataOutputStream.writeInt(rectangle.y);
            dataOutputStream.writeInt(rectangle.width);
            dataOutputStream.writeInt(rectangle.height);
        }
    }

    static short readVersion(DataInputStream dataInputStream) throws IOException {
        return SaveUtils.readShort(dataInputStream);
    }

    static void writeVersion(DataOutputStream dataOutputStream, short s) throws IOException {
        SaveUtils.writeShort(dataOutputStream, s);
    }

    static void readContext(DataInputStream dataInputStream, Map map) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = SaveUtils.readString(dataInputStream);
            DockableBarContext dockableBarContext = new DockableBarContext();
            dockableBarContext.setDockID(dataInputStream.readInt());
            dockableBarContext.setInitSide(dataInputStream.readInt());
            dockableBarContext.setInitIndex(dataInputStream.readInt());
            dockableBarContext.setInitPosition(dataInputStream.readInt() != 0);
            dockableBarContext.setInitMode(dataInputStream.readInt());
            dockableBarContext.setCurrentMode(dataInputStream.readInt());
            dockableBarContext.setCurrentDockSide(dataInputStream.readInt());
            dockableBarContext.setDockedWidth(dataInputStream.readInt());
            dockableBarContext.setDockedHeight(dataInputStream.readInt());
            Rectangle rectangle = SaveUtils.readRectangle(dataInputStream);
            if (!rectangle.isEmpty()) {
                dockableBarContext.setUndockedBounds(rectangle);
            }
            dockableBarContext.setHiddenPreviousState(SaveUtils.readPreviousState(dataInputStream));
            dockableBarContext.setClosePreviousState(SaveUtils.readPreviousState(dataInputStream));
            dockableBarContext.setDockPreviousState(SaveUtils.readPreviousState(dataInputStream));
            dockableBarContext.setFloatPreviousState(SaveUtils.readPreviousState(dataInputStream));
            Object v = map.remove(string);
            if (v instanceof DockableBarContext) {
                dockableBarContext.setInitIndex(((DockableBarContext)v).getInitIndex());
                dockableBarContext.setInitMode(((DockableBarContext)v).getInitMode());
                dockableBarContext.setInitSide(((DockableBarContext)v).getInitSide());
                dockableBarContext.setInitSubindex(((DockableBarContext)v).getInitSubindex());
            }
            map.put(string, dockableBarContext);
        }
    }

    static void writeContext(DataOutputStream dataOutputStream, Map map) throws IOException {
        dataOutputStream.writeInt(map.size());
        Set set = map.keySet();
        for (String string : set) {
            DockableBarContext dockableBarContext = (DockableBarContext)map.get(string);
            SaveUtils.writeString(dataOutputStream, string);
            dataOutputStream.writeInt(dockableBarContext.getDockID());
            dataOutputStream.writeInt(dockableBarContext.getInitSide());
            dataOutputStream.writeInt(dockableBarContext.getInitIndex());
            dataOutputStream.writeInt(dockableBarContext.isInitPosition() ? 1 : 0);
            dataOutputStream.writeInt(dockableBarContext.getInitMode());
            dataOutputStream.writeInt(dockableBarContext.getCurrentMode());
            dataOutputStream.writeInt(dockableBarContext.getCurrentDockSide());
            dataOutputStream.writeInt(dockableBarContext.getDockedWidth());
            dataOutputStream.writeInt(dockableBarContext.getDockedHeight());
            if (dockableBarContext.getUndockedBounds() != null) {
                SaveUtils.writeRectangle(dataOutputStream, dockableBarContext.getUndockedBounds());
            } else {
                SaveUtils.writeRectangle(dataOutputStream, new Rectangle(0, 0, 0, 0));
            }
            SaveUtils.writePreviousState(dataOutputStream, dockableBarContext.getHiddenPreviousState());
            SaveUtils.writePreviousState(dataOutputStream, dockableBarContext.getClosePreviousState());
            SaveUtils.writePreviousState(dataOutputStream, dockableBarContext.getDockPreviousState());
            SaveUtils.writePreviousState(dataOutputStream, dockableBarContext.getFloatPreviousState());
        }
    }

    static void writeComponent(DataOutputStream dataOutputStream, Component component) throws IOException {
        if (component instanceof DockableBarContainer) {
            SaveUtils.writeDockableBarContainer(dataOutputStream, (DockableBarContainer)component);
        } else if (component instanceof DockableBar) {
            SaveUtils.writeDockableBar(dataOutputStream, (DockableBar)component);
        } else if (component instanceof FloatingDockableBarContainer) {
            SaveUtils.writeFloatingContainer(dataOutputStream, (FloatingDockableBarContainer)component);
        } else {
            System.out.println("Error: Unknown type " + component);
        }
    }

    static Component readComponent(DockableBarManager dockableBarManager, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        switch (n) {
            case 1130: {
                return SaveUtils.readDockableBarContainer(dockableBarManager, dataInputStream);
            }
            case 1131: {
                return SaveUtils.readDockableBar(dockableBarManager, dataInputStream);
            }
            case 1132: {
                return SaveUtils.readFloatingContainer(dockableBarManager, dataInputStream);
            }
        }
        throw new IOException("Unknown type: " + n);
    }

    private static DockableBarContainer readDockableBarContainer(DockableBarManager dockableBarManager, DataInputStream dataInputStream) throws IOException {
        DockableBarContainer dockableBarContainer = dockableBarManager.createDockableBarContainer();
        dockableBarContainer.setSide(dataInputStream.readInt());
        int n = dataInputStream.readInt();
        DockableBarListList dockableBarListList = new DockableBarListList(dockableBarContainer);
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            if (n2 == 0) continue;
            DockableBarList dockableBarList = new DockableBarList(dockableBarListList);
            dockableBarListList.add(dockableBarList);
            for (int j = 0; j < n2; ++j) {
                int n3 = dataInputStream.readInt();
                DockableBar dockableBar = (DockableBar)SaveUtils.readComponent(dockableBarManager, dataInputStream);
                if (dockableBar == null) continue;
                try {
                    if (dockableBarContainer.getOrientation() == 0) {
                        dockableBar.setHoriDocked();
                    } else {
                        dockableBar.setVertDocked();
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                DockableBarItem dockableBarItem = new DockableBarItem(dockableBar, n3);
                dockableBarList.add(dockableBarItem);
            }
        }
        dockableBarContainer.setDockableBarList(dockableBarListList);
        return dockableBarContainer;
    }

    private static void writeDockableBarContainer(DataOutputStream dataOutputStream, DockableBarContainer dockableBarContainer) throws IOException {
        dataOutputStream.writeInt(1130);
        dataOutputStream.writeInt(dockableBarContainer.getSide());
        DockableBarListList dockableBarListList = dockableBarContainer.getDockableBarList();
        SaveUtils.writeInt(dataOutputStream, dockableBarListList.size());
        for (Object e : dockableBarListList) {
            DockableBarList dockableBarList = (DockableBarList)e;
            SaveUtils.writeInt(dataOutputStream, dockableBarList.size());
            for (Object e2 : dockableBarList) {
                DockableBarItem dockableBarItem = (DockableBarItem)e2;
                SaveUtils.writeInt(dataOutputStream, dockableBarItem.getStart());
                SaveUtils.writeDockableBar(dataOutputStream, (DockableBar)dockableBarItem.getComponent());
            }
        }
    }

    private static DockableBar readDockableBar(DockableBarManager dockableBarManager, DataInputStream dataInputStream) throws IOException {
        String string = SaveUtils.readString(dataInputStream);
        DockableBar dockableBar = dockableBarManager.getDockableBar(string);
        if (dockableBar != null) {
            DockableBarContext dockableBarContext = dockableBarManager.getDockableBarContextOf(string);
            if (dockableBarContext != null) {
                dockableBar.setContext(dockableBarContext);
                if (dockableBarContext.isVertDocked()) {
                    dockableBar.setOrientation(1);
                } else {
                    dockableBar.setOrientation(0);
                }
            } else {
                System.err.println("DockableBarContext shouldn't be null");
            }
            if (!dockableBar.isHidden()) {
                dockableBarManager.removeFromHiddenDockableBars(string);
            }
            dockableBar.setVisible(!dockableBar.isHidden());
            if (dockableBar instanceof CommandBar) {
                ((CommandBar)dockableBar).setPreferredRowCount(SaveUtils.readInt(dataInputStream));
            }
        } else {
            SaveUtils.readInt(dataInputStream);
        }
        return dockableBar;
    }

    private static void writeDockableBar(DataOutputStream dataOutputStream, DockableBar dockableBar) throws IOException {
        dataOutputStream.writeInt(1131);
        SaveUtils.writeString(dataOutputStream, dockableBar.getKey());
        if (dockableBar instanceof CommandBar) {
            SaveUtils.writeInt(dataOutputStream, ((CommandBar)dockableBar).getPreferredRowCount());
        }
    }

    private static FloatingDockableBarContainer createFloatingContainer(DockableBarManager dockableBarManager) {
        FloatingDockableBarContainer floatingDockableBarContainer = dockableBarManager.getRootPaneContainer() instanceof Dialog ? dockableBarManager.createFloatingDockableBarContainer((Dialog)((Object)dockableBarManager.getRootPaneContainer())) : (dockableBarManager.getRootPaneContainer() instanceof Applet ? dockableBarManager.createFloatingDockableBarContainer(JideSwingUtilities.getFrame((Applet)((Object)dockableBarManager.getRootPaneContainer()))) : dockableBarManager.createFloatingDockableBarContainer((Frame)((Object)dockableBarManager.getRootPaneContainer())));
        return floatingDockableBarContainer;
    }

    private static FloatingDockableBarContainer readFloatingContainer(DockableBarManager dockableBarManager, DataInputStream dataInputStream) throws IOException {
        FloatingDockableBarContainer floatingDockableBarContainer = SaveUtils.createFloatingContainer(dockableBarManager);
        floatingDockableBarContainer.setBounds(PortingUtils.overlapWithScreenBounds(floatingDockableBarContainer, SaveUtils.readRectangle(dataInputStream)));
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Component component = SaveUtils.readComponent(dockableBarManager, dataInputStream);
            if (component == null) continue;
            floatingDockableBarContainer.getContentPane().add(component);
            if (!(component instanceof DockableBar)) continue;
            ((DockableBar)component).setOrientation(0);
            if (((DockableBar)component).isHidden()) continue;
            try {
                ((DockableBar)component).setFloating();
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (floatingDockableBarContainer.getContentPane().getComponentCount() == 0) {
            floatingDockableBarContainer.dispose();
            return null;
        }
        return floatingDockableBarContainer;
    }

    private static void writeFloatingContainer(DataOutputStream dataOutputStream, FloatingDockableBarContainer floatingDockableBarContainer) throws IOException {
        boolean bl;
        dataOutputStream.writeInt(1132);
        Rectangle rectangle = floatingDockableBarContainer.getBounds();
        int n = rectangle.y;
        boolean bl2 = bl = n >= -5000;
        if (!bl) {
            rectangle.y += 10000;
        }
        SaveUtils.writeRectangle(dataOutputStream, rectangle);
        dataOutputStream.writeInt(floatingDockableBarContainer.getContentPane().getComponentCount());
        for (int i = 0; i < floatingDockableBarContainer.getContentPane().getComponentCount(); ++i) {
            SaveUtils.writeComponent(dataOutputStream, floatingDockableBarContainer.getContentPane().getComponent(i));
        }
    }

    static FloatingDockableBars readFloatingDockableBars(DockableBarManager dockableBarManager, DataInputStream dataInputStream) throws IOException {
        FloatingDockableBars floatingDockableBars = new FloatingDockableBars();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            Component component = SaveUtils.readComponent(dockableBarManager, dataInputStream);
            if (component == null) continue;
            floatingDockableBars.add(component);
        }
        return floatingDockableBars;
    }

    static void writeFloatingDockableBars(DataOutputStream dataOutputStream, FloatingDockableBars floatingDockableBars) throws IOException {
        int n = floatingDockableBars != null ? floatingDockableBars.size() : 0;
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            SaveUtils.writeComponent(dataOutputStream, (FloatingDockableBarContainer)floatingDockableBars.get(i));
        }
    }

    static HiddenDockableBars readHiddenDockableBars(DataInputStream dataInputStream) throws IOException {
        HiddenDockableBars<String> hiddenDockableBars = new HiddenDockableBars<String>();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = SaveUtils.readString(dataInputStream);
            hiddenDockableBars.add(string);
        }
        return hiddenDockableBars;
    }

    static void writeHiddenDockableBars(DataOutputStream dataOutputStream, HiddenDockableBars hiddenDockableBars) throws IOException {
        dataOutputStream.writeInt(hiddenDockableBars.size());
        for (int i = 0; i < hiddenDockableBars.size(); ++i) {
            String string = (String)hiddenDockableBars.get(i);
            SaveUtils.writeString(dataOutputStream, string);
        }
    }

    private static PreviousState readPreviousState(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 1) {
            int n2;
            PreviousState previousState = new PreviousState();
            previousState.mode = dataInputStream.readInt();
            previousState.dockID = dataInputStream.readInt();
            previousState.side = dataInputStream.readInt();
            previousState.rcBounds = SaveUtils.readRectangle(dataInputStream);
            previousState.start = dataInputStream.readInt();
            previousState.row = dataInputStream.readInt();
            previousState.newRow = dataInputStream.readBoolean();
            previousState.fcID = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            if (n3 != 0) {
                previousState.fcChildren = new ArrayList();
                for (n2 = 0; n2 < n3; ++n2) {
                    previousState.fcChildren.add(dataInputStream.readInt());
                }
            }
            if ((n3 = dataInputStream.readInt()) != 0) {
                previousState.parentStates = new ArrayList();
                for (n2 = 0; n2 < n3; ++n2) {
                    PreviousState.ParentState parentState = new PreviousState.ParentState();
                    parentState.ccID = dataInputStream.readInt();
                    parentState.myID = dataInputStream.readInt();
                    parentState.orientation = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    if (n4 != 0) {
                        parentState.ccChildren = new ArrayList();
                        for (int i = 0; i < n4; ++i) {
                            parentState.ccChildren.add(dataInputStream.readInt());
                        }
                    }
                    previousState.parentStates.add(parentState);
                }
            }
            return previousState;
        }
        return null;
    }

    private static void writePreviousState(DataOutputStream dataOutputStream, PreviousState previousState) throws IOException {
        if (previousState != null) {
            int n;
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(previousState.mode);
            dataOutputStream.writeInt(previousState.dockID);
            dataOutputStream.writeInt(previousState.side);
            SaveUtils.writeRectangle(dataOutputStream, previousState.rcBounds);
            dataOutputStream.writeInt(previousState.start);
            dataOutputStream.writeInt(previousState.row);
            dataOutputStream.writeBoolean(previousState.newRow);
            dataOutputStream.writeInt(previousState.fcID);
            if (previousState.fcChildren != null) {
                dataOutputStream.writeInt(previousState.fcChildren.size());
                for (n = 0; n < previousState.fcChildren.size(); ++n) {
                    dataOutputStream.writeInt((Integer)previousState.fcChildren.get(n));
                }
            } else {
                dataOutputStream.writeInt(0);
            }
            if (previousState.parentStates != null) {
                dataOutputStream.writeInt(previousState.parentStates.size());
                for (n = 0; n < previousState.parentStates.size(); ++n) {
                    PreviousState.ParentState parentState = (PreviousState.ParentState)previousState.parentStates.get(n);
                    dataOutputStream.writeInt(parentState.ccID);
                    dataOutputStream.writeInt(parentState.myID);
                    dataOutputStream.writeInt(parentState.orientation);
                    if (parentState.ccChildren != null) {
                        dataOutputStream.writeInt(parentState.ccChildren.size());
                        for (int i = 0; i < parentState.ccChildren.size(); ++i) {
                            dataOutputStream.writeInt((Integer)parentState.ccChildren.get(i));
                        }
                        continue;
                    }
                    dataOutputStream.writeInt(0);
                }
            } else {
                dataOutputStream.writeInt(0);
            }
        } else {
            dataOutputStream.writeInt(0);
        }
    }
}

