/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.FloatingDockableBarContainer;
import com.jidesoft.action.MainContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;

class PreviousState {
    int mode;
    int dockID;
    Rectangle rcBounds;
    int side;
    boolean newRow;
    int start;
    int row;
    int fcID;
    ArrayList fcChildren;
    ArrayList parentStates;

    PreviousState() {
    }

    public static PreviousState createPreviousState(DockableBar dockableBar) {
        Container container;
        PreviousState previousState = new PreviousState();
        previousState.mode = dockableBar.getContext().getCurrentMode();
        previousState.dockID = dockableBar.getDockID();
        Container container2 = dockableBar.getParent();
        if (container2 instanceof DockableBarContainer) {
            container = (DockableBarContainer)container2;
            DockableBarItem dockableBarItem = ((DockableBarContainer)container).getDockableBarList().getDockableBarItemOf(dockableBar);
            previousState.start = dockableBarItem.getStart();
            previousState.row = dockableBarItem.getRow();
            previousState.newRow = dockableBarItem.isOnlyOne();
            previousState.side = ((DockableBarContainer)container).getSide();
        }
        if ((container = PreviousState.getRootContainer(dockableBar)) != null) {
            previousState.rcBounds = container.getBounds();
        }
        return previousState;
    }

    public static void disposePreviousState(PreviousState previousState) {
        if (previousState == null) {
            return;
        }
        previousState = null;
    }

    static Container getRootContainer(Component component) {
        if (component instanceof MainContainer) {
            return (MainContainer)component;
        }
        if (component instanceof FloatingDockableBarContainer) {
            return (FloatingDockableBarContainer)component;
        }
        Container container = component.getParent();
        do {
            if (container == null) {
                return null;
            }
            if (container instanceof MainContainer) {
                return container;
            }
            if (!(container instanceof FloatingDockableBarContainer)) continue;
            return container;
        } while ((container = container.getParent()) != null);
        return null;
    }

    public String toString() {
        return "[" + super.toString() + " \n\tdockID:\t" + this.dockID + " \n\tfcChildren:\t" + this.fcChildren + " \n\tmode:\t" + this.mode + " \n\tnewRow:\t" + this.newRow + " \n\tparentStates:\t" + this.parentStates + " \n\trcBounds:\t" + this.rcBounds + " \n\trow:\t" + this.row + " \n\tside:\t" + this.side + " \n\tstart:\t" + this.start + "]";
    }

    static class ParentState {
        int ccID;
        int myID;
        int orientation;
        ArrayList ccChildren;

        ParentState() {
        }
    }
}

