/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.DockableBar;
import com.jidesoft.action.DockableBarContainer;
import com.jidesoft.action.DockableBarItem;
import com.jidesoft.action.DockableBarList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SizeRequirements;
import javax.swing.SwingConstants;

public class DockableBarContainerLayout
implements LayoutManager2,
Serializable,
SwingConstants {
    private static final long serialVersionUID = 851502149842087020L;
    public int _verticalGap = 1;
    public int _horizontalGap = 3;
    private SizeRequirements[] _srWidth;
    private SizeRequirements[] _srHeight;
    private DockableBarContainer _target;
    private int _side;
    private int[] _rowHeights;

    public DockableBarContainerLayout(Container container, int n) {
        if (!(container instanceof DockableBarContainer)) {
            throw new IllegalArgumentException("target must be DockableBarContainer.");
        }
        this._target = (DockableBarContainer)container;
        this._side = n;
    }

    public int getVerticalGap() {
        return this._verticalGap;
    }

    public void setVerticalGap(int n) {
        this._verticalGap = n;
    }

    public int getHorizontalGap() {
        return this._horizontalGap;
    }

    public void setHorizontalGap(int n) {
        this._horizontalGap = n;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateLayout(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            this._rowHeights = new int[this._target.getRowCount()];
            this._srWidth = new SizeRequirements[this._target.getRowCount()];
            this._srHeight = new SizeRequirements[this._target.getRowCount()];
            for (int i = 0; i < this._target.getRowCount(); ++i) {
                SizeRequirements sizeRequirements;
                SizeRequirements sizeRequirements2 = this.getPrimarySizeRequirements(i);
                this._srHeight[i] = sizeRequirements = this.getSecondarySizeRequirements(i);
                this._srWidth[i] = sizeRequirements2;
                this._rowHeights[i] = this._srHeight[i].preferred;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = this._target.getTreeLock();
        synchronized (object2) {
            this.internalAddComponent(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(String string, Component component) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            this.internalAddComponent(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            this.internalRemoveComponent(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._srWidth).preferred, SizeRequirements.getTiledSizeRequirements((SizeRequirements[])this._srHeight).preferred + (this._srHeight.length <= 0 ? 0 : this._verticalGap * (this._srHeight.length - 1)));
            if (this._target.isHorizontal()) {
                return dimension;
            }
            return new Dimension(dimension.height, dimension.width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._srWidth).minimum, SizeRequirements.getTiledSizeRequirements((SizeRequirements[])this._srHeight).minimum + (this._srHeight.length <= 0 ? 0 : this._verticalGap * (this._srHeight.length - 1)));
            if (this._target.isHorizontal()) {
                return dimension;
            }
            return new Dimension(dimension.height, dimension.width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container container) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(SizeRequirements.getAlignedSizeRequirements((SizeRequirements[])this._srWidth).maximum, SizeRequirements.getTiledSizeRequirements((SizeRequirements[])this._srHeight).maximum + (this._srHeight.length <= 0 ? 0 : this._verticalGap * (this._srHeight.length - 1)));
            if (this._target.isHorizontal()) {
                return dimension;
            }
            return new Dimension(dimension.height, dimension.width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            int n = 0;
            for (int i = 0; i < this._target.getRowCount(); ++i) {
                this.layoutRow(i, n);
                n += this._srHeight[i].preferred + this._verticalGap;
            }
        }
    }

    private void sort(List list) {
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                if (object instanceof DockableBarItem && object2 instanceof DockableBarItem) {
                    int n;
                    int n2 = ((DockableBarItem)object).getStart();
                    if (n2 == (n = ((DockableBarItem)object2).getStart())) {
                        return 0;
                    }
                    if (n2 > n) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
    }

    private void layoutRow(int n, int n2) {
        int n3 = this.getPrimarySize(this._target.getSize());
        if (n3 >= this._srWidth[n].preferred + this._horizontalGap * (this.internalGetRow(n).size() - 1)) {
            this.layoutRowIfFitted(n, n2, n3);
        } else if (n3 >= this._srWidth[n].minimum + this._horizontalGap * (this.internalGetRow(n).size() - 1)) {
            this.layoutRowIfNotFitted(n, n2, n3);
        }
    }

    private void layoutRowIfFitted(int n, int n2, int n3) {
        Rectangle rectangle;
        int n4;
        DockableBarItem dockableBarItem;
        List list = (List)this._target.getDockableBarList().get(n);
        int n5 = 0;
        ArrayList<DockableBarItem> arrayList = new ArrayList<DockableBarItem>();
        for (Object e : list) {
            dockableBarItem = (DockableBarItem)e;
            dockableBarItem.setDragging(false);
            arrayList.add(dockableBarItem);
        }
        this.sort(arrayList);
        Rectangle[] rectangleArray = new Rectangle[arrayList.size()];
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            dockableBarItem = (DockableBarItem)arrayList.get(n4);
            rectangle = new Rectangle();
            if (this._target.isHorizontal()) {
                rectangle.height = this._srHeight[n].preferred;
                rectangle.y = n2;
                rectangle.x = dockableBarItem.getStart() > n5 ? dockableBarItem.getStart() : n5;
                rectangle.width = dockableBarItem.getComponent() instanceof DockableBar && ((DockableBar)dockableBarItem.getComponent()).isStretch() ? (n4 == arrayList.size() - 1 ? (n4 != 0 ? this._target.getWidth() - rectangle.x : this._target.getWidth()) : dockableBarItem.getComponent().getPreferredSize().width) : dockableBarItem.getComponent().getPreferredSize().width;
                rectangleArray[n4] = rectangle;
                n5 = rectangle.x + rectangle.width;
                if (n4 == arrayList.size() - 1) continue;
                n5 += this._horizontalGap;
                continue;
            }
            rectangle.width = this._srHeight[n].preferred;
            rectangle.x = n2;
            rectangle.y = dockableBarItem.getStart() > n5 ? dockableBarItem.getStart() : n5;
            rectangle.height = dockableBarItem.getComponent() instanceof DockableBar && ((DockableBar)dockableBarItem.getComponent()).isStretch() ? (n4 == arrayList.size() - 1 ? (n4 != 0 ? this._target.getHeight() - rectangle.y : this._target.getHeight()) : dockableBarItem.getComponent().getPreferredSize().height) : dockableBarItem.getComponent().getPreferredSize().height;
            rectangleArray[n4] = rectangle;
            n5 = rectangle.y + rectangle.height;
            if (n4 == arrayList.size() - 1) continue;
            n5 += this._horizontalGap;
        }
        n4 = 0;
        if (n5 > n3) {
            n4 = n5 - n3;
        }
        for (int i = rectangleArray.length - 1; i >= 0; --i) {
            rectangle = rectangleArray[i];
            if (this._target.isHorizontal()) {
                rectangle.x -= n4;
                if (i <= 0) continue;
                if (rectangle.x >= rectangleArray[i - 1].x + rectangleArray[i - 1].width) {
                    n4 = 0;
                    continue;
                }
                n4 = rectangleArray[i - 1].x + rectangleArray[i - 1].width - rectangle.x;
                continue;
            }
            rectangle.y -= n4;
            if (i <= 0) continue;
            n4 = rectangle.y >= rectangleArray[i - 1].y + rectangleArray[i - 1].height ? 0 : rectangleArray[i - 1].y + rectangleArray[i - 1].height - rectangle.y;
        }
        if (!this._target.getComponentOrientation().isLeftToRight()) {
            for (Rectangle rectangle2 : rectangleArray) {
                rectangle2.x = this._target.getWidth() - rectangle2.x - rectangle2.width;
            }
        }
        for (int i = 0; i < rectangleArray.length; ++i) {
            DockableBarItem dockableBarItem2 = (DockableBarItem)arrayList.get(i);
            dockableBarItem2.getComponent().setBounds(rectangleArray[i]);
        }
    }

    private void internalAddRow(DockableBarList dockableBarList) {
        this._target.getDockableBarList().add(dockableBarList);
    }

    private void internalRemoveRow(int n) {
        this._target.getDockableBarList().remove(n);
    }

    private List internalGetRow(int n) {
        DockableBarList dockableBarList;
        if (n >= this._target.getDockableBarList().size() || n == -1) {
            dockableBarList = new DockableBarList(this._target.getDockableBarList());
            this.internalAddRow(dockableBarList);
        } else {
            dockableBarList = (DockableBarList)this._target.getDockableBarList().get(n);
        }
        return dockableBarList;
    }

    private void internalRemoveComponent(Component component) {
        this._target.getDockableBarList().removeComponent(component);
    }

    private void internalAddComponent(Component component) {
        this.internalAddComponent(component, -1, 0);
    }

    private void internalAddComponent(Component component, int n, int n2) {
        if (this._target.getDockableBarList().getDockableBarItemOf(component) != null) {
            return;
        }
        if (n == -1) {
            this._target.getDockableBarList().insertComponent(component, this._target.getDockableBarList().size(), n2);
        } else {
            this._target.getDockableBarList().insertComponent(component, n, n2);
        }
    }

    private int getPrimarySize(Dimension dimension) {
        if (this._side == 1 || this._side == 5) {
            return dimension.width;
        }
        return dimension.height;
    }

    private SizeRequirements getPrimarySizeRequirements(int n) {
        List list = this.internalGetRow(n);
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SizeRequirements sizeRequirements;
            DockableBarItem dockableBarItem = (DockableBarItem)list.get(i);
            sizeRequirementsArray[i] = this._target.getOrientation() == 0 ? (sizeRequirements = new SizeRequirements(dockableBarItem.getComponent().getMinimumSize().width, dockableBarItem.getComponent().getPreferredSize().width, dockableBarItem.getComponent().getMaximumSize().width, 0.5f)) : (sizeRequirements = new SizeRequirements(dockableBarItem.getComponent().getMinimumSize().height, dockableBarItem.getComponent().getPreferredSize().height, dockableBarItem.getComponent().getMaximumSize().height, 0.5f));
        }
        return SizeRequirements.getTiledSizeRequirements(sizeRequirementsArray);
    }

    private SizeRequirements getSecondarySizeRequirements(int n) {
        List list = this.internalGetRow(n);
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            SizeRequirements sizeRequirements;
            DockableBarItem dockableBarItem = (DockableBarItem)list.get(i);
            sizeRequirementsArray[i] = this._target.getOrientation() == 0 ? (sizeRequirements = new SizeRequirements(dockableBarItem.getComponent().getMinimumSize().height, dockableBarItem.getComponent().getPreferredSize().height, dockableBarItem.getComponent().getMaximumSize().height, 0.5f)) : (sizeRequirements = new SizeRequirements(dockableBarItem.getComponent().getMinimumSize().width, dockableBarItem.getComponent().getPreferredSize().width, dockableBarItem.getComponent().getMaximumSize().width, 0.5f));
        }
        return SizeRequirements.getAlignedSizeRequirements(sizeRequirementsArray);
    }

    public int getRowHeightAt(int n) {
        if (this._rowHeights == null) {
            return -1;
        }
        if (n >= 0 && n < this._rowHeights.length) {
            return this._rowHeights[n];
        }
        return -1;
    }

    int getActiveIndex(List list) {
        for (int i = 0; i < list.size(); ++i) {
            DockableBarItem dockableBarItem = (DockableBarItem)list.get(i);
            if (!dockableBarItem.isDragging()) continue;
            return i;
        }
        return -1;
    }

    boolean isResizing(List list) {
        for (int i = 0; i < list.size(); ++i) {
            DockableBarItem dockableBarItem = (DockableBarItem)list.get(i);
            if (!dockableBarItem.isDragging()) continue;
            return dockableBarItem.isResizing();
        }
        return false;
    }

    private void layoutRowIfNotFitted(int n, int n2, int n3) {
        int n4;
        Object object;
        DockableBarItem dockableBarItem;
        n3 -= this._horizontalGap * (this.internalGetRow(n).size() - 1);
        List list = (List)this._target.getDockableBarList().get(n);
        ArrayList<DockableBarItem> arrayList = new ArrayList<DockableBarItem>();
        for (Object e : list) {
            dockableBarItem = (DockableBarItem)e;
            arrayList.add(dockableBarItem);
        }
        this.sort(arrayList);
        int n5 = -1;
        boolean bl = false;
        dockableBarItem = null;
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            DockableBarItem dockableBarItem2 = (DockableBarItem)arrayList.get(i);
            sizeRequirementsArray[i] = this._target.getOrientation() == 0 ? (object = new SizeRequirements(dockableBarItem2.getComponent().getMinimumSize().width, dockableBarItem2.getComponent().getPreferredSize().width, dockableBarItem2.getComponent().getMaximumSize().width, 0.5f)) : (object = new SizeRequirements(dockableBarItem2.getComponent().getMinimumSize().height, dockableBarItem2.getComponent().getPreferredSize().height, dockableBarItem2.getComponent().getMaximumSize().height, 0.5f));
            if (!dockableBarItem2.isDragging()) continue;
            n5 = i;
            dockableBarItem = dockableBarItem2;
            if (!dockableBarItem.isResizing()) continue;
            bl = true;
        }
        Rectangle[] rectangleArray = new Rectangle[arrayList.size()];
        for (n4 = 0; n4 < rectangleArray.length; ++n4) {
            rectangleArray[n4] = new Rectangle();
            if (!bl) continue;
            object = (DockableBarItem)arrayList.get(n4);
            if (this._target.getOrientation() == 0) {
                rectangleArray[n4].x = ((DockableBarItem)object).getComponent().getX() - this._horizontalGap * n4;
                rectangleArray[n4].width = ((DockableBarItem)object).getComponent().getWidth();
                continue;
            }
            rectangleArray[n4].y = ((DockableBarItem)object).getComponent().getY() - this._horizontalGap * n4;
            rectangleArray[n4].height = ((DockableBarItem)object).getComponent().getHeight();
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            object = (DockableBarItem)arrayList.get(n4);
            ((DockableBarItem)object).setDragging(false);
        }
        if (this._target.getOrientation() == 0) {
            int n6;
            int n7;
            int n8;
            if (bl) {
                int n9;
                n4 = dockableBarItem.getStart() - n5 * this._horizontalGap;
                n8 = n5 < 0 ? 0 : this.getMinimumSize(0, n5, sizeRequirementsArray);
                int n10 = n9 = n5 < 0 ? n3 : this.getPreferredSize(0, n5, sizeRequirementsArray);
                if (n4 < n8) {
                    n4 = n8;
                } else if (n4 > n9) {
                    n4 = n9;
                }
                n7 = n5 >= arrayList.size() - 1 ? 0 : this.getMinimumSize(n5 + 1, arrayList.size(), sizeRequirementsArray);
                int n11 = n6 = n5 >= arrayList.size() - 1 ? n3 : this.getPreferredSize(n5 + 1, arrayList.size(), sizeRequirementsArray);
                if (n4 + sizeRequirementsArray[n5].preferred < n3 - n6) {
                    n4 = n3 - n6 - sizeRequirementsArray[n5].preferred;
                    rectangleArray[n5].width = sizeRequirementsArray[n5].preferred;
                } else if (n4 + sizeRequirementsArray[n5].minimum > n3 - n7) {
                    n4 = n3 - n7 - sizeRequirementsArray[n5].minimum;
                    rectangleArray[n5].width = sizeRequirementsArray[n5].minimum;
                } else if (n7 == 0 && n4 + sizeRequirementsArray[n5].preferred < n3) {
                    n4 = n3 - n7 - sizeRequirementsArray[n5].preferred;
                    rectangleArray[n5].width = sizeRequirementsArray[n5].preferred;
                }
                rectangleArray[n5].x = n4;
                if (n5 < arrayList.size() - 1) {
                    rectangleArray[n5].width = rectangleArray[n5 + 1].x - rectangleArray[n5].x;
                    if (rectangleArray[n5].width > sizeRequirementsArray[n5].preferred) {
                        rectangleArray[n5].width = sizeRequirementsArray[n5].preferred;
                    }
                    if (rectangleArray[n5].width < sizeRequirementsArray[n5].minimum) {
                        rectangleArray[n5].width = sizeRequirementsArray[n5].minimum;
                    }
                    rectangleArray[n5 + 1].x = rectangleArray[n5].x + rectangleArray[n5].width;
                    this.shrink(rectangleArray, n5 + 1, arrayList.size(), sizeRequirementsArray, n3 - rectangleArray[n5 + 1].x, true);
                } else {
                    rectangleArray[n5].width = n3 - rectangleArray[n5].x;
                }
                this.shrink(rectangleArray, 0, n5, sizeRequirementsArray, rectangleArray[n5].x, false);
            } else {
                int[] nArray;
                n4 = this.getMinimumSize(0, arrayList.size(), sizeRequirementsArray);
                for (n8 = 0; n8 < arrayList.size(); ++n8) {
                    rectangleArray[n8].width = sizeRequirementsArray[n8].minimum;
                }
                n8 = n3 - n4;
                if (n8 > 0 && n5 >= 0) {
                    int n12 = Math.max(0, Math.min(n8, sizeRequirementsArray[n5].preferred - sizeRequirementsArray[n5].minimum));
                    rectangleArray[n5].width += n12;
                    n8 -= n12;
                }
                if (this._target.getShrinkOrderProvider() == null) {
                    nArray = new int[arrayList.size()];
                    for (n7 = 0; n7 < arrayList.size(); ++n7) {
                        nArray[n7] = arrayList.size() - n7 - 1;
                    }
                } else {
                    nArray = this._target.getShrinkOrderProvider().getShrinkOrder(n);
                }
                for (n7 = arrayList.size() - 1; n8 > 0 && n7 >= 0; --n7) {
                    if (n7 == n5) continue;
                    n6 = arrayList.indexOf(((DockableBarList)this._target.getDockableBarList().get(n)).get(nArray[n7]));
                    int n13 = Math.max(0, Math.min(n8, sizeRequirementsArray[n6].preferred - sizeRequirementsArray[n6].minimum));
                    rectangleArray[n6].width += n13;
                    n8 -= n13;
                }
                for (n7 = 1; n7 < arrayList.size(); ++n7) {
                    rectangleArray[n7].x = rectangleArray[n7 - 1].x + rectangleArray[n7 - 1].width;
                }
            }
            for (n4 = 0; n4 < rectangleArray.length; ++n4) {
                Rectangle rectangle = rectangleArray[n4];
                rectangle.y = n2;
                rectangle.height = this._srHeight[n].preferred;
                DockableBarItem dockableBarItem3 = (DockableBarItem)arrayList.get(n4);
                rectangle.x += this._horizontalGap * n4;
                dockableBarItem3.getComponent().setBounds(rectangle);
            }
        } else {
            int n14;
            int n15;
            int n16;
            if (bl) {
                int n17;
                n4 = dockableBarItem.getStart() - n5 * this._horizontalGap;
                n16 = n5 < 0 ? 0 : this.getMinimumSize(0, n5, sizeRequirementsArray);
                int n18 = n17 = n5 < 0 ? n3 : this.getPreferredSize(0, n5, sizeRequirementsArray);
                if (n4 < n16) {
                    n4 = n16;
                } else if (n4 > n17) {
                    n4 = n17;
                }
                n15 = n5 >= arrayList.size() - 1 ? 0 : this.getMinimumSize(n5 + 1, arrayList.size(), sizeRequirementsArray);
                int n19 = n14 = n5 >= arrayList.size() - 1 ? n3 : this.getPreferredSize(n5 + 1, arrayList.size(), sizeRequirementsArray);
                if (n4 + sizeRequirementsArray[n5].preferred < n3 - n14) {
                    n4 = n3 - n14 - sizeRequirementsArray[n5].preferred;
                    rectangleArray[n5].height = sizeRequirementsArray[n5].preferred;
                } else if (n4 + sizeRequirementsArray[n5].minimum > n3 - n15) {
                    n4 = n3 - n15 - sizeRequirementsArray[n5].minimum;
                    rectangleArray[n5].height = sizeRequirementsArray[n5].minimum;
                } else if (n15 == 0 && n4 + sizeRequirementsArray[n5].preferred < n3) {
                    n4 = n3 - n15 - sizeRequirementsArray[n5].preferred;
                    rectangleArray[n5].height = sizeRequirementsArray[n5].preferred;
                }
                rectangleArray[n5].y = n4;
                if (n5 < arrayList.size() - 1) {
                    rectangleArray[n5].height = rectangleArray[n5 + 1].y - rectangleArray[n5].y;
                    if (rectangleArray[n5].height > sizeRequirementsArray[n5].preferred) {
                        rectangleArray[n5].height = sizeRequirementsArray[n5].preferred;
                    }
                    if (rectangleArray[n5].height < sizeRequirementsArray[n5].minimum) {
                        rectangleArray[n5].height = sizeRequirementsArray[n5].minimum;
                    }
                    rectangleArray[n5 + 1].y = rectangleArray[n5].y + rectangleArray[n5].height;
                    this.shrink(rectangleArray, n5 + 1, arrayList.size(), sizeRequirementsArray, n3 - rectangleArray[n5 + 1].y, true);
                } else {
                    rectangleArray[n5].height = n3 - rectangleArray[n5].y;
                }
                this.shrink(rectangleArray, 0, n5, sizeRequirementsArray, rectangleArray[n5].y, false);
            } else {
                int[] nArray;
                n4 = this.getMinimumSize(0, arrayList.size(), sizeRequirementsArray);
                for (n16 = 0; n16 < arrayList.size(); ++n16) {
                    rectangleArray[n16].height = sizeRequirementsArray[n16].minimum;
                }
                n16 = n3 - n4;
                if (n16 > 0 && n5 >= 0) {
                    int n20 = Math.max(0, Math.min(n16, sizeRequirementsArray[n5].preferred - sizeRequirementsArray[n5].minimum));
                    rectangleArray[n5].height += n20;
                    n16 -= n20;
                }
                if (this._target.getShrinkOrderProvider() == null) {
                    nArray = new int[arrayList.size()];
                    for (n15 = 0; n15 < arrayList.size(); ++n15) {
                        nArray[n15] = arrayList.size() - n15 - 1;
                    }
                } else {
                    nArray = this._target.getShrinkOrderProvider().getShrinkOrder(n);
                }
                for (n15 = arrayList.size() - 1; n16 > 0 && n15 >= 0; --n15) {
                    if (n15 == n5) continue;
                    n14 = arrayList.indexOf(((DockableBarList)this._target.getDockableBarList().get(n)).get(nArray[n15]));
                    int n21 = Math.max(0, Math.min(n16, sizeRequirementsArray[n14].preferred - sizeRequirementsArray[n14].minimum));
                    rectangleArray[n14].height += n21;
                    n16 -= n21;
                }
                for (n15 = 1; n15 < arrayList.size(); ++n15) {
                    rectangleArray[n15].y = rectangleArray[n15 - 1].y + rectangleArray[n15 - 1].height;
                }
            }
            for (n4 = 0; n4 < rectangleArray.length; ++n4) {
                Rectangle rectangle = rectangleArray[n4];
                rectangle.x = n2;
                rectangle.width = this._srHeight[n].preferred;
                DockableBarItem dockableBarItem4 = (DockableBarItem)arrayList.get(n4);
                rectangle.y += this._horizontalGap * n4;
                dockableBarItem4.getComponent().setBounds(rectangle);
            }
        }
    }

    private void shrink(Rectangle[] rectangleArray, int n, int n2, SizeRequirements[] sizeRequirementsArray, int n3, boolean bl) {
        int n4 = this.getPreferredSize(n, n2, sizeRequirementsArray);
        int n5 = n4 - n3;
        if (n5 < 0) {
            n5 = 0;
        }
        if (this._target.getOrientation() == 0) {
            if (bl) {
                for (int i = n; i < n2; ++i) {
                    if (i != n) {
                        rectangleArray[i].x = rectangleArray[i - 1].x + rectangleArray[i - 1].width;
                    }
                    if (n5 > 0) {
                        if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum >= n5) {
                            rectangleArray[i].width = sizeRequirementsArray[i].preferred - n5;
                            n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].width;
                            continue;
                        }
                        if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum < n5) {
                            rectangleArray[i].width = sizeRequirementsArray[i].minimum;
                            n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].width;
                            continue;
                        }
                        rectangleArray[i].width = sizeRequirementsArray[i].minimum;
                        n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].width;
                        continue;
                    }
                    rectangleArray[i].width = sizeRequirementsArray[i].preferred;
                }
            } else {
                for (int i = n2 - 1; i >= n; --i) {
                    if (n5 > 0) {
                        if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum >= n5) {
                            rectangleArray[i].width = sizeRequirementsArray[i].preferred - n5;
                            n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].width;
                        } else if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum < n5) {
                            rectangleArray[i].width = sizeRequirementsArray[i].minimum;
                            n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].width;
                        } else {
                            rectangleArray[i].width = sizeRequirementsArray[i].minimum;
                            n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].width;
                        }
                    } else {
                        rectangleArray[i].width = sizeRequirementsArray[i].preferred;
                    }
                    if (i == rectangleArray.length - 1) continue;
                    rectangleArray[i].x = rectangleArray[i + 1].x - rectangleArray[i].width;
                }
            }
        } else if (bl) {
            for (int i = n; i < n2; ++i) {
                if (i != n) {
                    rectangleArray[i].y = rectangleArray[i - 1].y + rectangleArray[i - 1].height;
                }
                if (n5 > 0) {
                    if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum >= n5) {
                        rectangleArray[i].height = sizeRequirementsArray[i].preferred - n5;
                        n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].height;
                        continue;
                    }
                    if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum < n5) {
                        rectangleArray[i].height = sizeRequirementsArray[i].minimum;
                        n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].height;
                        continue;
                    }
                    rectangleArray[i].height = sizeRequirementsArray[i].minimum;
                    n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].height;
                    continue;
                }
                rectangleArray[i].height = sizeRequirementsArray[i].preferred;
            }
        } else {
            for (int i = n2 - 1; i >= n; --i) {
                if (n5 > 0) {
                    if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum >= n5) {
                        rectangleArray[i].height = sizeRequirementsArray[i].preferred - n5;
                        n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].height;
                    } else if (sizeRequirementsArray[i].preferred - sizeRequirementsArray[i].minimum < n5) {
                        rectangleArray[i].height = sizeRequirementsArray[i].minimum;
                        n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].height;
                    } else {
                        rectangleArray[i].height = sizeRequirementsArray[i].minimum;
                        n5 -= sizeRequirementsArray[i].preferred - rectangleArray[i].height;
                    }
                } else {
                    rectangleArray[i].height = sizeRequirementsArray[i].preferred;
                }
                if (i == rectangleArray.length - 1) continue;
                rectangleArray[i].y = rectangleArray[i + 1].y - rectangleArray[i].height;
            }
        }
    }

    private int getMinimumSize(int n, int n2, SizeRequirements[] sizeRequirementsArray) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            SizeRequirements sizeRequirements = sizeRequirementsArray[i];
            n3 += sizeRequirements.minimum;
        }
        return n3;
    }

    private int getPreferredSize(int n, int n2, SizeRequirements[] sizeRequirementsArray) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            SizeRequirements sizeRequirements = sizeRequirementsArray[i];
            n3 += sizeRequirements.preferred;
        }
        return n3;
    }
}

