/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.CommandBarPaneLayout;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.TopLevelMenuContainer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingConstants;

class CommandBarPane
extends JPanel
implements Alignable,
SwingConstants,
MenuElement,
TopLevelMenuContainer {
    protected int _orientation = 0;
    private int _preferredRowCount;
    private boolean _usePreferredRowCount;
    private ArrayList _hiddenComponents = new ArrayList();
    private CommandBarPaneLayout _layout;

    public CommandBarPane() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this._layout = new CommandBarPaneLayout(this);
        this.setLayout(this._layout);
    }

    @Override
    public boolean supportVerticalOrientation() {
        return true;
    }

    @Override
    public boolean supportHorizontalOrientation() {
        return true;
    }

    @Override
    public void setOrientation(int n) {
        this.checkOrientation(n);
        int n2 = this._orientation;
        if (this._orientation != n) {
            this._orientation = n;
            JideSwingUtilities.setChildrenOrientationOf(this, n);
            this.firePropertyChange("orientation", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    protected void checkOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public int getPreferredRowCount() {
        return this._preferredRowCount;
    }

    public void setPreferredRowCount(int n) {
        this._preferredRowCount = n;
    }

    public boolean isUsePreferredRowCount() {
        return this._usePreferredRowCount;
    }

    public void setUsePreferredRowCount(boolean bl) {
        this._usePreferredRowCount = bl;
    }

    public Component[] getHiddenComponents() {
        return this._hiddenComponents.toArray(new Component[this._hiddenComponents.size()]);
    }

    public void addHiddenComponent(Component component) {
        if (!this._hiddenComponents.contains(component)) {
            this._hiddenComponents.add(component);
        }
        if (component.getParent() == this) {
            this.remove(component);
        }
    }

    public void removeHiddenComponent(Component component) {
        if (this._hiddenComponents.contains(component)) {
            this._hiddenComponents.remove(component);
        }
        if (component.getParent() != this) {
            this.add(component);
        }
    }

    public void removeAllHiddenComponents() {
        this._hiddenComponents.clear();
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent, MenuElement[] menuElementArray, MenuSelectionManager menuSelectionManager) {
    }

    @Override
    public void menuSelectionChanged(boolean bl) {
    }

    @Override
    public MenuElement[] getSubElements() {
        int n;
        Vector<Component> vector = new Vector<Component>();
        int n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            Component component = this.getComponent(n);
            if (!(component instanceof MenuElement)) continue;
            vector.addElement(component);
        }
        MenuElement[] menuElementArray = new MenuElement[vector.size()];
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            menuElementArray[n] = (MenuElement)vector.elementAt(n);
        }
        return menuElementArray;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public Rectangle getActualSize(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return this._layout.getActualSize(this, n, n2, n3, n4, n5, bl, bl2);
    }

    @Override
    public boolean isMenuBar() {
        return false;
    }
}

