/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.action;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.Gripper;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SizeRequirements;
import javax.swing.SwingConstants;

class CommandBarLayout
implements LayoutManager2,
Serializable,
SwingConstants {
    private HashMap<Component, Integer> _hiddenOrder = new HashMap();
    private Gripper _gripper;
    private CommandBarTitleBar _titleBar;
    private Chevron _chevron;
    private Dimension _savePreferredDimension;
    private int[] _splits;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private boolean _reset = true;
    private boolean _respectMinimumSizeWhenNecessary = true;
    private static final long serialVersionUID = 3568625581768530323L;
    private int _axis;
    private Container _target;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;
    private List<Result> _result = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getActualSize(Container container, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        Object object = container.getTreeLock();
        synchronized (object) {
            DockableBar dockableBar = (DockableBar)container;
            if (dockableBar.isFloating()) {
                n4 -= this._titleBar != null ? this._titleBar.getPreferredSize().height : 0;
            } else {
                n3 -= (this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0) + (this._chevron != null ? this._chevron.getPreferredSize().width : 0);
            }
            Insets insets = container.getInsets();
            n3 = (int)Math.min((long)n3 - (long)insets.left - (long)insets.right, Integer.MAX_VALUE);
            n4 = (int)Math.min((long)n4 - (long)insets.top - (long)insets.bottom, Integer.MAX_VALUE);
            this.checkRequests();
            if (n5 == 0) {
                int n6 = this.retrieveByWidth(n3, bl2);
                Result result = this._result.get(n6);
                n3 = result.width;
                n4 = result.height;
                this._splits = result.splits;
                if (dockableBar instanceof CommandBar) {
                    ((CommandBar)dockableBar).setPreferredRowCount(this._splits.length + 1);
                }
            } else {
                int n7 = this.retrieveByHeight(n4, bl2);
                Result result = this._result.get(n7);
                n3 = result.width;
                n4 = result.height;
                this._splits = result.splits;
                if (dockableBar instanceof CommandBar) {
                    ((CommandBar)dockableBar).setPreferredRowCount(this._splits.length + 1);
                }
            }
            if (dockableBar.isFloating()) {
                n4 += this._titleBar != null ? this._titleBar.getPreferredSize().height + 2 : 0;
            } else {
                n3 += (this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0) + (this._chevron != null ? this._chevron.getPreferredSize().width : 0);
            }
            n3 = (int)Math.min((long)n3 + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            n4 = (int)Math.min((long)n4 + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
            return new Rectangle(n, n2, n3, n4);
        }
    }

    private boolean shouldShowGripper(DockableBar dockableBar) {
        return dockableBar.getDockableBarManager() != null && dockableBar.getDockableBarManager().isRearrangable() && dockableBar.isRearrangable();
    }

    private int getMinWidth(SizeRequirements[] sizeRequirementsArray) {
        int n = 0;
        for (SizeRequirements sizeRequirements : sizeRequirementsArray) {
            if (n >= sizeRequirements.preferred) continue;
            n = sizeRequirements.preferred;
        }
        return n;
    }

    public CommandBarLayout(Container container, int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n;
        this._target = container;
    }

    @Override
    public synchronized void invalidateLayout(Container container) {
        this._savePreferredDimension = null;
        this._splits = null;
        this.reset();
    }

    protected synchronized void reset() {
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
        this._savePreferredDimension = null;
        this._result = null;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component component) {
        Object object = this._target.getTreeLock();
        synchronized (object) {
            this._hiddenOrder.remove(component);
            if (this._reset) {
                this._result = null;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = this._target.getTreeLock();
        synchronized (object2) {
            if (object instanceof Integer) {
                this._hiddenOrder.put(component, (Integer)object);
            } else {
                this._hiddenOrder.put(component, 0);
            }
            if (this._reset) {
                this._result = null;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (this._savePreferredDimension != null) {
                return this._savePreferredDimension;
            }
            Dimension dimension = new Dimension(0, 0);
            Serializable serializable = this;
            synchronized (serializable) {
                this.checkContainer(container);
                this.checkRequests();
                if (this._target instanceof DockableBar) {
                    DockableBar dockableBar = (DockableBar)this._target;
                    if (dockableBar.isFloating()) {
                        if (dockableBar instanceof CommandBar) {
                            int n = ((CommandBar)dockableBar).getPreferredRowCount();
                            dimension = this.getPreferredSizeByRowCount(n);
                        } else {
                            dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
                        }
                        if (this._titleBar != null) {
                            dimension.height += this._titleBar.getPreferredSize().height + 2;
                        }
                    } else {
                        dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
                        if (dockableBar.getOrientation() == 0) {
                            dimension.width = dimension.width + ((this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0) + (dockableBar.isStretch() ? 0 : (this._chevron != null ? this._chevron.getPreferredSize().width : 0)));
                        } else {
                            dimension.height = dimension.height + ((this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().height : 0) + (dockableBar.isStretch() ? 0 : (this._chevron != null ? this._chevron.getPreferredSize().height : 0)));
                        }
                    }
                }
            }
            serializable = container.getInsets();
            dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)serializable).left + (long)((Insets)serializable).right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)serializable).top + (long)((Insets)serializable).bottom, Integer.MAX_VALUE);
            this._savePreferredDimension = dimension;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkRequests();
            this.checkContainer(container);
            List<Component> list = this.sortComponentByOrder();
            this.checkRequests();
            if (this._target instanceof DockableBar) {
                DockableBar dockableBar = (DockableBar)this._target;
                dimension = dockableBar.getOrientation() == 0 ? new Dimension((this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getMinimumSize().width : 0) + (this._chevron != null ? this._chevron.getMinimumSize().width : 0) + (list.size() != 0 ? list.get((int)0).getMinimumSize().width : 0), this.yTotal.minimum) : new Dimension(this.xTotal.minimum, (this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getMinimumSize().height : 0) + (this._chevron != null ? this._chevron.getMinimumSize().height : 0) + (list.size() != 0 ? list.get((int)0).getMinimumSize().height : 0));
            }
        }
        object = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)object).left + (long)((Insets)object).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)object).top + (long)((Insets)object).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container container) {
        Dimension dimension;
        Object object = container.getTreeLock();
        synchronized (object) {
            this.checkContainer(container);
            this.checkRequests();
            dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        }
        object = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)((Insets)object).left + (long)((Insets)object).right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)((Insets)object).top + (long)((Insets)object).bottom, Integer.MAX_VALUE);
        return dimension;
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            if (!container.isVisible()) {
                return;
            }
            Dimension dimension = this._target.getSize();
            if (dimension.width == 0 || dimension.height == 0) {
                return;
            }
            this.checkContainer(container);
            DockableBar dockableBar = (DockableBar)container;
            Insets insets = this._target.getInsets();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            boolean bl = dockableBar.getOrientation() == 1 || this._target.getComponentOrientation().isLeftToRight();
            int n = dimension.width;
            int n2 = dimension.height;
            int n3 = insets.top;
            int n4 = bl ? insets.left : n;
            dockableBar.setDuringLayout(true);
            List<Component> list = this.getComponents();
            List<Component> list2 = this.getUnsupportedComponents();
            for (Serializable serializable : list2) {
                serializable.setBounds(0, 0, 0, 0);
            }
            int n5 = list.size();
            if (dockableBar.isFloating()) {
                Result result;
                int n6;
                if (this._gripper != null) {
                    this._gripper.setVisible(false);
                    this._gripper.setEnabled(this._gripper.isVisible());
                }
                if (this._chevron != null) {
                    this._chevron.setVisible(false);
                    this._chevron.setEnabled(false);
                }
                if (this._titleBar != null) {
                    Serializable serializable;
                    this._titleBar.setVisible(true);
                    this._titleBar.setEnabled(true);
                    this._titleBar.setBounds(insets.left, n3, dimension.width, this._titleBar.getPreferredSize().height);
                    serializable = this._titleBar.getPreferredSize();
                    n3 += ((Dimension)serializable).height + 1;
                    n2 -= ((Dimension)serializable).height;
                }
                --n2;
                int n7 = n4;
                int n8 = 0;
                this.checkRequests();
                if (this._target instanceof CommandBar && (n6 = ((CommandBar)this._target).getPreferredRowCount() - 1) >= 0 && n6 < this._result.size() && (result = this._result.get(n6)) != null) {
                    this._splits = result.splits;
                }
                n6 = this.yTotal.preferred;
                this._reset = false;
                for (int i = 0; i < n5; ++i) {
                    Component component;
                    if (this._splits != null && n8 <= this._splits.length - 1 && i == this._splits[n8]) {
                        n3 += this.yTotal.preferred;
                        n4 = n7;
                        ++n8;
                    }
                    if ((component = list.get(i)).getParent() != this._target && this._target instanceof CommandBar) {
                        ((CommandBar)this._target).removeHiddenComponent(component);
                    }
                    if (!component.isVisible()) continue;
                    Dimension dimension2 = this.getPreferredSize(component);
                    component.setBounds(bl ? n4 : n4 - dimension2.width, n3, dimension2.width, n6);
                    if (bl) {
                        n4 += dimension2.width;
                        continue;
                    }
                    n4 -= dimension2.width;
                }
                this._reset = true;
            } else {
                Serializable serializable;
                Dimension dimension3;
                Serializable serializable2;
                int n9;
                int n10;
                if (this._gripper != null) {
                    this._gripper.setVisible(this.shouldShowGripper(dockableBar));
                    this._gripper.setEnabled(this._gripper.isVisible());
                }
                if (this._chevron != null) {
                    this._chevron.setVisible(!dockableBar.isStretch());
                    this._chevron.setEnabled(!dockableBar.isStretch());
                }
                if (this._titleBar != null) {
                    this._titleBar.setVisible(false);
                    this._titleBar.setEnabled(false);
                }
                int n11 = n5;
                int n12 = n;
                int n13 = n2;
                Dimension[] dimensionArray = new Dimension[n5];
                if (dockableBar.getOrientation() == 0) {
                    n12 -= this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().width : 0;
                    n12 -= this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().width : 0;
                    n10 = 0;
                    for (n9 = 0; n9 < n5; ++n9) {
                        serializable2 = list.get(n9);
                        dimension3 = this.getPreferredSize((Component)serializable2);
                        n10 += dimension3.width;
                        dimensionArray[n9] = dimension3;
                    }
                    if (this.isRespectMinimumSizeWhenNecessary() && n10 > n12) {
                        for (n9 = n5 - 1; n9 >= 0; --n9) {
                            serializable2 = list.get(n9);
                            dimension3 = this.getPreferredSize((Component)serializable2);
                            serializable = this.getMinimumSize((Component)serializable2);
                            if (dimension3.width > serializable.width) {
                                n10 -= dimension3.width - serializable.width;
                                dimensionArray[n9] = serializable;
                            }
                            if (n10 > n12) continue;
                            dimensionArray[n9].width += n12 - n10;
                            break;
                        }
                    }
                    n12 += this._chevron != null && this._chevron.isVisible() ? this.getPreferredSize((Component)this._chevron).width : 0;
                } else {
                    n13 -= this.shouldShowGripper(dockableBar) && this._gripper != null ? this._gripper.getPreferredSize().height : 0;
                    n13 -= this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().height : 0;
                    n10 = 0;
                    for (n9 = 0; n9 < n5; ++n9) {
                        serializable2 = list.get(n9);
                        dimension3 = this.getPreferredSize((Component)serializable2);
                        n10 += dimension3.height;
                        dimensionArray[n9] = dimension3;
                    }
                    if (this.isRespectMinimumSizeWhenNecessary() && n10 > n13) {
                        for (n9 = n5 - 1; n9 >= 0; --n9) {
                            serializable2 = list.get(n9);
                            dimension3 = this.getPreferredSize((Component)serializable2);
                            serializable = this.getMinimumSize((Component)serializable2);
                            if (dimension3.height > serializable.height) {
                                n10 -= dimension3.height - serializable.height;
                                dimensionArray[n9] = serializable;
                            }
                            if (n10 > n13) continue;
                            dimensionArray[n9].height += n13 - n10;
                            break;
                        }
                    }
                    n13 += this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().height : 0;
                }
                if (dockableBar.getOrientation() == 0) {
                    n10 = this._chevron != null ? this._chevron.getPreferredSize().width : 0;
                    for (n9 = 0; n9 < n5; ++n9) {
                        serializable2 = dimensionArray[n9];
                        if ((n12 -= ((Dimension)serializable2).width) >= 0 && (n12 >= n10 || n9 == n5 - 1)) continue;
                        n12 += ((Dimension)serializable2).width;
                        while (n12 < 0) {
                            n12 -= n10;
                            if (--n9 < 0) break;
                            serializable2 = dimensionArray[n9];
                            n12 += ((Dimension)serializable2).width;
                        }
                        n11 = n9 - 1;
                        break;
                    }
                } else {
                    n10 = this._chevron != null ? this._chevron.getPreferredSize().height : 0;
                    for (n9 = 0; n9 < n5; ++n9) {
                        serializable2 = dimensionArray[n9];
                        if ((n13 -= ((Dimension)serializable2).height) >= 0 && (n13 >= n10 || n9 == n5 - 1)) continue;
                        n13 += ((Dimension)serializable2).height;
                        while (n13 < 0) {
                            n13 -= n10;
                            if (--n9 < 0) break;
                            serializable2 = dimensionArray[n9];
                            n13 += ((Dimension)serializable2).height;
                        }
                        n11 = n9 - 1;
                        break;
                    }
                }
                if (this._chevron != null) {
                    n10 = this._chevron.isShowMore() ? 1 : 0;
                    int n14 = n9 = n11 < n5 - 1 ? 1 : 0;
                    if (n10 != n9) {
                        this._chevron.setShowMore(n9 != 0);
                    }
                    if (this._target instanceof DockableBar && ((DockableBar)this._target).isStretch()) {
                        this._chevron.setVisible(n9 != 0);
                        this._chevron.setEnabled(n9 != 0);
                    }
                }
                if (dockableBar.getOrientation() == 0) {
                    if (this._gripper != null && this.shouldShowGripper(dockableBar)) {
                        this._gripper.setBounds(bl ? n4 : n4 - this._gripper.getPreferredSize().width, n3, this._gripper.getPreferredSize().width, n2);
                        n4 = bl ? (n4 += this._gripper.getPreferredSize().width) : (n4 -= this._gripper.getPreferredSize().width);
                    }
                    if (this._target instanceof CommandBar) {
                        ((CommandBar)this._target).removeAllHiddenComponents();
                    }
                    for (n10 = 0; n10 < n5; ++n10) {
                        Component component = list.get(n10);
                        if (list.indexOf(component) == -1) continue;
                        if (list.indexOf(component) > n11) {
                            if (!(this._target instanceof CommandBar)) continue;
                            ((CommandBar)this._target).addHiddenComponent(component);
                            continue;
                        }
                        if (component.getParent() != this._target && this._target instanceof CommandBar) {
                            ((CommandBar)this._target).removeHiddenComponent(component);
                        }
                        if (!component.isVisible()) continue;
                        if (n10 < n5 && this._target instanceof DockableBar && ((DockableBar)this._target).isStretch() && this.shouldExpand(component)) {
                            int n15 = this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().width : 0;
                            for (int i = n10 + 1; i < n5; ++i) {
                                serializable = list.get(i);
                                if (list.indexOf(serializable) > n11) continue;
                                n15 += dimensionArray[i].width;
                            }
                            component.setBounds(bl ? n4 : n15, n3, bl ? n - n15 - n4 : n4 - n15, n2);
                            if (bl) {
                                n4 = n - n15 + insets.left;
                                continue;
                            }
                            n4 = n15 + insets.left;
                            continue;
                        }
                        Dimension dimension4 = dimensionArray[n10];
                        component.setBounds(bl ? n4 : n4 - dimension4.width, n3, dimension4.width, n2);
                        if (bl) {
                            n4 += dimension4.width;
                            continue;
                        }
                        n4 -= dimension4.width;
                    }
                    if (this._chevron != null && this._chevron.isVisible()) {
                        this._chevron.setBounds(bl ? this._target.getWidth() - this._chevron.getPreferredSize().width : 0, 0, this._chevron.getPreferredSize().width, this._target.getHeight());
                    }
                } else {
                    if (this._gripper != null && this.shouldShowGripper(dockableBar)) {
                        this._gripper.setBounds(n4, n3, n, this._gripper.getPreferredSize().height);
                        n3 += this._gripper.getPreferredSize().height;
                    }
                    if (this._target instanceof CommandBar) {
                        ((CommandBar)this._target).removeAllHiddenComponents();
                    }
                    for (n10 = 0; n10 < n5; ++n10) {
                        Component component = list.get(n10);
                        if (list.indexOf(component) == -1) continue;
                        if (list.indexOf(component) > n11) {
                            if (!(this._target instanceof CommandBar)) continue;
                            ((CommandBar)this._target).addHiddenComponent(component);
                            continue;
                        }
                        if (component.getParent() != this._target && this._target instanceof CommandBar) {
                            ((CommandBar)this._target).removeHiddenComponent(component);
                        }
                        if (!component.isVisible()) continue;
                        if (n10 < n5 - 1 && this._target instanceof DockableBar && ((DockableBar)this._target).isStretch() && this.shouldExpand(component)) {
                            int n16 = this._chevron != null && this._chevron.isVisible() ? this._chevron.getPreferredSize().height : 0;
                            for (int i = n10 + 1; i < n5; ++i) {
                                serializable = list.get(i);
                                if (list.indexOf(serializable) > n11) continue;
                                n16 += dimensionArray[i].height;
                            }
                            component.setBounds(n4, n3, n, n2 - n16 - n3);
                            n3 = n2 - n16 + insets.top;
                            continue;
                        }
                        Dimension dimension5 = dimensionArray[n10];
                        component.setBounds(n4, n3, n, dimension5.height);
                        n3 += dimension5.height;
                    }
                    if (this._chevron != null && this._chevron.isVisible()) {
                        this._chevron.setBounds(0, this._target.getHeight() - this._chevron.getPreferredSize().height, this._target.getWidth(), this._chevron.getPreferredSize().height);
                    }
                }
            }
            dockableBar.setDuringLayout(false);
        }
    }

    protected Dimension getPreferredSize(Component component) {
        return component.isVisible() ? component.getPreferredSize() : new Dimension(0, 0);
    }

    protected Dimension getMinimumSize(Component component) {
        return component.isVisible() ? component.getMinimumSize() : new Dimension(0, 0);
    }

    protected boolean shouldExpand(Component component) {
        Object object = ((JComponent)component).getClientProperty("CommandBar.expandable");
        if ("false".equals(object)) {
            return false;
        }
        if ("true".equals(object)) {
            return true;
        }
        return component instanceof CommandBar.Expansion || component instanceof JTextField || component instanceof JComboBox;
    }

    int getHiddenOrder(Object object) {
        if (!(object instanceof Component)) {
            return 0;
        }
        Component component = (Component)object;
        Integer n = this._hiddenOrder.get(component);
        if (n != null) {
            return n;
        }
        return 0;
    }

    List<Component> sortComponentByOrder() {
        List<Component> list = this.getComponents();
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                if (CommandBarLayout.this.getHiddenOrder(object) > CommandBarLayout.this.getHiddenOrder(object2)) {
                    return -1;
                }
                if (CommandBarLayout.this.getHiddenOrder(object) < CommandBarLayout.this.getHiddenOrder(object2)) {
                    return 1;
                }
                return -1;
            }
        });
        return list;
    }

    protected List<Component> getComponents() {
        Vector<Component> vector = new Vector<Component>();
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component[] componentArray = this._target.getComponent(i);
            if (componentArray instanceof Gripper) {
                this._gripper = (Gripper)componentArray;
                continue;
            }
            if (componentArray instanceof CommandBarTitleBar) {
                this._titleBar = (CommandBarTitleBar)componentArray;
                continue;
            }
            if (componentArray instanceof Chevron) {
                this._chevron = (Chevron)componentArray;
                continue;
            }
            if (!this.isOrientationSupport((Component)componentArray)) continue;
            vector.add((Component)componentArray);
        }
        if (this._target instanceof CommandBar) {
            Component[] componentArray;
            for (Component component : componentArray = ((CommandBar)this._target).getHiddenComponents()) {
                if (!this.isOrientationSupport(component)) continue;
                vector.add(component);
            }
        }
        return vector;
    }

    protected List<Component> getUnsupportedComponents() {
        Vector<Component> vector = new Vector<Component>();
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component[] componentArray = this._target.getComponent(i);
            if (componentArray instanceof Gripper || componentArray instanceof CommandBarTitleBar || componentArray instanceof Chevron || this.isOrientationSupport((Component)componentArray)) continue;
            vector.add((Component)componentArray);
        }
        if (this._target instanceof CommandBar) {
            Component[] componentArray;
            for (Component component : componentArray = ((CommandBar)this._target).getHiddenComponents()) {
                if (this.isOrientationSupport(component)) continue;
                vector.add(component);
            }
        }
        return vector;
    }

    private boolean isOrientationSupport(Component component) {
        if (this._target instanceof DockableBar) {
            if (((DockableBar)this._target).getOrientation() == 0) {
                return !(component instanceof Alignable) || ((Alignable)((Object)component)).supportHorizontalOrientation();
            }
            if (component instanceof Alignable && ((Alignable)((Object)component)).supportVerticalOrientation()) {
                return true;
            }
        }
        return false;
    }

    void checkContainer(Container container) {
        if (this._target != container) {
            throw new AWTError("CommandBarLayout can't be shared");
        }
    }

    void checkRequests() {
        Object object;
        if (this.xChildren == null || this.yChildren == null) {
            Serializable serializable;
            int n;
            object = this.getComponents();
            int n2 = object.size();
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n2];
            SizeRequirements[] sizeRequirementsArray2 = new SizeRequirements[n2];
            for (n = 0; n < n2; ++n) {
                serializable = (Component)object.get(n);
                if (!serializable.isVisible()) {
                    sizeRequirementsArray[n] = new SizeRequirements(0, 0, 0, 0.0f);
                    sizeRequirementsArray2[n] = new SizeRequirements(0, 0, 0, 0.0f);
                    continue;
                }
                Dimension dimension = serializable.getMinimumSize();
                Dimension dimension2 = serializable.getPreferredSize();
                Dimension dimension3 = serializable.getMaximumSize();
                sizeRequirementsArray[n] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, 0.0f);
                sizeRequirementsArray2[n] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, 0.0f);
            }
            n = this.resolveAxis(this._axis, this._target.getComponentOrientation());
            if (n == 0) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(sizeRequirementsArray);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(sizeRequirementsArray2);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(sizeRequirementsArray);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(sizeRequirementsArray2);
            }
            serializable = UIDefaultsLookup.getDimension("CommandBar.minimumSize");
            if (serializable != null) {
                if (this.xTotal.preferred == 0) {
                    this.xTotal.preferred = ((Dimension)serializable).width;
                }
                if (this.yTotal.preferred == 0) {
                    this.yTotal.preferred = ((Dimension)serializable).height;
                }
            }
            this.xChildren = sizeRequirementsArray;
            this.yChildren = sizeRequirementsArray2;
        }
        if (this._target instanceof DockableBar && (((DockableBar)(object = (DockableBar)this._target)).getOrientation() == 0 || ((DockableBar)object).isFloating())) {
            this.calculateResult(this.xChildren);
        }
    }

    private int resolveAxis(int n, ComponentOrientation componentOrientation) {
        int n2 = n == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n);
        return n2;
    }

    private void calculateResult(SizeRequirements[] sizeRequirementsArray) {
        if (this._result != null) {
            return;
        }
        this._result = new Vector<Result>();
        int n = this.getMinWidth(sizeRequirementsArray);
        int n2 = 0;
        int[] nArray = new int[sizeRequirementsArray.length];
        for (int i = 0; i < sizeRequirementsArray.length; ++i) {
            nArray[i] = n2 += sizeRequirementsArray[i].preferred;
        }
        int[] nArray2 = new int[sizeRequirementsArray.length];
        boolean bl = false;
        for (int i = 1; i <= sizeRequirementsArray.length; ++i) {
            int n3 = n2 / i;
            if (n3 < n) {
                if (bl) continue;
                n3 = n;
                bl = true;
            }
            boolean bl2 = false;
            while (!bl2) {
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                block3: do {
                    for (int j = n5; j < sizeRequirementsArray.length; ++j) {
                        n5 = j;
                        if (nArray[j] - n6 > n3) {
                            n6 = nArray[nArray2[n4] - 1];
                            ++n4;
                            bl2 = false;
                            continue block3;
                        }
                        nArray2[n4] = j + 1;
                        bl2 = true;
                    }
                } while (n4 < i && !bl2);
                if (bl2) continue;
                ++n3;
            }
            nArray2[i - 1] = 0;
            Result result = new Result();
            result.rowCount = i;
            result.width = n3;
            result.splits = new int[i - 1];
            System.arraycopy(nArray2, 0, result.splits, 0, i - 1);
            result.height = result.rowCount * this.yTotal.preferred;
            this._result.add(result);
        }
    }

    private int retrieveByWidth(int n, boolean bl) {
        if (bl) {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (n < result.width) continue;
                return i;
            }
        } else {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (result.width <= n) continue;
                return i;
            }
        }
        return bl ? this._result.size() - 1 : 0;
    }

    private int retrieveByHeight(int n, boolean bl) {
        if (bl) {
            for (int i = this._result.size() - 1; i >= 0; --i) {
                Result result = this._result.get(i);
                if (n < result.height) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._result.size(); ++i) {
                Result result = this._result.get(i);
                if (result.height <= n) continue;
                return i;
            }
        }
        return bl ? 0 : this._result.size() - 1;
    }

    Dimension getPreferredSizeByRowCount(int n) {
        if (this._result != null && this._result.size() > 0) {
            int n2 = this._result.get((int)0).rowCount;
            int n3 = this._result.get((int)(this._result.size() - 1)).rowCount;
            if (n < n2) {
                n = n2;
            }
            if (n > n3) {
                n = n3;
            }
            for (Result result : this._result) {
                if (result.rowCount != n) continue;
                return new Dimension(result.width, result.height);
            }
        }
        return new Dimension(0, 0);
    }

    public boolean isRespectMinimumSizeWhenNecessary() {
        return this._respectMinimumSizeWhenNecessary;
    }

    public void setRespectMinimumSizeWhenNecessary(boolean bl) {
        this._respectMinimumSizeWhenNecessary = bl;
    }

    private static class Result {
        int rowCount;
        int[] splits;
        int width;
        int height;

        private Result() {
        }
    }
}

