/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.obf.Cl;
import com.yworks.yguard.obf.ObfuscationConfig;
import com.yworks.yguard.obf.TreeItem;
import com.yworks.yguard.obf.classfile.ClassFile;
import java.lang.reflect.Modifier;

public abstract class MdFd
extends TreeItem {
    private String descriptor = null;
    private ObfuscationConfig obfuscationConfig;
    private String[] parsedTypes = null;

    public MdFd(TreeItem parent, boolean isSynthetic, String name, String descriptor, int access, ObfuscationConfig obfuscationConfig) {
        super(parent, name);
        this.descriptor = descriptor;
        this.obfuscationConfig = obfuscationConfig;
        this.access = access;
        this.isSynthetic = isSynthetic;
        if (name.equals("") || descriptor.equals("") || !(parent instanceof Cl)) {
            System.err.println("Internal error: method/field must have name and descriptor, and have Class or Interface as parent");
        }
        if (isSynthetic || Modifier.isNative(access)) {
            this.setOutName(this.getInName());
        }
    }

    public ObfuscationConfig getObfuscationConfig() {
        return this.obfuscationConfig;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int modifiers = this.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            sb.append("abstract ");
        }
        if (Modifier.isSynchronized(modifiers)) {
            sb.append("synchronized ");
        }
        if (Modifier.isTransient(modifiers)) {
            sb.append("transient ");
        }
        if (Modifier.isVolatile(modifiers)) {
            sb.append("volatile ");
        }
        if (Modifier.isNative(modifiers)) {
            sb.append("native ");
        }
        if (Modifier.isPublic(modifiers)) {
            sb.append("public ");
        }
        if (Modifier.isProtected(modifiers)) {
            sb.append("protected ");
        }
        if (Modifier.isPrivate(modifiers)) {
            sb.append("private ");
        }
        if (Modifier.isStatic(modifiers)) {
            sb.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            sb.append("final ");
        }
        sb.append(this.getReturnTypeName());
        sb.append(this.getInName());
        sb.append(this.getDescriptorName());
        return sb.toString();
    }

    protected String getReturnTypeName() {
        String[] types = this.parseTypes();
        return (types.length > 0 ? types[types.length - 1] : "") + " ";
    }

    protected abstract String getDescriptorName();

    protected String[] parseTypes() {
        if (this.parsedTypes == null) {
            try {
                this.parsedTypes = ClassFile.parseDescriptor(this.getDescriptor(), true);
            }
            catch (Exception e) {
                this.parsedTypes = null;
            }
        }
        return this.parsedTypes;
    }
}

