/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.util;

import java.util.Arrays;
import java.util.List;

public final class BaseDataOID {
    public static final int UNKNOWN = 4;
    public static final int BOOL = 5;
    public static final int INT8 = 6;
    public static final int FLOAT8 = 7;
    public static final int CHAR = 8;
    public static final int VARCHAR = 9;
    public static final int DATE = 10;
    public static final int TIME = 11;
    public static final int TIMESTAMP = 12;
    public static final int TIMESTAMPTZ = 13;
    public static final int INTERVAL = 14;
    public static final int INTERVALYM = 114;
    public static final int TIMETZ = 15;
    public static final int NUMERIC = 16;
    public static final int VARBINARY = 17;
    public static final int UUID = 20;
    public static final int BINARY = 117;
    public static final int LONGVARBINARY = 116;
    public static final int LONGVARCHAR = 115;
    public static final int COMPLEXROW = 300;
    public static final int COMPLEXARRAY = 301;
    public static final int COMPLEXMAP = 302;
    public static final int BOOLARRAY1D = 1505;
    public static final int INT8ARRAY1D = 1506;
    public static final int FLOAT8ARRAY1D = 1507;
    public static final int CHARARRAY1D = 1508;
    public static final int VARCHARARRAY1D = 1509;
    public static final int LONGVARCHARARRAY1D = 1519;
    public static final int DATEARRAY1D = 1510;
    public static final int TIMEARRAY1D = 1511;
    public static final int TIMESTAMPARRAY1D = 1512;
    public static final int TIMESTAMPTZARRAY1D = 1513;
    public static final int INTERVALARRAY1D = 1514;
    public static final int INTERVALYMARRAY1D = 1521;
    public static final int TIMETZARRAY1D = 1515;
    public static final int NUMERICARRAY1D = 1516;
    public static final int BINARYARRAY1D = 1522;
    public static final int VARBINARYARRAY1D = 1517;
    public static final int LONGVARBINARYARRAY1D = 1518;
    public static final int UUIDARRAY1D = 1520;
    public static final int BOOLSET = 2705;
    public static final int INT8SET = 2706;
    public static final int FLOAT8SET = 2707;
    public static final int CHARSET = 2708;
    public static final int VARCHARSET = 2709;
    public static final int LONGVARCHARSET = 2719;
    public static final int DATESET = 2710;
    public static final int TIMESET = 2711;
    public static final int TIMESTAMPSET = 2712;
    public static final int TIMESTAMPTZSET = 2713;
    public static final int INTERVALSET = 2714;
    public static final int INTERVALYMSET = 2721;
    public static final int TIMETZSET = 2715;
    public static final int NUMERICSET = 2716;
    public static final int BINARYSET = 2722;
    public static final int VARBINARYSET = 2717;
    public static final int LONGVARBINARYSET = 2718;
    public static final int UUIDSET = 2720;
    public static final List<Integer> KNOWN_OIDS = Arrays.asList(5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 114, 15, 16, 17, 20, 117, 116, 115, 300, 301, 302, 1505, 1506, 1507, 1508, 1509, 1510, 1511, 1515, 1512, 1513, 1514, 1521, 1516, 1522, 1517, 1518, 1519, 1520, 2705, 2706, 2707, 2708, 2709, 2719, 2710, 2711, 2712, 2713, 2714, 2721, 2715, 2716, 2722, 2717, 2718, 2720);

    public static boolean isBaseTypeOID(int n) {
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 114: 
            case 115: 
            case 116: 
            case 117: {
                return true;
            }
        }
        return false;
    }

    public static boolean isComplexType(int n) {
        return BaseDataOID.isArrayType(n) || BaseDataOID.isSetType(n) || BaseDataOID.isRowType(n) || BaseDataOID.isMapType(n);
    }

    public static boolean isArrayType(int n) {
        switch (n) {
            case 301: 
            case 1505: 
            case 1506: 
            case 1507: 
            case 1508: 
            case 1509: 
            case 1510: 
            case 1511: 
            case 1512: 
            case 1513: 
            case 1514: 
            case 1515: 
            case 1516: 
            case 1517: 
            case 1518: 
            case 1519: 
            case 1520: 
            case 1521: 
            case 1522: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSetType(int n) {
        switch (n) {
            case 2705: 
            case 2706: 
            case 2707: 
            case 2708: 
            case 2709: 
            case 2710: 
            case 2711: 
            case 2712: 
            case 2713: 
            case 2714: 
            case 2715: 
            case 2716: 
            case 2717: 
            case 2718: 
            case 2719: 
            case 2720: 
            case 2721: 
            case 2722: {
                return true;
            }
        }
        return false;
    }

    public static boolean isRowType(int n) {
        return n == 300;
    }

    public static boolean isMapType(int n) {
        return n == 302;
    }

    public static boolean isComplexArrayOrSetType_1D(int n) {
        if (BaseDataOID.isArrayType(n) || BaseDataOID.isSetType(n)) {
            return n != 301;
        }
        return false;
    }

    public static boolean isNestedComplexType(int n) {
        return n == 300 || n == 301 || n == 302;
    }

    public static int transfromComplexArrayOIDtoBaseOID(int n) throws IllegalArgumentException {
        switch (n) {
            case 1505: 
            case 2705: {
                return 5;
            }
            case 1506: 
            case 2706: {
                return 6;
            }
            case 1507: 
            case 2707: {
                return 7;
            }
            case 1508: 
            case 2708: {
                return 8;
            }
            case 1509: 
            case 2709: {
                return 9;
            }
            case 1519: 
            case 2719: {
                return 115;
            }
            case 1510: 
            case 2710: {
                return 10;
            }
            case 1511: 
            case 2711: {
                return 11;
            }
            case 1512: 
            case 2712: {
                return 12;
            }
            case 1513: 
            case 2713: {
                return 13;
            }
            case 1514: 
            case 2714: {
                return 14;
            }
            case 1521: 
            case 2721: {
                return 114;
            }
            case 1515: 
            case 2715: {
                return 15;
            }
            case 1516: 
            case 2716: {
                return 16;
            }
            case 1522: 
            case 2722: {
                return 117;
            }
            case 1517: 
            case 2717: {
                return 17;
            }
            case 1518: 
            case 2718: {
                return 116;
            }
            case 1520: 
            case 2720: {
                return 20;
            }
        }
        throw new IllegalArgumentException("unsupported Complex type oid:" + n);
    }

    private BaseDataOID() {
    }
}

