/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import com.vertica.support.IMessageSource;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageSourceImpl
implements IMessageSource {
    private Map<Integer, String> m_componentToFileName = new HashMap<Integer, String>();
    private Map<Integer, String> m_componentIDToName = new HashMap<Integer, String>();
    private boolean m_isConcatComponentName;
    private boolean m_isConcatVendorString;
    private String m_vendorName = "";

    public MessageSourceImpl(boolean isConcatVendorString, boolean isConcatComponentName) {
        this.m_isConcatVendorString = isConcatVendorString;
        this.m_isConcatComponentName = isConcatComponentName;
        this.setVendorName("Simba");
    }

    @Override
    public String loadMessage(Locale locale, int componentID, String messageID) {
        return this.getFormattedMessage(locale, componentID, messageID, this.m_isConcatVendorString, this.m_isConcatComponentName, new Object[0]);
    }

    @Override
    public String loadMessage(Locale locale, int componentID, String messageID, boolean isConcatVendor, boolean isConcatComponent) {
        return this.getFormattedMessage(locale, componentID, messageID, isConcatVendor, isConcatComponent, new Object[0]);
    }

    @Override
    public String loadMessage(Locale locale, int componentID, String messageID, boolean isConcatVendor, boolean isConcatComponent, Object ... arguments) {
        return this.getFormattedMessage(locale, componentID, messageID, isConcatVendor, isConcatComponent, arguments);
    }

    @Override
    public String loadMessage(Locale locale, int componentID, String messageID, Object ... arguments) {
        return this.getFormattedMessage(locale, componentID, messageID, this.m_isConcatVendorString, this.m_isConcatComponentName, arguments);
    }

    public synchronized void registerMessages(String baseFileName, int componentID, String componentName) {
        this.m_componentToFileName.put(componentID, baseFileName);
        this.m_componentIDToName.put(componentID, componentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVendorName(String vendorName) {
        MessageSourceImpl messageSourceImpl = this;
        synchronized (messageSourceImpl) {
            this.m_vendorName = "[" + vendorName + "]";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedMessage(Locale locale, int componentID, String messageID, boolean isConcatVendor, boolean isConcatComponent, Object ... arguments) {
        try {
            String componentName;
            String baseFileName = this.m_componentToFileName.get(componentID);
            if (null == baseFileName) {
                return "Component not found: " + componentID;
            }
            ResourceBundle messages = ResourceBundle.getBundle(baseFileName, locale);
            String message = messages.getString(messageID);
            if (null != arguments) {
                message = MessageFormat.format(message, arguments);
            }
            StringBuilder sb = new StringBuilder();
            if (isConcatVendor) {
                MessageSourceImpl messageSourceImpl = this;
                synchronized (messageSourceImpl) {
                    sb.append(this.m_vendorName);
                }
            }
            if (isConcatComponent && null != (componentName = this.m_componentIDToName.get(componentID))) {
                sb.append("[");
                sb.append(componentName);
                sb.append("]");
            }
            sb.append(message);
            return sb.toString();
        }
        catch (MissingResourceException e) {
            return "Error message not found: " + messageID + ". " + e.getLocalizedMessage();
        }
    }
}

