/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc4;

import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SConnectionHandle;
import com.vertica.jdbc.common.SPooledConnection;
import com.vertica.jdbc.jdbc4.S4Connection;
import com.vertica.jdbc.jdbc4.S4PooledConnection;
import com.vertica.jdbc.jdbc4.S4PreparedStatement;
import com.vertica.jdbc.jdbc4.S4PreparedStatementHandle;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Properties;

public class S4ConnectionHandle
extends SConnectionHandle {
    public S4ConnectionHandle(SConnection connection, SPooledConnection pooledConnection) throws SQLException {
        super(connection, pooledConnection);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkIfOpen();
        try {
            return ((S4Connection)this.m_connection).getClientInfo();
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkIfOpen();
        try {
            return ((S4Connection)this.m_connection).getClientInfo(name);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, autoGeneratedKeys);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, columnIndexes);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkIfOpen();
        try {
            PreparedStatement statement = this.m_connection.prepareStatement(sql, columnNames);
            return new S4PreparedStatementHandle((S4PooledConnection)this.m_pooledConnection, (S4PreparedStatement)statement);
        }
        catch (SQLException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S4Connection)this.m_connection).setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.m_isClosed) {
            throw (SQLClientInfoException)ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONNECTION_CLOSED, this.m_connection.getWarningListener(), ExceptionType.CLIENT_INFO, new Object[0]);
        }
        try {
            ((S4Connection)this.m_connection).setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            if (!this.m_connection.getConnection().isAlive()) {
                this.m_pooledConnection.onHandleError(e);
            }
            throw e;
        }
    }
}

