/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.RowData;
import com.vertica.io.VStream;
import com.vertica.support.exceptions.RecoverableException;
import com.vertica.util.ClientErrorException;
import java.io.IOException;

public class DataRowResponseMessage
extends ResponseMessage {
    int m_columnCount;
    int m_rowLength;
    private static int ExtraByteInRemainingLength = 6;
    private RowData m_row;

    public DataRowResponseMessage(VStream vStream) {
        super(vStream);
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        this.m_row = new RowData(this.m_vStream);
        this.m_rowLength = Math.max(0, n - ExtraByteInRemainingLength);
    }

    public byte[] getCellData(int n) throws RecoverableException, ClientErrorException {
        return this.m_row.getColumnAt(n);
    }

    public RowData getRow() {
        return this.m_row;
    }

    public int getRowLength() throws RecoverableException {
        return this.m_rowLength;
    }

    @Override
    public MessageType getType() {
        return MessageType.DataRow;
    }

    public void finishReadRow() throws RecoverableException {
        this.m_row.readAll();
    }
}

