/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.DefaultParamException;
import com.vertica.dsi.exceptions.ParamAlreadyPushedException;

public final class ParameterInputValue {
    private ParameterMetadata m_metadata;
    private boolean m_isPushed;
    private boolean m_isDefault;
    private DataWrapper m_data;

    public ParameterInputValue(ParameterMetadata metadata, boolean isPushed, boolean isDefault, DataWrapper data) {
        this.m_metadata = metadata;
        this.m_isPushed = isPushed;
        this.m_isDefault = isDefault;
        this.m_data = data;
    }

    public ParameterInputValue(ParameterMetadata metadata, boolean isPushed, DataWrapper data) {
        this.m_metadata = metadata;
        this.m_isPushed = isPushed;
        this.m_isDefault = false;
        this.m_data = data;
    }

    public ParameterInputValue(ParameterMetadata metadata, DataWrapper data) {
        this.m_metadata = metadata;
        this.m_isPushed = false;
        this.m_isDefault = false;
        this.m_data = data;
    }

    public DataWrapper getData() throws ParamAlreadyPushedException, DefaultParamException {
        if (this.m_isPushed) {
            throw new ParamAlreadyPushedException();
        }
        if (this.m_isDefault) {
            throw new DefaultParamException();
        }
        return this.m_data;
    }

    public ParameterMetadata getMetadata() {
        return this.m_metadata;
    }

    public boolean isDefaultValue() {
        return this.m_isDefault;
    }

    public boolean isNull() {
        return null == this.m_data || this.m_data.isNull();
    }

    public boolean isPushed() {
        return this.m_isPushed;
    }

    public void setIsDefaultValue(boolean isDefaultValue) {
        this.m_isDefault = isDefaultValue;
    }

    public void setPushed(boolean isPushed) {
        this.m_isPushed = isPushed;
    }
}

