/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.core.VConnection;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dataengine.SimpleQueryExecutor;
import com.vertica.dataengine.VResultSet;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IMetadataSource;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.CursorType;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataColumn;
import com.vertica.dsi.dataengine.utilities.MetadataColumnFactory;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.io.RowData;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.util.BaseDataOID;
import com.vertica.util.ClientErrorException;
import com.vertica.util.Features;
import com.vertica.util.TypeUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;

public class VMetadataSource
implements IMetadataSource {
    private VConnection m_connection;
    private SimpleQueryExecutor m_queryExecutor;
    private MetadataSourceID m_type;
    private DSILogger m_log;
    private IResultSet m_results;
    private Map<MetadataSourceColumnTag, String> m_restrictions;
    private String m_escapeChar;
    private boolean m_filterAsIdentifier;
    private ArrayList<? extends IColumn> m_rowDescription;
    private EnumMap<MetadataSourceColumnTag, Integer> m_tagToColIndexMap;
    private EnumMap<MetadataSourceColumnTag, Short> m_tagToTypeMap;
    private String m_ODBCOrJDBC;

    public VMetadataSource(VConnection vConnection, MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl) throws ErrorException {
        this(vConnection, metadataSourceID, map, string, string2, bl, null);
    }

    public VMetadataSource(VConnection vConnection, MetadataSourceID metadataSourceID, Map<MetadataSourceColumnTag, String> map, String string, String string2, boolean bl, VResultSet vResultSet) throws ErrorException {
        this.m_connection = vConnection;
        this.m_log = vConnection.getConnectionLog();
        this.m_queryExecutor = new SimpleQueryExecutor(vConnection);
        this.m_restrictions = map;
        this.m_type = metadataSourceID;
        this.m_filterAsIdentifier = bl;
        String string3 = this.m_ODBCOrJDBC = Features.isSupported(Features.Feature.JDBCTypes, vConnection.getEffectiveProtocolVersion()) ? "jdbc" : "odbc";
        if (string == null || string.equals("\\")) {
            string = "\\\\";
        }
        this.m_escapeChar = string;
        this.m_results = vResultSet == null ? this.runMetadataQuery() : new VMetadataResultSet(vResultSet.getSelectColumns(), vResultSet.getRows());
        this.m_rowDescription = this.m_results.getSelectColumns();
        this.buildTagMappings();
    }

    private void buildTagMappings() throws ErrorException {
        ArrayList<MetadataColumn> arrayList = MetadataColumnFactory.createMetadataColumns(this.m_connection.createStatement(), this.m_type);
        this.m_tagToColIndexMap = new EnumMap(MetadataSourceColumnTag.class);
        this.m_tagToTypeMap = new EnumMap(MetadataSourceColumnTag.class);
        for (int i = 0; i < this.m_rowDescription.size(); ++i) {
            IColumn iColumn = this.m_rowDescription.get(i);
            String string = iColumn.getName();
            for (MetadataColumn metadataColumn : arrayList) {
                MetadataSourceColumnTag metadataSourceColumnTag = metadataColumn.getColumnTag();
                String string2 = metadataSourceColumnTag.toString();
                if (!string.equalsIgnoreCase(string2)) continue;
                this.m_tagToTypeMap.put(metadataSourceColumnTag, metadataColumn.getTypeMetadata().getType());
                this.m_tagToColIndexMap.put(metadataSourceColumnTag, i);
            }
        }
    }

    private VResultSet runMetadataQuery() throws ErrorException {
        StringBuilder stringBuilder = new StringBuilder(512);
        String string = this.makeWhereClause();
        String string2 = this.m_connection.getCatalogName();
        stringBuilder.append("select * from (");
        switch (this.m_type) {
            case CATALOG_ONLY: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name");
                break;
            }
            case CATALOG_SCHEMA_ONLY: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, name as schema_name from v_internal.vs_schemata where name <> 'v_internal' order by catalog_name, schema_name");
                break;
            }
            case COLUMNS: {
                this.writeColumnsQuery(stringBuilder);
                break;
            }
            case PSEUDO_COLUMNS_JDBC41: {
                this.writePseudoColumnsQuery(stringBuilder);
                break;
            }
            case COLUMN_PRIVILEGES: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, vs_grants.table_schema as schema_name, vs_grants.table_name, vs_columns.attname as column_name, vs_grants.grantor, vs_grants.grantee, vs_grants.privileges_description as privilege, case when (vs_grants.privileges <= 65536) then 'NO' else 'YES' end as isgrantable");
                stringBuilder.append(" from v_internal.vs_grants, v_internal.vs_tables, v_internal.vs_columns where vs_grants.object_id = vs_tables.oid and vs_tables.oid = vs_columns.oid ");
                stringBuilder.append(" order by catalog_name, schema_name, table_name, column_name, privilege");
                break;
            }
            case FOREIGN_KEYS: {
                this.writeForeignKeysQuery(stringBuilder);
                break;
            }
            case FUNCTIONS_JDBC4: {
                this.writeFunctionsQuery(stringBuilder);
                break;
            }
            case FUNCTION_COLUMNS_JDBC4: {
                this.writeFunctionColumnsQuery(stringBuilder);
                break;
            }
            case PRIMARY_KEYS: {
                this.writePrimaryKeysQuery(stringBuilder);
                break;
            }
            case PROCEDURES: {
                this.writeProceduresQuery(stringBuilder);
                break;
            }
            case PROCEDURE_COLUMNS: {
                this.writeProcedureColumnsQuery(stringBuilder);
                break;
            }
            case SPECIAL_COLUMNS: {
                stringBuilder.append("select ");
                stringBuilder.append(2);
                stringBuilder.append(" as scope, primary_keys.column_name, case when sql_datetime_sub = 10 then 1111 else data_type end as data_type, data_type_name, column_size, buffer_length, decimal_digits, ");
                stringBuilder.append(1);
                stringBuilder.append(" as pseudo, ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, primary_keys.table_schema as schema_name, primary_keys.table_name as table_name");
                stringBuilder.append(" from v_catalog.primary_keys join v_catalog." + this.m_ODBCOrJDBC + "_columns on primary_keys.table_schema = " + this.m_ODBCOrJDBC + "_columns.schema_name and primary_keys.table_name = " + this.m_ODBCOrJDBC + "_columns.table_name and primary_keys.column_name = " + this.m_ODBCOrJDBC + "_columns.column_name");
                break;
            }
            case SCHEMA_ONLY: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, name as schema_name from v_internal.vs_schemata where name <> 'v_internal' order by name");
                break;
            }
            case TABLES: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, schema_name, table_name, table_type, remarks from v_catalog.all_tables ");
                stringBuilder.append("order by table_type, catalog_name, schema_name, table_name");
                break;
            }
            case TABLE_PRIVILEGES: {
                stringBuilder.append("select ");
                stringBuilder.append(string2);
                stringBuilder.append(" as catalog_name, vs_grants.table_schema as schema_name, vs_grants.table_name, vs_grants.grantor, vs_grants.grantee, vs_grants.privileges_description as privilege, CASE WHEN (vs_grants.privileges <= 65536) THEN 'NO' ELSE 'YES' END as isgrantable from v_internal.vs_grants join v_internal.vs_tables on object_id = oid ");
                stringBuilder.append("order by catalog_name, schema_name, table_name, privilege, grantee");
                break;
            }
            case TABLETYPE_ONLY: {
                stringBuilder.append("select 'GLOBAL TEMPORARY' as table_type union all select 'LOCAL TEMPORARY' as table_type union all select 'SYSTEM TABLE' as table_type union all select 'TABLE' as table_type union all select 'VIEW' as table_type order by table_type");
                break;
            }
            case TYPE_INFO: {
                this.writeTypeInfoQuery(stringBuilder);
                break;
            }
            default: {
                LogUtilities.logError("Unknown metadata type: " + (Object)((Object)this.m_type), (ILogger)this.m_log);
            }
        }
        stringBuilder.append(") as vmd ");
        stringBuilder.append(string);
        VResultSet vResultSet = this.m_queryExecutor.execute(stringBuilder.toString());
        this.m_results = vResultSet;
        return vResultSet;
    }

    public IResultSet getResultSet() {
        return this.m_results;
    }

    private String makeWhereClause() {
        StringBuilder stringBuilder = new StringBuilder(256);
        boolean bl = false;
        String string = "escape E'" + this.m_escapeChar + "'";
        for (Map.Entry<MetadataSourceColumnTag, String> entry : this.m_restrictions.entrySet()) {
            MetadataSourceColumnTag metadataSourceColumnTag = entry.getKey();
            if (this.excludeTag(metadataSourceColumnTag)) continue;
            if (!bl) {
                stringBuilder.append("where ");
            } else {
                stringBuilder.append("and ");
            }
            String string2 = this.getComparisonOperator(metadataSourceColumnTag);
            stringBuilder.append(metadataSourceColumnTag.toString());
            stringBuilder.append(" ");
            stringBuilder.append(string2);
            stringBuilder.append(" ");
            this.writeFilterValue(entry, stringBuilder);
            if (string2.endsWith("like")) {
                stringBuilder.append(" ");
                stringBuilder.append(string);
            }
            stringBuilder.append(" ");
            bl = true;
        }
        return stringBuilder.toString();
    }

    private boolean excludeTag(MetadataSourceColumnTag metadataSourceColumnTag) {
        switch (metadataSourceColumnTag) {
            case IDENTIFIER_TYPE_TAG: 
            case NULLABLE_TAG: 
            case IS_RESULT_SET: 
            case USER_DATA_TYPE: {
                return true;
            }
        }
        return false;
    }

    private void writeFilterValue(Map.Entry<MetadataSourceColumnTag, String> entry, StringBuilder stringBuilder) {
        String string = entry.getValue();
        switch (entry.getKey()) {
            case TABLE_TYPE: {
                String[] stringArray = string.split(",");
                stringBuilder.append("(");
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append("'");
                    stringBuilder.append(stringArray[i].toUpperCase());
                    stringBuilder.append("'");
                    if (i >= stringArray.length - 1) continue;
                    stringBuilder.append(",");
                }
                stringBuilder.append(")");
                break;
            }
            default: {
                stringBuilder.append("'");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("'");
            }
        }
    }

    private String getComparisonOperator(MetadataSourceColumnTag metadataSourceColumnTag) {
        switch (metadataSourceColumnTag) {
            case SCOPE: {
                return "=";
            }
            case CATALOG_NAME: 
            case COLUMN_NAME: 
            case CREATE_PARAM: 
            case DATA_TYPE_NAME: 
            case FOREIGN_KEY_CATALOG_NAME: 
            case FOREIGN_KEY_COLUMN_NAME: 
            case FOREIGN_KEY_NAME: 
            case FOREIGN_KEY_SCHEMA_NAME: 
            case GRANTEE: 
            case GRANTOR: 
            case INDEX_NAME: 
            case ISGRANTABLE: 
            case LITERAL_PREFIX: 
            case LITERAL_SUFFIX: 
            case LOCAL_TYPE_NAME: 
            case PRIMARY_KEY_CATALOG_NAME: 
            case PRIMARY_KEY_COLUMN_NAME: 
            case PRIMARY_KEY_NAME: 
            case PRIMARY_KEY_SCHEMA_NAME: 
            case PRIMARY_KEY_TABLE_NAME: 
            case PROCEDURE_NAME: 
            case REMARKS: 
            case SCHEMA_NAME: 
            case TABLE_NAME: {
                return this.m_filterAsIdentifier ? "=" : "ilike";
            }
            case TABLE_TYPE: {
                return "in";
            }
        }
        return "=";
    }

    @Override
    public void close() {
        this.m_results.close();
    }

    @Override
    public void closeCursor() throws ErrorException {
        this.m_results.closeCursor();
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        Integer n = this.m_tagToColIndexMap.get((Object)metadataSourceColumnTag);
        if (!this.excludeTag(metadataSourceColumnTag) && n == null) {
            throw new ClientErrorException("Column is null for tag " + (Object)((Object)metadataSourceColumnTag));
        }
        if (n == null) {
            return false;
        }
        boolean bl = this.m_results.getData(n, l, l2, dataWrapper);
        this.checkAndConvertLargeTypes(metadataSourceColumnTag, dataWrapper);
        return bl;
    }

    private void checkAndConvertLargeTypes(MetadataSourceColumnTag metadataSourceColumnTag, DataWrapper dataWrapper) throws ClientErrorException {
        if (!dataWrapper.isNull()) {
            short s = this.m_tagToTypeMap.get((Object)metadataSourceColumnTag);
            try {
                switch (s) {
                    case -6: {
                        if (dataWrapper.getType() == -1) {
                            dataWrapper.setTinyInt(Short.valueOf(dataWrapper.getLongVarChar()));
                            break;
                        }
                        dataWrapper.setTinyInt(dataWrapper.getInteger().shortValue());
                        break;
                    }
                    case 5: {
                        if (dataWrapper.getType() == -1) {
                            dataWrapper.setSmallInt(Integer.valueOf(dataWrapper.getLongVarChar()));
                            break;
                        }
                        dataWrapper.setSmallInt(dataWrapper.getInteger().intValue());
                        break;
                    }
                    case 7: {
                        if (dataWrapper.getType() == -1) {
                            dataWrapper.setReal(Float.valueOf(dataWrapper.getLongVarChar()));
                            break;
                        }
                        dataWrapper.setReal(dataWrapper.getDouble().floatValue());
                        break;
                    }
                    case 12: {
                        dataWrapper.setVarChar(dataWrapper.getLongVarChar());
                        break;
                    }
                    case 1: {
                        dataWrapper.setChar(dataWrapper.getLongVarChar());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new ClientErrorException("Unrecognized type for conversion: " + s);
            }
        }
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        return this.m_results.hasMoreRows();
    }

    @Override
    public boolean moveToNextRow() {
        try {
            return this.m_results.moveToNextRow();
        }
        catch (ErrorException errorException) {
            return false;
        }
    }

    private void writePrimaryKeysQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as primary_key_catalog_name,");
        stringBuilder.append(" table_schema as primary_key_schema_name,");
        stringBuilder.append(" table_name as primary_key_table_name,");
        stringBuilder.append(" column_name as primary_key_column_name,");
        stringBuilder.append(" ordinal_position as key_seq,");
        stringBuilder.append(" constraint_name as primary_key_name");
        stringBuilder.append(" from v_catalog.primary_keys");
        stringBuilder.append(" order by primary_key_catalog_name, primary_key_schema_name, primary_key_table_name, key_seq");
    }

    private void writeForeignKeysQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as primary_key_catalog_name,");
        stringBuilder.append(" primary_keys.table_schema as primary_key_schema_name,");
        stringBuilder.append(" primary_keys.table_name as primary_key_table_name, primary_keys.column_name as primary_key_column_name, ");
        stringBuilder.append(string);
        stringBuilder.append(" as foreign_key_catalog_name,");
        stringBuilder.append(" foreign_keys.table_schema as foreign_key_schema_name,");
        stringBuilder.append(" foreign_keys.table_name as foreign_key_table_name,");
        stringBuilder.append(" foreign_keys.column_name as foreign_key_column_name,");
        stringBuilder.append(" primary_keys.ordinal_position as key_seq,");
        stringBuilder.append(" 3 as foreign_key_update_rule,");
        stringBuilder.append(" 3 as foreign_key_delete_rule,");
        stringBuilder.append(" foreign_keys.constraint_name as foreign_key_name,");
        stringBuilder.append(" primary_keys.constraint_name as primary_key_name,");
        stringBuilder.append(" 7 as deferrability");
        stringBuilder.append(" from v_catalog.primary_keys");
        stringBuilder.append(" join v_catalog.foreign_keys");
        stringBuilder.append(" on primary_keys.table_name = foreign_keys.reference_table_name");
        stringBuilder.append(" and primary_keys.table_schema = foreign_keys.reference_table_schema");
        stringBuilder.append(" and primary_keys.column_name = foreign_keys.reference_column_name");
        Set<MetadataSourceColumnTag> set = this.m_restrictions.keySet();
        boolean bl = false;
        bl |= set.contains((Object)MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME);
        bl |= set.contains((Object)MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME);
        if (bl |= set.contains((Object)MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME)) {
            stringBuilder.append(" order by primary_key_catalog_name, primary_key_schema_name, primary_key_table_name, key_seq");
        } else {
            stringBuilder.append(" order by foreign_key_catalog_name, foreign_key_schema_name, foreign_key_table_name, key_seq");
        }
    }

    private void writeColumnsQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as catalog_name,");
        stringBuilder.append(" schema_name,");
        stringBuilder.append(" table_name,");
        stringBuilder.append(" column_name,");
        stringBuilder.append(" case when sql_datetime_sub = 10 then 1111 else data_type end as data_type,");
        stringBuilder.append(" data_type_name,");
        stringBuilder.append(" column_size,");
        stringBuilder.append(" buffer_length,");
        stringBuilder.append(" decimal_digits,");
        stringBuilder.append(" num_prec_radix,");
        stringBuilder.append(" nullable,");
        stringBuilder.append(" remarks,");
        stringBuilder.append(" column_default as column_def,");
        stringBuilder.append(" sql_type_id as sql_data_type,");
        stringBuilder.append(" sql_datetime_sub,");
        stringBuilder.append(" char_octet_length,");
        stringBuilder.append(" ordinal_position,");
        stringBuilder.append(" is_nullable,");
        stringBuilder.append(" case is_identity when 't' then 'YES' when 'f' then 'NO' else null end as is_autoincrement,");
        stringBuilder.append(" case is_identity when 't' then 'YES' when 'f' then 'NO' else null end as is_generatedcolumn,");
        stringBuilder.append(" 0 as user_data_type");
        stringBuilder.append(" from v_catalog." + this.m_ODBCOrJDBC + "_columns");
        stringBuilder.append(" order by catalog_name, schema_name, table_name, ordinal_position");
    }

    private void writePseudoColumnsQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as catalog_name,");
        stringBuilder.append(" schema_name,");
        stringBuilder.append(" table_name,");
        stringBuilder.append(" 'epoch' as column_name,");
        stringBuilder.append(" -5 as data_type,");
        stringBuilder.append(" 19 as column_size,");
        stringBuilder.append(" null as decimal_digits,");
        stringBuilder.append(" 10 as num_prec_radix,");
        stringBuilder.append(" 'NO_USAGE_RESTRICTIONS' as column_usage,");
        stringBuilder.append(" null as remarks,");
        stringBuilder.append(" null as char_octet_length,");
        stringBuilder.append(" 'YES' as is_nullable");
        stringBuilder.append(" from v_catalog.all_tables");
        stringBuilder.append(" where table_type <> 'SYSTEM TABLE' and table_type <> 'VIEW'");
        stringBuilder.append(" order by catalog_name, schema_name, table_name");
    }

    private void writeTypeInfoQuery(StringBuilder stringBuilder) {
        stringBuilder.append("select type_name as data_type_name,");
        stringBuilder.append(" case " + this.m_ODBCOrJDBC + "_type when 9 then " + this.m_ODBCOrJDBC + "_subtype when 10 then 1111 else " + this.m_ODBCOrJDBC + "_type end as data_type,");
        stringBuilder.append(" column_size,");
        String string = new String();
        for (int n : BaseDataOID.KNOWN_OIDS) {
            string = string + n + ", ";
        }
        string = string.substring(0, string.length() - 2);
        stringBuilder.append(" case when type_id not in (");
        stringBuilder.append(string);
        stringBuilder.append(") then null when " + this.m_ODBCOrJDBC + "_type in (-5, 2, 8) then null ");
        stringBuilder.append("when " + this.m_ODBCOrJDBC + "_type in (2003) and data_type_name ilike 'Array[%' then 'ARRAY['  ");
        stringBuilder.append("when " + this.m_ODBCOrJDBC + "_type in (2003) and data_type_name ilike 'Set[%' then 'SET['  ");
        stringBuilder.append("else E'\\'' end as literal_prefix,");
        stringBuilder.append(" case when type_id not in (");
        stringBuilder.append(string);
        stringBuilder.append(") then null when " + this.m_ODBCOrJDBC + "_type in (-5, 2, 8) then null ");
        stringBuilder.append("when " + this.m_ODBCOrJDBC + "_type in (2003) then ']' ");
        stringBuilder.append("else E'\\'' end as literal_suffix,");
        stringBuilder.append(" creation_parameters as create_param,");
        stringBuilder.append(" 1 as nullable,");
        stringBuilder.append(" case when " + this.m_ODBCOrJDBC + "_type in (1, 12, -3, -1, -4, -2) then 1 else 0 end as case_sensitive,");
        stringBuilder.append(" 3 as searchable,");
        stringBuilder.append(" 0 as unsigned_attribute,");
        stringBuilder.append(" case " + this.m_ODBCOrJDBC + "_type when 2 then 1 else 0 end as fixed_prec_scale,");
        stringBuilder.append(" 0 as auto_unique,");
        stringBuilder.append(" type_name as local_type_name,");
        stringBuilder.append(" min_scale as minimum_scale,");
        stringBuilder.append(" max_scale as maximum_scale,");
        stringBuilder.append(" " + this.m_ODBCOrJDBC + "_type as sql_data_type,");
        stringBuilder.append(" " + this.m_ODBCOrJDBC + "_subtype as sql_datetime_sub,");
        stringBuilder.append(" 10 as num_prec_radix,");
        stringBuilder.append(" null as interval_precision,");
        stringBuilder.append(" 0 as user_data_type");
        stringBuilder.append(" from v_catalog.types");
        stringBuilder.append(" order by data_type, data_type_name");
    }

    private void writeFunctionsQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as catalog_name,");
        stringBuilder.append(" schema_name,");
        stringBuilder.append(" procedure_name,");
        stringBuilder.append(" definition as remarks,");
        stringBuilder.append(" 0 as procedure_type,");
        stringBuilder.append(" procedure_name || '(' || procedure_argument_types || ')' as specific_name");
        stringBuilder.append(" from v_internal.vs_procedures");
        stringBuilder.append(" where user_defined");
        stringBuilder.append(" order by catalog_name, schema_name, procedure_name, specific_name");
    }

    private void writeProceduresQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as catalog_name,");
        stringBuilder.append(" schema_name,");
        stringBuilder.append(" procedure_name,");
        stringBuilder.append(" null as num_input_params,");
        stringBuilder.append(" null as num_output_params,");
        stringBuilder.append(" null as num_result_sets,");
        stringBuilder.append(" definition as remarks, ");
        stringBuilder.append(0);
        stringBuilder.append(" as procedure_type,");
        stringBuilder.append(" procedure_name || '(' || procedure_argument_types || ')' as specific_name");
        stringBuilder.append(" from v_internal.vs_procedures");
        stringBuilder.append(" where user_defined");
        stringBuilder.append(" order by catalog_name, schema_name, procedure_name, specific_name");
    }

    private void writeFunctionColumnsQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as catalog_name,");
        stringBuilder.append(" proc_schema as schema_name,");
        stringBuilder.append(" proc_name as procedure_name,");
        stringBuilder.append(" column_name,");
        stringBuilder.append(" case column_type when 5 then 4 else column_type end as procedure_column_type,");
        stringBuilder.append(" case when sql_datetime_sub = 10 then 1111 else data_type end as data_type,");
        stringBuilder.append(" type_name as data_type_name,");
        stringBuilder.append(" column_size,");
        stringBuilder.append(" buffer_length,");
        stringBuilder.append(" decimal_digits,");
        stringBuilder.append(" num_prec_radix,");
        stringBuilder.append(" nullable,");
        stringBuilder.append(" remarks,");
        stringBuilder.append(" column_size as char_octet_length,");
        stringBuilder.append(" ordinal_position,");
        stringBuilder.append(" is_nullable,");
        stringBuilder.append(" specific_proc_name as specific_name,");
        stringBuilder.append(" 0 as user_data_type");
        stringBuilder.append(" from v_internal.odbc_procedure_columns");
        stringBuilder.append(" order by catalog_name, schema_name, procedure_name, procedure_column_type, ordinal_position");
    }

    private void writeProcedureColumnsQuery(StringBuilder stringBuilder) {
        String string = this.m_connection.getCatalogName();
        stringBuilder.append("select ");
        stringBuilder.append(string);
        stringBuilder.append(" as catalog_name,");
        stringBuilder.append(" proc_schema as schema_name,");
        stringBuilder.append(" proc_name as procedure_name,");
        stringBuilder.append(" column_name,");
        stringBuilder.append(" column_type as procedure_column_type,");
        stringBuilder.append(" case when sql_datetime_sub = 10 then 1111 else data_type end as data_type,");
        stringBuilder.append(" type_name as data_type_name,");
        stringBuilder.append(" column_size,");
        stringBuilder.append(" buffer_length,");
        stringBuilder.append(" decimal_digits,");
        stringBuilder.append(" num_prec_radix,");
        stringBuilder.append(" nullable,");
        stringBuilder.append(" remarks,");
        stringBuilder.append(" null as column_def,");
        stringBuilder.append(" sql_data_type,");
        stringBuilder.append(" sql_datetime_sub,");
        stringBuilder.append(" column_size as char_octet_length,");
        stringBuilder.append(" ordinal_position,");
        stringBuilder.append(" is_nullable,");
        stringBuilder.append(" 0 as user_data_type,");
        stringBuilder.append(" specific_proc_name as specific_name");
        stringBuilder.append(" from v_internal.odbc_procedure_columns");
        stringBuilder.append(" order by catalog_name, schema_name, procedure_name, procedure_column_type, ordinal_position");
    }

    private static class VMetadataResultSet
    implements IResultSet {
        private final ArrayList<? extends IColumn> m_rowDescription;
        private final ArrayList<RowData> m_rows;
        private int m_rowIdx;
        private Object m_rowIdxLock;
        private final int m_numRows;

        public VMetadataResultSet(ArrayList<ColumnDescription> arrayList, ArrayList<RowData> arrayList2) {
            this.m_rowDescription = arrayList;
            this.m_rows = arrayList2;
            this.m_numRows = arrayList2.size();
            this.m_rowIdx = -1;
            this.m_rowIdxLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getData(int n, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
            ColumnDescription columnDescription = (ColumnDescription)this.m_rowDescription.get(n);
            RowData rowData = null;
            Object object = this.m_rowIdxLock;
            synchronized (object) {
                rowData = this.m_rows.get(this.m_rowIdx);
            }
            return TypeUtils.deserialize(columnDescription, l, l2, dataWrapper, rowData.getColumnAt(n));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMoreRows() {
            Object object = this.m_rowIdxLock;
            synchronized (object) {
                return this.m_rowIdx != this.m_numRows - 1;
            }
        }

        @Override
        public void setDataNeeded(int n, boolean bl) {
        }

        @Override
        public boolean getDataNeeded(int n) {
            return true;
        }

        @Override
        public boolean supportsHasMoreRows() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean moveToNextRow() {
            Object object = this.m_rowIdxLock;
            synchronized (object) {
                if (this.m_rowIdx < this.m_numRows - 1) {
                    ++this.m_rowIdx;
                    return this.m_rowIdx != this.m_numRows;
                }
                return false;
            }
        }

        @Override
        public ArrayList<? extends IColumn> getSelectColumns() {
            return this.m_rowDescription;
        }

        @Override
        public long getRowCount() {
            return this.m_rows.size();
        }

        @Override
        public boolean hasRowCount() {
            return true;
        }

        @Override
        public boolean writeData(int n, DataWrapper dataWrapper, long l, boolean bl) {
            return false;
        }

        @Override
        public boolean rowDeleted() {
            return false;
        }

        @Override
        public boolean rowInserted() {
            return false;
        }

        @Override
        public boolean rowUpdated() {
            return false;
        }

        @Override
        public int getFetchSize() {
            return 0;
        }

        @Override
        public void appendRow() {
        }

        @Override
        public void close() {
        }

        @Override
        public void closeCursor() {
        }

        @Override
        public void deleteRow() {
        }

        @Override
        public void onFinishRowUpdate() {
        }

        @Override
        public void onStartRowUpdate() {
        }

        @Override
        public void setCursorType(CursorType cursorType) {
        }

        @Override
        public void setFetchSize(int n) {
        }

        @Override
        public void registerWarningListener(IWarningListener iWarningListener) {
        }
    }
}

