/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.ant;

import com.yworks.yguard.common.ant.PatternMatchedSection;
import com.yworks.yguard.common.ant.TypePatternSet;
import com.yworks.yshrink.util.Util;
import java.util.EnumSet;
import org.objectweb.asm.Type;

public final class MethodSection
extends PatternMatchedSection {
    private String signature;
    private String name;
    private String className;
    private String returnType;
    private String args;
    private String throwsClause;

    public MethodSection() {
        this.types = EnumSet.of(TypePatternSet.Type.NAME, TypePatternSet.Type.CLASS);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
        String[] methodArr = Util.toNativeMethod(signature);
        String methodName = methodArr[0];
        String methodDesc = methodArr[1];
        this.setName(methodName);
        this.setReturnType(Util.toJavaType(Type.getReturnType((String)methodDesc).getDescriptor()));
        this.setArgs(Util.getArgumentString(Type.getArgumentTypes((String)methodDesc)));
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setName(String name) {
        if (name.trim().indexOf(32) != -1) {
            this.setSignature(name);
        } else {
            this.name = name;
        }
    }

    public void setClass(String name) {
        this.className = Util.toInternalClass(name);
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = Util.toInternalClass(returnType);
    }

    public String getThrows() {
        return this.throwsClause;
    }

    public void setThrows(String throwsClause) {
        this.throwsClause = throwsClause;
    }

    @Override
    public TypePatternSet createPatternSet() {
        System.out.println("MethodSection.createPatternSet");
        TypePatternSet typePatternSet = new TypePatternSet();
        typePatternSet.setType("class");
        this.addPatternSet(typePatternSet, typePatternSet.getType());
        return typePatternSet;
    }
}

