/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.ant;

import com.yworks.util.ant.ZipScannerTool;
import com.yworks.yguard.ObfuscatorTask;
import com.yworks.yguard.ant.Property;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ZipFileSet;

public abstract class PatternMatchedClassesSection {
    protected List patternSets = new ArrayList(5);
    protected final Map properties = new HashMap();
    protected boolean allowMatchAllPatternSet = false;

    public void addConfiguredPatternSet(PatternSet ps) {
        this.patternSets.add(ps);
    }

    public void addConfiguredProperty(Property p) {
        this.properties.put(p.getName(), p.getValue());
    }

    public List getPatternSets() {
        return this.patternSets;
    }

    public void addEntries(Collection entries, ZipFileSet zf) throws IOException {
        Project project = zf.getProject();
        for (PatternSet ps : this.patternSets) {
            DirectoryScanner scanner = zf.getDirectoryScanner(project);
            scanner.setIncludes(ObfuscatorTask.toNativePattern(ps.getIncludePatterns(project)));
            scanner.setExcludes(ObfuscatorTask.toNativePattern(ps.getExcludePatterns(project)));
            String[] matches = ZipScannerTool.getMatches(zf, scanner);
            for (int i = 0; i < matches.length; ++i) {
                String match = matches[i];
                if (!match.endsWith(".class")) continue;
                match = match.substring(0, match.length() - 6);
                this.addEntries(entries, match);
            }
        }
        if (this.patternSets.isEmpty() && this.allowMatchAllPatternSet) {
            DirectoryScanner scanner = zf.getDirectoryScanner(project);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.setExcludes(new String[0]);
            String[] matches = ZipScannerTool.getMatches(zf, scanner);
            for (int i = 0; i < matches.length; ++i) {
                String match = matches[i];
                if (!match.endsWith(".class")) continue;
                match = match.substring(0, match.length() - 6);
                this.addEntries(entries, match);
            }
        }
    }

    public abstract void addEntries(Collection var1, String var2);
}

