/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.graph;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Network;
import com.yworks.util.graph.Node;
import java.util.Set;

public class Edge {
    private Network<Node, Edge> network;

    public Edge(Network<Node, Edge> network) {
        this.network = network;
    }

    public Node target() {
        return (Node)this.network.incidentNodes((Object)this).target();
    }

    public Node source() {
        return (Node)this.network.incidentNodes((Object)this).source();
    }

    public Edge nextInEdge() {
        Set inEdges = this.network.inEdges((Object)this.target());
        boolean found = false;
        for (Edge edge : inEdges) {
            if (found) {
                return edge;
            }
            if (!edge.equals(this)) continue;
            found = true;
        }
        return null;
    }

    public Edge nextOutEdge() {
        Set outEdges = this.network.outEdges(this.network.incidentNodes((Object)this).source());
        boolean found = false;
        for (Edge edge : outEdges) {
            if (found) {
                return edge;
            }
            if (!edge.equals(this)) continue;
            found = true;
        }
        return null;
    }

    public Node opposite(Node node) {
        EndpointPair endpointPair = this.network.incidentNodes((Object)this);
        if (((Node)endpointPair.source()).equals(node)) {
            return (Node)endpointPair.target();
        }
        return (Node)endpointPair.source();
    }
}

