/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.tx;

import org.h2.mvstore.MVMap;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.mvstore.tx.VersionedValueCommitted;
import org.h2.mvstore.tx.VersionedValueUncommitted;
import org.h2.value.VersionedValue;

abstract class TxDecisionMaker
extends MVMap.DecisionMaker<VersionedValue> {
    private final int mapId;
    private final Object key;
    final Object value;
    private final Transaction transaction;
    long undoKey;
    private long lastOperationId;
    private Transaction blockingTransaction;
    private MVMap.Decision decision;

    TxDecisionMaker(int n, Object object, Object object2, Transaction transaction) {
        this.mapId = n;
        this.key = object;
        this.value = object2;
        this.transaction = transaction;
    }

    @Override
    public MVMap.Decision decide(VersionedValue versionedValue, VersionedValue versionedValue2) {
        int n;
        long l;
        assert (this.decision == null);
        if (versionedValue == null || (l = versionedValue.getOperationId()) == 0L || this.isThisTransaction(n = TransactionStore.getTransactionId(l))) {
            this.logIt(versionedValue);
            this.decision = MVMap.Decision.PUT;
        } else if (this.isCommitted(n)) {
            this.logIt(versionedValue.getCurrentValue() == null ? null : VersionedValueCommitted.getInstance(versionedValue.getCurrentValue()));
            this.decision = MVMap.Decision.PUT;
        } else if (this.getBlockingTransaction() != null) {
            this.decision = MVMap.Decision.ABORT;
        } else if (this.isRepeatedOperation(l)) {
            Object object = versionedValue.getCommittedValue();
            this.logIt(object == null ? null : VersionedValueCommitted.getInstance(object));
            this.decision = MVMap.Decision.PUT;
        } else {
            this.decision = MVMap.Decision.REPEAT;
        }
        return this.decision;
    }

    @Override
    public final void reset() {
        if (this.decision != MVMap.Decision.REPEAT) {
            this.lastOperationId = 0L;
            if (this.decision == MVMap.Decision.PUT) {
                this.transaction.logUndo();
            }
        }
        this.blockingTransaction = null;
        this.decision = null;
    }

    public final MVMap.Decision getDecision() {
        return this.decision;
    }

    final Transaction getBlockingTransaction() {
        return this.blockingTransaction;
    }

    final void logIt(VersionedValue versionedValue) {
        this.undoKey = this.transaction.log(this.mapId, this.key, versionedValue);
    }

    final boolean isThisTransaction(int n) {
        return n == this.transaction.transactionId;
    }

    final boolean isCommitted(int n) {
        boolean bl;
        Transaction transaction;
        do {
            transaction = this.transaction.store.getTransaction(n);
            bl = this.transaction.store.committingTransactions.get().get(n);
        } while (transaction != this.transaction.store.getTransaction(n));
        if (!bl) {
            this.blockingTransaction = transaction;
        }
        return bl;
    }

    final boolean isRepeatedOperation(long l) {
        if (l == this.lastOperationId) {
            return true;
        }
        this.lastOperationId = l;
        return false;
    }

    final MVMap.Decision setDecision(MVMap.Decision decision) {
        this.decision = decision;
        return this.decision;
    }

    public final String toString() {
        return "txdm " + this.transaction.transactionId;
    }

    public static final class LockDecisionMaker
    extends TxDecisionMaker {
        LockDecisionMaker(int n, Object object, Transaction transaction) {
            super(n, object, null, transaction);
        }

        @Override
        public MVMap.Decision decide(VersionedValue versionedValue, VersionedValue versionedValue2) {
            MVMap.Decision decision = super.decide(versionedValue, versionedValue2);
            if (versionedValue == null) {
                assert (decision == MVMap.Decision.PUT);
                decision = this.setDecision(MVMap.Decision.REMOVE);
            }
            return decision;
        }

        @Override
        public VersionedValue selectValue(VersionedValue versionedValue, VersionedValue versionedValue2) {
            return VersionedValueUncommitted.getInstance(this.undoKey, versionedValue == null ? null : versionedValue.getCurrentValue(), versionedValue == null ? null : versionedValue.getCommittedValue());
        }
    }

    public static class PutDecisionMaker
    extends TxDecisionMaker {
        PutDecisionMaker(int n, Object object, Object object2, Transaction transaction) {
            super(n, object, object2, transaction);
        }

        @Override
        public final VersionedValue selectValue(VersionedValue versionedValue, VersionedValue versionedValue2) {
            return VersionedValueUncommitted.getInstance(this.undoKey, this.value, versionedValue == null ? null : versionedValue.getCommittedValue());
        }
    }

    public static final class PutIfAbsentDecisionMaker
    extends PutDecisionMaker {
        PutIfAbsentDecisionMaker(int n, Object object, Object object2, Transaction transaction) {
            super(n, object, object2, transaction);
        }

        @Override
        public MVMap.Decision decide(VersionedValue versionedValue, VersionedValue versionedValue2) {
            int n;
            assert (this.getDecision() == null);
            if (versionedValue == null) {
                this.logIt(null);
                return this.setDecision(MVMap.Decision.PUT);
            }
            long l = versionedValue.getOperationId();
            if (l == 0L || this.isThisTransaction(n = TransactionStore.getTransactionId(l))) {
                if (versionedValue.getCurrentValue() != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                this.logIt(versionedValue);
                return this.setDecision(MVMap.Decision.PUT);
            }
            if (this.isCommitted(n)) {
                if (versionedValue.getCurrentValue() != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                this.logIt(null);
                return this.setDecision(MVMap.Decision.PUT);
            }
            if (this.getBlockingTransaction() != null) {
                return this.setDecision(MVMap.Decision.ABORT);
            }
            if (this.isRepeatedOperation(l)) {
                Object object = versionedValue.getCommittedValue();
                if (object != null) {
                    return this.setDecision(MVMap.Decision.ABORT);
                }
                this.logIt(null);
                return this.setDecision(MVMap.Decision.PUT);
            }
            return this.setDecision(MVMap.Decision.REPEAT);
        }
    }
}

