/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;

public class StreamParameter
implements Cloneable,
ParameterHolder {
    private final InputStream is;
    private final long length;
    private final boolean noBackslashEscapes;

    public StreamParameter(InputStream is, long length, boolean noBackslashEscapes) {
        this.is = is;
        this.length = length;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    public StreamParameter(InputStream is, boolean noBackSlashEscapes) {
        this(is, Long.MAX_VALUE, noBackSlashEscapes);
    }

    @Override
    public void writeTo(PacketOutputStream pos) throws IOException {
        pos.write(BINARY_INTRODUCER);
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.is, true, this.noBackslashEscapes);
        } else {
            pos.write(this.is, this.length, true, this.noBackslashEscapes);
        }
        pos.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return -1;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        ByteArrayOutputStream bb = new ByteArrayOutputStream();
        byte[] array = new byte[4096];
        if (this.length == Long.MAX_VALUE) {
            int len;
            while ((len = this.is.read(array)) > 0) {
                bb.write(array, 0, len);
            }
        } else {
            int len;
            for (long maxLen = this.length; (len = this.is.read(array)) > 0 && maxLen > 0L; maxLen -= (long)len) {
                bb.write(array, 0, Math.min(len, (int)maxLen));
            }
        }
        byte[] val = bb.toByteArray();
        pos.writeFieldLength(val.length);
        pos.write(val);
    }

    @Override
    public void writeLongData(PacketOutputStream pos) throws IOException {
        if (this.length == Long.MAX_VALUE) {
            pos.write(this.is, false, this.noBackslashEscapes);
        } else {
            pos.write(this.is, this.length, false, this.noBackslashEscapes);
        }
    }

    @Override
    public String toString() {
        return "<Stream>";
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.BLOB;
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return true;
    }
}

