-- Sakila Sample Database Schema Triggers
-- Version 1.2

-- Copyright (c) 2006, 2019, Oracle and/or its affiliates.
-- All rights reserved.

-- Redistribution and use in source and binary forms, with or without
-- modification, are permitted provided that the following conditions are
-- met:

-- * Redistributions of source code must retain the above copyright notice,
--   this list of conditions and the following disclaimer.
-- * Redistributions in binary form must reproduce the above copyright
--   notice, this list of conditions and the following disclaimer in the
--   documentation and/or other materials provided with the distribution.
-- * Neither the name of Oracle nor the names of its contributors may be used
--   to endorse or promote products derived from this software without
--   specific prior written permission.

-- THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
-- IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
-- THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
-- PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
-- CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
-- EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
-- PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
-- PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
-- LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
-- NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
-- SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

-- -------------------------------------------------
-- Modified for use with H2 database in DbVisualizer
-- (see ReadMe.DbVisualizer for details)
-- -------------------------------------------------
USE sakila;

---------------------
-- CREATE TRIGGERS --
---------------------

--
-- Triggers for loading film_text from film
--
DROP TRIGGER IF EXISTS ins_film;
DROP TRIGGER IF EXISTS upd_film;
DROP TRIGGER IF EXISTS del_film;
CREATE TRIGGER ins_film AFTER INSERT ON film FOR EACH ROW CALL "com.onseven.dbvis.db.h2.sakila.SakilaTrigger$ins_film";
CREATE TRIGGER upd_film AFTER UPDATE ON film FOR EACH ROW CALL "com.onseven.dbvis.db.h2.sakila.SakilaTrigger$upd_film";
CREATE TRIGGER del_film AFTER DELETE ON film FOR EACH ROW CALL "com.onseven.dbvis.db.h2.sakila.SakilaTrigger$del_film";

-- [NOT YET IMPLEMENTED ]
-- 
-- Doesn't seem possible to get H2 to run the triggers before the NOT NULL constraint check.
-- Triggers replaced with default values in corresponding columns.
-- 
-- --
-- -- Trigger to enforce create dates on INSERT
-- --
-- CREATE TRIGGER customer_create_date BEFORE INSERT ON customer FOR EACH ROW CALL "com.onseven.dbvis.db.h2.sakila.SakilaTrigger$customer_create_date";
-- 
-- --
-- -- Trigger to enforce payment_date during INSERT
-- --
-- CREATE TRIGGER payment_date BEFORE INSERT ON payment FOR EACH ROW CALL "com.onseven.dbvis.db.h2.sakila.SakilaTrigger$payment_date";
-- 	
-- --
-- -- Trigger to enforce rental_date on INSERT
-- --
-- CREATE TRIGGER rental_date BEFORE INSERT ON rental FOR EACH ROW CALL "com.onseven.dbvis.db.h2.sakila.SakilaTrigger$rental_date";

----------------------
-- CREATE FUNCTIONS --
----------------------
DROP ALIAS IF EXISTS "get_customer_balance";
DROP ALIAS IF EXISTS "inventory_held_by_customer";
DROP ALIAS IF EXISTS "inventory_in_stock";
CREATE ALIAS "get_customer_balance" FOR "com.onseven.dbvis.db.h2.sakila.SakilaFunction.get_customer_balance";
CREATE ALIAS "inventory_held_by_customer" FOR "com.onseven.dbvis.db.h2.sakila.SakilaFunction.inventory_held_by_customer";
CREATE ALIAS "inventory_in_stock" FOR "com.onseven.dbvis.db.h2.sakila.SakilaFunction.inventory_in_stock";