/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder;

import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.statement.StatementDescriptor;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.BindMetaDataInfo;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.jcc.DB2Connection;
import com.ibm.db2.jcc.SQLJColumnMetaData;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;

public class DBRMGenerator {
    private String user_ = null;
    private String hardEncoding_ = "Cp037";
    private String packageName_;
    private String DBRMDir_ = null;
    private PrintWriter printWriter_ = null;

    public DBRMGenerator(PrintWriter printWriter) {
        this.printWriter_ = printWriter;
    }

    public void generateDBRM(BindMetaDataInfo bindMetaDataInfo, ArtifactOptionsSet artifactOptionsSet, int n2) throws FileNotFoundException, IOException, SQLException {
        this.user_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.USERNAME);
        this.DBRMDir_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OUTPUT_DBRM_PATH);
        this.errorCheckingForValidDBRMGeneration(bindMetaDataInfo);
        this.packageName_ = bindMetaDataInfo.getRootPkgName();
        if (!bindMetaDataInfo.isForceSingleBindIsolation()) {
            this.packageName_ = this.packageName_ + n2;
        }
        bindMetaDataInfo.setStatementDescriptorArray_(new StatementDescriptorImpl[bindMetaDataInfo.getBindStatementsIncludesReservedSections().length]);
        this.generateDBRM(bindMetaDataInfo, n2);
    }

    public void generateDBRM(BindMetaDataInfo bindMetaDataInfo, String string, ArtifactOptionsSet artifactOptionsSet, String string2) {
        String string3 = null;
        this.user_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.USERNAME);
        DB2Connection dB2Connection = null;
        try {
            dB2Connection = bindMetaDataInfo.getDB2ConnectionForBindAndUnsetAutoCommit(artifactOptionsSet);
            bindMetaDataInfo.setMetaData(string2, dB2Connection, string);
            if (bindMetaDataInfo.packageContainsStatementsToBind()) {
                this.DBRMDir_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OUTPUT_DBRM_PATH);
                string3 = bindMetaDataInfo.getRootPkgName();
                String string4 = null;
                int n2 = -1;
                string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.ISOLATION_LEVEL);
                if (string4 != null) {
                    n2 = bindMetaDataInfo.checkIsolationLevelOptionReturnNumericLevel(string4);
                }
                this.errorCheckingForValidDBRMGeneration(bindMetaDataInfo);
                if (string4 != null) {
                    this.packageName_ = bindMetaDataInfo.getRootPkgName();
                    if (!bindMetaDataInfo.isForceSingleBindIsolation()) {
                        this.packageName_ = this.packageName_ + n2;
                    }
                    this.generateDBRM(bindMetaDataInfo, n2);
                } else {
                    for (int i10 = 1; i10 <= 4; ++i10) {
                        this.packageName_ = bindMetaDataInfo.getRootPkgName() + i10;
                        this.generateDBRM(bindMetaDataInfo, i10);
                    }
                }
                bindMetaDataInfo.commitIfUserAllowsCommits(dB2Connection);
            }
        }
        catch (Exception exception) {
            DataRuntimeException dataRuntimeException = exception instanceof DataRuntimeException ? (DataRuntimeException)exception : ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DBRM_FAIL", string2), exception, 10280);
            try {
                bindMetaDataInfo.rollbackIfUserAllowsRollbacks(dB2Connection);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw dataRuntimeException;
        }
        finally {
            bindMetaDataInfo.cleanupDB2Connection(dB2Connection);
        }
    }

    private void errorCheckingForValidDBRMGeneration(BindMetaDataInfo bindMetaDataInfo) {
        boolean bl2 = false;
        if (bindMetaDataInfo.isDB2ForZOS_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(bindMetaDataInfo.dbInfo_, 11, 1, Character.valueOf('5'))) {
            bl2 = true;
        }
        String string = bindMetaDataInfo.getRootPkgName();
        if (!bl2 && string.length() > 7) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DBRM_PCKNAME_LEN", string), null, 10283);
        }
        if (!bl2) {
            for (char c10 : string.toCharArray()) {
                if (!Character.isLowerCase(c10)) continue;
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DBRM_PCKNAME", string), null, 10284);
            }
        }
    }

    private void generateDBRM(BindMetaDataInfo bindMetaDataInfo, int n2) throws FileNotFoundException, IOException, SQLException {
        boolean bl2 = false;
        String string = this.DBRMDir_ + File.separator + this.packageName_;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        if (bindMetaDataInfo.isDB2ForZOS_ && StaticProfileConstants.isDatabaseProductLevelGreaterThanOrEqualTo(bindMetaDataInfo.dbInfo_, 11, 1, Character.valueOf('5'))) {
            bl2 = true;
        }
        this.writeDBRMHeader(bindMetaDataInfo, dataOutputStream, bl2);
        this.writeDBRMEntries(bindMetaDataInfo, dataOutputStream);
        dataOutputStream.flush();
        dataOutputStream.close();
        ToolsLogger.getLogger().log(Level.FINER, "generating DBRM:  collectionName: " + bindMetaDataInfo.getCollectionNameToUse() + " pkgName: " + this.packageName_ + " consistencyToken: " + Arrays.toString(bindMetaDataInfo.getConsistencyToken()) + " packageVersion: " + bindMetaDataInfo.getPackageVersion());
        this.printWriter_.println(Messages.getText("MSG_DBRM_GEN", new Object[]{this.packageName_, bindMetaDataInfo.checkNumericLevelAndReturnIsolation(n2)}));
    }

    private void writeDBRMEntries(BindMetaDataInfo bindMetaDataInfo, DataOutputStream dataOutputStream) throws IOException, SQLException {
        int n2 = 80;
        String string = "DBRM";
        byte[] byArray = null;
        short s2 = 0;
        short s3 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = null;
        String string2 = null;
        short s4 = 0;
        short s5 = 0;
        int n4 = 0;
        int n5 = 0;
        String string3 = null;
        int n6 = 0;
        byte[] byArray2 = this.getInitializedByteArray(n2, (byte)64);
        byte[] byArray3 = new byte[24];
        short s6 = 0;
        int n7 = 0;
        byte[] byArray4 = new byte[22];
        String string4 = null;
        short s7 = 0;
        short s8 = 0;
        short[] sArray = null;
        short s9 = 0;
        byte[] byArray5 = new byte[1];
        short s10 = 0;
        short s11 = 0;
        int n8 = 0;
        short s12 = 0;
        short s13 = 0;
        byte[] byArray6 = new byte[1];
        short s14 = 0;
        long l8 = 0L;
        byte[] byArray7 = null;
        String string5 = bindMetaDataInfo.getEncodingForDBRM();
        StatementDescriptor[] statementDescriptorArray = bindMetaDataInfo.getStatementDescriptorArray();
        for (int i10 = 0; i10 < statementDescriptorArray.length; ++i10) {
            int n9;
            l8 = 0L;
            byArray = string.getBytes(this.hardEncoding_);
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            stringBuffer = new StringBuffer(bindMetaDataInfo.getBindStatementsIncludesReservedSections()[i10]);
            if (stringBuffer.charAt(stringBuffer.length() - 1) != ' ') {
                stringBuffer.append(' ');
            }
            string2 = stringBuffer.toString();
            EscapeLexer escapeLexer = new EscapeLexer(string2);
            String string6 = escapeLexer.upperCaseSQLNotInQuotedString();
            byArray = string6.getBytes(string5);
            n4 = byArray.length;
            int n10 = n4 + 4;
            int n11 = 20;
            int n12 = 4;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            n3 = n11 + n10 + n12 + n13 + n14 + n15;
            SQLJColumnMetaData sQLJColumnMetaData = bindMetaDataInfo.getHostVariableInfo()[i10];
            n5 = sQLJColumnMetaData != null ? sQLJColumnMetaData.getColumns() : 0;
            n3 += 22 * n5;
            for (n9 = 0; n9 < n5; ++n9) {
                string3 = sQLJColumnMetaData.getNames()[n9];
                byArray7 = string3.getBytes(string5);
                n6 = byArray7.length;
                n3 += n6;
            }
            byArray = this.getBytesFromInt(n3);
            System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
            s2 = (short)bindMetaDataInfo.getBindSectionNum()[i10];
            byArray = this.getBytesFromShort(s2);
            System.arraycopy(byArray, 0, byArray3, 8, byArray.length);
            byArray = this.getBytesFromShort(s3);
            System.arraycopy(byArray, 0, byArray3, 10, byArray.length);
            s4 = s2;
            byArray = this.getBytesFromInt(s4);
            System.arraycopy(byArray, 0, byArray3, 12, byArray.length);
            byArray = new byte[2];
            System.arraycopy(byArray, 0, byArray3, 16, byArray.length);
            s5 = 20;
            byArray = this.getBytesFromShort(s5);
            System.arraycopy(byArray, 0, byArray3, 18, byArray.length);
            byArray = this.getBytesFromInt(n4);
            System.arraycopy(byArray, 0, byArray3, 20, byArray.length);
            dataOutputStream.write(byArray3, 0, byArray3.length);
            l8 = byArray3.length;
            byArray = string6.getBytes(string5);
            dataOutputStream.write(byArray, 0, byArray.length);
            l8 += (long)byArray.length;
            s6 = (short)n5;
            dataOutputStream.writeShort(s6);
            dataOutputStream.writeShort(n7);
            l8 += 4L;
            sArray = this.getHostVarColonPositions(bindMetaDataInfo.getBindStatementsIncludesReservedSections()[i10]);
            for (n9 = 0; n9 < n5; ++n9) {
                string4 = sQLJColumnMetaData.getNames()[n9];
                byArray7 = string4.getBytes(string5);
                s7 = (short)(22 + byArray7.length);
                byArray = this.getBytesFromShort(s7);
                System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
                s8 = 7;
                byArray = this.getBytesFromShort(s8);
                System.arraycopy(byArray, 0, byArray4, 2, byArray.length);
                s9 = sArray[n9];
                byArray = this.getBytesFromShort(s9);
                System.arraycopy(byArray, 0, byArray4, 4, byArray.length);
                short s15 = sQLJColumnMetaData.sqlxParmmodes[n9];
                this.setNBRMpvrb(s15, byArray5);
                System.arraycopy(byArray5, 0, byArray4, 6, 1);
                s10 = (short)sQLJColumnMetaData.sqlPrecisions[n9];
                byArray = this.getBytesFromShort(s10);
                System.arraycopy(byArray, 0, byArray4, 7, byArray.length);
                s11 = (short)sQLJColumnMetaData.sqlScales[n9];
                byArray = this.getBytesFromShort(s11);
                System.arraycopy(byArray, 0, byArray4, 9, byArray.length);
                n8 = (int)sQLJColumnMetaData.sqlLengths[n9];
                byArray = this.getBytesFromInt(n8);
                System.arraycopy(byArray, 0, byArray4, 11, byArray.length);
                s12 = (short)sQLJColumnMetaData.sqlTypes[n9];
                byArray = this.getBytesFromShort(s12);
                System.arraycopy(byArray, 0, byArray4, 15, byArray.length);
                s13 = (short)sQLJColumnMetaData.sqlCcsids[n9];
                byArray = this.getBytesFromShort(s13);
                System.arraycopy(byArray, 0, byArray4, 17, byArray.length);
                System.arraycopy(byArray6, 0, byArray4, 19, byArray6.length);
                s14 = (short)byArray7.length;
                byArray = this.getBytesFromShort(s14);
                System.arraycopy(byArray, 0, byArray4, 20, byArray.length);
                dataOutputStream.write(byArray4, 0, byArray4.length);
                l8 += (long)byArray4.length;
                dataOutputStream.write(byArray7, 0, byArray7.length);
                l8 += (long)byArray7.length;
            }
            if (l8 % (long)n2 == 0L) continue;
            dataOutputStream.write(byArray2, 0, (int)((long)n2 - l8 % (long)n2));
        }
    }

    private void writeDBRMHeader(BindMetaDataInfo bindMetaDataInfo, DataOutputStream dataOutputStream, boolean bl2) throws IOException {
        Object object;
        String string = "DBRM";
        byte[] byArray = string.getBytes(this.hardEncoding_);
        String string2 = bindMetaDataInfo.getEncodingForDBRM();
        dataOutputStream.write(byArray, 0, byArray.length);
        int n2 = 160;
        if (bl2) {
            n2 = 320;
        }
        dataOutputStream.writeInt(n2);
        byArray = this.getInitializedByteArray(8, (byte)64);
        byte[] byArray2 = null;
        if (this.user_ != null) {
            byArray2 = this.user_.getBytes(this.hardEncoding_);
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = this.getInitializedByteArray(8, (byte)64);
        byte[] byArray3 = this.packageName_.getBytes(this.hardEncoding_);
        if (!bl2) {
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
        }
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = bindMetaDataInfo.getConsistencyToken();
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = new byte[40];
        byte[] byArray4 = this.getInitializedByteArray(8, (byte)64);
        byArray4[0] = 7;
        byArray4[1] = 0;
        byArray4[2] = -12;
        byArray4[3] = 34;
        byArray4[4] = 0;
        byArray4[5] = 1;
        byArray4[6] = 0;
        byArray4[7] = 0;
        System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
        dataOutputStream.write(byArray, 0, byArray.length);
        int n3 = 0;
        dataOutputStream.writeShort(n3);
        String string3 = "1";
        byArray = string3.getBytes(this.hardEncoding_);
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = new byte[2];
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = this.getInitializedByteArray(1, (byte)-128);
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = new byte[1];
        String string4 = "L";
        if (string2.equalsIgnoreCase("UTF-8")) {
            object = string4.getBytes(this.hardEncoding_);
            System.arraycopy(object, 0, byArray, 0, ((byte[])object).length);
        }
        dataOutputStream.write(byArray, 0, byArray.length);
        object = null;
        object = string2.equalsIgnoreCase("UTF-8") ? (Object)"L" : (Object)"H";
        byArray = ((String)object).getBytes(this.hardEncoding_);
        dataOutputStream.write(byArray, 0, byArray.length);
        int n4 = 0;
        byte[] byArray5 = null;
        byArray = this.getInitializedByteArray(64, (byte)64);
        String string5 = bindMetaDataInfo.getPackageVersion();
        if (string5 != null) {
            byArray5 = string5.getBytes(this.hardEncoding_);
            n4 = (short)byArray5.length;
            System.arraycopy(byArray5, 0, byArray, 0, byArray5.length);
        }
        dataOutputStream.writeShort(n4);
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = new byte[13];
        dataOutputStream.write(byArray, 0, byArray.length);
        byArray = new byte[1];
        dataOutputStream.write(byArray, 0, byArray.length);
        if (bl2) {
            short s2 = (short)byArray3.length;
            byArray = new byte[2];
            dataOutputStream.writeShort(s2);
            byArray = this.getInitializedByteArray(128, (byte)64);
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            byArray = this.getInitializedByteArray(30, (byte)64);
            dataOutputStream.write(byArray, 0, byArray.length);
        }
    }

    private void setNBRMpvrb(int n2, byte[] byArray) {
        int n3 = -128;
        int n4 = 64;
        switch (n2) {
            case 1: {
                byArray[0] = n3;
                break;
            }
            case 4: {
                byArray[0] = n4;
                break;
            }
            case 2: {
                byArray[0] = (byte)(n3 | n4);
                break;
            }
            default: {
                byArray[0] = n3;
            }
        }
    }

    private byte[] getInitializedByteArray(int n2, byte by2) {
        byte[] byArray = new byte[n2];
        for (int i10 = 0; i10 < byArray.length; ++i10) {
            byArray[i10] = by2;
        }
        return byArray;
    }

    private byte[] getBytesFromInt(int n2) {
        return new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
    }

    private byte[] getBytesFromShort(short s2) {
        return new byte[]{(byte)(s2 >> 8), (byte)s2};
    }

    private short[] getHostVarColonPositions(String string) {
        int n2 = string.length();
        int n3 = n2 - 1;
        int n4 = 32;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<Short> vector = new Vector<Short>();
        block5: for (int i10 = 0; i10 < n2; ++i10) {
            n4 = string.charAt(i10);
            switch (n4) {
                case 39: {
                    bl2 = true;
                    ++i10;
                    while (i10 < n3) {
                        if (string.charAt(i10) == '\'') {
                            if (string.charAt(i10 + 1) == '\'') {
                                i10 += 2;
                                continue;
                            }
                            bl2 = false;
                            break;
                        }
                        ++i10;
                    }
                    if (!bl2) continue block5;
                    ++i10;
                    continue block5;
                }
                case 34: {
                    bl3 = true;
                    ++i10;
                    while (i10 < n3) {
                        if (string.charAt(i10) == '\"') {
                            if (string.charAt(i10 + 1) == '\"') {
                                i10 += 2;
                                continue;
                            }
                            bl3 = false;
                            break;
                        }
                        ++i10;
                    }
                    if (!bl3) continue block5;
                    ++i10;
                    continue block5;
                }
                case 58: {
                    if (string.charAt(i10 + 1) != 'H') continue block5;
                    vector.add((short)i10);
                    ++i10;
                }
            }
        }
        short[] sArray = new short[vector.size()];
        for (int i11 = 0; i11 < vector.size(); ++i11) {
            sArray[i11] = (Short)vector.elementAt(i11);
        }
        return sArray;
    }
}

