/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.combobox;

import com.jidesoft.combobox.D;
import com.jidesoft.combobox.PopupPanel;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;

public class ColorChooserPanel
extends PopupPanel
implements ItemListener {
    public static final int PALETTE_COLOR_15 = 0;
    public static final int PALETTE_COLOR_40 = 1;
    public static final int PALETTE_COLOR_216 = 2;
    public static final int PALETTE_GRAY_16 = 3;
    public static final int PALETTE_GRAY_102 = 4;
    public static final int PALETTE_GRAY_256 = 5;
    public static final int PALETTE_CUSTOMIZE = -1;
    private int \u01b1;
    private int \u01af;
    private int \u01b6;
    private Color[] \u01ae;
    private String[] \u01ac;
    private int \u01bf = 18;
    private static Color[] \u01bb;
    private String[] \u01b8;
    private static Color[] \u01b4;
    private String[] \u01b2;
    private static Color[] \u01b3;
    private static Color[] \u01b7;
    private static Color[] \u01b9;
    private static Color[] \u01b5;
    private boolean \u01ab;
    private boolean \u01be;
    protected AbstractButton _defaultColor;
    protected AbstractButton _moreColor;
    protected JPanel _colorPanel;
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    private ColorChooserDialogProvider \u01ba;
    private ColorButton[] \u01b0;
    private Point \u01bd = new Point(0, 0);
    private static final int \u01bc = -1;
    private static final int \u01ad = -2;

    public ColorChooserPanel() {
        this(1, false, true);
    }

    public ColorChooserPanel(int n2) {
        this(n2, false, true);
    }

    public ColorChooserPanel(int n2, boolean bl, boolean bl2) {
        this(n2, bl, bl2, Locale.getDefault());
    }

    public ColorChooserPanel(int n2, boolean bl, boolean bl2, Locale locale) {
        this.\u01b1 = n2;
        this.\u01be = bl;
        this.\u01ab = bl2;
        this.initColors();
        this.initComponent();
        this.addItemListener(this);
        this.setLocale(locale);
    }

    public ColorChooserPanel(Color[] colorArray, String[] stringArray, boolean bl, boolean bl2) {
        this(colorArray, stringArray, bl, bl2, Locale.getDefault());
    }

    public ColorChooserPanel(Color[] colorArray, String[] stringArray, boolean bl, boolean bl2, Locale locale) {
        this(colorArray, stringArray, 0, 0, bl, bl2, locale);
    }

    public ColorChooserPanel(Color[] colorArray, String[] stringArray, int n2, int n3, boolean bl, boolean bl2, Locale locale) {
        if (colorArray.length == 0) {
            throw new IllegalArgumentException("The length of colors array passed in to ColorChooserPanel is 0.");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("The length of names array passed in to ColorChooserPanel is 0.");
        }
        if (colorArray.length != stringArray.length) {
            throw new IllegalArgumentException("The length of colors array passed in to ColorChooserPanel is not the same with the length of names array.");
        }
        if (colorArray.length < n2) {
            throw new IllegalArgumentException("The length of colors array passed in to ColorChooserPanel is less than the input value of rows");
        }
        this.\u01b1 = -1;
        this.\u01be = bl;
        this.\u01ab = bl2;
        this.\u01ae = colorArray;
        this.\u01ac = stringArray;
        if (n3 <= 0 || n2 <= 0) {
            this.\u01b6 = ColorChooserPanel.\u0105(colorArray.length);
            this.\u01af = colorArray.length / this.\u01b6;
        } else {
            this.\u01af = n2;
            this.\u01b6 = n3;
        }
        this.initComponent();
        this.addItemListener(this);
        this.setLocale(locale);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        LookAndFeel.installColorsAndFont(this, "TextField.background", "TextField.foreground", "TextField.font");
    }

    protected void initColors() {
        switch (this.\u01b1) {
            case 0: {
                this.\u01af = 3;
                this.\u01b6 = 5;
                this.\u01ae = ColorChooserPanel.\u0120();
                this.\u01ac = this.\u011c();
                break;
            }
            case 1: {
                this.\u01af = 5;
                this.\u01b6 = 8;
                this.\u01ae = ColorChooserPanel.\u0122();
                this.\u01ac = this.\u0121();
                break;
            }
            case 2: {
                this.\u01af = 12;
                this.\u01b6 = 18;
                this.\u01ae = ColorChooserPanel.\u011e();
                this.\u01ac = null;
                break;
            }
            case 3: {
                this.\u01af = 2;
                this.\u01b6 = 8;
                this.\u01ae = ColorChooserPanel.getPaletteGrayScale16();
                this.\u01ac = null;
                break;
            }
            case 4: {
                this.\u01af = 6;
                this.\u01b6 = 17;
                this.\u01ae = ColorChooserPanel.getPaletteGrayScale120();
                this.\u01ac = null;
                break;
            }
            case 5: {
                this.\u01af = 16;
                this.\u01b6 = 16;
                this.\u01ae = ColorChooserPanel.getPaletteGrayScale256();
                this.\u01ac = null;
            }
        }
    }

    protected static Color[] getPaletteGrayScale16() {
        if (\u01b7 == null) {
            \u01b7 = new Color[16];
            for (int i2 = 0; i2 < \u01b7.length; ++i2) {
                int n2 = i2 * 16;
                ColorChooserPanel.\u01b7[i2] = new Color(n2, n2, n2);
            }
        }
        return \u01b7;
    }

    protected static Color[] getPaletteGrayScale120() {
        if (\u01b9 == null) {
            \u01b9 = new Color[102];
            int n2 = 0;
            for (int i2 = 0; i2 < \u01b9.length; ++i2) {
                ColorChooserPanel.\u01b9[i2] = new Color(n2, n2, n2);
                if (i2 % 2 == 0) {
                    n2 += 3;
                    continue;
                }
                n2 += 2;
            }
        }
        return \u01b9;
    }

    protected static Color[] getPaletteGrayScale256() {
        if (\u01b5 == null) {
            \u01b5 = new Color[256];
            for (int i2 = 0; i2 < \u01b5.length; ++i2) {
                ColorChooserPanel.\u01b5[i2] = new Color(i2, i2, i2);
            }
        }
        return \u01b5;
    }

    public Color[] getPossibleColors() {
        return this.\u01ae;
    }

    public String[] getPossibleColorsName() {
        return this.\u01ac;
    }

    public Color getSelectedColor() {
        Object object = this.getSelectedObject();
        if (object instanceof Color) {
            return (Color)object;
        }
        return null;
    }

    public void setSelectedColor(Color color) {
        AbstractButton abstractButton = this.\u0101(this.getSelectedColor());
        if (abstractButton != null) {
            abstractButton.getModel().setRollover(false);
        }
        if (this._moreColor != null) {
            this._moreColor.getModel().setRollover(false);
        }
        if (this._defaultColor != null) {
            this._defaultColor.getModel().setRollover(false);
        }
        this.setSelectedObject(color);
    }

    private boolean \u011a() {
        return this.\u01ab;
    }

    private boolean \u011d() {
        return this.\u01be;
    }

    protected void initComponent() {
        LookAndFeel.installColorsAndFont(this, "TextField.background", "TextField.foreground", "TextField.font");
        C c2 = new C();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        LookAndFeel.installColorsAndFont(jPanel, "TextField.background", "TextField.foreground", "TextField.font");
        jPanel.setLayout(new BorderLayout(4, 4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this._colorPanel = new NullPanel(new GridLayout(this.\u01af, this.\u01b6, 0, 0));
        this.\u01b0 = new ColorButton[this.\u01ae.length];
        for (int i2 = 0; i2 < this.\u01ae.length; ++i2) {
            this.\u01b0[i2] = new ColorButton(this.\u01ae[i2], i2){

                @Override
                public String getToolTipText(MouseEvent mouseEvent) {
                    if (ColorChooserPanel.this.\u01ac != null && this.\u0166() < ColorChooserPanel.this.\u01ac.length) {
                        return ColorChooserPanel.this.\u01ac[this.\u0166()];
                    }
                    return ObjectConverterManager.toString(this.getColor());
                }
            };
            if (this.\u01ac != null && i2 < this.\u01ac.length) {
                this.\u01b0[i2].setToolTipText(this.\u01ac[i2]);
            } else {
                this.\u01b0[i2].setToolTipText(ObjectConverterManager.toString(this.\u01ae[i2]));
            }
            this.\u01b0[i2].setPreferredSize(new Dimension(this.\u01bf, this.\u01bf));
            this._colorPanel.add(this.\u01b0[i2]);
            this.\u01b0[i2].addActionListener(c2);
        }
        jPanel.add((Component)this._colorPanel, "Center");
        if (this.\u011a()) {
            this._defaultColor = this.createButton("Color.none");
            this._defaultColor.setOpaque(false);
            jPanel.add((Component)this._defaultColor, "First");
            this._defaultColor.addActionListener(c2);
        }
        if (this.\u011d()) {
            this._moreColor = this.createButton("Color.moreColors");
            this._moreColor.setOpaque(false);
            jPanel.add((Component)this._moreColor, "Last");
            this._moreColor.addActionListener(new A());
        }
        this.add(jPanel);
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        this.registerKeyStrokes();
    }

    protected AbstractButton createButton(String string) {
        JideButton jideButton = new JideButton(this.getResourceString(string));
        jideButton.setDefaultForeground(new Color(UIDefaultsLookup.getColor("controlText").getRGB()));
        return jideButton;
    }

    protected Color showColorChooser(Component component, String string, Color color) {
        ColorChooserDialogProvider colorChooserDialogProvider = this.getColorChooserDialogProvider();
        if (colorChooserDialogProvider != null) {
            return colorChooserDialogProvider.showColorChooserDialog(component, string, color);
        }
        return ColorChooserPanel.showColorChooserDialog(component, string, color);
    }

    public ColorChooserDialogProvider getColorChooserDialogProvider() {
        return this.\u01ba;
    }

    public void setColorChooserDialogProvider(ColorChooserDialogProvider colorChooserDialogProvider) {
        this.\u01ba = colorChooserDialogProvider;
    }

    public ColorButton[] getColorButtons() {
        return this.\u01b0;
    }

    public static Color showColorChooserDialog(Component component, String string, Color color) throws HeadlessException {
        B b2;
        JColorChooser jColorChooser = new JColorChooser(color != null ? color : Color.white);
        JDialog jDialog = JColorChooser.createDialog(component, string, true, jColorChooser, b2 = new B(jColorChooser), null);
        JComponent jComponent = JideSwingUtilities.getFirstJComponent(jDialog);
        if (jComponent != null) {
            jComponent.putClientProperty("JidePopup.actualOwner", component);
        }
        jDialog.setVisible(true);
        return b2.\u0101();
    }

    private AbstractButton \u0101(Color color) {
        if (color == null) {
            return this._defaultColor;
        }
        for (int i2 = 0; i2 < this._colorPanel.getComponentCount(); ++i2) {
            Component component = this._colorPanel.getComponent(i2);
            if (!(component instanceof ColorButton) || !color.equals(((ColorButton)component).getColor())) continue;
            return (ColorButton)component;
        }
        return null;
    }

    private void \u011f() {
        for (int i2 = 0; i2 < this._colorPanel.getComponentCount(); ++i2) {
            Component component = this._colorPanel.getComponent(i2);
            if (!(component instanceof ColorButton)) continue;
            ((ColorButton)component).setSelected(false);
            ((ColorButton)component).getModel().setRollover(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getItem() instanceof Color) {
            if (itemEvent.getStateChange() == 1) {
                AbstractButton abstractButton = this.\u0101((Color)itemEvent.getItem());
                if (abstractButton != null) {
                    abstractButton.setSelected(true);
                    abstractButton.repaint();
                }
            } else if (itemEvent.getStateChange() == 2) {
                this.\u011f();
            }
        }
    }

    protected void prevCell() {
        int n2 = this.\u011b();
        this.\u0101(n2, false);
        n2 = n2 == 0 ? (this._defaultColor != null ? -1 : (this._moreColor != null ? -2 : this.getPossibleColors().length - 1)) : (n2 == -1 ? (this._moreColor != null ? -2 : this.getPossibleColors().length - 1) : (n2 <= -2 ? this.getPossibleColors().length - 1 : --n2));
        this.\u0101(n2, true);
    }

    protected void nextCell() {
        int n2 = this.\u011b();
        this.\u0101(n2, false);
        n2 = n2 == this.getPossibleColors().length - 1 ? (this._moreColor != null ? -2 : (this._defaultColor != null ? -1 : 0)) : (n2 <= -2 ? (this._defaultColor != null ? -1 : 0) : (n2 == -1 ? 0 : ++n2));
        this.\u0101(n2, true);
    }

    protected void prevRow() {
        int n2 = this.\u011b();
        this.\u0101(n2, false);
        n2 = n2 == -1 ? (this._moreColor != null ? -2 : this.\u01bd.x + (this.\u01af - 1) * this.\u01b6) : (n2 <= -2 ? this.\u01bd.x + (this.\u01af - 1) * this.\u01b6 : (n2 >= 0 && n2 < this.\u01b6 ? (this._defaultColor != null ? -1 : (this._moreColor != null ? -2 : this.\u01bd.x + (this.\u01af - 1) * this.\u01b6)) : (n2 -= this.\u01b6)));
        this.\u0101(n2, true);
    }

    protected void nextRow() {
        int n2 = this.\u011b();
        this.\u0101(n2, false);
        n2 = n2 >= (this.\u01af - 1) * this.\u01b6 && n2 < this.\u01af * this.\u01b6 ? (this._moreColor != null ? -2 : (this._defaultColor != null ? -1 : this.\u01bd.x)) : (n2 <= -2 ? (this._defaultColor != null ? -1 : this.\u01bd.x) : (n2 == -1 ? this.\u01bd.x : (n2 += this.\u01b6)));
        this.\u0101(n2, true);
    }

    protected void firstCell() {
        int n2 = this.\u011b();
        this.\u0101(n2, false);
        n2 = 0;
        this.\u0101(n2, true);
    }

    protected void lastCell() {
        int n2 = this.\u011b();
        this.\u0101(n2, false);
        n2 = this.getPossibleColors().length - 1;
        this.\u0101(n2, true);
    }

    private int \u011b() {
        if (this._defaultColor != null && this._defaultColor.isSelected()) {
            return -1;
        }
        if (this._moreColor != null && this._moreColor.isSelected()) {
            return -2;
        }
        for (int i2 = 0; i2 < this._colorPanel.getComponentCount(); ++i2) {
            Component component = this._colorPanel.getComponent(i2);
            if (!(component instanceof ColorButton) || !((ColorButton)component).isSelected()) continue;
            return i2;
        }
        return -3;
    }

    private void \u0101(int n2, boolean bl) {
        if (n2 == -1 && this._defaultColor != null) {
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, this.getSelectedColor(), null);
            this._defaultColor.setSelected(bl);
            return;
        }
        if (n2 == -2 && this._moreColor != null) {
            this._moreColor.setSelected(bl);
            return;
        }
        if (n2 < 0) {
            n2 = this.\u01bd.x;
        }
        this.\u01bd.x = n2 % this.\u01b6;
        this.\u01bd.y = n2 / this.\u01b6;
        Component component = this._colorPanel.getComponent(n2);
        if (component instanceof ColorButton) {
            ((ColorButton)component).setSelected(bl);
            if (bl) {
                this.firePropertyChange(PROPERTY_SELECTED_COLOR, null, ((ColorButton)component).getColor());
            }
        }
    }

    protected void registerKeyStrokes() {
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -2634180858281447699L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.prevCell();
            }
        }, KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -3414649134282507209L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.nextCell();
            }
        }, KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -4683903665679849538L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.prevRow();
            }
        }, KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 6791819790416330058L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.nextRow();
            }
        }, KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = 3756684464718994582L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.firstCell();
            }
        }, KeyStroke.getKeyStroke(36, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -1347774392133100194L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorChooserPanel.this.lastCell();
            }
        }, KeyStroke.getKeyStroke(35, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){
            private static final long \u0102 = -49899669707624010L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = ColorChooserPanel.this.\u011b();
                if (n2 == -1) {
                    ColorChooserPanel.this.setSelectedColor(null);
                } else if (n2 == -2) {
                    ColorChooserPanel.this._moreColor.doClick();
                } else if (n2 != -3) {
                    ColorChooserPanel.this.setSelectedColor(ColorChooserPanel.this.getPossibleColors()[n2]);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 1);
    }

    private static Color[] \u0120() {
        if (\u01b4 == null) {
            \u01b4 = new Color[]{new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 0, 255), new Color(0, 0, 255), new Color(255, 0, 0), new Color(0, 0, 128), new Color(0, 128, 128), new Color(0, 128, 0), new Color(0, 128, 0), new Color(128, 0, 0), new Color(128, 128, 0), new Color(128, 128, 128), new Color(192, 192, 192), new Color(0, 0, 0)};
        }
        return \u01b4;
    }

    private String[] \u011c() {
        if (this.\u01b2 == null) {
            Locale locale = this.getLocale();
            this.\u01b2 = new String[]{this.getResourceString("Color.Yellow", locale), this.getResourceString("Color.BrightGreen", locale), this.getResourceString("Color.Turquoise", locale), this.getResourceString("Color.Pink", locale), this.getResourceString("Color.Blue", locale), this.getResourceString("Color.Red", locale), this.getResourceString("Color.DarkBlue", locale), this.getResourceString("Color.Teal", locale), this.getResourceString("Color.Green", locale), this.getResourceString("Color.Violet", locale), this.getResourceString("Color.DarkRed", locale), this.getResourceString("Color.DarkYellow", locale), this.getResourceString("Color.Gray-40", locale), this.getResourceString("Color.Gray-25", locale), this.getResourceString("Color.Black")};
        }
        return this.\u01b2;
    }

    private static Color[] \u0122() {
        if (\u01bb == null) {
            \u01bb = new Color[]{new Color(0, 0, 0), new Color(153, 51, 0), new Color(51, 51, 0), new Color(0, 51, 0), new Color(0, 51, 102), new Color(0, 0, 128), new Color(51, 51, 153), new Color(51, 51, 51), new Color(128, 0, 0), new Color(255, 102, 0), new Color(128, 128, 0), new Color(0, 128, 0), new Color(0, 128, 128), new Color(0, 0, 255), new Color(102, 102, 153), new Color(128, 128, 128), new Color(255, 0, 0), new Color(255, 153, 0), new Color(153, 204, 0), new Color(51, 153, 102), new Color(51, 204, 204), new Color(51, 102, 255), new Color(128, 0, 128), new Color(153, 153, 153), new Color(255, 0, 255), new Color(255, 204, 0), new Color(255, 255, 0), new Color(0, 255, 0), new Color(0, 255, 255), new Color(0, 204, 255), new Color(153, 51, 102), new Color(192, 192, 192), new Color(255, 153, 204), new Color(255, 204, 153), new Color(255, 255, 153), new Color(204, 255, 204), new Color(204, 255, 255), new Color(153, 204, 255), new Color(204, 153, 255), new Color(255, 255, 255)};
        }
        return \u01bb;
    }

    private String[] \u0121() {
        if (this.\u01b8 == null) {
            Locale locale = this.getLocale();
            this.\u01b8 = new String[]{this.getResourceString("Color.Black", locale), this.getResourceString("Color.Brown", locale), this.getResourceString("Color.OliveGreen", locale), this.getResourceString("Color.DarkGreen", locale), this.getResourceString("Color.DarkTeal", locale), this.getResourceString("Color.DarkBlue", locale), this.getResourceString("Color.Indigo", locale), this.getResourceString("Color.Gray-80", locale), this.getResourceString("Color.DarkRed", locale), this.getResourceString("Color.Orange", locale), this.getResourceString("Color.DarkYellow", locale), this.getResourceString("Color.Green", locale), this.getResourceString("Color.Teal", locale), this.getResourceString("Color.Blue", locale), this.getResourceString("Color.Blue-Gray", locale), this.getResourceString("Color.Gray-50", locale), this.getResourceString("Color.Red", locale), this.getResourceString("Color.LightOrange", locale), this.getResourceString("Color.Lime", locale), this.getResourceString("Color.SeaGreen", locale), this.getResourceString("Color.Aqua", locale), this.getResourceString("Color.LightBlue", locale), this.getResourceString("Color.Violet", locale), this.getResourceString("Color.Gray-40", locale), this.getResourceString("Color.Pink", locale), this.getResourceString("Color.Gold", locale), this.getResourceString("Color.Yellow", locale), this.getResourceString("Color.BrightGreen", locale), this.getResourceString("Color.Turquoise", locale), this.getResourceString("Color.SkyBlue", locale), this.getResourceString("Color.Plum", locale), this.getResourceString("Color.Gray-25", locale), this.getResourceString("Color.Rose", locale), this.getResourceString("Color.Tan", locale), this.getResourceString("Color.LightYellow", locale), this.getResourceString("Color.LightGreen", locale), this.getResourceString("Color.LightTurquoise", locale), this.getResourceString("Color.PaleBlue", locale), this.getResourceString("Color.Lavender", locale), this.getResourceString("Color.White")};
        }
        return this.\u01b8;
    }

    private static Color[] \u011e() {
        if (\u01b3 == null) {
            \u01b3 = new Color[]{new Color(0xFFFFFF), new Color(0xFFFFCC), new Color(0xFFFF99), new Color(0xFFFF66), new Color(0xFFFF33), new Color(0xFFFF00), new Color(0xCCFFFF), new Color(0xCCFFCC), new Color(0xCCFF99), new Color(0xCCFF66), new Color(0xCCFF33), new Color(0xCCFF00), new Color(0x99FFFF), new Color(0x99FFCC), new Color(0x99FF99), new Color(0x66FFFF), new Color(0x99FF66), new Color(0x99FF33), new Color(0x66FFCC), new Color(0xFFCCFF), new Color(0x99FF00), new Color(0x33FFFF), new Color(0xFFCCCC), new Color(0x33FFCC), new Color(65535), new Color(0x66FF99), new Color(0xFFCC99), new Color(0x66FF66), new Color(0x66FF33), new Color(65484), new Color(0x66FF00), new Color(0x33FF99), new Color(0xFFCC66), new Color(0xFFCC33), new Color(0xCCCCFF), new Color(0x33FF66), new Color(0x33FF33), new Color(65433), new Color(0xFFCC00), new Color(0x33FF00), new Color(65382), new Color(65331), new Color(65280), new Color(0xCCCCCC), new Color(0xCCCC99), new Color(0x99CCFF), new Color(0xCCCC66), new Color(0xCCCC00), new Color(0xCCCC33), new Color(0x99CCCC), new Color(0xFF99FF), new Color(0x99CC99), new Color(0x66CCFF), new Color(0xFF99CC), new Color(0x99CC66), new Color(0x66CCCC), new Color(0x99CC33), new Color(52479), new Color(0x33CCFF), new Color(0x99CC00), new Color(0xFF9999), new Color(0x66CC99), new Color(0xFF9966), new Color(0x66CC66), new Color(0x33CCCC), new Color(0xCC99FF), new Color(52428), new Color(0xFF9933), new Color(0xFF9900), new Color(0x66CC33), new Color(0x66CC00), new Color(0x33CC99), new Color(52377), new Color(0xCC99CC), new Color(0x33CC66), new Color(52326), new Color(0xCC9999), new Color(0xFF66FF), new Color(0x33CC33), new Color(0x33CC00), new Color(0xCC9966), new Color(52275), new Color(0x9999FF), new Color(52224), new Color(0xCC9933), new Color(0xCC9900), new Color(0xFF66CC), new Color(0x9999CC), new Color(0xFF6699), new Color(0x999999), new Color(0x6699FF), new Color(0xFF6666), new Color(0xCC66FF), new Color(0x999966), new Color(0x6699CC), new Color(0x999933), new Color(0xFFCC33), new Color(0xFF6600), new Color(0xFF33FF), new Color(0x3399FF), new Color(0x999900), new Color(0x669999), new Color(0xCC66CC), new Color(39423), new Color(0xFF33CC), new Color(0x3399CC), new Color(0xCC6699), new Color(0x669966), new Color(0xFF00FF), new Color(0x339999), new Color(0x669933), new Color(0x669900), new Color(0xFF3399), new Color(39372), new Color(0x9966FF), new Color(0xCC6666), new Color(39321), new Color(0xCC6633), new Color(0xCC6600), new Color(0x339966), new Color(0xFF00CC), new Color(0xFF3366), new Color(39270), new Color(0xCC33FF), new Color(0xFF3333), new Color(0x339933), new Color(39219), new Color(0x9966CC), new Color(0xFF3300), new Color(0xFF0099), new Color(0x339900), new Color(39168), new Color(0x6666FF), new Color(0xCC33CC), new Color(0xFF0066), new Color(0x996699), new Color(0xFF0033), new Color(0xFF0000), new Color(0xCC00FF), new Color(0xCC3399), new Color(0x996666), new Color(0x6666CC), new Color(0x996633), new Color(0x996600), new Color(0x3366FF), new Color(0xCC3366), new Color(0xCC00CC), new Color(0x9933FF), new Color(26367), new Color(0x666699), new Color(0xCC3333), new Color(0xCC3300), new Color(0x3366CC), new Color(0xCC0099), new Color(0x9933CC), new Color(0x666666), new Color(0x666633), new Color(26316), new Color(0x9900FF), new Color(0x666600), new Color(0xCC0066), new Color(0x336699), new Color(0x993399), new Color(0xCC0033), new Color(0x6633FF), new Color(0x336666), new Color(26265), new Color(0xCC0000), new Color(0x993366), new Color(0x9900CC), new Color(0x336633), new Color(26214), new Color(0x336600), new Color(0x6633CC), new Color(0x3333FF), new Color(26163), new Color(0x993333), new Color(0x993300), new Color(0x6600FF), new Color(0x990099), new Color(26112), new Color(13311), new Color(0x663399), new Color(39270), new Color(0x3333CC), new Color(0x663366), new Color(0x6600CC), new Color(0x990033), new Color(13260), new Color(0x990000), new Color(0x3300FF), new Color(0x663333), new Color(0x663300), new Color(0x660099), new Color(255), new Color(0x333399), new Color(0x3300CC), new Color(13209), new Color(0x333300), new Color(0x660066), new Color(0x333333), new Color(13158), new Color(204), new Color(0x660033), new Color(0x333300), new Color(0x660000), new Color(0x330099), new Color(13107), new Color(13056), new Color(153), new Color(0x330066), new Color(0x330033), new Color(102), new Color(0x330000), new Color(51), new Color(0)};
        }
        return \u01b3;
    }

    private static int \u0105(int n2) {
        int n3;
        for (int i2 = n3 = (int)Math.ceil(Math.sqrt(n2)); i2 <= n2; ++i2) {
            int n4 = n2 % i2;
            if (n4 != 0) continue;
            return i2;
        }
        return n3 + 1;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.\u01b2 != null) {
            this.\u01b2 = null;
            this.\u01ac = this.\u0121();
        }
        if (this.\u01b8 != null) {
            this.\u01b8 = null;
            this.\u01ac = this.\u0121();
        }
        if (this._defaultColor != null) {
            this._defaultColor.setText(this.getResourceString("Color.none", locale));
        }
        if (this._moreColor != null) {
            this._moreColor.setText(this.getResourceString("Color.moreColors", locale));
        }
    }

    protected String getResourceString(String string) {
        return D.\u0101(this.getLocale()).getString(string);
    }

    protected String getResourceString(String string, Locale locale) {
        return D.\u0101(locale).getString(string);
    }

    void \u0104(int n2) {
        for (ColorButton colorButton : this.getColorButtons()) {
            Color color = colorButton.getColor();
            if (color.getAlpha() != n2) {
                colorButton.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), n2));
            }
            colorButton.invalidate();
        }
        this.repaint();
    }

    public class ColorButton
    extends JideButton {
        private static final int \u05de = 3;
        private Color \u05df;
        private int \u05e0;

        public ColorButton(Color color, int n2) {
            this.setColor(color);
            this.\u010c(n2);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setOpaque(false);
        }

        public Color getColor() {
            return this.\u05df;
        }

        public void setColor(Color color) {
            this.\u05df = color;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n2 = this.getWidth() - 1;
            int n3 = this.getHeight() - 1;
            graphics.setColor(Color.gray);
            graphics.drawRect(3, 3, n2 - 6, n3 - 6);
            graphics.setColor(this.\u05df);
            graphics.fillRect(4, 4, n2 - 6 - 1, n3 - 6 - 1);
        }

        int \u0166() {
            return this.\u05e0;
        }

        void \u010c(int n2) {
            this.\u05e0 = n2;
        }
    }

    private class C
    implements ActionListener {
        private C() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof ColorButton) {
                ColorButton colorButton = (ColorButton)actionEvent.getSource();
                ColorChooserPanel.this.setSelectedColor(colorButton.getColor());
                colorButton.repaint();
            } else if (actionEvent.getSource().equals(ColorChooserPanel.this._defaultColor)) {
                ColorChooserPanel.this.setSelectedColor(null);
            }
        }
    }

    private class A
    implements ActionListener {
        private A() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Component component = (Component)actionEvent.getSource();
            Color color = ColorChooserPanel.this.showColorChooser(component, ColorChooserPanel.this.getResourceString("Color.dialogTitle", ColorChooserPanel.this.getLocale()), ColorChooserPanel.this.getSelectedColor());
            if (color != null) {
                ColorChooserPanel.this.setSelectedColor(color);
            }
        }
    }

    private static class B
    implements ActionListener,
    Serializable {
        JColorChooser \u0102;
        Color \u0101;
        private static final long \u0103 = 4787690316171110620L;

        public B(JColorChooser jColorChooser) {
            this.\u0102 = jColorChooser;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.\u0101 = this.\u0102.getColor();
        }

        public Color \u0101() {
            return this.\u0101;
        }
    }

    public static interface ColorChooserDialogProvider {
        public Color showColorChooserDialog(Component var1, String var2, Color var3);
    }
}

