/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.fit;

import com.jidesoft.chart.AboveBoundsException;
import com.jidesoft.chart.BelowBoundsException;
import com.jidesoft.chart.ChartBoundsException;
import com.jidesoft.chart.ChartException;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.range.Positionable;
import java.util.ArrayList;
import java.util.List;

public class FunctionMap {
    public static double getXApproximately(ChartModel chartModel, double d2) throws ChartException {
        boolean bl = false;
        int n2 = chartModel.getPointCount();
        if (n2 <= 1) {
            throw new IllegalStateException("Too few points in model to estimate an X value");
        }
        Double d3 = Double.MAX_VALUE;
        Double d4 = Double.MIN_VALUE;
        for (int i2 = 1; i2 < n2; ++i2) {
            Positionable positionable;
            Chartable chartable = chartModel.getPoint(i2 - 1);
            Chartable chartable2 = chartModel.getPoint(i2);
            if (chartable == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + (i2 - 1));
            }
            if (chartable2 == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + i2);
            }
            double d5 = Math.min(chartable.getY().position(), chartable2.getY().position());
            double d6 = Math.max(chartable.getY().position(), chartable2.getY().position());
            int n3 = chartable.getY().position() < chartable2.getY().position() ? 1 : -1;
            Positionable positionable2 = n3 == 1 ? chartable.getX() : chartable2.getX();
            Positionable positionable3 = positionable = n3 == 1 ? chartable2.getX() : chartable.getX();
            if (d5 <= d2 && d6 >= d2) {
                double d7 = (d6 - d5) / (positionable.position() - positionable2.position());
                double d8 = positionable2.position() + (d2 - d5) / d7;
                return d8;
            }
            if (d2 < d5) {
                bl = true;
            }
            d3 = Math.min(d3, positionable2.position());
            d4 = Math.max(d4, positionable.position());
        }
        if (bl) {
            throw new BelowBoundsException((double)d3, d2 + " is less than the value of the first line segment in " + chartModel);
        }
        throw new AboveBoundsException((double)d4, d2 + " is greater than the value of the first line segment in " + chartModel);
    }

    public static List<Double> getXsApproximately(ChartModel chartModel, double d2) throws BelowBoundsException, AboveBoundsException {
        boolean bl = false;
        int n2 = chartModel.getPointCount();
        if (n2 <= 1) {
            throw new IllegalStateException("Too few points in model to estimate an X value");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d3 = Double.MAX_VALUE;
        Double d4 = Double.MIN_VALUE;
        for (int i2 = 1; i2 < n2; ++i2) {
            Chartable chartable = chartModel.getPoint(i2 - 1);
            Chartable chartable2 = chartModel.getPoint(i2);
            Positionable positionable = chartable.getY();
            Positionable positionable2 = chartable2.getY();
            Positionable positionable3 = chartable.getX();
            Positionable positionable4 = chartable2.getX();
            if (positionable.position() <= d2 && positionable2.position() >= d2) {
                double d5 = (positionable2.position() - positionable.position()) / (positionable4.position() - positionable3.position());
                double d6 = positionable3.position() + (d2 - positionable.position()) / d5;
                arrayList.add(d6);
            } else if (d2 < positionable.position()) {
                bl = true;
            }
            d3 = Math.min(d3, positionable3.position());
            d4 = Math.max(d4, positionable4.position());
        }
        if (arrayList.size() == 0) {
            if (bl) {
                throw new BelowBoundsException((double)d3, d2 + " is less than the value of the first line segment in " + chartModel);
            }
            throw new AboveBoundsException((double)d4, d2 + " is greater than the value of the first line segment in " + chartModel);
        }
        return arrayList;
    }

    public static List<Double> getYsApproximately(ChartModel chartModel, double d2) throws BelowBoundsException, AboveBoundsException {
        boolean bl = false;
        int n2 = chartModel.getPointCount();
        if (n2 <= 1) {
            throw new IllegalStateException("Too few points in model to estimate a Y value");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        Double d3 = Double.MAX_VALUE;
        Double d4 = Double.MIN_VALUE;
        for (int i2 = 1; i2 < n2; ++i2) {
            Chartable chartable = chartModel.getPoint(i2 - 1);
            Chartable chartable2 = chartModel.getPoint(i2);
            Positionable positionable = chartable.getX();
            Positionable positionable2 = chartable2.getX();
            Positionable positionable3 = chartable.getY();
            Positionable positionable4 = chartable2.getY();
            if (positionable.position() <= d2 && positionable2.position() >= d2) {
                double d5 = (positionable4.position() - positionable3.position()) / (positionable2.position() - positionable.position());
                double d6 = positionable3.position() + (d2 - positionable.position()) * d5;
                arrayList.add(d6);
            } else if (d2 < positionable.position()) {
                bl = true;
            }
            d3 = Math.min(d3, positionable.position());
            d4 = Math.max(d4, positionable2.position());
        }
        if (arrayList.size() == 0) {
            if (bl) {
                throw new BelowBoundsException((double)d3, d2 + " is less than the value of the first line segment in " + chartModel);
            }
            throw new AboveBoundsException((double)d4, d2 + " is greater than the value of the first line segment in " + chartModel);
        }
        return arrayList;
    }

    public static double getYApproximately(ChartModel chartModel, double d2) throws ChartException {
        if (chartModel == null) {
            throw new NullPointerException("Cannot compute y values from a null ChartModel!");
        }
        int n2 = chartModel.getPointCount();
        if (n2 <= 1) {
            throw new ChartException("Too few points in model to estimate a Y value");
        }
        Double d3 = Double.MAX_VALUE;
        Double d4 = Double.MIN_VALUE;
        for (int i2 = 1; i2 < n2; ++i2) {
            Chartable chartable = chartModel.getPoint(i2 - 1);
            Chartable chartable2 = chartModel.getPoint(i2);
            if (chartable == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + (i2 - 1));
            }
            if (chartable2 == null) {
                throw new ChartException("ChartModel contains a null Chartable at index " + i2);
            }
            double d5 = Math.min(chartable.getX().position(), chartable2.getX().position());
            double d6 = Math.max(chartable.getX().position(), chartable2.getX().position());
            int n3 = chartable.getX().position() < chartable2.getX().position() ? 1 : -1;
            Positionable positionable = n3 == 1 ? chartable.getY() : chartable2.getY();
            Positionable positionable2 = chartable2.getY();
            if (d5 <= d2 && d6 >= d2) {
                double d7 = (double)n3 * (chartable2.getY().position() - chartable.getY().position()) / (d6 - d5);
                double d8 = positionable.position() + (d2 - d5) * d7;
                return d8;
            }
            d3 = Math.min(d3, d5);
            d4 = Math.max(d4, d6);
        }
        if (d2 < d3) {
            throw new BelowBoundsException((double)d3, d2 + " is less than " + d3 + ", which is the value of the first line segment in " + chartModel);
        }
        if (d2 > d4) {
            throw new AboveBoundsException((double)d4, d2 + " is greater than " + d4 + ", which is the value of the last line segment in " + chartModel);
        }
        throw new ChartBoundsException("Out of bounds with x = " + d2);
    }
}

