/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.axis;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.UserToPixelTransform;
import com.jidesoft.chart.annotation.AutoPositionedLabel;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.Tick;
import com.jidesoft.chart.render.AxisRenderer;
import com.jidesoft.chart.util.Rotation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisComponent
extends JPanel {
    private static final long \u0102 = -3138493763021996631L;
    public static final String PROPERTY_AXIS = "Axis";
    public static final String PROPERTY_CHART = "Chart";
    private Axis \u0105;
    private Chart \u0109;
    private Orientation \u0101 = Orientation.vertical;
    private JViewport \u0108;
    private Point \u0104;
    private final B \u0107 = new B();
    private final A \u0106 = new A();
    private Rectangle \u010a = null;
    private final int \u0103 = 40;
    private final int \u010b = 400;

    public AxisComponent() {
        Dimension dimension = new Dimension(40, 400);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public AxisComponent(Chart chart, Axis axis) {
        this();
        this.setChart(chart);
        this.setAxis(axis);
    }

    public Axis getAxis() {
        return this.\u0105;
    }

    public void setAxis(Axis axis) {
        Axis axis2 = this.\u0105;
        if (axis2 != null) {
            axis2.removePropertyChangeListener(this.\u0106);
        }
        this.\u0105 = axis;
        axis.addPropertyChangeListener(this.\u0106);
        this.firePropertyChange(PROPERTY_AXIS, axis2, axis);
    }

    public Chart getChart() {
        return this.\u0109;
    }

    public void setChart(Chart chart) {
        Chart chart2 = this.\u0109;
        if (this.\u0108 != null) {
            this.\u0108.removeChangeListener(this.\u0107);
        }
        this.\u0109 = chart;
        this.\u0108 = this.\u0101(chart);
        if (this.\u0108 != null) {
            this.\u0108.addChangeListener(this.\u0107);
        }
        this.firePropertyChange(PROPERTY_CHART, chart2, chart);
    }

    private JViewport \u0101(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JViewport) {
            return (JViewport)component;
        }
        return this.\u0101(component.getParent());
    }

    public Orientation getOrientation() {
        return this.\u0101;
    }

    public void setOrientation(Orientation orientation) {
        this.\u0101 = orientation;
        if (orientation == Orientation.horizontal) {
            Dimension dimension = this.getPreferredSize();
            if (dimension.width < dimension.height) {
                Dimension dimension2 = new Dimension(dimension.height, dimension.width);
                this.setSize(dimension2);
                this.setPreferredSize(dimension2);
            }
        }
    }

    private Font \u0101() {
        Font font = this.\u0105.getTickFont();
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        super.paintComponent(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.\u0105 != null) {
            Tick[] tickArray = this.\u0105.getTicks();
            if (this.getOrientation() == Orientation.vertical) {
                this.\u0102(graphics2D, this.\u0105, tickArray);
            } else {
                this.\u0101(graphics2D, this.\u0105, tickArray);
            }
        }
        graphics2D.dispose();
    }

    private void \u0102(Graphics2D graphics2D, Axis axis, Tick[] tickArray) {
        Object object;
        Point2D point2D;
        graphics2D.setClip(null);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Dimension dimension = this.getSize();
        AxisPlacement axisPlacement = axis.getPlacement();
        int n2 = axisPlacement == AxisPlacement.TRAILING ? 0 : dimension.width - 1;
        int n3 = this.\u0109.getYEnd();
        axis.render(graphics2D, n2, n3, this.\u0109.getYStart() - this.\u0109.getYEnd(), Orientation.vertical);
        for (Tick tick : tickArray) {
            String string;
            int n4 = tick.isMajor() ? this.\u0109.getTickLength() : this.\u0109.getMinorTickLength();
            point2D = new Point2D.Double(0.0, tick.getPosition());
            Point point = this.\u0109.calculatePixelPoint(point2D, (UserToPixelTransform)(object = this.\u0109.getTransformForAxis(axis)));
            if (point == null) continue;
            int n5 = point.y;
            if (axis.isTicksVisible() && n5 >= n3) {
                graphics2D.setColor(this.\u0109.getTickColor());
                int n6 = axisPlacement == AxisPlacement.LEADING ? -1 : 1;
                graphics2D.drawLine(n2, n5, n2 + n4 * n6, n5);
            }
            if ((string = tick.getLabel()) == null) continue;
            graphics2D.setFont(this.\u0101());
            int n7 = fontMetrics.stringWidth(string);
            graphics2D.setColor(this.\u0109.getLabelColor());
            if (axisPlacement == AxisPlacement.TRAILING) {
                this.drawStringIfWithinBounds(graphics2D, string, n2 + n4 + fontMetrics.getDescent(), n5 + fontMetrics.getDescent());
                continue;
            }
            if (axisPlacement == AxisPlacement.LEADING) {
                this.drawStringIfWithinBounds(graphics2D, string, n2 - n7 - n4 - 1, n5 + fontMetrics.getDescent());
                continue;
            }
            this.drawStringIfWithinBounds(graphics2D, string, n2 + n4 + fontMetrics.getDescent(), n5 + fontMetrics.getDescent());
        }
        AutoPositionedLabel autoPositionedLabel = axis.getLabel();
        if (autoPositionedLabel != null) {
            int n8 = fontMetrics.getHeight();
            Double d2 = autoPositionedLabel.getRotation();
            int n9 = (int)Math.ceil((double)n8 / 2.0);
            Point2D.Double double_ = new Point2D.Double(0.0, axis.midPoint());
            point2D = this.\u0109.calculatePixelPoint((Point2D)double_, axis);
            if (point2D != null) {
                if (axisPlacement == AxisPlacement.LEADING) {
                    object = d2 == null ? Rotation.QUARTER_ANTICLOCKWISE.doubleValue() : d2.doubleValue();
                    autoPositionedLabel.paint((Graphics)graphics2D, n9 + fontMetrics.getDescent(), ((Point)point2D).y, (Double)object);
                } else {
                    object = d2 == null ? Rotation.QUARTER_CLOCKWISE.doubleValue() : d2.doubleValue();
                    autoPositionedLabel.paint((Graphics)graphics2D, dimension.width - n9 - fontMetrics.getDescent(), ((Point)point2D).y, (Double)object);
                }
            }
        }
    }

    private void \u0101(Graphics2D graphics2D, Axis axis, Tick[] tickArray) {
        Shape shape = graphics2D.getClip();
        assert (axis != null);
        Font font = axis.getTickFont();
        FontMetrics fontMetrics = font == null ? graphics2D.getFontMetrics() : graphics2D.getFontMetrics(font);
        int n2 = axis.getTickLength();
        graphics2D.setClip(0, 0, this.getWidth(), this.getHeight());
        int n3 = this.\u0104 == null ? 0 : this.\u0104.x;
        int n4 = this.getHeight() - 1;
        AxisPlacement axisPlacement = axis.getPlacement();
        axis.render(graphics2D, this.\u0109.getXStart(), axisPlacement == AxisPlacement.TRAILING ? n4 : 0, this.\u0109.getXEnd() - this.\u0109.getXStart(), Orientation.horizontal);
        for (Tick tick : tickArray) {
            int n5;
            Point2D.Double double_ = new Point2D.Double(tick.getPosition(), 0.0);
            UserToPixelTransform userToPixelTransform = this.\u0109.getUserToPixelTransform();
            Point point = this.\u0109.calculatePixelPoint((Point2D)double_, userToPixelTransform);
            int n6 = n5 = tick.isMajor() ? axis.getTickLength() : axis.getMinorTickLength();
            if (point == null) continue;
            Point point2 = SwingUtilities.convertPoint(this.\u0109, point, this);
            int n7 = point2.x - n3;
            String string = tick.getLabel();
            graphics2D.setColor(this.\u0109.getTickColor());
            AxisRenderer axisRenderer = axis.getAxisRenderer();
            int n8 = axisRenderer == null ? 0 : axisRenderer.getBreadth();
            int n9 = this.\u0109.getXStart();
            Color color = this.\u0109.getLabelColor();
            int n10 = axis.getTickLabelOffset();
            if (axisPlacement == null || axisPlacement == AxisPlacement.LEADING) {
                graphics2D.drawLine(n7, 0, n7, n5);
                graphics2D.setColor(color);
                this.\u0109.drawXAxisTickLabel(graphics2D, axis, string, n7, 0 + n5 + n8);
                continue;
            }
            if (n5 > 0) {
                graphics2D.drawLine(n7, n4, n7, n4 - n5);
            }
            graphics2D.setColor(color);
            this.\u0109.drawXAxisTickLabel(graphics2D, axis, string, n7, n4 - fontMetrics.getDescent() - n10 - n8);
        }
        graphics2D.setClip(shape);
    }

    protected void drawStringIfWithinBounds(Graphics graphics, String string, int n2, int n3) {
        Rectangle rectangle = this.getBounds();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (string == null) {
            return;
        }
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getAscent();
        if (rectangle == null || n2 >= 0 && n2 + n4 <= rectangle.width && n3 - n5 >= 0 && n3 <= rectangle.height) {
            Rectangle rectangle2 = new Rectangle(n2 - 1 - 3, n3 - n5 + 1 - 1, n4 + 6, n5 + 2);
            if (this.\u010a == null || !this.\u010a.intersects(rectangle2)) {
                graphics.drawString(string, n2, n3);
                this.\u010a = rectangle2;
            }
        }
    }

    private class A
    implements PropertyChangeListener {
        private A() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Point point = AxisComponent.this.\u0104;
            AxisComponent.this.\u0104 = AxisComponent.this.\u0108 == null ? null : AxisComponent.this.\u0108.getViewPosition();
            if (AxisComponent.this.\u0104 != null && (point == null || ((AxisComponent)AxisComponent.this).\u0104.x != point.x || ((AxisComponent)AxisComponent.this).\u0104.y != point.y)) {
                AxisComponent.this.\u0109.update();
            }
        }
    }

    private class B
    implements ChangeListener {
        private B() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Point point = AxisComponent.this.\u0104;
            AxisComponent.this.\u0104 = AxisComponent.this.\u0108 == null ? null : AxisComponent.this.\u0108.getViewPosition();
            if (AxisComponent.this.\u0104 != null && (point == null || ((AxisComponent)AxisComponent.this).\u0104.x != point.x || ((AxisComponent)AxisComponent.this).\u0104.y != point.y)) {
                AxisComponent.this.\u0109.update();
            }
        }
    }
}

