/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.swing.plaf.basic;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.swing.WidgetUtils;
import de.javasoft.swing.jydocking.Dockbar;
import de.javasoft.swing.plaf.DockbarUI;
import de.javasoft.swing.plaf.basic.BasicDockingPainter;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;

public class BasicDockbarUI
extends DockbarUI
implements PropertyChangeListener {
    protected Dockbar dockbar;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDockbarUI();
    }

    public void installUI(JComponent jComponent) {
        this.dockbar = (Dockbar)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListener();
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults();
        this.uninstallListener();
    }

    protected void installDefaults() {
        this.updateDefaults();
    }

    protected void uninstallDefaults() {
    }

    protected void installListener() {
        this.dockbar.addPropertyChangeListener(this);
    }

    protected void uninstallListener() {
        this.dockbar.removePropertyChangeListener(this);
    }

    private void updateDefaults() {
        if (this.dockbar.dockbarItemGapIsUIResource()) {
            this.dockbar.setDockbarItemGap(SyntheticaLookAndFeel.getInt("JYDocking.dockbar.itemGap", this.dockbar, 2), true);
        }
        this.dockbar.setOpaque(SyntheticaLookAndFeel.getBoolean("JYDocking.dockbar.opaque", this.dockbar, true));
        this.updateInsets(this.dockbar.getPlacement());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n = 0;
        int n2 = 0;
        int n3 = jComponent.getWidth();
        int n4 = jComponent.getHeight();
        this.paintBackground(jComponent, graphics, n, n2, n3, n4, ((Dockbar)jComponent).getPlacement());
    }

    protected void paintBackground(JComponent jComponent, Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        BasicDockingPainter.getInstance().paintDockingDockbarBackground(jComponent, new SyntheticaState(), graphics, n, n2, n3, n4, n5);
    }

    protected void updateInsets(int n) {
        Insets insets = SyntheticaLookAndFeel.getInsets("JYDocking.dockbar." + Dockbar.placementAsString(n) + ".insets", this.dockbar);
        if (insets == null) {
            insets = n == 3 ? new Insets(3, 1, 1, 1) : (n == 4 ? new Insets(1, 3, 1, 1) : new Insets(1, 1, 1, 3));
        }
        this.dockbar.setBorder(new EmptyBorder(insets));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateDefaults();
        }
        if ("placement".equals(string)) {
            this.updateInsets((Integer)propertyChangeEvent.getNewValue());
        }
    }
}

